#include "scope-call-log.h"

#include <glib.h>
#include <gio/gio.h>

#define UNITY_SCOPE_CONTACTS_CALL_LOG_SERVICE_NAME "com.canonical.unity.scope.contacts.calllog"

static void
on_dbus_name_acquired (GDBusConnection * connection, const gchar * name, ScopeCallLog *scope)
{
    g_debug ("Scope service acquired start scope");
    scope_call_log_run (scope);
}


static void
on_dbus_name_lost (GDBusConnection * connection, const gchar * name, gpointer user_data)
{
    // TODO: stop scope
}


int main(int argc, char **argv)
{
    g_type_init();


    ScopeCallLog *scope = scope_call_log_new ();

    g_debug ("Register name");

    g_bus_own_name (G_BUS_TYPE_SESSION,
                    UNITY_SCOPE_CONTACTS_CALL_LOG_SERVICE_NAME,
                    G_BUS_NAME_OWNER_FLAGS_NONE,
                    (GBusAcquiredCallback) on_dbus_name_acquired,
                    NULL,
                    (GBusNameLostCallback) on_dbus_name_lost,
                    scope,
                    NULL);


    GMainLoop *loop = g_main_loop_new (NULL, FALSE);
    g_main_loop_run (loop);
    return 0;
}
