/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CLUTTER_FOCUS_MANAGER_H_
#define _CLUTTER_FOCUS_MANAGER_H_

#include <glib.h>
#include <clutter/clutter.h>

#include "clutter-focus-group.h"

#define CLUTTER_TYPE_FOCUS_MANAGER (clutter_focus_manager_get_type ())

#define CLUTTER_FOCUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CLUTTER_TYPE_FOCUS_MANAGER, ClutterFocusManager))

#define CLUTTER_FOCUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CLUTTER_TYPE_FOCUS_MANAGER, ClutterFocusManagerClass))

#define CLUTTER_IS_FOCUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CLUTTER_TYPE_FOCUS_MANAGER))

#define CLUTTER_IS_FOCUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CLUTTER_TYPE_FOCUS_MANAGER))

#define CLUTTER_FOCUS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CLUTTER_TYPE_FOCUS_MANAGER, ClutterFocusManagerClass))

typedef struct _ClutterFocusManager        ClutterFocusManager;
typedef struct _ClutterFocusManagerClass   ClutterFocusManagerClass;
typedef struct _ClutterFocusManagerPrivate ClutterFocusManagerPrivate;
 
struct _ClutterFocusManager
{
  ClutterActor        parent;	

  ClutterFocusManagerPrivate *priv;
};

struct _ClutterFocusManagerClass
{
  ClutterActorClass   parent_class;
};

GType          clutter_focus_manager_get_type     (void) G_GNUC_CONST;

ClutterActor * clutter_focus_manager_get_default  (void);

void           clutter_focus_manager_insert_group (ClutterFocusManager *,
                                                   ClutterFocusGroup *,
                                                   gint                );

#endif /* _CLUTTER_FOCUS_MANAGER_H_ */

