#!/bin/bash
#### BEGIN INIT INFO
# Provides:  Inventec
# Default-Start:     Run Level 5
### END INIT INFO
#
# Author:	Thomas <thomas.wu@inventec.com>
#

mode="666"
module="event key fan wireless mute hibernate threeg"

rm -rf /var/tmp/sleep
rm -rf /dev/arizona
mkdir -p /dev/arizona

case "$1" in
    start)
	echo -n "Starting osd Driver..."

	modprobe --force-modversion osddriver
	for device in $module
	do
        	major=$(awk "\$2==\"$device\" {print \$1}" /proc/devices)
 	        mknod /dev/arizona/$device c $major 0
        	chmod $mode /dev/arizona/$device
	done
	/usr/bin/osdd
	echo "ok"
    ;;
  stop)
	echo -n  "Stopping osd Driver..."
	killall -9 osdd &>/dev/null
	rmmod osddriver
	echo "ok"
    ;;
  *)
    echo "Usage: /etc/init.d/osd.sh {start|stop}"
    exit 1
    ;;
esac

exit 0
