/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * main.c
 * Copyright (C) a 2009 <a@a>
 * 
 * main.c is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * main.c is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if 0
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <config.h>

#include <gtk/gtk.h>
#include <glade/glade.h>
#else
#include "common.h"
#endif

#include <gconf/gconf-client.h>
#include <gconf/gconf-value.h>


/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif



#include "callbacks.h"


//******************************
// Define
//******************************
#if 0
#define GLADE_FILE "/home/naito/work/tdsetting/src/tdsetting.glade"
#else
#define GLADE_FILE "/usr/share/tdsetting/glade/tdsetting.glade"
#endif

#define DT_STRLEN					128

#define DT_WIDGET_NAME_HOME		"drawingarea1"
#define DT_WIDGET_NAME_WEB		"drawingarea2"
#define DT_WIDGET_NAME_MAIL		"drawingarea3"
#define DT_WIDGET_NAME_USER		"drawingarea4"

#define DT_FILE_NAME_HOME		"/usr/share/pixmaps/1-2.png"
#define DT_FILE_NAME_WEB			"/usr/share/pixmaps/2-2.png"
#define DT_FILE_NAME_MAIL		"/usr/share/pixmaps/3-2.png"
#define DT_FILE_NAME_USER		"/usr/share/pixmaps/4-2.png"
#define DT_FILE_NAME_DEF			"/usr/share/icons/hicolor/24x24/apps/gnome-panel-launcher.png"

#define DT_FILE_WIDTH			32
#define DT_FILE_HEIGHT			32

#define DT_ERR_MSG_FILE			_("No such file or directory")
#define DT_ERR_MSG_EXEC			_("A file cannot execute")

#if 0	/* It is used to draw init button by the program. */
#define DT_INIT_BTN_LABEL		_("Initialize(_I)")
#endif

#define DT_KEY_TBL_NUM			4

enum {
	DT_MODE_APPLI,
	DT_MODE_LAUNCHER,
	DT_MODE_OTHER,
	DT_MODES
};

typedef struct dt_widget_id_tbl {
	gchar*	combo_id;
	gchar*	entry_id;
	gchar*	button_id;
} DT_WIDGET_ID_TBL;

DT_WIDGET_ID_TBL	DT_WIDGET_TBL[] = {
	{DT_CMB_ID_HOME, DT_ENT_ID_HOME, DT_BTN_ID_HOME},
	{DT_CMB_ID_WEB,  DT_ENT_ID_WEB,  DT_BTN_ID_WEB},
	{DT_CMB_ID_MAIL, DT_ENT_ID_MAIL, DT_BTN_ID_MAIL},
	{DT_CMB_ID_USER, DT_ENT_ID_USER, DT_BTN_ID_USER}
};

typedef struct dt_gconf_tbl {
	gchar*	base;
	gchar*	type;
	gchar*	mode;
	gchar*	appli;
} DT_GCONF_TBL;

DT_GCONF_TBL	DT_GKEY_TBL[] = {
	{DT_SCHEME_HOME, DT_TYPE_HOME, DT_MODE_HOME, DT_APPLI_HOME},
	{DT_SCHEME_WEB,  DT_TYPE_WEB,  DT_MODE_WEB,  DT_APPLI_WEB},
	{DT_SCHEME_MAIL, DT_TYPE_MAIL, DT_MODE_MAIL, DT_APPLI_MAIL},
	{DT_SCHEME_USER, DT_TYPE_USER, DT_MODE_USER, DT_APPLI_USER}
};

enum {
	DT_ERR_TYPE_FILE,
	DT_ERR_TYPE_EXEC,
	DT_ERRS
};


//******************************
// Structer/Variables
//******************************
typedef struct _DtPrefsManager 	DtPrefsManager;

struct _DtPrefsManager {
	GConfClient *gconf_client;
};

DtPrefsManager *dt_prefs_manager = NULL;
GtkWidget	*d_entry;
GladeXML	*gxml;
GtkEntry	*entry;
gboolean	ginitflg;


//******************************
// Prottype
//******************************
static gboolean
dt_prefs_manager_init (void);

static GtkWidget*
dt_create_dialog (void);

static void
dt_set_dialog_data (void);

static void
dt_draw_icon (const gchar*, const gchar*);

#if 0	/* It is used to draw init button by the program. */
static void
dt_draw_init_button (const gchar*, const gchar*, const gchar*);
#endif

static void
dt_set_combo_and_entry (void);

static gint
dt_prefs_manager_get_int (const gchar*, gint);

static gchar*
dt_prefs_manager_get_string (const gchar*, const gchar*);

static gint
dt_gconf_client_get_int_with_default (GConfClient*, const gchar*, gint, GError**);

static gchar*
dt_gconf_client_get_string_with_default (GConfClient*, const gchar*, const gchar*, GError**);

static gboolean
dt_update_gconf_int (gchar*, gint);

static gboolean
dt_update_gconf_string (gchar*, gint);

static void		 
dt_prefs_manager_set_int (const gchar*, gint);

static void
dt_prefs_manager_set_string (const gchar*, const gchar*);

static void
dt_show_errdialog (const gchar*, gint);

static void
dt_init_combo_and_entry (void);

static void
dt_init_gconf (void);


//******************************
// Public Function
//******************************
void
dt_show_sub_dialog (const gchar *gconf_key)
{
	GtkComboBox *combobox = (GtkComboBox*)NULL;

	g_print ("dt_show_sub_dialog() start\n");

	combobox = (GtkComboBox*)glade_xml_get_widget(gxml, DT_WIDGET_TBL[ghbox_pos].combo_id);
	gcombo_index = gtk_combo_box_get_active (combobox);

	g_print ("dt_show_sub_dialog() gcombo_index[%d]\n",gcombo_index);
	g_print ("dt_show_sub_dialog() ghbox_pos[%d]\n",ghbox_pos);

	switch(gcombo_index)
	{
		case DT_MENU_APPLI:
			dialog2 = dt_create_dialog2 ();
			g_print ("on_d_btn1_clicked() dialog2[%x]\n",(guint)dialog2);
			gtk_widget_show (dialog2);
			break;
		default:
			break;
	}
	g_print ("dt_show_sub_dialog() end\n");
}

/* Generation of the dialog for file selection. */
GtkWidget*
dt_create_dialog2 (void)
{
	g_print ("dt_create_dialog2() dialog2[%x]\n",(guint)dialog2);
	if (dialog2 == NULL)
	{
		dialog2 = glade_xml_get_widget(gxml, "dialog2");
		g_signal_connect (dialog2,
				  "destroy",
				  G_CALLBACK (d2_destroy),
				  &dialog2);
	}
	
	return dialog2;
}

/* This is processing when the menu of a combo box is chosen. */
void
dt_select_category (void)
{
	GtkWidget *d_button = (GtkWidget*)NULL;
	const gchar *str = (gchar*)NULL;

	g_print ("dt_select_category() start\n");

	switch(gcombo_index)
	{
		case DT_MENU_APPLI:
			/* set gconf-value to entry-area */
			d_entry = glade_xml_get_widget(gxml, DT_WIDGET_TBL[ghbox_pos].entry_id);
			entry = GTK_ENTRY(d_entry);
			str = dt_prefs_manager_get_string ((const gchar*)DT_GKEY_TBL[ghbox_pos].appli, DT_STR_DEF);
			g_print ("dt_select_category() str[%s]\n",str);
///			if (ginitflg){
///				gtk_entry_set_text (entry, "");
///			}else{
				gtk_entry_set_text (entry, str);
///			}
			if (str != NULL){
				g_free ((gchar*)str);
			}
			/* active reference-button */
			d_button = glade_xml_get_widget(gxml, DT_WIDGET_TBL[ghbox_pos].button_id);
			gtk_widget_set_sensitive (d_button, TRUE);
			break;
		default:
			/* set space to entry-area */
			d_entry = glade_xml_get_widget(gxml, DT_WIDGET_TBL[ghbox_pos].entry_id);
			entry = GTK_ENTRY(d_entry);
			gtk_entry_set_text (entry, "");
			/* non-active reference-button */
			d_button = glade_xml_get_widget(gxml, DT_WIDGET_TBL[ghbox_pos].button_id);
			gtk_widget_set_sensitive (d_button, FALSE);
			break;
	}
	g_print ("dt_select_category() end\n");
}

/* This function sets the information inputted by the user to a main dialog. */
gboolean
dt_update_entry (void)
{
	gchar *filename = (gchar*)NULL;

	g_print ("dt_update_entry() start\n");

	d_entry = glade_xml_get_widget(gxml, DT_WIDGET_TBL[ghbox_pos].entry_id);
	g_print ("dt_update_entry() d_entry[%x]\n",(guint)d_entry);

	entry = GTK_ENTRY(d_entry);

	switch(gcombo_index)
	{
		case DT_MENU_APPLI:
			filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER(dialog2));
			if (filename != NULL){
				gtk_entry_set_text (entry, filename);
				ginitflg = FALSE;
			}
			g_print ("dt_update_entry() filename[%s]\n",filename);
			g_free (filename);
			break;
		default:
			break;
	}
	g_print ("dt_update_entry() end\n");
	
	return TRUE;
}

/* This function sets registration information to gconf. */
gboolean
dt_update_gconf (void)
{
	gboolean result = FALSE;
	gchar *gconf_key = (gchar*)NULL;
	gint icnt = (gint)0;
	GtkComboBox *combobox = (GtkComboBox*)NULL;
	gint wcombo_index = (gint)0;
	
	g_print ("dt_update_gconf() start\n");

	/* It is judged whether it returns to an initial value. */
	if (ginitflg){
		dt_init_gconf ();
		return TRUE;
	}

	gconf_key = g_new0 (char, DT_STRLEN);

	g_print ("dt_update_gconf() d_entry[%x]\n",(guint)d_entry);
	g_print ("dt_update_gconf() gxml[%x]\n",(guint)gxml);

	for (icnt=0; icnt<DT_KEY_TBL_NUM; icnt++)
	{
		combobox = (GtkComboBox*)glade_xml_get_widget(gxml, DT_WIDGET_TBL[icnt].combo_id);
		wcombo_index = gtk_combo_box_get_active (combobox);
		switch(wcombo_index)
		{
			case DT_MENU_APPLI:
				result = dt_update_gconf_int (DT_GKEY_TBL[icnt].mode, DT_MODE_APPLI);
				d_entry = glade_xml_get_widget(gxml, DT_WIDGET_TBL[icnt].entry_id);
				strcpy(gconf_key, DT_GKEY_TBL[icnt].appli);
				g_print ("###dt_update_gconf() gconf_key[%s]\n",gconf_key);
				result = dt_update_gconf_string (gconf_key, wcombo_index);
				break;
			case DT_MENU_INTERNET:
			case DT_MENU_MAIL:
			case DT_MENU_MEDIA:
				result = dt_update_gconf_int (DT_GKEY_TBL[icnt].mode, DT_MODE_APPLI);
				break;
			case DT_MENU_LAUNCHER:
				result = dt_update_gconf_int (DT_GKEY_TBL[icnt].mode, DT_MODE_LAUNCHER);
				break;
			case DT_MENU_OPTICAL:
			default:
				result = dt_update_gconf_int (DT_GKEY_TBL[icnt].mode, DT_MODE_OTHER);
				break;
		}
		if(!result){
			break;
		}
		result = dt_update_gconf_int (DT_GKEY_TBL[icnt].type, wcombo_index);
		if(!result){
			break;
		}
	}
	g_free (gconf_key);

	g_print ("dt_update_gconf() end\n");
	return result;
}

void
dt_init_entry (void)
{
	/* It memorizes that the initialize button was pushed. */
	ginitflg = TRUE;

	/* Only display: An entry box is returned to an initial value. */
	dt_init_combo_and_entry ();
}


//******************************
// Private Function
//******************************
static gboolean
dt_prefs_manager_init (void)
{
	g_print ("dt_prefs_manager_init() start\n");

	dialog = (GtkWidget*)NULL;
	dialog2 = (GtkWidget*)NULL;
	gcombo_index = (gint)0;
	ghbox_pos = (gint)0;
	d_entry = (GtkWidget*)NULL;
	gxml = (GladeXML*)NULL;
	entry = (GtkEntry*)NULL;
	ginitflg = FALSE;
	
	if (dt_prefs_manager == NULL)
	{
		GConfClient *gconf_client = (GConfClient*)NULL;

		gconf_client = gconf_client_get_default ();
		if (gconf_client == NULL)
		{
			g_print ("Cannot initialize preferences manager.\n");
			return FALSE;
		}
		dt_prefs_manager = g_new0 (DtPrefsManager, 1);
		dt_prefs_manager->gconf_client = gconf_client;
	}

	if (dt_prefs_manager->gconf_client == NULL)
	{
		g_free (dt_prefs_manager);
		dt_prefs_manager = NULL;
	}
	g_print ("dt_prefs_manager_init() end\n");

	return dt_prefs_manager != NULL;
}

/* Generation of the main dialog. */
static GtkWidget*
dt_create_dialog (void)
{
	gxml = glade_xml_new (GLADE_FILE, NULL, NULL);
	
	/* This is important */
	glade_xml_signal_autoconnect (gxml);
	dialog = glade_xml_get_widget(gxml, "dialog");
	g_print ("create_dialog() dialog[%x]\n",(guint)dialog);
	g_signal_connect (dialog,
			  "destroy",
			  G_CALLBACK (d_destroy),
			  &dialog);

	return dialog;
}

/* This is initial-setting processing for main dialog. */
static void
dt_set_dialog_data (void)
{
	/* drawing icon */
	dt_draw_icon (DT_FILE_NAME_HOME, DT_WIDGET_NAME_HOME);
	dt_draw_icon (DT_FILE_NAME_WEB, DT_WIDGET_NAME_WEB);
	dt_draw_icon (DT_FILE_NAME_MAIL, DT_WIDGET_NAME_MAIL);
	dt_draw_icon (DT_FILE_NAME_USER, DT_WIDGET_NAME_USER);
	
	/* setup of display information for combobox and entrybox */
	dt_set_combo_and_entry ();

#if 0	/* It is used to draw init button by the program. */
	/* drawing user button */
	dt_draw_init_button ("d_init", DT_FILE_NAME_DEF, DT_INIT_BTN_LABEL);
#endif
}

static void
dt_draw_icon (const gchar *filename, const gchar *widgetname)
{
	GdkPixbuf *pixbuf = (GdkPixbuf*)NULL;
	GtkWidget *drawingarea = (GtkWidget*)NULL;

	g_print ("dt_draw_icon() start\n");

	/* read image file */
	pixbuf = gdk_pixbuf_new_from_file_at_size (filename, 32, 32, NULL);
	/* get drawing area */
	drawingarea = glade_xml_get_widget (gxml, widgetname);
	/* set drawing size */
	gtk_widget_set_size_request (drawingarea,
				gdk_pixbuf_get_width (pixbuf), 
				gdk_pixbuf_get_height(pixbuf));
	/* set callback */
	g_signal_connect (G_OBJECT(drawingarea),
			"expose_event", G_CALLBACK(cb_d_expose),
			(gpointer) pixbuf);

	g_print ("dt_draw_icon() end\n");
}


/* This is initial-setting processing for main dialog. */
static void
dt_set_combo_and_entry (void)
{
	gint icnt = (gint)0;
	gint wc_index = (gint)0;
	GtkComboBox *combobox = (GtkComboBox*)NULL;
	const gchar *str = (gchar*)NULL;

	g_print ("dt_set_combo_and_entry() start\n");

	for (icnt=0; icnt<DT_KEY_TBL_NUM; icnt++)
	{
		/* set gconf value to combo box */
		wc_index = dt_prefs_manager_get_int ((const gchar*)DT_GKEY_TBL[icnt].type, DT_INT_DEF);
		g_print ("dt_set_combo_and_entry() wc_index[%d]\n",wc_index);
		combobox = (GtkComboBox*)glade_xml_get_widget(gxml, DT_WIDGET_TBL[icnt].combo_id);
		g_print ("dt_set_combo_and_entry() combobox[%x]\n",(guint)combobox);
		gtk_combo_box_set_active (combobox, wc_index);

		/* set gconf value to entry box */
		switch(wc_index)
		{
			case DT_MENU_APPLI:
				str = dt_prefs_manager_get_string ((const gchar*)DT_GKEY_TBL[icnt].appli, DT_STR_DEF);
				g_print ("dt_set_combo_and_entry() str[%s]\n",str);
				if (str != NULL){
					entry = GTK_ENTRY(glade_xml_get_widget(gxml, DT_WIDGET_TBL[icnt].entry_id));
					gtk_entry_set_text (entry, str);
					g_free ((gchar*)str);
				}
				break;
			default:
				break;
		}
	}
	g_print ("dt_set_combo_and_entry() end\n");
}

/* The utility function which acquires an integral value from gconf */
static gint 
dt_prefs_manager_get_int (const gchar* key, gint def)
{
	g_return_val_if_fail (dt_prefs_manager != NULL, def);
	g_return_val_if_fail (dt_prefs_manager->gconf_client != NULL, def);

	return dt_gconf_client_get_int_with_default (dt_prefs_manager->gconf_client,
						  key,
						  def,
						  NULL);
}	

/* The utility function which acquires an string value from gconf */
static gchar *
dt_prefs_manager_get_string (const gchar* key, const gchar* def)
{
	g_return_val_if_fail (dt_prefs_manager != NULL, 
			      def ? g_strdup (def) : NULL);
	g_return_val_if_fail (dt_prefs_manager->gconf_client != NULL, 
			      def ? g_strdup (def) : NULL);

	return dt_gconf_client_get_string_with_default (
	                         dt_prefs_manager->gconf_client,
						     key,
						     def,
						     NULL);
}	

/* The utility function which acquires an integral value from gconf */
static gint
dt_gconf_client_get_int_with_default (GConfClient* client, const gchar* key,
		                        	   gint def, GError** err)
{
	GError* error = NULL;
	GConfValue* val;

	g_return_val_if_fail (err == NULL || *err == NULL, def);

	val = gconf_client_get (client, key, &error);

	if (val != NULL){
		gint retval = def;

		g_return_val_if_fail (error == NULL, def);
      
//		if (check_type (key, val, GCONF_VALUE_INT, &error)){
			retval = gconf_value_get_int(val);
//		}else{
//			handle_error (client, error, err);
//		}
		gconf_value_free (val);

		return retval;
	}else{
		if (error != NULL){
//			handle_error (client, error, err);
		}
		return def;
	}
}

/* The utility function which acquires an string value from gconf */
static gchar*
dt_gconf_client_get_string_with_default (GConfClient* client, const gchar* key,
										const gchar* def, GError** err)
{
	GError* error = (GError*)NULL;
	gchar* val = (gchar*)NULL;

	g_return_val_if_fail (err == NULL || *err == NULL, def ? g_strdup (def) : NULL);

	val = gconf_client_get_string (client, key, &error);

	if (val != NULL){
		g_return_val_if_fail (error == NULL, def ? g_strdup (def) : NULL);
		return val;
	}else{
		if (error != NULL){
#if 0
			handle_error (client, error, err);
#endif
		}
		return def ? g_strdup (def) : NULL;
	}
}

/* The utility function which sets an integral value to gconf */
static gboolean
dt_update_gconf_int (gchar* gconf_key, gint set_val)
{
	gint gconf_val = (gint)0;

	g_print ("dt_update_gconf_int() start\n");

	g_print ("dt_update_gconf_int() gconf_key[%s]\n",gconf_key);

	gconf_val = dt_prefs_manager_get_int ((const gchar*)gconf_key, DT_INT_DEF);

	g_print ("dt_update_gconf_int() gconf_val[%d]\n",gconf_val);
	g_print ("dt_update_gconf_int() set_val[%d]\n",set_val);

	if (gconf_val != set_val)
	{
		dt_prefs_manager_set_int (gconf_key, set_val);
		g_print ("dt_update_gconf_int() update gconf\n");
	}

	g_print ("dt_update_gconf_int() end\n");
	return TRUE;
}

/* This function sets registration information to gconf. */
static gboolean
dt_update_gconf_string (gchar* gconf_key, gint wcombo_index)
{
	const gchar *filename = (const gchar*)NULL;
	gint result = 0;

	g_print ("dt_update_gconf_string() start\n");

	g_print ("dt_update_gconf_string() gconf_key[%s]\n",gconf_key);
	g_print ("dt_update_gconf_string() d_entry[%x]\n",(guint)d_entry);

	g_print ("dt_update_gconf_string() d_entry[%x]\n",(guint)d_entry);

	entry = GTK_ENTRY(d_entry);
	filename = gtk_entry_get_text (entry);

	g_print ("dt_update_gconf_string() wcombo_index[%d]\n",wcombo_index);
	g_print ("dt_update_gconf_string() filename[%s]\n",filename);

	if (wcombo_index == DT_MENU_APPLI)
	{
		/* It is confirmed whether a file exists. */
		result = g_file_test (filename, G_FILE_TEST_IS_REGULAR);
		g_print ("dt_update_gconf_string() result_file[%d]\n", result);
		if(!result){
			dt_show_errdialog (filename, DT_ERR_TYPE_FILE);
			return FALSE;
		}
#if 0	/* It is commentization in order to start by the associated application. */
		/* It is confirmed whether a file can be performed. */
		result = g_file_test (filename, G_FILE_TEST_IS_EXECUTABLE);
		g_print ("dt_update_gconf_string() result_exec[%d]\n", result);
		if(!result){
			dt_show_errdialog (filename, DT_ERR_TYPE_EXEC);
			return FALSE;
		}
#endif
	}
	dt_prefs_manager_set_string (gconf_key, filename);
	g_print ("dt_update_gconf_string() update gconf\n");

	g_print ("dt_update_gconf_string() end\n");
	return TRUE;
}

/* The utility function which sets an integral value to gconf */
static void		 
dt_prefs_manager_set_int (const gchar* key, gint value)
{
	g_print ("dt_prefs_manager_set_int() start\n");

	g_return_if_fail (dt_prefs_manager != NULL);
	g_return_if_fail (dt_prefs_manager->gconf_client != NULL);
	g_return_if_fail (gconf_client_key_is_writable (
				dt_prefs_manager->gconf_client, key, NULL));

	g_print ("dt_prefs_manager_set_int() >>>key[%s]\n",key);
	g_print ("dt_prefs_manager_set_int() >>>value[%d]\n",value);

	gconf_client_set_int (dt_prefs_manager->gconf_client, key, value, NULL);

	g_print ("dt_prefs_manager_set_int() end\n");
}

/* The utility function which sets an string value to gconf */
static void		 
dt_prefs_manager_set_string (const gchar* key, const gchar* value)
{
	g_print ("dt_prefs_manager_set_string() start\n");

	g_return_if_fail (value != NULL);
	
	g_return_if_fail (dt_prefs_manager != NULL);
	g_return_if_fail (dt_prefs_manager->gconf_client != NULL);
	g_return_if_fail (gconf_client_key_is_writable (
				dt_prefs_manager->gconf_client, key, NULL));
			
	g_print ("dt_prefs_manager_set_string() >>>key[%s]\n",key);
	g_print ("dt_prefs_manager_set_string() >>>value[%s]\n",value);

	gconf_client_set_string (dt_prefs_manager->gconf_client, key, value, NULL);

	g_print ("dt_prefs_manager_set_string() end\n");
}

/* This function draws an error dialog. */
static void
dt_show_errdialog (const gchar *filename, gint type)
{
	GtkWidget *dialog4 = (GtkWidget*)NULL;
	gchar *errmsg = (gchar*)NULL;
	
	g_print ("dt_show_errdialog() start\n");

	errmsg = g_new0 (char, DT_STRLEN);

	if(type == DT_ERR_TYPE_FILE){
		errmsg = 
			g_strconcat (filename, " ", DT_ERR_MSG_FILE, NULL);
	}else{
		errmsg = 
			g_strconcat (filename, " ", DT_ERR_MSG_EXEC, NULL);
	}
///	dialog4 = gtk_message_dialog_new (GTK_WINDOW(dialog4),
///					GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
///					GTK_MESSAGE_ERROR,
///					GTK_BUTTONS_CLOSE,
///					"%s", errmsg);
	dialog4 = glade_xml_get_widget(gxml, "errdialog");
	g_print ("dt_show_errdialog() dialog4[%x]\n",(guint)dialog4);
	gtk_message_dialog_set_markup (GTK_MESSAGE_DIALOG(dialog4), errmsg);

	g_free (errmsg);
	gtk_dialog_run (GTK_DIALOG(dialog4));

///	gtk_widget_destroy (dialog4);
	gtk_widget_hide (dialog4);
}

static void
dt_init_combo_and_entry (void)
{
	gint icnt = (gint)0;
	GtkComboBox *combobox = (GtkComboBox*)NULL;

	g_print ("dt_init_combo_and_entry() start\n");

	for (icnt=0; icnt<DT_KEY_TBL_NUM; icnt++)
	{
		/* initialize combobox */
		combobox = (GtkComboBox*)glade_xml_get_widget(gxml, DT_WIDGET_TBL[icnt].combo_id);
		g_print ("dt_init_combo_and_entry() combobox[%x]\n",(guint)combobox);
		gtk_combo_box_set_active (combobox, icnt);
///		/* initialize entrybox */
///		entry = GTK_ENTRY(glade_xml_get_widget(gxml, DT_WIDGET_TBL[icnt].entry_id));
///		gtk_entry_set_text (entry, "");
	}
	g_print ("dt_init_combo_and_entry() end\n");
}

static void
dt_init_gconf (void)
{
	gint icnt = (gint)0;
	GConfChangeSet *chgset;

	g_print ("dt_init_gconf() start\n");

	/* On management: gconf value is returned to an initial value. */
	chgset = gconf_change_set_new ();
	for (icnt=0; icnt<DT_KEY_TBL_NUM; icnt++)
	{
		gconf_change_set_unset (chgset, DT_GKEY_TBL[icnt].appli);
		gconf_change_set_unset (chgset, DT_GKEY_TBL[icnt].mode);
		gconf_change_set_unset (chgset, DT_GKEY_TBL[icnt].type);
	}
	gconf_client_commit_change_set (dt_prefs_manager->gconf_client, chgset, FALSE, NULL);
	gconf_change_set_unref (chgset);

	g_print ("dt_init_gconf() end\n");
}

int
main (int argc, char *argv[])
{

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	g_print ("main() argc[%d]\n",argc);
	g_print ("main() argv[%s]\n",argv[0]);
	g_print ("main() argv[%s]\n",argv[1]);

	gtk_set_locale ();
	gtk_init (&argc, &argv);

	g_return_val_if_fail (dt_prefs_manager == NULL, FALSE);

	dt_prefs_manager_init ();

	dialog = dt_create_dialog ();

	dt_set_dialog_data ();

	gtk_widget_show (dialog);

	gtk_main ();

	ginitflg = FALSE;
	g_free (dt_prefs_manager);

	return 0;
}
