/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * main.c
 * Copyright (C) SHARP CORPORATION 2009 <hoge@sharp.co.jp>
 * 
 * main.c is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * main.c is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <config.h>

#include <gtk/gtk.h>
#include <glade/glade.h>


#undef ENABLE_NLS
/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif



#include "callbacks.h"

/* For testing propose use the local (not installed) glade file */
#define GLADE_FILE PACKAGE_DATA_DIR"/spider_version/glade/spider_version.glade"
/* #define GLADE_FILE "src/spider_version.glade" */
#define ROOTFS_VER_FILE "/etc/spdr001_rev.txt"
#define NOR_VER_FILE "/proc/ver_boot"
#define OS_VER_FILE "/proc/ver_kernel"

gchar *
get_file_line(gchar *filename)
{
	gchar buf[128];
	FILE *fp;
	size_t readsz;
	char *cdata;

	memset(buf, 0, 128);
	fp = fopen(filename, "r");
	if (fp != NULL){
		readsz = fread (buf, 1, 128, fp);
		cdata = strchr(buf, '\n');
		if (cdata != NULL){
			*cdata = 0x00;
		}
		fclose(fp);
	}else{
		return (NULL);
	}
	return (g_strdup(buf));
}
	
GtkWidget*
create_window (void)
{
	GtkWidget *window;
	GladeXML *gxml;
	gchar *cd;
    GtkLabel *ver_label;

	gxml = glade_xml_new (GLADE_FILE, NULL, NULL);
	
	/* This is important */
	glade_xml_signal_autoconnect (gxml);
	window = glade_xml_get_widget (gxml, "window");

	/* get rootfs version */
	cd = get_file_line(ROOTFS_VER_FILE);
	ver_label = GTK_LABEL(glade_xml_get_widget(gxml, "rootfs_ver"));
	gtk_label_set_text (ver_label, cd);
	g_free(cd);

	/* get nor version */
	cd = get_file_line(NOR_VER_FILE);
	ver_label = GTK_LABEL(glade_xml_get_widget(gxml, "nor_ver"));
	gtk_label_set_text (ver_label, cd);
	g_free(cd);

	/* get os version */
	cd = get_file_line(OS_VER_FILE);
	ver_label = GTK_LABEL(glade_xml_get_widget(gxml, "os_ver"));
	gtk_label_set_text (ver_label, cd);
	g_free(cd);

	return window;
}

int
main (int argc, char *argv[])
{
 	GtkWidget *window;


#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	
	gtk_set_locale ();
	gtk_init (&argc, &argv);

	window = create_window ();
	gtk_widget_show (window);

	gtk_main ();
	return 0;
}
