/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _GADGET_CAIRO_H_
#define _GADGET_CAIRO_H_

#include <glib.h>
#include <glib-object.h>
#include <cairo/cairo.h>
#include <libgadget/gadget-proxy.h>

G_BEGIN_DECLS

#define GADGET_TYPE_CAIRO (gadget_cairo_get_type ())

#define GADGET_CAIRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
        GADGET_TYPE_CAIRO, GadgetCairo))

#define GADGET_CAIRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
      	GADGET_TYPE_CAIRO, GadgetCairoClass))

#define GADGET_IS_CAIRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
        GADGET_TYPE_CAIRO))

#define GADGET_CAIRO_IS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
        GADGET_TYPE_CAIRO))

#define GADGET_CAIRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
        GADGET_TYPE_CAIRO, GadgetCairoClass))

typedef struct _GadgetCairo        GadgetCairo;
typedef struct _GadgetCairoClass   GadgetCairoClass;
typedef struct _GadgetCairoPrivate GadgetCairoPrivate;
 
struct _GadgetCairo
{
  GadgetProxy parent;	

  GadgetCairoPrivate *priv;
};

struct _GadgetCairoClass
{
  /*< private >*/
  GadgetProxyClass  parent_class;

  /*< public >*/
  
  /* signals, not vfuncs */
  
  /* vtable */
  void (*draw) (GadgetCairo *self, cairo_t *cr);

  /*< private >*/
  /* padding */
  void (*_gadget_cairo_padding1) (void);
  void (*_gadget_cairo_padding2) (void);
  void (*_gadget_cairo_padding3) (void);
  void (*_gadget_cairo_padding4) (void);
  void (*_gadget_cairo_padding5) (void);
  void (*_gadget_cairo_padding6) (void);
};

GType gadget_cairo_get_type (void) G_GNUC_CONST;

void gadget_cairo_draw (GadgetCairo *self,
                        cairo_t     *cr);

G_END_DECLS

#endif /* _GADGET_CAIRO_H_ */

