/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _GADGET_MANAGER_H_
#define _GADGET_MANAGER_H_

#include <glib.h>
#include <glib-object.h>
#include <libgadget/gadget-proxy.h>

G_BEGIN_DECLS

#define GADGET_TYPE_MANAGER (gadget_manager_get_type ())

#define GADGET_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
        GADGET_TYPE_MANAGER, GadgetManager))

#define GADGET_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
      	GADGET_TYPE_MANAGER, GadgetManagerClass))

#define GADGET_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
        GADGET_TYPE_MANAGER))

#define GADGET_MANAGER_IS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
        GADGET_TYPE_MANAGER))

#define GADGET_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
        GADGET_TYPE_MANAGER, GadgetManagerClass))

typedef struct _GadgetManager        GadgetManager;
typedef struct _GadgetManagerClass   GadgetManagerClass;
typedef struct _GadgetManagerPrivate GadgetManagerPrivate;
typedef struct _GadgetInfo           GadgetInfo;
 
struct _GadgetManager
{
  GObject parent;	

  GadgetManagerPrivate *priv;
};

struct _GadgetManagerClass
{
  /*< private >*/
  GObjectClass  parent_class;

  /*< public >*/
  
  /* signals, not vfuncs */
  
  /* vtable */
  
  /*< private >*/
  /* padding */
  void (*_gadget_manager_padding1) (void);
  void (*_gadget_manager_padding2) (void);
  void (*_gadget_manager_padding3) (void);
  void (*_gadget_manager_padding4) (void);
  void (*_gadget_manager_padding5) (void);
  void (*_gadget_manager_padding6) (void);
};

struct _GadgetInfo
{
  gchar     *name;
  gchar     *description;
  gchar     *path;
  gchar     *author;
  gchar     *version;
  GdkPixbuf *icon;
  gchar     *icon_name;
};

GType gadget_manager_get_type (void) G_GNUC_CONST;

GadgetManager * gadget_manager_get_default  (void);

void            gadget_manager_load_sources (GadgetManager *self);

gboolean        gadget_manager_can_handle_path (GadgetManager *self,
                                                const gchar   *path);

GadgetProxy   * gadget_manager_load_gadget     (GadgetManager *self,
                                                const gchar   *path,
                                                const gchar   *uid);

/*
 *  Returns a list of GadgetInfo * pointers. Free with
 *  #gadget_info_free.
 */
GList         * gadget_manager_get_available_gadgets (GadgetManager *self);

GadgetInfo    * gadget_info_new                      (void);
void            gadget_info_free                     (GadgetInfo    *info);

G_END_DECLS

#endif /* _GADGET_MANAGER_H_ */

