/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LIBGADGET_VIEW_HOST_
#define _LIBGADGET_VIEW_HOST_

#include <gtk/gtk.h>
#include <ggadget/view_interface.h>
#include <ggadget/view_host_interface.h>

#include <ggadget/gtk/cairo_graphics.h>

#include <ggadget-gadget.h>

namespace ggadget {

using ggadget::ViewHostInterface;
using ggadget::gtk::CairoGraphics;

class LibgadgetViewHost : public ViewHostInterface {
  
  public:
    LibgadgetViewHost (GGadget *gadget,
                       ViewHostInterface::Type type);
    virtual ~LibgadgetViewHost ();

    virtual Type GetType () const;

    virtual void Destroy ();
    
    virtual void SetView (ViewInterface *view);

    virtual ViewInterface *GetView () const;

    virtual void Draw (cairo_t *cr);

    virtual GraphicsInterface *NewGraphics () const {
      return new CairoGraphics (1.0);
    }

    virtual void * GetNativeWidget () const;

    virtual void ViewCoordToNativeWidgetCoord (double x,
                                               double y,
                                               double *widget_x,
                                               double *widget_y) const;

    virtual void NativeWidgetCoordToViewCoord (double x,
                                               double y,
                                               double *view_x,
                                               double *view_y) const;

    virtual void QueueDraw ();

    virtual void QueueResize ();

    virtual void EnableInputShapeMask (bool enable);

    virtual void SetResizable (ViewInterface::ResizableMode mode);

    virtual void SetCaption (const std::string &caption);

    virtual void SetShowCaptionAlways (bool always);

    virtual void SetCursor (ggadget::ViewInterface::CursorType cursor);

    virtual void ShowTooltip (const std::string &tooltip);

    virtual void ShowTooltipAtPosition (const std::string &tooltip,
                                        double             x,
                                        double             y);

    virtual bool ShowView (bool modal, 
                           int flags, 
                           Slot1<bool, int> *feedback_handler);

    virtual void CloseView ();

    virtual bool ShowContextMenu (int button);

    virtual void BeginResizeDrag (int, ViewInterface::HitTest);

    virtual void BeginMoveDrag (int);

    virtual void Alert (const ViewInterface *view,
                        const char *message);

    virtual ggadget::ViewHostInterface::ConfirmResponse Confirm 
                       (const ViewInterface *view,
                        const char *message,
                        bool);

    virtual std::string Prompt (const ViewInterface *view,
                                const char *message,
                                const char *default_value);

    virtual int GetDebugMode () const;
    
    
    GGadget *ggadget_;
    ViewInterface *view_;
    ViewHostInterface::Type type_;
    double zoom_; 
    GtkWidget *context_menu_;
};

} /* namespace ggadget */

#endif /* _LIBGADGET_VIEW_HOST_ */
