#! /bin/sh

# Compile a .glsl file to a file that can be included in a C++ program
USAGE="Usage: $0 <file.glsl>"
CGC=cgc
CGC_PROFILE=arbfp1

if test $# -ne 1
then
    echo $USAGE
    exit 1
fi

GLSL_FILE=$1
FRAG_FILE=`basename $1 .glsl`.frag
#GLSL_INC_FILE=`basename $1 .glsl`.glsl_quoted

echo "// Generated by src/opengl/util/$0 from $1" > $FRAG_FILE
$CGC -quiet -oglsl -profile $CGC_PROFILE $GLSL_FILE | while read line
do
   if test `echo $line | cut -c1` != "#"
   then
      echo -e \"$line\" >> $FRAG_FILE
   fi
done
echo "; // Generated by src/opengl/util/$0 from $1" >> $FRAG_FILE

#echo "// Generated by src/opengl/util/$0 from $1" > $GLSL_INC_FILE
#cat $GLSL_FILE | while read line
#do
#      printf \"%s\\\\n\"\\n "$line" >> $GLSL_INC_FILE
#done
#echo "; // Generated by src/opengl/util/$0 from $1" >> $GLSL_INC_FILE
