/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken@vandine.org>
 */

using Gwibber.Test;

private class Main : Object
{
  private Main ()
  {
    unowned string[] args = null;
    Gwibber.Service service = new Gwibber.Service ();
    Test.init (ref args);

    /* Gwibber.Utils test */
    UtilsSuite utils_suite;
    utils_suite = new UtilsSuite ();

    /* Gwibber.Streams test */
    StreamsSuite streams_suite;
    streams_suite = new StreamsSuite ();

    Test.run ();

    service.quit ();
    //Gtk.main_quit ();
  }

  static int main (string[] args)
  {
    Environment.set_variable ("XDG_DATA_HOME", Config.TESTDIR+"/data", true);
    Environment.set_variable ("XDG_CACHE_HOME", Config.TESTDIR+"/data", true);
    Gtk.init (ref args);
    var m = new Main ();
    Gtk.main ();

    return 0;
  }
}
