/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 * Authored by Alberto Mardegan <alberto.mardegan@canonical.com>
 */

namespace Gwibber
{
    public class Accounts : Object
    {
        private Ag.Manager manager;

        /** 
            Accounts::created:
            @arg0: HashTable of an account

            Emitted when an account has changed
        */
        public signal void created(Gwibber.Account account);

        public Accounts()
        {
            manager = new Ag.Manager.for_service_type("microblogging");
            manager.account_created.connect(on_account_created);
        }

        public GLib.List<Gwibber.Account> list()
        {
            GLib.List<Gwibber.Account> accounts = null;
            foreach (var account_service in manager.get_account_services()) {
                var account = new Gwibber.Account (account_service);
                accounts.append(account);
            }
            return accounts;
        }

        public Gwibber.Account lookup_by_id (string id)
        {
            uint account_id;
            string service_id;
            account_id = int.parse(id.split("/")[0]);
            service_id = id.split("/")[1];
            var account = manager.get_account(account_id);
            var service = manager.get_service(service_id);
            var account_service = new Ag.AccountService(account, service);
            return new Gwibber.Account (account_service);
        }

        private void on_account_created(uint account_id)
        {
            var account = manager.get_account(account_id);
            if (!account.supports_service("microblogging")) return;

            var services = account.list_services();
            foreach (var service in services) {
                var account_service = new Ag.AccountService(account, service);
                created(new Gwibber.Account(account_service));
            }
        }
    }
}
