/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Christopher Blizzard.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Christopher Blizzard <blizzard@mozilla.org>
 *   Ramiro Estrugo <ramiro@eazel.com>
 *   Chris Lord <chris@linux.intel.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef _MOZ_HEADLESS
#define _MOZ_HEADLESS

#include <glib-object.h>
#include <cairo/cairo.h>
#include "moz-headless-key.h"
#include "moz-drawing-area.h"

G_BEGIN_DECLS

#ifdef MOZILLA_CLIENT
#include "nscore.h"
#else /* MOZILLA_CLIENT */
#ifndef nscore_h__
/* Because this header may be included from files which not part of the mozilla
   build system, define macros from nscore.h */

#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 3)
#define NS_HIDDEN __attribute__((visibility("hidden")))
#else
#define NS_HIDDEN
#endif

#define NS_FROZENCALL
#define NS_EXPORT_(type) type
#define NS_IMPORT_(type) type
#endif /* nscore_h__ */
#endif /* MOZILLA_CLIENT */

#ifdef XPCOM_GLUE

#define MOZHEADLESS_API(type, name, params) \
  typedef type (NS_FROZENCALL * name##Type) params; \
  extern name##Type name NS_HIDDEN;

#else /* XPCOM_GLUE */

#ifdef _IMPL_MOZHEADLESS
#define MOZHEADLESS_API(type, name, params) NS_EXPORT_(type) name params;
#else
#define MOZHEADLESS_API(type,name, params) NS_IMPORT_(type) name params;
#endif

#endif /* XPCOM_GLUE */



#define MOZ_TYPE_HEADLESS moz_headless_get_type()

#define MOZ_HEADLESS(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MOZ_TYPE_HEADLESS, MozHeadless))

#define MOZ_HEADLESS_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MOZ_TYPE_HEADLESS, MozHeadlessClass))

#define MOZ_IS_HEADLESS(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MOZ_TYPE_HEADLESS))

#define MOZ_IS_HEADLESS_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MOZ_TYPE_HEADLESS))

#define MOZ_HEADLESS_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MOZ_TYPE_HEADLESS, MozHeadlessClass))

typedef struct {
  gint x;
  gint y;
  gint width;
  gint height;
} MozHeadlessRect;

typedef struct _MozHeadlessPrivate MozHeadlessPrivate;

typedef struct {
  GObject             parent;

  MozHeadlessPrivate *priv;
} MozHeadless;

/* Function prototypes for nsIGlobalHistory2 implementation */
typedef void (*MozHeadlessHistoryAddUri)(const gchar *uri,
                                         gboolean redirect,
                                         gboolean top_level,
                                         const gchar *referrer,
                                         gpointer user_data);
typedef gboolean (*MozHeadlessHistoryIsVisited)(const gchar *uri,
                                                gpointer user_data);
typedef void (*MozHeadlessHistorySetPageTitle)(const gchar *uri,
                                               const gchar *title,
                                               gpointer     user_data);

/* Function prototype for mouse cursor changes */
typedef void (*MozHeadlessSetCursorCallback)(MozHeadlessCursorType type,
                                             const MozHeadlessCursor *cursor,
                                             gpointer user_data);

typedef struct {
  GObjectClass        parent_class;

  void (* link_message)        (MozHeadless *headless);
  void (* js_status)           (MozHeadless *headless);
  void (* location)            (MozHeadless *headless);
  void (* icon)                (MozHeadless *headless);
  void (* title)               (MozHeadless *headless);
  void (* progress)            (MozHeadless *headless, gint64 curprogress,
                                gint64 maxprogress);
  void (* progress_all)        (MozHeadless *headless, const char *aURI,
                                gint64 curprogress, gint64 maxprogress);
  void (* net_state)           (MozHeadless *headless, gint state, guint status);
  void (* net_state_all)       (MozHeadless *headless, const char *aURI,
                                gint state, guint status);
  void (* net_start)           (MozHeadless *headless);
  void (* net_stop)            (MozHeadless *headless);
  void (* new_window)          (MozHeadless *headless, MozHeadless **newEmbed,
                                guint chromemask);
  void (* visibility)          (MozHeadless *headless, gboolean visibility);
  void (* destroy_brsr)        (MozHeadless *headless);
  gint (* open_uri)            (MozHeadless *headless, const char *aURI);
  void (* size_to)             (MozHeadless *headless, gint width, gint height);
  gint (* dom_key_down)        (MozHeadless *headless, gpointer dom_event);
  gint (* dom_key_press)       (MozHeadless *headless, gpointer dom_event);
  gint (* dom_key_up)          (MozHeadless *headless, gpointer dom_event);
  gint (* dom_mouse_down)      (MozHeadless *headless, gpointer dom_event);
  gint (* dom_mouse_up)        (MozHeadless *headless, gpointer dom_event);
  gint (* dom_mouse_click)     (MozHeadless *headless, gpointer dom_event);
  gint (* dom_mouse_dbl_click) (MozHeadless *headless, gpointer dom_event);
  gint (* dom_mouse_over)      (MozHeadless *headless, gpointer dom_event);
  gint (* dom_mouse_out)       (MozHeadless *headless, gpointer dom_event);
  void (* security_change)     (MozHeadless *headless, gpointer request,
                                guint state);
  void (* status_change)       (MozHeadless *headless, gpointer request,
                                gint status, gpointer message);
  gint (* dom_activate)        (MozHeadless *headless, gpointer dom_event);
  gint (* dom_focus_in)        (MozHeadless *headless, gpointer dom_event);
  gint (* dom_focus_out)       (MozHeadless *headless, gpointer dom_event);
  
  void (* updated)             (MozHeadless *headless, gint x, gint y, gint width, gint height);
  gboolean (* scroll)          (MozHeadless *headless, MozHeadlessRect *rect, gint dx, gint dy);
  void (* can_go_back)         (MozHeadless *headless, gboolean can_go_back);
  void (* can_go_forward)      (MozHeadless *headless, gboolean can_go_forward);
  void (* show_tooltip)        (MozHeadless *headless, const gchar *text,
                                gint x, gint y);
  void (* hide_tooltip)        (MozHeadless *headless);
} MozHeadlessClass;

MOZHEADLESS_API(GType,        moz_headless_get_type,   (void))
MOZHEADLESS_API(MozHeadless*, moz_headless_new,        (void))
MOZHEADLESS_API(MozHeadless*, moz_headless_new_with_chrome, (guint chromeflags))

MOZHEADLESS_API(void,     moz_headless_push_startup,   (void))
MOZHEADLESS_API(void,     moz_headless_pop_startup,    (void))
MOZHEADLESS_API(void,     moz_headless_set_directory,  (const gchar *key,
                                                        const gchar *path))

/* Tell mozheadless where the mozilla libs live. If this is not specified,
   The MOZILLA_FIVE_HOME environment variable is checked. */
MOZHEADLESS_API(void,     moz_headless_set_path,       (const char *aPath))

MOZHEADLESS_API(void,     moz_headless_set_comp_path,  (const char *aPath))
MOZHEADLESS_API(void,     moz_headless_add_comp_path,  (const char *aPath))
MOZHEADLESS_API(void,     moz_headless_add_chrome_path,(const char *aPath))
MOZHEADLESS_API(void,     moz_headless_register_component, (gpointer aComponentInfo))
MOZHEADLESS_API(void,     moz_headless_set_profile_path, (const char *aDir,
                                                          const char *aName))
MOZHEADLESS_API(void,     moz_headless_load_url,       (MozHeadless *headless,
                                                        const char *url))
MOZHEADLESS_API(void,     moz_headless_stop_load,      (MozHeadless *headless))
MOZHEADLESS_API(gboolean, moz_headless_can_go_back,    (MozHeadless *headless))
MOZHEADLESS_API(gboolean, moz_headless_can_go_forward, (MozHeadless *headless))
MOZHEADLESS_API(void,     moz_headless_go_back,        (MozHeadless *headless))
MOZHEADLESS_API(void,     moz_headless_go_forward,     (MozHeadless *headless))
MOZHEADLESS_API(void,     moz_headless_render_data,    (MozHeadless *headless, 
                                                        const char *data,
                                                        guint32 len,
                                                        const char *base_uri, 
                                                        const char *mime_type))
MOZHEADLESS_API(void,   moz_headless_open_stream,      (MozHeadless *headless,
                                                        const char *base_uri,
                                                        const char *mime_type))
MOZHEADLESS_API(void,   moz_headless_append_data,      (MozHeadless *headless,
                                                        const char *data,
                                                        guint32 len))
MOZHEADLESS_API(void,   moz_headless_close_stream,     (MozHeadless *headless))
MOZHEADLESS_API(char*,  moz_headless_get_link_message, (MozHeadless *headless))
MOZHEADLESS_API(char*,  moz_headless_get_js_status,    (MozHeadless *headless))
MOZHEADLESS_API(char*,  moz_headless_get_title,        (MozHeadless *headless))
MOZHEADLESS_API(char*,  moz_headless_get_location,     (MozHeadless *headless))
MOZHEADLESS_API(char*,  moz_headless_get_icon,         (MozHeadless *headless))
MOZHEADLESS_API(void,   moz_headless_reload,           (MozHeadless *headless,
                                                        gint32 flags))
MOZHEADLESS_API(void,   moz_headless_set_chrome_mask,  (MozHeadless *headless, 
                                                        guint32 flags))
MOZHEADLESS_API(guint32, moz_headless_get_chrome_mask, (MozHeadless *headless))
MOZHEADLESS_API(void,   moz_headless_focus,            (MozHeadless *headless,
                                                        gboolean     in))
MOZHEADLESS_API(void,   moz_headless_set_surface,      (MozHeadless *headless,
                                                        gpointer target,
                                                        gint     width,
                                                        gint     height,
                                                        gint     stride))
MOZHEADLESS_API(void,   moz_headless_set_size,         (MozHeadless *headless,
                                                        gint width,
                                                        gint height))
MOZHEADLESS_API(void,   moz_headless_get_size,         (MozHeadless *headless,
                                                        gint *width,
                                                        gint *height))
MOZHEADLESS_API(void,   moz_headless_get_document_size,(MozHeadless *headless,
                                                        gint *width,
                                                        gint *height))
MOZHEADLESS_API(void,   moz_headless_freeze_updates,   (MozHeadless *headless,
                                                        gboolean frozen))
MOZHEADLESS_API(void,   moz_headless_invalidate,       (MozHeadless *headless,
                                                        gint x,
                                                        gint y,
                                                        guint width,
                                                        guint height,
                                                        gboolean now))
MOZHEADLESS_API(void,   moz_headless_purge_session_history,
                                                       (MozHeadless *headless))
MOZHEADLESS_API(void,   moz_headless_motion,           (MozHeadless *headless,
                                                        gint x,
                                                        gint y,
                                                        MozHeadlessModifier modifiers))
MOZHEADLESS_API(void,   moz_headless_button_press,     (MozHeadless *headless,
                                                        gint x,
                                                        gint y,
                                                        gint button,
                                                        gint click_count,
                                                        MozHeadlessModifier modifiers))
MOZHEADLESS_API(void,   moz_headless_button_release,   (MozHeadless *headless,
                                                        gint x,
                                                        gint y,
                                                        gint button,
                                                        MozHeadlessModifier modifiers))
MOZHEADLESS_API(void,   moz_headless_key_press,        (MozHeadless *headless,
                                                        MozHeadlessKey key,
                                                        gunichar       unicode_value,
                                                        MozHeadlessModifier modifiers))
MOZHEADLESS_API(void,   moz_headless_key_release,      (MozHeadless *headless,
                                                        MozHeadlessKey key,
                                                        MozHeadlessModifier modifiers))
MOZHEADLESS_API(void,   moz_headless_scroll,           (MozHeadless *headless,
                                                        gint dx,
                                                        gint dy))
MOZHEADLESS_API(void,   moz_headless_set_scroll_pos,   (MozHeadless *headless,
                                                        gint x,
                                                        gint y))
MOZHEADLESS_API(void,   moz_headless_get_scroll_pos,   (MozHeadless *headless,
                                                        gint *x,
                                                        gint *y))
MOZHEADLESS_API(void *, moz_headless_get_plugin_window,(MozHeadless *headless))
MOZHEADLESS_API(MozHeadless *, moz_headless_get_from_dom_window,
                                                       (gpointer aNsIDOMWindow))

MOZHEADLESS_API(void,     moz_headless_set_change_cursor_callback,
                                         (MozHeadlessSetCursorCallback callback,
                                          gpointer user_data))

MOZHEADLESS_API(void,     moz_headless_set_app_vendor,   (const gchar *string))
MOZHEADLESS_API(void,     moz_headless_set_app_name,     (const gchar *string))
MOZHEADLESS_API(void,     moz_headless_set_app_id,       (const gchar *string))
MOZHEADLESS_API(void,     moz_headless_set_app_version,  (const gchar *string))
MOZHEADLESS_API(void,     moz_headless_set_app_build_id, (const gchar *string))
MOZHEADLESS_API(void,     moz_headless_set_app_platform_version,
                                                         (const gchar *string))
MOZHEADLESS_API(void,     moz_headless_set_app_platform_build_id,
                                                         (const gchar *string))

/* These are straight out of nsIWebProgressListener.h */

typedef enum
{
  MOZ_HEADLESS_FLAG_START = 1,
  MOZ_HEADLESS_FLAG_REDIRECTING = 2,
  MOZ_HEADLESS_FLAG_TRANSFERRING = 4,
  MOZ_HEADLESS_FLAG_NEGOTIATING = 8,
  MOZ_HEADLESS_FLAG_STOP = 16,
  
  MOZ_HEADLESS_FLAG_IS_REQUEST = 65536,
  MOZ_HEADLESS_FLAG_IS_DOCUMENT = 131072,
  MOZ_HEADLESS_FLAG_IS_NETWORK = 262144,
  MOZ_HEADLESS_FLAG_IS_WINDOW = 524288,

  MOZ_HEADLESS_FLAG_RESTORING = 16777216
} MozHeadlessProgressFlags;

/* These are from various networking headers */

typedef enum
{
  /* NS_ERROR_UNKNOWN_HOST */
  MOZ_HEADLESS_STATUS_FAILED_DNS     = 2152398878U,
 /* NS_ERROR_CONNECTION_REFUSED */
  MOZ_HEADLESS_STATUS_FAILED_CONNECT = 2152398861U,
 /* NS_ERROR_NET_TIMEOUT */
  MOZ_HEADLESS_STATUS_FAILED_TIMEOUT = 2152398862U,
 /* NS_BINDING_ABORTED */
  MOZ_HEADLESS_STATUS_FAILED_USERCANCELED = 2152398850U
} MozHeadlessStatusFlags;

/* These used to be straight out of nsIWebNavigation.h until the API
   changed.  Now there's a mapping table that maps these values to the
   internal values. */

typedef enum 
{
  MOZ_HEADLESS_FLAG_RELOADNORMAL = 0,
  MOZ_HEADLESS_FLAG_RELOADBYPASSCACHE = 1,
  MOZ_HEADLESS_FLAG_RELOADBYPASSPROXY = 2,
  MOZ_HEADLESS_FLAG_RELOADBYPASSPROXYANDCACHE = 3,
  MOZ_HEADLESS_FLAG_RELOADCHARSETCHANGE = 4
} MozHeadlessReloadFlags;

/* These are straight out of nsIWebBrowserChrome.h */

typedef enum
{
  MOZ_HEADLESS_FLAG_DEFAULTCHROME = 1U,
  MOZ_HEADLESS_FLAG_WINDOWBORDERSON = 2U,
  MOZ_HEADLESS_FLAG_WINDOWCLOSEON = 4U,
  MOZ_HEADLESS_FLAG_WINDOWRESIZEON = 8U,
  MOZ_HEADLESS_FLAG_MENUBARON = 16U,
  MOZ_HEADLESS_FLAG_TOOLBARON = 32U,
  MOZ_HEADLESS_FLAG_LOCATIONBARON = 64U,
  MOZ_HEADLESS_FLAG_STATUSBARON = 128U,
  MOZ_HEADLESS_FLAG_PERSONALTOOLBARON = 256U,
  MOZ_HEADLESS_FLAG_SCROLLBARSON = 512U,
  MOZ_HEADLESS_FLAG_TITLEBARON = 1024U,
  MOZ_HEADLESS_FLAG_EXTRACHROMEON = 2048U,
  MOZ_HEADLESS_FLAG_ALLCHROME = 4094U,
  MOZ_HEADLESS_FLAG_WINDOWRAISED = 33554432U,
  MOZ_HEADLESS_FLAG_WINDOWLOWERED = 67108864U,
  MOZ_HEADLESS_FLAG_CENTERSCREEN = 134217728U,
  MOZ_HEADLESS_FLAG_DEPENDENT = 268435456U,
  MOZ_HEADLESS_FLAG_MODAL = 536870912U,
  MOZ_HEADLESS_FLAG_OPENASDIALOG = 1073741824U,
  MOZ_HEADLESS_FLAG_OPENASCHROME = 2147483648U 
} MozHeadlessChromeFlags;

/* this is a singleton object that you can hook up to to get signals
   that are not handed out on a per widget basis. */

#define MOZ_TYPE_HEADLESS_SINGLE moz_headless_single_get_type()

#define MOZ_HEADLESS_SINGLE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MOZ_TYPE_HEADLESS_SINGLE, MozHeadlessSingle))

#define MOZ_HEADLESS_SINGLE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MOZ_TYPE_HEADLESS_SINGLE, MozHeadlessSingleClass))

#define MOZ_IS_HEADLESS_SINGLE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MOZ_TYPE_HEADLESS_SINGLE))

#define MOZ_IS_HEADLESS_SINGLE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MOZ_TYPE_HEADLESS_SINGLE))

#define MOZ_HEADLESS_SINGLE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MOZ_TYPE_HEADLESS_SINGLE, MozHeadlessSingleClass))

typedef struct _MozHeadlessSingle        MozHeadlessSingle;
typedef struct _MozHeadlessSingleClass   MozHeadlessSingleClass;
typedef struct _MozHeadlessSinglePrivate MozHeadlessSinglePrivate;

struct _MozHeadlessSingle
{
  GObject                   object;
  MozHeadlessSinglePrivate *priv;
};

struct _MozHeadlessSingleClass
{
  GObjectClass parent_class;

  void (* new_window_orphan)   (MozHeadlessSingle  *embed,
                                MozHeadless       **newEmbed,
                                guint               chromemask);
};

MOZHEADLESS_API(GType,               moz_headless_single_get_type, (void))
MOZHEADLESS_API(MozHeadlessSingle *, moz_headless_single_get,      (void))

G_END_DECLS

#endif /* _MOZ_HEADLESS */

