import unittest

from urecovery.recipe import *

class TestCase(unittest.TestCase):
    #{{{def testSetter(self):
    def testSetter(self):
        p = Partition(min=-1, max=200)
        self.assertRaises(AssertionError, p.check)
        p = Partition(min='', max='')
        self.assertRaises(AssertionError, p.check)
        p = Partition(min=20000, max=1)
        self.assertRaises(AssertionError, p.check)
    #}}}

    #{{{def testRecipe(self):
    def testRecipe(self):
        ro = Recipe("recovery-recipe")
        ro.addPartition( Partition(min=4000, max=4000,
                  pirority=100000,
                  bootable=True,
                  fstype='fat32') )
        ro.addPartition( Partition(min=500, max=1000000,
                  pirority=100000,
                  fstype='ext3',
                  mountpoint='/'))
        ro.addPartition( Partition(min='105%', max='107%',
                  pirority=100000, fstype='swap'))
        print ro
        self.assertTrue(len(ro.partitions) == 3)
        a = "recovery-recipe ::  4000 4000 100000 fat32 $primary { } $bootable { } method{ format } format{ } use_filesystem{ } filesystem{ fat32 } . 500 1000000 100000 ext3 $primary { } method{ format } format{ } use_filesystem{ } filesystem{ ext3 } mountpoint{ / } . 105% 107% 100000 linux-swap $primary { } method{ format } format{ } use_filesystem{ } filesystem{ swap } ."
        self.assertTrue(ro.genStr() == a)
    #}}}
pass

if __name__ == '__main__':
    unittest.main()

