# telepathy-butterfly - an MSN connection manager for Telepathy
#
# Copyright (C) 2007 Ali Sabil <ali.sabil@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import logging
import weakref

import telepathy

__all__ = ['UfAHandleFactory']

logger = logging.getLogger('UfA.Handle')

def UfAHandleFactory(connection, type, id, name, **kwargs):
    mapping = {telepathy.HANDLE_TYPE_CONTACT: UfAContactHandle}
    handle = mapping[type](connection, id, name, **kwargs)
    connection._handles[handle.type, handle.id] = handle
    return handle


class UfAHandle(telepathy.server.Handle):
    def __init__(self, connection, id, handle_type, name):
        telepathy.server.Handle.__init__(self, id, handle_type, name)
        self._conn = weakref.proxy(connection)

    def __unicode__(self):
        type_mapping = {telepathy.HANDLE_TYPE_CONTACT : 'Contact'}
        type_str = type_mapping.get(self.type, '')
        return "<UfA%sHandle id=%u name='%s'>" % \
            (type_str, self.id, self.name)


class UfAContactHandle(UfAHandle):
    def __init__(self, connection, id, contact_name, contact=None):
        handle_type = telepathy.HANDLE_TYPE_CONTACT
        handle_name = contact_name
        self._contact = contact
        logger.info("Calling the contact handle")

        UfAHandle.__init__(self, connection, id, handle_type, handle_name)

    @property
    def contact(self):
        return self._contact

