# telepathy-ufa - A Ubuntu For Android connection manager
#
# Copyright (C) 2012 Canonical Ltd.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import logging
from call import UfACall

__all__ = ['UfAPhone.py']

logger = logging.getLogger('UfA.Phone')

class UfAPhone:
    def __init__(self, phone):
        self.id = phone[0]
        self.ringingCall = UfACall(phone[1])
        self.foregroundCall = UfACall(phone[2])
        self.backgroundCall = UfACall(phone[3])
