/*
 * <insert one-line description of what the program does>
 * Copyright (c) <2008-2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *

File Name:          EngineCmm.c

Description:

Environment (opt):
    OS: Mandriva, Metasys
    SE: Mandriva, SUSE
 
Notes (opt):
****************************************************************************/

#include <stdio.h>
#include <string.h>
#include "Engine/EngineCmm.h"
#include "InfoMgmt/InfoMgmt.h"
#include "ConnMgmt/ConnMgmt.h"

char s[100];
BootCert bootCert;

int ConnMgmt_DownloadSpecialBootCert(BootCert *pBootCert)
{
	bootCert.BootCount = 100;
	memcpy(bootCert.Cert, "Boot Certificate data simulation", sizeof(bootCert.Cert));
	bootCert.CertKind = SpecialCert;
	bootCert.ExpirationDate.Year = 2012;
	bootCert.ExpirationDate.Month = 12;
	bootCert.ExpirationDate.Day = 12;
	memcpy(pBootCert, &bootCert, sizeof(bootCert));
	return 0;
}

int ConnMgmt_DownloadBootCert(BootCert *pBootCert)
{
	bootCert.BootCount = 100;
	memcpy(bootCert.Cert, "Boot Certificate data simulation", sizeof(bootCert.Cert));
	bootCert.CertKind = NormalCert;
	bootCert.ExpirationDate.Year = 2012;
	bootCert.ExpirationDate.Month = 12;
	bootCert.ExpirationDate.Day = 12;
	memcpy(pBootCert, &bootCert, sizeof(bootCert));
	return 0;
}

int ConnMgmt_SendSharedSecretUpdateSuccess(void)
{
	return 0;
}

int ConnMgmt_SendSpecialCertUpdateSuccess(void)
{
	return 0;
}

int DeviceInfo_StudentID(char *strStudentID, char *cmd)
{
	strcpy(strStudentID, "Student - Luke He");
	return 0;
}

int OtherInfo_Construct(OtherInfo *this)
{
	strcpy(this -> LastDate, "2");
	strcpy(this -> LastTimes, "5");
	return 0;
}

int PromptInfo_Construct(PromptInfo *this)
{
	strcpy(this -> PromptDays, "2");
	strcpy(this -> PromptTimes, "5");
	return 0;
}

int WriteLog(int errcode)
{
	printf("Pop up error message box, error code -> %d \n", errcode);
	return 0;
}

typedef struct DownloadCertFinishEventArgs_struct
{
	int     CertKind;
	int     DownloadStatus;

} DownloadCertFinishEventArgs;

int tcEngine_DownloadCertFinish(DownloadCertFinishEventArgs *dcfEventArgs)
{
	// download success
	if(dcfEventArgs->DownloadStatus)
	{
// reboot system if cert is shared secret or special cert
	if(dcfEventArgs->CertKind == SharedSecret ||
		dcfEventArgs->CertKind == SpecialCert){}

//		RebootDevice();
//	SendMessage(Handle,WM.REBOOT,0, 0);	
// end of if(dcfEventArgs.CertKind == BootCert.SHAREDSECRET 
	} // end of if(dcfEventArgs.DownloadStatus)
	return SUCCESS;
} // end of int tcEngine_DownloadCertFinish
