/*
 * <insert one-line description of what the program does>
 * Copyright (c) <2008-2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _TPM_INTERFACE_
#define _TPM_INTERFACE_

#include "tspi.h"
#include "tss_defines.h"
#include "tss_error.h"
#include "Engine/EngineCmm.h"

typedef	char *				STRING;
typedef	unsigned char		BOOL;
typedef	unsigned int		HRESULT;  

#define TDAGENT_CONNECT_LENGTH			34

#define TDAGENT_SHAREDSECRET_LENGTH		128
#define TDAGENT_PUBLICKEY_LENGTH	    568
#define TDAGENT_USERDATA_LENGTH			24
#define TDAGENT_PACKET_LENGTH	        541

#define	TPM_NV_INDEX_EKCert_IFX		((UINT32)0x1000F000)
#define TDAGENT_SHAREDSECRET_INDEX	((UINT32)0x00001001) 
#define TDAGENT_PUBLICKEY_INDEX	    ((UINT32)0x00001002) 
#define TDAGENT_USERDATA_INDEX		((UINT32)0x00001003) 
#define TDAGENT_PACKET_INDEX	    ((UINT32)0x00001004) 

int TPM_CreateSpaceForTPM(char *);
int TPM_SaveUserDataToTPM(BYTE *);
int TPM_ReadUserDataFromTPM(BYTE *);
int TPM_SaveProvisionPacketToTPM(BYTE *, int);
int TPM_ReadProvisionPacketFromTPM(BYTE *);
int TPM_SaveSharedSecretToTPM(BYTE *);
int TPM_ReadSharedSecretFromTPM(BYTE *);

#endif
