/*
 * <insert one-line description of what the program does>
 * Copyright (c) <2008-2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _ERROR_CODE_
#define _ERROR_CODE_

#include "debug.h"

//errorcode.h
#define ConnMgmt_Base       (0<<24) //0~22
#define ConnMgmt_Soap_Base  (1<<24) //0~36
#define ConnMgmt_Http_Base  (2<<24) //201~505
#define ConnMgmt_Http2_Base  (2<<24) //201~505
#define ConnMgmt_Http3_Base  (3<<24) //201~505
#define ConnMgmt_Http4_Base  (4<<24) //201~505
#define ConnMgmt_Http5_Base  (5<<24) //201~505
#define TCEngine_Base       (6<<24)
#define TPMCtrl_Base 	    (7<<24)
#define INFOMGMT_Base     (8<<24)
#define GUI_Base (9<<24)

#define MAX_MODULENO	9


//error code from ConnMgmt Module
//The remote service point could not be contacted at the transport level. 
#define ConnMgmt_ExceptionStatus_ConnectFailure                 (ConnMgmt_Base+0)
// The connection was prematurely closed.
#define ConnMgmt_ExceptionStatus_ConnectionClosed               (ConnMgmt_Base+1)	
// The connection for a request that specifies the Keep-alive header was closed unexpectedly.
#define ConnMgmt_ExceptionStatus_KeepAliveFailure               (ConnMgmt_Base+2)
// A message was received that exceeded the specified limit when sending a request or receiving a response from the server. 
#define ConnMgmt_ExceptionStatus_MessageLengthLimitExceeded     (ConnMgmt_Base+3)
// The name resolver service could not resolve the host name. 
#define ConnMgmt_ExceptionStatus_NameResolutionFailure          (ConnMgmt_Base+4)
// An internal asynchronous request is pending
#define ConnMgmt_ExceptionStatus_Pending                        (ConnMgmt_Base+5)
// The response received from the server was complete but indicated a protocol-level error. 
// For example, an HTTP protocol error such as 401 Access Denied would use this status.
#define ConnMgmt_ExceptionStatus_ProtocolError                  (ConnMgmt_Base+6)
// The name resolver service could not resolve the proxy host name. 
#define ConnMgmt_ExceptionStatus_ProxyNameResolutionFailure     (ConnMgmt_Base+7)
// A complete response was not received from the remote server.
#define ConnMgmt_ExceptionStatus_ReceiveFailure                 (ConnMgmt_Base+8)
// The request was canceled
#define ConnMgmt_ExceptionStatus_RequestCanceled                (ConnMgmt_Base+9)
// An error occurred while establishing a connection using SSL. 
#define ConnMgmt_ExceptionStatus_SecureChannelFailure           (ConnMgmt_Base+10)
// A complete request could not be sent to the remote server. 
#define ConnMgmt_ExceptionStatus_SendFailure                    (ConnMgmt_Base+11)
// The server response was not a valid HTTP response. 
#define ConnMgmt_ExceptionStatus_ServerProtocolViolation        (ConnMgmt_Base+12)
// No error was encountered.
#define ConnMgmt_ExceptionStatus_Success                        (ConnMgmt_Base+13)
// No response was received during the time-out period for a request.		
#define ConnMgmt_ExceptionStatus_Timeout                        (ConnMgmt_Base+14)
// A server certificate could not be validated.
#define ConnMgmt_ExceptionStatus_TrustFailure                   (ConnMgmt_Base+15)
// return data from web service fromat Invalidation
#define ConnMgmt_ExceptionStatus_ReturnDataInvalidation         (ConnMgmt_Base+16)
// parameter of Send to web service error
#define ConnMgmt_ExceptionStatus_ParameterError                 (ConnMgmt_Base+17)
// Web service inner Error
#define ConnMgmt_ExceptionStatus_WebServiceInnerError           (ConnMgmt_Base+18)
// An exception of unknown type has occurred. 
#define ConnMgmt_ExceptionStatus_UnknownError                   (ConnMgmt_Base+19)

//HWIDInvalid
#define ConnMgmt_RefuseServiceExceptionReason_HWIDInvalid       (ConnMgmt_Base+20)
//BootTickInvalid
#define ConnMgmt_RefuseServiceExceptionReason_BootTickInvalid   (ConnMgmt_Base+21)
//DeviceStolen
#define ConnMgmt_RefuseServiceExceptionReason_DeviceStolen      (ConnMgmt_Base+22)

//BooCertPointIsNull 
#define ConnMgmt_BooCertPointIsNull                             (ConnMgmt_Base+23)
//CurrentStatePointIsNull 
#define ConnMgmt_CurrentStatePointIsNull                        (ConnMgmt_Base+24)

//ConnMgmt invoke DeviceInfo_Construct error
#define ConnMgmt_invoke_DeviceInfo_Construct_Error    (ConnMgmt_Base+25)
//ConnMgmt invoke DeviceInfo_StudentID error
#define ConnMgmt_invoke_DeviceInfo_StudentID_Error    (ConnMgmt_Base+26)
//ConnMgmt invoke DeviceInfo_Construct error
#define ConnMgmt_invoke_OtherInfo_Construct_Error    (ConnMgmt_Base+27)
//ConnMgmt invoke DeviceInfo_Construct error
#define ConnMgmt_invoke_ServerInfo_Construct_Error    (ConnMgmt_Base+28)

// Start add by Roc Zhang 2007-9-19

//Open Root CA file failed
#define ConnMgmt_OPEN_FILE_Error    			(ConnMgmt_Base+29)
//Wrtie data to Root CA file failed
#define ConnMgmt_WRITEFILE_Error    			(ConnMgmt_Base+30)

// End add

#define ConnMgmt_END                                                        (ConnMgmt_Base+30)// modified by Roc Zhang 2007-9-19
  

#define ConnMgmt_SOAP_OK            (ConnMgmt_Soap_Base+0)//No error

#define ConnMgmt_SOAP_CLI_FAULT     (ConnMgmt_Soap_Base+1) //* The service returned a client fault (SOAP 1.2 Sender fault)

#define ConnMgmt_SOAP_SVR_FAULT     (ConnMgmt_Soap_Base+2) //* The service returned a server fault (SOAP 1.2 Receiver fault)

#define ConnMgmt_SOAP_TAG_MISMATCH  (ConnMgmt_Soap_Base+3)  //An XML element didn't correspond to anything expected

#define ConnMgmt_SOAP_TYPE          (ConnMgmt_Soap_Base+4)  //An XML schema type mismatch

#define ConnMgmt_SOAP_SYNTAX_ERROR  (ConnMgmt_Soap_Base+5)  //An XML syntax error occurred on the input

#define ConnMgmt_SOAP_NO_TAG        (ConnMgmt_Soap_Base+6)  //Begin of an element expected, but not found

#define ConnMgmt_SOAP_IOB           (ConnMgmt_Soap_Base+7)  //Array index out of bounds

#define ConnMgmt_SOAP_MUSTUNDERSTAND    (ConnMgmt_Soap_Base+8) //* An element needs to be ignored that need to be understood

#define ConnMgmt_SOAP_NAMESPACE     (ConnMgmt_Soap_Base+9)  //Namespace name mismatch (validation error)

#define ConnMgmt_SOAP_OBJ_MISMATCH  (ConnMgmt_Soap_Base+10)  //Mismatch in the size and/or shape of an object

#define ConnMgmt_SOAP_FATAL_ERROR   (ConnMgmt_Soap_Base+11)  // Internal error

#define ConnMgmt_SOAP_FAULT         (ConnMgmt_Soap_Base+12) //An exception raised by the service

#define ConnMgmt_SOAP_NO_METHOD     (ConnMgmt_Soap_Base+13)  //Skeleton error: the skeleton cannot serve the method

#define ConnMgmt_SOAP_GET_METHOD    (ConnMgmt_Soap_Base+14)  //Unsupported HTTP GET

#define ConnMgmt_SOAP_EOM           (ConnMgmt_Soap_Base+15)  //Out of memory

#define ConnMgmt_SOAP_NULL          (ConnMgmt_Soap_Base+16)  //An element was null, while it is not supposed to be null

#define ConnMgmt_SOAP_MULTI_ID      (ConnMgmt_Soap_Base+17)  //Multiple occurrences of the same element ID on the input

#define ConnMgmt_SOAP_MISSING_ID    (ConnMgmt_Soap_Base+18)  //Element ID missing for an HREF on the input

#define ConnMgmt_SOAP_HREF          (ConnMgmt_Soap_Base+19)  //Reference to object is incompatible with the object refered to

#define ConnMgmt_SOAP_UDP_ERROR     (ConnMgmt_Soap_Base+20)  //A TCP connection error occured
#define ConnMgmt_SOAP_TCP_ERROR     (ConnMgmt_Soap_Base+21)  //A TCP connection error occured

#define ConnMgmt_SOAP_HTTP_ERROR    (ConnMgmt_Soap_Base+22)  //An HTTP error occured

#define ConnMgmt_SOAP_SSL_ERROR     (ConnMgmt_Soap_Base+23)  //An SSL error occured

#define ConnMgmt_SOAP_ZLIB_ERROR    (ConnMgmt_Soap_Base+24)  //A Zlib error occured

#define ConnMgmt_SOAP_PLUGIN_ERROR  (ConnMgmt_Soap_Base+25)  //Failed to register plugin

#define ConnMgmt_SOAP_MIME_ERROR    (ConnMgmt_Soap_Base+26)  //MIME parsing error

#define ConnMgmt_SOAP_DIME_ERROR    (ConnMgmt_Soap_Base+27)  //DIME parsing error

#define ConnMgmt_SOAP_DIME_END      (ConnMgmt_Soap_Base+28)  //End of DIME error

#define ConnMgmt_SOAP_DIME_HREF     (ConnMgmt_Soap_Base+29)  //DIME attachment has no href from SOAP body (and no DIME_callbacks were dened to save the attachment)

#define ConnMgmt_SOAP_DIME_MISMATCH (ConnMgmt_Soap_Base+30)  //DIME version/transmission error

#define ConnMgmt_SOAP_VERSIONMISMATCH (ConnMgmt_Soap_Base+31) //* SOAP version mismatch or no SOAP message

#define ConnMgmt_SOAP_DATAENCODINGUNKNOWN (ConnMgmt_Soap_Base+32)  //SOAP 1.2 DataEncodingUnknown fault

#define ConnMgmt_SOAP_REQUIRED (ConnMgmt_Soap_Base+33)  //Attributed required validation error

#define ConnMgmt_SOAP_PROHIBITED (ConnMgmt_Soap_Base+34)  //Attributed prohibited validation error

#define ConnMgmt_SOAP_OCCURS (ConnMgmt_Soap_Base+35)  //Element minOccurs/maxOccurs validation error

#define ConnMgmt_SOAP_LENGTH (ConnMgmt_Soap_Base+36)  //Element length validation error

#define ConnMgmt_SOAP_EOF (ConnMgmt_Soap_Base+37)  //Unexpected end of  le, no input, or timeout while receiving data
#define ConnMgmt_SOAP_END (ConnMgmt_Soap_Base+37) 




#define ConnMgmt_Http2_START (ConnMgmt_Http_Base+201)
#define HTTP_Created                        (ConnMgmt_Http_Base+201)
#define HTTP_Accepted                       (ConnMgmt_Http_Base+202)
#define HTTP_Non_Authoritative_Information  (ConnMgmt_Http_Base+203)
#define HTTP_No_Content                     (ConnMgmt_Http_Base+204)
#define HTTP_Reset_Content                  (ConnMgmt_Http_Base+205)
#define HTTP_Partial_Content                (ConnMgmt_Http_Base+206)

#define ConnMgmt_Http2_END (ConnMgmt_Http_Base+206)

#define ConnMgmt_Http3_START (ConnMgmt_Http_Base+300)
#define HTTP_Multiple_Choices               (ConnMgmt_Http_Base+300)
#define HTTP_Moved_Permanently              (ConnMgmt_Http_Base+301)
#define HTTP_Found                          (ConnMgmt_Http_Base+302)
#define HTTP_See_Other                      (ConnMgmt_Http_Base+303)
#define HTTP_Not_Modified                   (ConnMgmt_Http_Base+304)
#define HTTP_Use_Proxy                      (ConnMgmt_Http_Base+305)
#define HTTP_Temporary_Redirect             (ConnMgmt_Http_Base+307)
#define ConnMgmt_Http3_END (ConnMgmt_Http_Base+307)

#define ConnMgmt_Http4_START (ConnMgmt_Http_Base+400)
#define HTTP_Bad_Request                    (ConnMgmt_Http_Base+400)
#define HTTP_Unauthorized                   (ConnMgmt_Http_Base+401)
#define HTTP_Payment_Required               (ConnMgmt_Http_Base+402)
#define HTTP_Forbidden                      (ConnMgmt_Http_Base+403)
#define HTTP_Not_Found                      (ConnMgmt_Http_Base+404)
#define HTTP_Method_Not_Allowed             (ConnMgmt_Http_Base+405)
#define HTTP_Not_Acceptable                 (ConnMgmt_Http_Base+406)
#define HTTP_Proxy_Authentication_Required  (ConnMgmt_Http_Base+407)
#define HTTP_Request_Time_out               (ConnMgmt_Http_Base+408)
#define HTTP_Conflict                       (ConnMgmt_Http_Base+409)
#define HTTP_Gone                           (ConnMgmt_Http_Base+410)
#define HTTP_Length_Required                (ConnMgmt_Http_Base+411)
#define HTTP_Precondition_Failed            (ConnMgmt_Http_Base+412)
#define HTTP_Request_Entity_Too_Large       (ConnMgmt_Http_Base+413)
#define HTTP_Request_URI_Too_Large          (ConnMgmt_Http_Base+414)
#define HTTP_Unsupported_Media_Type         (ConnMgmt_Http_Base+415)
#define HTTP_Requested_range_not_satisable  (ConnMgmt_Http_Base+416)
#define HTTP_Expectation_Failed             (ConnMgmt_Http_Base+417)
#define ConnMgmt_Http4_END (ConnMgmt_Http_Base+417)

#define ConnMgmt_Http5_START (ConnMgmt_Http_Base+500)
#define HTTP_Internal_Server_Error          (ConnMgmt_Http_Base+500)
#define HTTP_Not_Implemented                (ConnMgmt_Http_Base+501)
#define HTTP_Bad_Gateway                    (ConnMgmt_Http_Base+502)
#define HTTP_Service_Unavailable            (ConnMgmt_Http_Base+503)
#define HTTP_Gateway_Time_out               (ConnMgmt_Http_Base+504)
#define HTTP_Version_not_supported          (ConnMgmt_Http_Base+505)
#define ConnMgmt_Http5_END (ConnMgmt_Http_Base+505)

// Error Code of TCEngine Module

// There's no Boot Certificate got back from connection module
#define TCEngine_ExceptionStatus_NoBootCert				(TCEngine_Base + 0)
// Try to fetch the Boot Counter but failed
#define TCEngine_ExceptionStatus_GetBootCountFailed		(TCEngine_Base + 1)
// Try to create memory for Expiry Date but failed
#define TCEngine_ExceptionStatus_AllocExpiryDateFailed	(TCEngine_Base + 2)
// Try to fetch the Expiry Date but failed
#define TCEngine_ExceptionStatus_GetExpiryDateFailed	(TCEngine_Base + 3)
// Try to fetch the Student ID but failed
#define TCEngine_ExceptionStatus_GetStudentIDFailed		(TCEngine_Base + 4)
// Try to create memory for TPM object but failed
#define TCEngine_ExceptionStatus_AllocTPMFailed			(TCEngine_Base + 5)
// Try to fetch data from TPM but failed
#define TCEngine_ExceptionStatus_ReadTPMFailed			(TCEngine_Base + 6)
// Try to write data to TPM but failed
#define TCEngine_ExceptionStatus_WriteTPMFailed			(TCEngine_Base + 7)
// The parameter passed down by caller has error format
#define TCEngine_ExceptionStatus_ParamError				(TCEngine_Base + 8)
// The TCEngine module encounter an unknown error
#define TCEngine_ExceptionStatus_UnknownError			(TCEngine_Base + 9)	

#define TCEngine_END			(TCEngine_Base + 9)	


// Error Code of TPMCtrl Module
// Try to fetch the User Data from TPM but failed
#define TPMCtrl_ExceptionStatus_GetUserDataFailed		(TPMCtrl_Base + 0)
// Try to fetch the Boot Tick from TPM but failed		
#define TPMCtrl_ExceptionStatus_GetBootTickFailed		(TPMCtrl_Base + 1)
// Try to fetch the Boot Counter from TPM but failed
#define TPMCtrl_ExceptionStatus_GetBootCountFailed		(TPMCtrl_Base + 2)
// Try to fetch the Expiry Date from TPM but failed
#define TPMCtrl_ExceptionStatus_GetExpirDateFailed		(TPMCtrl_Base + 3)
// Try to fetch the Hardware ID from TPM but failed
#define TPMCtrl_ExceptionStatus_GetHardwareIDFailed		(TPMCtrl_Base + 4)
// Try to initialize the TPM NV storage but failed		
#define TPMCtrl_ExceptionStatus_InitTPMFailed			(TPMCtrl_Base + 5)
// Try to read data from TPM but failed 
#define TPMCtrl_ExceptionStatus_ReadTPMFailed			(TPMCtrl_Base + 6)
// Try to write data to TPM but failed
#define TPMCtrl_ExceptionStatus_WriteTPMFailed			(TPMCtrl_Base + 7)
// Try to create TPM object but failed
#define TPMCtrl_ExceptionStatus_CreatObjFailed			(TPMCtrl_Base + 8)
// Try to assign the priority to TPM but failed
#define TPMCtrl_ExceptionStatus_AssignToObjFailed		(TPMCtrl_Base + 9)
// Try to fetch the valid data length from TPM but failed
#define TPMCtrl_ExceptionStatus_GetAttribUnitFailed		(TPMCtrl_Base + 10)
// The parameter passed down by caller has error format
#define TPMCtrl_ExceptionStatus_ParamError				(TPMCtrl_Base + 11)
// The TPMCtrl module encounter an unknown error
#define TPMCtrl_ExceptionStatus_UnknownError			(TPMCtrl_Base + 12)

// Try to initialize the TPM NV storage but failed		
#define TPMCtrl_ProvisionStatus_InitTPMFailed			(TPMCtrl_Base + 13)
// Try to fetch the valid data length from TPM but failed
#define TPMCtrl_ProvisionStatus_GetAttribUnitFailed		(TPMCtrl_Base + 14)
// The Provision parameter passed down by caller has error format
#define TPMCtrl_ProvisionStatus_ParamError				(TPMCtrl_Base + 15)
// The Provision module encounter an unknown error
#define TPMCtrl_ProvisionStatus_UnknownError			(TPMCtrl_Base + 16)

#define TPMCtrl_END			(TPMCtrl_Base + 16)

#define INFOMGMT_ERR_NORESOLVCONF	(INFOMGMT_Base + 0) 

 #define INFOMGMT_ERR_PARAM		(INFOMGMT_Base + 1)

 #define INFOMGMT_ERR_NOPROCNETROUTE	(INFOMGMT_Base + 2)

 #define INFOMGMT_ERR_FMT			(INFOMGMT_Base + 3)

 #define INFOMGMT_ERR_IOCTL		(INFOMGMT_Base + 4)

 #define INFOMGMT_ERR_SOCKET		(INFOMGMT_Base + 5)

 #define INFOMGMT_ERR_NOGW		(INFOMGMT_Base + 6)

 #define INFOMGMT_ERR_NOIF		(INFOMGMT_Base + 7)

 #define INFOMGMT_ERR_INVALIDCMD		(INFOMGMT_Base + 8)

 #define INFOMGMT_ERR_NOFFPROF		(INFOMGMT_Base + 9)

 #define INFOMGMT_ERR_NOFFPREF		(INFOMGMT_Base + 10)

 #define INFOMGMT_ERR_NOPROXY		(INFOMGMT_Base + 11)

 #define INFOMGMT_ERR_RWINIFILE		(INFOMGMT_Base + 12)

 #define INFOMGMT_ERR_NOINIFILE		(INFOMGMT_Base + 13)


 #define INFOMGMT_ERR_DEVICEINFO		(INFOMGMT_Base + 14)

 #define INFOMGMT_ERR_OTHERINFO		(INFOMGMT_Base + 15)

 #define INFOMGMT_ERR_PROXYINFO		(INFOMGMT_Base + 16)

 #define INFOMGMT_ERR_PROMPTINFO		(INFOMGMT_Base + 17)

 #define INFOMGMT_ERR_SERVERINFO		(INFOMGMT_Base + 18)

 #define INFOMGMT_ERR_GW_CHAR		(INFOMGMT_Base + 19)
#define INFOMGMT_END (INFOMGMT_Base + 19)


#define GUI_ERR_FILE_NOT_OPEN (GUI_Base+0)
#define GUI_ERR_RESOURCE_FORMAT (GUI_Base+1)
#define GUI_ERR_TWO_INSTANCE (GUI_Base+2)
#define GUI_ERR_UNKNOWN (GUI_Base+2)
#define GUI_END (GUI_Base+2)


#define ERR_MSG_LEN 300
//get the error message from the error code
char* geterrmsg( int* errcode);
//pop up error message box according to the error code
int ErrMsgBox(int errcode);
//ConnMgmt's Http error code remapping,return the new errcode
int maperrcode(int errcode);



#define MODULE_CONNMGMT 0
#define MODULE_ENGINE 1
#define MODULE_TPMCTRL 2
#define MODULE_INFOMGMT 3
#define MODULE_GUI 4


#define LOG_FILE "tdagent.log"
#define LOG_MAX_LEN 1024


//write log
int WritestrLog(int moduleno, char* loginfo);
int WriteLog(int errcode);
#endif
