#
# This file is part of Python Download Manager
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Author: Kenneth Christiansen <kenneth.christiansen@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

class DownloadState:
    (NOT_STARTED,
     CONNECTING, # is set on all starts, resumes and auto. starts from queue
     IN_PROGRESS,
     PAUSED,
     CANCELLED,
     QUEUED,
     FILTERED,
     COMPLETED,
     EXCEPTION) = range(9)


class Session:
    DBUS_SERVICE_NAME = "br.org.indt.DownloadManager.DownloadSession"
    DBUS_OBJ_PATH     = "/br/org/indt/DownloadManager/DownloadSession"
    DBUS_IFACE        = "br.org.indt.DownloadManager.DownloadSession"


class ExceptionType:
    (IO,
     HTTP,
     URL,
     UNKNOWN) = range(4)
