/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: dlg_InsertTrendline.hxx,v $
 * $Revision: 1.3.44.1 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef _CHART2_DLG_INSERT_TRENDLINE_HXX
#define _CHART2_DLG_INSERT_TRENDLINE_HXX

#include <vcl/dialog.hxx>
#include <vcl/button.hxx>
#include <svtools/itemset.hxx>
#include <memory>

//.............................................................................
namespace chart
{
//.............................................................................

class TrendlineResources;
class InsertTrendlineDialog : public ModalDialog
{
public:
    InsertTrendlineDialog( Window* pParent, const SfxItemSet& rMyAttrs );
    virtual ~InsertTrendlineDialog();

    void FillItemSet( SfxItemSet& rOutAttrs );
    virtual void DataChanged( const DataChangedEvent& rDCEvt );

    // sets the size so that all control texts fit. Has to be done after
    // complete construction of the dialog
    void adjustSize();

private:
    const SfxItemSet & rInAttrs;

    OKButton          aBtnOK;
    CancelButton      aBtnCancel;
    HelpButton        aBtnHelp;

    ::std::auto_ptr< TrendlineResources >    m_apTrendlineResources;
};

//.............................................................................
} //namespace chart
//.............................................................................

#endif
