/*
 * $Id: pci_lsi_20810.c,v 1.12 2009-01-28 12:59:21 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include "fixme.h"
#include <stdio.h>

#include "glue-shm.h"

#include "chip_lsi_53C810.h"

#include "pci_lsi_20810.h"

#define COMP "pci_lsi_20810"

struct cpssp {
	/* Config */

	/* Ports */
	struct sig_pci_bus *port_pci;
	struct sig_scsi_bus *port_scsi;

	/* Signals */

	/* State */

	/* Processes */
	unsigned int chip;
};

void
pci_lsi_20810_init(
	unsigned int nr,
	struct sig_pci_bus *port_pci,
	struct sig_scsi_bus *port_scsi
)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	chip_lsi_53C810_init(cpssp->chip, port_pci->p5V, port_pci->n_reset,
			port_pci->idsel, port_pci->main, port_pci->intA,
			port_scsi);
}

void
pci_lsi_20810_create(unsigned int nr, const char *name)
{
	struct cpssp *cpssp;

	shm_create(COMP, nr, sizeof(*cpssp));
	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->chip = chip_lsi_53C810_create();

	shm_unmap(cpssp, sizeof(*cpssp));
}

void
pci_lsi_20810_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	chip_lsi_53C810_destroy(cpssp->chip);

	shm_unmap(cpssp, sizeof(*cpssp));
	shm_destroy(COMP, nr);
}
