/*
 * $Id: conn_boolean.c,v 1.3 2009-01-28 12:59:19 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "glue-shm.h"

#include "conn_boolean.h"

#define COMP	"conn_boolean"

struct cpssp {
	struct sig_boolean_merge *forward;
};

void
conn_boolean_init(
	unsigned int nr,
	struct sig_boolean *out,
	struct sig_boolean *mb
)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->forward = sig_boolean_merge(mb, out);
}

unsigned int
conn_boolean_create(void)
{
	static unsigned int nr = 0;

	shm_create(COMP, nr, sizeof(struct cpssp));

	return nr++;
}

void
conn_boolean_destroy(unsigned int nr)
{
	shm_destroy(COMP, nr);
}
