/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Gord Allott <gord.allott@canonical.com>
 *
 */

#include <glib.h>
#include <stdlib.h>
#include <unistd.h>
#include <clutk/clutk.h>

static void test_menu (void);
static void test_menuitem (void);
static void test_menuseperator (void);
static void test_menu_get_num_items (void);

void
test_menu_create_suite (void)
{
#define DOMAIN "/Menu"

  g_test_add_func (DOMAIN"/Menu", test_menu);
  g_test_add_func (DOMAIN"/MenuItem", test_menuitem);
  g_test_add_func (DOMAIN"/MenuSeperator", test_menuseperator);
  g_test_add_func (DOMAIN"/MenuGetNumItems", test_menu_get_num_items);
}

static void
test_menu (void)
{
  ClutterActor *stage;
  CtkMenu      *menu;

  stage = clutter_stage_get_default ();

  menu = ctk_menu_new ();

  clutter_container_add (CLUTTER_CONTAINER (stage), CLUTTER_ACTOR (menu), NULL);
  clutter_actor_show_all (stage);

  clutter_actor_hide (stage);

  g_assert (CTK_IS_MENU (menu));

  clutter_container_remove_actor (CLUTTER_CONTAINER (stage),
                                  CLUTTER_ACTOR (menu));
}

static void
test_menuitem (void)
{
  ClutterActor *stage;
  CtkMenu      *menu;
  CtkMenuItem  *menuitem;

  stage = clutter_stage_get_default ();

  menu = ctk_menu_new ();
  clutter_container_add (CLUTTER_CONTAINER (stage), CLUTTER_ACTOR (menu), NULL);
  clutter_actor_show_all (stage);

  clutter_actor_hide (stage);

  menuitem = ctk_menu_item_new_with_label ("Hello World!");
  ctk_menu_append (menu, CLUTTER_ACTOR (menuitem), TRUE);

  g_assert (CTK_IS_MENU (clutter_actor_get_parent (CLUTTER_ACTOR (menuitem))));
  g_assert (!g_strcmp0(ctk_menu_item_get_label (menuitem), "Hello World!"));

  clutter_container_remove_actor (CLUTTER_CONTAINER (stage),
                                  CLUTTER_ACTOR (menu));
}

static void
test_menuseperator (void)
{
  ClutterActor      *stage;
  CtkMenu           *menu;
  CtkMenuSeperator  *menuseperator;

  stage = clutter_stage_get_default ();

  menu = ctk_menu_new ();
  clutter_container_add (CLUTTER_CONTAINER (stage), CLUTTER_ACTOR (menu), NULL);
  clutter_actor_show_all (stage);

  clutter_actor_hide (stage);

  menuseperator = ctk_menu_seperator_new ();
  ctk_menu_append (menu, CLUTTER_ACTOR (menuseperator), FALSE);

  g_assert (CTK_IS_MENU (clutter_actor_get_parent (CLUTTER_ACTOR (menuseperator))));
  g_assert (CTK_IS_MENU_SEPERATOR (menuseperator));

  clutter_container_remove_actor (CLUTTER_CONTAINER (stage),
                                  CLUTTER_ACTOR (menu));
}

static void
test_menu_get_num_items (void)
{
  ClutterActor *stage;
  CtkMenu      *menu;
  CtkMenuItem  *menuitem;

  stage = clutter_stage_get_default ();

  menu = ctk_menu_new ();
  clutter_container_add (CLUTTER_CONTAINER (stage), CLUTTER_ACTOR (menu), NULL);
  clutter_actor_show_all (stage);

  clutter_actor_hide (stage);

  g_assert_cmpint (ctk_menu_get_num_items (menu), ==, 0);

  menuitem = ctk_menu_item_new_with_label ("item 1");
  ctk_menu_append (menu, CLUTTER_ACTOR (menuitem), TRUE);

  g_assert_cmpint (ctk_menu_get_num_items (menu), ==, 1);

  clutter_container_remove_actor (CLUTTER_CONTAINER (stage),
                                  CLUTTER_ACTOR (menu));
}

