// Copyright 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#import <CoreGraphics/CoreGraphics.h>
#import <UIKit/UIKit.h>

#include "base/mac/scoped_cftyperef.h"
#include "skia/ext/skia_utils_ios.h"
#include "ui/gfx/image/image_unittest_util.h"

namespace gfx {
namespace test {

SkColor GetPlatformImageColor(PlatformImage image, int x, int y) {
  // Start by extracting the target pixel into a 1x1 CGImage.
  base::mac::ScopedCFTypeRef<CGImageRef> pixel_image(
      CGImageCreateWithImageInRect(image.CGImage, CGRectMake(x, y, 1, 1)));

  // Draw that pixel into a 1x1 bitmap context.
  base::mac::ScopedCFTypeRef<CGColorSpaceRef> color_space(
      CGColorSpaceCreateDeviceRGB());
  base::mac::ScopedCFTypeRef<CGContextRef> bitmap_context(
      CGBitmapContextCreate(/*data=*/ NULL,
                            /*width=*/ 1, /*height=*/ 1,
                            /*bitsPerComponent=*/ 8, /*bytesPerRow=*/ 4,
                            color_space,
                            kCGImageAlphaPremultipliedFirst |
                                kCGBitmapByteOrder32Host));
  CGContextDrawImage(bitmap_context, CGRectMake(0, 0, 1, 1), pixel_image);

  // The CGBitmapContext has the same memory layout as SkColor, so we can just
  // read an SkColor straight out of the context.
  SkColor* data =
      reinterpret_cast<SkColor*>(CGBitmapContextGetData(bitmap_context));
  return *data;
}

}  // namespace test
}  // namespace gfx
