// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef REMOTING_PROTOCOL_VIDEO_STUB_H_
#define REMOTING_PROTOCOL_VIDEO_STUB_H_

#include "base/callback_forward.h"
#include "base/memory/scoped_ptr.h"

namespace remoting {

class VideoPacket;

namespace protocol {

class VideoStub {
 public:
  virtual ~VideoStub() {}

  virtual void ProcessVideoPacket(scoped_ptr<VideoPacket> video_packet,
                                  const base::Closure& done) = 0;

 protected:
  VideoStub() {}

 private:
  DISALLOW_COPY_AND_ASSIGN(VideoStub);
};

}  // namespace protocol
}  // namespace remoting

#endif  // REMOTING_PROTOCOL_VIDEO_STUB_H_
