// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef REMOTING_HOST_DESKTOP_ENVIRONMENT_FACTORY_H_
#define REMOTING_HOST_DESKTOP_ENVIRONMENT_FACTORY_H_

#include "base/basictypes.h"
#include "base/memory/ref_counted.h"
#include "base/memory/scoped_ptr.h"

namespace base {
class SingleThreadTaskRunner;
}  // namespace base

namespace remoting {

class ClientSession;
class DesktopEnvironment;

class DesktopEnvironmentFactory {
 public:
  DesktopEnvironmentFactory(
      scoped_refptr<base::SingleThreadTaskRunner> input_task_runner,
      scoped_refptr<base::SingleThreadTaskRunner> ui_task_runner);
  virtual ~DesktopEnvironmentFactory();

  // Creates an instance of |DesktopEnvironment| to be used by |client|.
  virtual scoped_ptr<DesktopEnvironment> Create(ClientSession* client);

  // Returns |true| if created |DesktopEnvironment| instances support audio
  // capture.
  virtual bool SupportsAudioCapture() const;

 protected:
  scoped_refptr<base::SingleThreadTaskRunner> input_task_runner_;
  scoped_refptr<base::SingleThreadTaskRunner> ui_task_runner_;

  DISALLOW_COPY_AND_ASSIGN(DesktopEnvironmentFactory);
};

}  // namespace remoting

#endif  // REMOTING_HOST_DESKTOP_ENVIRONMENT_FACTORY_H_
