// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef NET_QUIC_CRYPTO_QUIC_ENCRYPTER_H_
#define NET_QUIC_CRYPTO_QUIC_ENCRYPTER_H_

#include "net/base/net_export.h"
#include "net/quic/crypto/crypto_protocol.h"
#include "net/quic/quic_protocol.h"

namespace net {

class NET_EXPORT_PRIVATE QuicEncrypter {
 public:
  virtual ~QuicEncrypter() {}

  static QuicEncrypter* Create(CryptoTag algorithm);

  // Returns a newly created QuicData object containing the encrypted
  // |plaintext| as well as a MAC over both |plaintext| and |associated_data|,
  // or NULL if there is an error.
  virtual QuicData* Encrypt(base::StringPiece associated_data,
                            base::StringPiece plaintext) = 0;

  // Returns the maximum length of plaintext that can be encrypted
  // to ciphertext no larger than |ciphertext_size|.
  virtual size_t GetMaxPlaintextSize(size_t ciphertext_size) = 0;

  // Returns the length of the ciphertext that would be generated by encrypting
  // to plaintext of size |plaintext_size|.
  virtual size_t GetCiphertextSize(size_t plaintext_size) = 0;

};

}  // namespace net

#endif  // NET_QUIC_CRYPTO_QUIC_ENCRYPTER_H_
