# Copyright (c) 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'chromium_code': 1,

    'linux_link_kerberos%': 0,
    'conditions': [
      ['chromeos==1 or OS=="android" or OS=="ios"', {
        # Disable Kerberos on ChromeOS, Android and iOS, at least for now.
        # It needs configuration (krb5.conf and so on).
        'use_kerberos%': 0,
      }, {  # chromeos == 0
        'use_kerberos%': 1,
      }],
      ['OS=="android"', {
        # The way the cache uses mmap() is inefficient on some Android devices.
        # If this flag is set, we hackily avoid using mmap() in the disk cache.
        'posix_avoid_mmap%': 1,
      }, {
        'posix_avoid_mmap%': 0,
      }],
      ['OS=="ios"', {
        # Websockets and socket stream are not used on iOS.
        'enable_websockets%': 0,
        # iOS does not use V8.
        'use_v8_in_net%': 0,
        'enable_built_in_dns%': 0,
      }, {
        'enable_websockets%': 1,
        'use_v8_in_net%': 1,
        'enable_built_in_dns%': 1,
      }],
    ],
  },
  'includes': [
    '../build/win_precompile.gypi',
  ],
  'targets': [
    {
      'target_name': 'net',
      'type': '<(component)',
      'variables': { 'enable_wexit_time_destructors': 1, },
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:base_i18n',
        '../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
        '../build/temp_gyp/googleurl.gyp:googleurl',
        '../crypto/crypto.gyp:crypto',
        '../sdch/sdch.gyp:sdch',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../third_party/zlib/zlib.gyp:zlib',
        'net_resources',
      ],
      'sources': [
        'android/gurl_utils.cc',
        'android/gurl_utils.h',
        'android/net_jni_registrar.cc',
        'android/net_jni_registrar.h',
        'android/network_change_notifier_android.cc',
        'android/network_change_notifier_android.h',
        'android/network_change_notifier_delegate_android.cc',
        'android/network_change_notifier_delegate_android.h',
        'android/network_change_notifier_factory_android.cc',
        'android/network_change_notifier_factory_android.h',
        'android/network_library.cc',
        'android/network_library.h',
        'base/address_family.h',
        'base/address_list.cc',
        'base/address_list.h',
        'base/address_tracker_linux.cc',
        'base/address_tracker_linux.h',
        'base/asn1_util.cc',
        'base/asn1_util.h',
        'base/auth.cc',
        'base/auth.h',
        'base/backoff_entry.cc',
        'base/backoff_entry.h',
        'base/bandwidth_metrics.cc',
        'base/bandwidth_metrics.h',
        'base/big_endian.cc',
        'base/big_endian.h',
        'base/cache_type.h',
        'base/cert_database.cc',
        'base/cert_database.h',
        'base/cert_database_android.cc',
        'base/cert_database_ios.cc',
        'base/cert_database_mac.cc',
        'base/cert_database_nss.cc',
        'base/cert_database_openssl.cc',
        'base/cert_database_win.cc',
        'base/cert_status_flags.cc',
        'base/cert_status_flags.h',
        'base/cert_verifier.cc',
        'base/cert_verifier.h',
        'base/cert_verify_proc.cc',
        'base/cert_verify_proc.h',
        'base/cert_verify_proc_android.cc',
        'base/cert_verify_proc_android.h',
        'base/cert_verify_proc_mac.cc',
        'base/cert_verify_proc_mac.h',
        'base/cert_verify_proc_nss.cc',
        'base/cert_verify_proc_nss.h',
        'base/cert_verify_proc_openssl.cc',
        'base/cert_verify_proc_openssl.h',
        'base/cert_verify_proc_win.cc',
        'base/cert_verify_proc_win.h',
        'base/cert_verify_result.cc',
        'base/cert_verify_result.h',
        'base/completion_callback.h',
        'base/connection_type_histograms.cc',
        'base/connection_type_histograms.h',
        'base/crl_set.cc',
        'base/crl_set.h',
        'base/crypto_module.h',
        'base/crypto_module_nss.cc',
        'base/crypto_module_openssl.cc',
        'base/data_url.cc',
        'base/data_url.h',
        'base/default_server_bound_cert_store.cc',
        'base/default_server_bound_cert_store.h',
        'base/directory_lister.cc',
        'base/directory_lister.h',
        'base/dns_reloader.cc',
        'base/dns_reloader.h',
        'base/dns_util.cc',
        'base/dns_util.h',
        'base/dnsrr_resolver.cc',
        'base/dnsrr_resolver.h',
        'base/escape.cc',
        'base/escape.h',
        'base/ev_root_ca_metadata.cc',
        'base/ev_root_ca_metadata.h',
        'base/expiring_cache.h',
        'base/file_stream.cc',
        'base/file_stream.h',
        'base/file_stream_context.cc',
        'base/file_stream_context.h',
        'base/file_stream_context_posix.cc',
        'base/file_stream_context_win.cc',
        'base/file_stream_metrics.cc',
        'base/file_stream_metrics.h',
        'base/file_stream_metrics_posix.cc',
        'base/file_stream_metrics_win.cc',
        'base/file_stream_net_log_parameters.cc',
        'base/file_stream_net_log_parameters.h',
        'base/file_stream_whence.h',
        'base/filter.cc',
        'base/filter.h',
        'base/int128.cc',
        'base/int128.h',
        'base/gzip_filter.cc',
        'base/gzip_filter.h',
        'base/gzip_header.cc',
        'base/gzip_header.h',
        'base/host_cache.cc',
        'base/host_cache.h',
        'base/host_mapping_rules.cc',
        'base/host_mapping_rules.h',
        'base/host_port_pair.cc',
        'base/host_port_pair.h',
        'base/host_resolver.cc',
        'base/host_resolver.h',
        'base/host_resolver_impl.cc',
        'base/host_resolver_impl.h',
        'base/host_resolver_proc.cc',
        'base/host_resolver_proc.h',
        'base/io_buffer.cc',
        'base/io_buffer.h',
        'base/ip_endpoint.cc',
        'base/ip_endpoint.h',
        'base/keygen_handler.cc',
        'base/keygen_handler.h',
        'base/keygen_handler_mac.cc',
        'base/keygen_handler_nss.cc',
        'base/keygen_handler_openssl.cc',
        'base/keygen_handler_win.cc',
        'base/load_flags.h',
        'base/load_flags_list.h',
        'base/load_states.h',
        'base/load_states_list.h',
        'base/mapped_host_resolver.cc',
        'base/mapped_host_resolver.h',
        'base/mime_sniffer.cc',
        'base/mime_sniffer.h',
        'base/mime_util.cc',
        'base/mime_util.h',
        'base/multi_threaded_cert_verifier.cc',
        'base/multi_threaded_cert_verifier.h',
        'base/net_error_list.h',
        'base/net_errors.cc',
        'base/net_errors.h',
        'base/net_errors_posix.cc',
        'base/net_errors_win.cc',
        'base/net_export.h',
        'base/net_log.cc',
        'base/net_log.h',
        'base/net_log_event_type_list.h',
        'base/net_log_source_type_list.h',
        'base/net_module.cc',
        'base/net_module.h',
        'base/net_util.cc',
        'base/net_util.h',
        'base/net_util_posix.cc',
        'base/net_util_win.cc',
        'base/network_change_notifier.cc',
        'base/network_change_notifier.h',
        'base/network_change_notifier_factory.h',
        'base/network_change_notifier_linux.cc',
        'base/network_change_notifier_linux.h',
        'base/network_change_notifier_mac.cc',
        'base/network_change_notifier_mac.h',
        'base/network_change_notifier_win.cc',
        'base/network_change_notifier_win.h',
        'base/network_config_watcher_mac.cc',
        'base/network_config_watcher_mac.h',
        'base/network_delegate.cc',
        'base/network_delegate.h',
        'base/nss_cert_database.cc',
        'base/nss_cert_database.h',
        'base/nss_memio.c',
        'base/nss_memio.h',
        'base/openssl_memory_private_key_store.cc',
        'base/openssl_private_key_store.h',
        'base/openssl_private_key_store_android.cc',
        'base/pem_tokenizer.cc',
        'base/pem_tokenizer.h',
        'base/platform_mime_util.h',
        # TODO(tc): gnome-vfs? xdgmime? /etc/mime.types?
        'base/platform_mime_util_linux.cc',
        'base/platform_mime_util_mac.mm',
        'base/platform_mime_util_win.cc',
        'base/prioritized_dispatcher.cc',
        'base/prioritized_dispatcher.h',
        'base/priority_queue.h',
        'base/rand_callback.h',
        'base/registry_controlled_domains/registry_controlled_domain.cc',
        'base/registry_controlled_domains/registry_controlled_domain.h',
        'base/request_priority.h',
        'base/sdch_filter.cc',
        'base/sdch_filter.h',
        'base/sdch_manager.cc',
        'base/sdch_manager.h',
        'base/server_bound_cert_service.cc',
        'base/server_bound_cert_service.h',
        'base/server_bound_cert_store.cc',
        'base/server_bound_cert_store.h',
        'base/single_request_cert_verifier.cc',
        'base/single_request_cert_verifier.h',
        'base/single_request_host_resolver.cc',
        'base/single_request_host_resolver.h',
        'base/ssl_cert_request_info.cc',
        'base/ssl_cert_request_info.h',
        'base/ssl_cipher_suite_names.cc',
        'base/ssl_cipher_suite_names.h',
        'base/ssl_client_auth_cache.cc',
        'base/ssl_client_auth_cache.h',
        'base/ssl_client_cert_type.h',
        'base/ssl_config_service.cc',
        'base/ssl_config_service.h',
        'base/ssl_config_service_defaults.cc',
        'base/ssl_config_service_defaults.h',
        'base/ssl_info.cc',
        'base/ssl_info.h',
        'base/static_cookie_policy.cc',
        'base/static_cookie_policy.h',
        'base/stream_listen_socket.cc',
        'base/stream_listen_socket.h',
        'base/sys_addrinfo.h',
        'base/tcp_listen_socket.cc',
        'base/tcp_listen_socket.h',
        'base/test_data_stream.cc',
        'base/test_data_stream.h',
        'base/test_root_certs.cc',
        'base/test_root_certs.h',
        'base/test_root_certs_mac.cc',
        'base/test_root_certs_nss.cc',
        'base/test_root_certs_openssl.cc',
        'base/test_root_certs_android.cc',
        'base/test_root_certs_win.cc',
        'base/transport_security_state.cc',
        'base/transport_security_state.h',
        'base/transport_security_state_static.h',
        'base/unix_domain_socket_posix.cc',
        'base/unix_domain_socket_posix.h',
        'base/upload_bytes_element_reader.cc',
        'base/upload_bytes_element_reader.h',
        'base/upload_data.cc',
        'base/upload_data.h',
        'base/upload_data_stream.cc',
        'base/upload_data_stream.h',
        'base/upload_element.cc',
        'base/upload_element.h',
        'base/upload_element_reader.cc',
        'base/upload_element_reader.h',
        'base/upload_file_element_reader.cc',
        'base/upload_file_element_reader.h',
        'base/upload_progress.h',
        'base/winsock_init.cc',
        'base/winsock_init.h',
        'base/winsock_util.cc',
        'base/winsock_util.h',
        'base/x509_cert_types.cc',
        'base/x509_cert_types.h',
        'base/x509_cert_types_mac.cc',
        'base/x509_cert_types_win.cc',
        'base/x509_certificate.cc',
        'base/x509_certificate.h',
        'base/x509_certificate_ios.cc',
        'base/x509_certificate_mac.cc',
        'base/x509_certificate_net_log_param.cc',
        'base/x509_certificate_net_log_param.h',
        'base/x509_certificate_nss.cc',
        'base/x509_certificate_openssl.cc',
        'base/x509_certificate_win.cc',
        'base/x509_util.h',
        'base/x509_util.cc',
        'base/x509_util_ios.cc',
        'base/x509_util_ios.h',
        'base/x509_util_mac.cc',
        'base/x509_util_mac.h',
        'base/x509_util_nss.cc',
        'base/x509_util_nss.h',
        'base/x509_util_openssl.cc',
        'base/x509_util_openssl.h',
        'base/zap.cc',
        'base/zap.h',
        'cookies/canonical_cookie.cc',
        'cookies/canonical_cookie.h',
        'cookies/cookie_monster.cc',
        'cookies/cookie_monster.h',
        'cookies/cookie_options.h',
        'cookies/cookie_store.cc',
        'cookies/cookie_store.h',
        'cookies/cookie_util.cc',
        'cookies/cookie_util.h',
        'cookies/parsed_cookie.cc',
        'cookies/parsed_cookie.h',
        'disk_cache/addr.cc',
        'disk_cache/addr.h',
        'disk_cache/backend_impl.cc',
        'disk_cache/backend_impl.h',
        'disk_cache/bitmap.cc',
        'disk_cache/bitmap.h',
        'disk_cache/block_files.cc',
        'disk_cache/block_files.h',
        'disk_cache/cache_util.h',
        'disk_cache/cache_util_posix.cc',
        'disk_cache/cache_util_win.cc',
        'disk_cache/disk_cache.h',
        'disk_cache/disk_format.cc',
        'disk_cache/disk_format.h',
        'disk_cache/entry_impl.cc',
        'disk_cache/entry_impl.h',
        'disk_cache/errors.h',
        'disk_cache/eviction.cc',
        'disk_cache/eviction.h',
        'disk_cache/experiments.h',
        'disk_cache/file.cc',
        'disk_cache/file.h',
        'disk_cache/file_block.h',
        'disk_cache/file_lock.cc',
        'disk_cache/file_lock.h',
        'disk_cache/file_posix.cc',
        'disk_cache/file_win.cc',
        'disk_cache/histogram_macros.h',
        'disk_cache/in_flight_backend_io.cc',
        'disk_cache/in_flight_backend_io.h',
        'disk_cache/in_flight_io.cc',
        'disk_cache/in_flight_io.h',
        'disk_cache/mapped_file.h',
        'disk_cache/mapped_file_posix.cc',
        'disk_cache/mapped_file_avoid_mmap_posix.cc',
        'disk_cache/mapped_file_win.cc',
        'disk_cache/mem_backend_impl.cc',
        'disk_cache/mem_backend_impl.h',
        'disk_cache/mem_entry_impl.cc',
        'disk_cache/mem_entry_impl.h',
        'disk_cache/mem_rankings.cc',
        'disk_cache/mem_rankings.h',
        'disk_cache/net_log_parameters.cc',
        'disk_cache/net_log_parameters.h',
        'disk_cache/rankings.cc',
        'disk_cache/rankings.h',
        'disk_cache/sparse_control.cc',
        'disk_cache/sparse_control.h',
        'disk_cache/stats.cc',
        'disk_cache/stats.h',
        'disk_cache/stats_histogram.cc',
        'disk_cache/stats_histogram.h',
        'disk_cache/storage_block-inl.h',
        'disk_cache/storage_block.h',
        'disk_cache/stress_support.h',
        'disk_cache/trace.cc',
        'disk_cache/trace.h',
        'disk_cache/flash/format.h',
        'disk_cache/flash/log_store.cc',
        'disk_cache/flash/log_store.h',
        'disk_cache/flash/log_store_entry.cc',
        'disk_cache/flash/log_store_entry.h',
        'disk_cache/flash/segment.cc',
        'disk_cache/flash/segment.h',
        'disk_cache/flash/storage.cc',
        'disk_cache/flash/storage.h',
        'dns/address_sorter.h',
        'dns/address_sorter_posix.cc',
        'dns/address_sorter_posix.h',
        'dns/address_sorter_win.cc',
        'dns/dns_client.cc',
        'dns/dns_client.h',
        'dns/dns_config_service.cc',
        'dns/dns_config_service.h',
        'dns/dns_config_service_posix.cc',
        'dns/dns_config_service_posix.h',
        'dns/dns_config_service_win.cc',
        'dns/dns_config_service_win.h',
        'dns/dns_hosts.cc',
        'dns/dns_hosts.h',
        'dns/dns_protocol.h',
        'dns/dns_query.cc',
        'dns/dns_query.h',
        'dns/dns_response.cc',
        'dns/dns_response.h',
        'dns/dns_session.cc',
        'dns/dns_session.h',
        'dns/dns_socket_pool.cc',
        'dns/dns_socket_pool.h',
        'dns/dns_transaction.cc',
        'dns/dns_transaction.h',
        'dns/notify_watcher_mac.cc',
        'dns/notify_watcher_mac.h',
        'dns/serial_worker.cc',
        'dns/serial_worker.h',
        'ftp/ftp_auth_cache.cc',
        'ftp/ftp_auth_cache.h',
        'ftp/ftp_ctrl_response_buffer.cc',
        'ftp/ftp_ctrl_response_buffer.h',
        'ftp/ftp_directory_listing_parser.cc',
        'ftp/ftp_directory_listing_parser.h',
        'ftp/ftp_directory_listing_parser_ls.cc',
        'ftp/ftp_directory_listing_parser_ls.h',
        'ftp/ftp_directory_listing_parser_netware.cc',
        'ftp/ftp_directory_listing_parser_netware.h',
        'ftp/ftp_directory_listing_parser_os2.cc',
        'ftp/ftp_directory_listing_parser_os2.h',
        'ftp/ftp_directory_listing_parser_vms.cc',
        'ftp/ftp_directory_listing_parser_vms.h',
        'ftp/ftp_directory_listing_parser_windows.cc',
        'ftp/ftp_directory_listing_parser_windows.h',
        'ftp/ftp_network_layer.cc',
        'ftp/ftp_network_layer.h',
        'ftp/ftp_network_session.cc',
        'ftp/ftp_network_session.h',
        'ftp/ftp_network_transaction.cc',
        'ftp/ftp_network_transaction.h',
        'ftp/ftp_request_info.h',
        'ftp/ftp_response_info.cc',
        'ftp/ftp_response_info.h',
        'ftp/ftp_server_type_histograms.cc',
        'ftp/ftp_server_type_histograms.h',
        'ftp/ftp_transaction.h',
        'ftp/ftp_transaction_factory.h',
        'ftp/ftp_util.cc',
        'ftp/ftp_util.h',
        'http/des.cc',
        'http/des.h',
        'http/http_atom_list.h',
        'http/http_auth.cc',
        'http/http_auth.h',
        'http/http_auth_cache.cc',
        'http/http_auth_cache.h',
        'http/http_auth_controller.cc',
        'http/http_auth_controller.h',
        'http/http_auth_filter.cc',
        'http/http_auth_filter.h',
        'http/http_auth_filter_win.h',
        'http/http_auth_gssapi_posix.cc',
        'http/http_auth_gssapi_posix.h',
        'http/http_auth_handler.cc',
        'http/http_auth_handler.h',
        'http/http_auth_handler_basic.cc',
        'http/http_auth_handler_basic.h',
        'http/http_auth_handler_digest.cc',
        'http/http_auth_handler_digest.h',
        'http/http_auth_handler_factory.cc',
        'http/http_auth_handler_factory.h',
        'http/http_auth_handler_negotiate.cc',
        'http/http_auth_handler_negotiate.h',
        'http/http_auth_handler_ntlm.cc',
        'http/http_auth_handler_ntlm.h',
        'http/http_auth_handler_ntlm_portable.cc',
        'http/http_auth_handler_ntlm_win.cc',
        'http/http_auth_sspi_win.cc',
        'http/http_auth_sspi_win.h',
        'http/http_basic_stream.cc',
        'http/http_basic_stream.h',
        'http/http_byte_range.cc',
        'http/http_byte_range.h',
        'http/http_cache.cc',
        'http/http_cache.h',
        'http/http_cache_transaction.cc',
        'http/http_cache_transaction.h',
        'http/http_content_disposition.cc',
        'http/http_content_disposition.h',
        'http/http_chunked_decoder.cc',
        'http/http_chunked_decoder.h',
        'http/http_network_layer.cc',
        'http/http_network_layer.h',
        'http/http_network_session.cc',
        'http/http_network_session.h',
        'http/http_network_session_peer.cc',
        'http/http_network_session_peer.h',
        'http/http_network_transaction.cc',
        'http/http_network_transaction.h',
        'http/http_pipelined_connection.h',
        'http/http_pipelined_connection_impl.cc',
        'http/http_pipelined_connection_impl.h',
        'http/http_pipelined_host.cc',
        'http/http_pipelined_host.h',
        'http/http_pipelined_host_capability.h',
        'http/http_pipelined_host_forced.cc',
        'http/http_pipelined_host_forced.h',
        'http/http_pipelined_host_impl.cc',
        'http/http_pipelined_host_impl.h',
        'http/http_pipelined_host_pool.cc',
        'http/http_pipelined_host_pool.h',
        'http/http_pipelined_stream.cc',
        'http/http_pipelined_stream.h',
        'http/http_proxy_client_socket.cc',
        'http/http_proxy_client_socket.h',
        'http/http_proxy_client_socket_pool.cc',
        'http/http_proxy_client_socket_pool.h',
        'http/http_request_headers.cc',
        'http/http_request_headers.h',
        'http/http_request_info.cc',
        'http/http_request_info.h',
        'http/http_response_body_drainer.cc',
        'http/http_response_body_drainer.h',
        'http/http_response_headers.cc',
        'http/http_response_headers.h',
        'http/http_response_info.cc',
        'http/http_response_info.h',
        'http/http_server_properties.cc',
        'http/http_server_properties.h',
        'http/http_server_properties_impl.cc',
        'http/http_server_properties_impl.h',
        'http/http_status_code.h',
        'http/http_stream.h',
        'http/http_stream_base.h',
        'http/http_stream_factory.cc',
        'http/http_stream_factory.h',
        'http/http_stream_factory_impl.cc',
        'http/http_stream_factory_impl.h',
        'http/http_stream_factory_impl_job.cc',
        'http/http_stream_factory_impl_job.h',
        'http/http_stream_factory_impl_request.cc',
        'http/http_stream_factory_impl_request.h',
        'http/http_stream_parser.cc',
        'http/http_stream_parser.h',
        'http/http_transaction.h',
        'http/http_transaction_delegate.h',
        'http/http_transaction_factory.h',
        'http/http_util.cc',
        'http/http_util.h',
        'http/http_util_icu.cc',
        'http/http_vary_data.cc',
        'http/http_vary_data.h',
        'http/http_version.h',
        'http/infinite_cache.cc',
        'http/infinite_cache.h',
        'http/md4.cc',
        'http/md4.h',
        'http/partial_data.cc',
        'http/partial_data.h',
        'http/proxy_client_socket.h',
        'http/proxy_client_socket.cc',
        'http/url_security_manager.cc',
        'http/url_security_manager.h',
        'http/url_security_manager_posix.cc',
        'http/url_security_manager_win.cc',
        'ocsp/nss_ocsp.cc',
        'ocsp/nss_ocsp.h',
        'proxy/dhcp_proxy_script_adapter_fetcher_win.cc',
        'proxy/dhcp_proxy_script_adapter_fetcher_win.h',
        'proxy/dhcp_proxy_script_fetcher.cc',
        'proxy/dhcp_proxy_script_fetcher.h',
        'proxy/dhcp_proxy_script_fetcher_factory.cc',
        'proxy/dhcp_proxy_script_fetcher_factory.h',
        'proxy/dhcp_proxy_script_fetcher_win.cc',
        'proxy/dhcp_proxy_script_fetcher_win.h',
        'proxy/dhcpcsvc_init_win.cc',
        'proxy/dhcpcsvc_init_win.h',
        'proxy/multi_threaded_proxy_resolver.cc',
        'proxy/multi_threaded_proxy_resolver.h',
        'proxy/network_delegate_error_observer.cc',
        'proxy/network_delegate_error_observer.h',
        'proxy/polling_proxy_config_service.cc',
        'proxy/polling_proxy_config_service.h',
        'proxy/proxy_bypass_rules.cc',
        'proxy/proxy_bypass_rules.h',
        'proxy/proxy_config.cc',
        'proxy/proxy_config.h',
        'proxy/proxy_config_service.h',
        'proxy/proxy_config_service_android.cc',
        'proxy/proxy_config_service_android.h',
        'proxy/proxy_config_service_fixed.cc',
        'proxy/proxy_config_service_fixed.h',
        'proxy/proxy_config_service_ios.cc',
        'proxy/proxy_config_service_ios.h',
        'proxy/proxy_config_service_linux.cc',
        'proxy/proxy_config_service_linux.h',
        'proxy/proxy_config_service_mac.cc',
        'proxy/proxy_config_service_mac.h',
        'proxy/proxy_config_service_win.cc',
        'proxy/proxy_config_service_win.h',
        'proxy/proxy_config_source.cc',
        'proxy/proxy_config_source.h',
        'proxy/proxy_info.cc',
        'proxy/proxy_info.h',
        'proxy/proxy_list.cc',
        'proxy/proxy_list.h',
        'proxy/proxy_resolver.h',
        'proxy/proxy_resolver_error_observer.h',
        'proxy/proxy_resolver_js_bindings.cc',
        'proxy/proxy_resolver_js_bindings.h',
        'proxy/proxy_resolver_mac.cc',
        'proxy/proxy_resolver_mac.h',
        'proxy/proxy_resolver_request_context.h',
        'proxy/proxy_resolver_script.h',
        'proxy/proxy_resolver_script_data.cc',
        'proxy/proxy_resolver_script_data.h',
        'proxy/proxy_resolver_winhttp.cc',
        'proxy/proxy_resolver_winhttp.h',
        'proxy/proxy_retry_info.h',
        'proxy/proxy_script_decider.cc',
        'proxy/proxy_script_decider.h',
        'proxy/proxy_script_fetcher.h',
        'proxy/proxy_script_fetcher_impl.cc',
        'proxy/proxy_script_fetcher_impl.h',
        'proxy/proxy_server.cc',
        'proxy/proxy_server.h',
        'proxy/proxy_server_mac.cc',
        'proxy/proxy_service.cc',
        'proxy/proxy_service.h',
        'proxy/sync_host_resolver.h',
        'proxy/sync_host_resolver_bridge.cc',
        'proxy/sync_host_resolver_bridge.h',
        'quic/congestion_control/cubic.cc',
        'quic/congestion_control/cubic.h',
        'quic/congestion_control/fix_rate_receiver.cc',
        'quic/congestion_control/fix_rate_receiver.h',
        'quic/congestion_control/fix_rate_sender.cc',
        'quic/congestion_control/fix_rate_sender.h',
        'quic/congestion_control/hybrid_slow_start.cc',
        'quic/congestion_control/hybrid_slow_start.h',
        'quic/congestion_control/leaky_bucket.cc',
        'quic/congestion_control/leaky_bucket.h',
        'quic/congestion_control/paced_sender.cc',
        'quic/congestion_control/paced_sender.h',
        'quic/congestion_control/quic_receipt_metrics_collector.cc',
        'quic/congestion_control/quic_receipt_metrics_collector.h',
        'quic/congestion_control/quic_send_scheduler.cc',
        'quic/congestion_control/quic_send_scheduler.h',
        'quic/congestion_control/receive_algorithm_interface.cc',
        'quic/congestion_control/receive_algorithm_interface.h',
        'quic/congestion_control/send_algorithm_interface.cc',
        'quic/congestion_control/send_algorithm_interface.h',
        'quic/congestion_control/tcp_cubic_sender.cc',
        'quic/congestion_control/tcp_cubic_sender.h',
        'quic/congestion_control/tcp_receiver.cc',
        'quic/congestion_control/tcp_receiver.h',
        'quic/crypto/crypto_framer.cc',
        'quic/crypto/crypto_framer.h',
        'quic/crypto/crypto_protocol.cc',
        'quic/crypto/crypto_protocol.h',
        'quic/crypto/null_decrypter.cc',
        'quic/crypto/null_decrypter.h',
        'quic/crypto/null_encrypter.cc',
        'quic/crypto/null_encrypter.h',
        'quic/crypto/quic_decrypter.cc',
        'quic/crypto/quic_decrypter.h',
        'quic/crypto/quic_encrypter.cc',
        'quic/crypto/quic_encrypter.h',
        'quic/crypto/quic_random.cc',
        'quic/crypto/quic_random.h',
        'quic/quic_client_session.cc',
        'quic/quic_client_session.h',
        'quic/quic_crypto_client_stream.cc',
        'quic/quic_crypto_client_stream.h',
        'quic/quic_crypto_stream.cc',
        'quic/quic_crypto_stream.h',
        'quic/quic_clock.cc',
        'quic/quic_clock.h',
        'quic/quic_connection.cc',
        'quic/quic_connection.h',
        'quic/quic_connection_helper.cc',
        'quic/quic_connection_helper.h',
        'quic/quic_data_reader.cc',
        'quic/quic_data_reader.h',
        'quic/quic_data_writer.cc',
        'quic/quic_data_writer.h',
        'quic/quic_fec_group.cc',
        'quic/quic_fec_group.h',
        'quic/quic_framer.cc',
        'quic/quic_framer.h',
        'quic/quic_http_stream.cc',
        'quic/quic_http_stream.h',
        'quic/quic_packet_creator.cc',
        'quic/quic_packet_creator.h',
        'quic/quic_protocol.cc',
        'quic/quic_protocol.h',
        'quic/quic_reliable_client_stream.cc',
        'quic/quic_reliable_client_stream.h',
        'quic/quic_session.cc',
        'quic/quic_session.h',
        'quic/quic_stream_factory.cc',
        'quic/quic_stream_factory.h',
        'quic/quic_stream_sequencer.cc',
        'quic/quic_stream_sequencer.h',
        'quic/quic_time.cc',
        'quic/quic_time.h',
        'quic/quic_utils.cc',
        'quic/quic_utils.h',
        'quic/reliable_quic_stream.cc',
        'quic/reliable_quic_stream.h',
        'socket/buffered_write_stream_socket.cc',
        'socket/buffered_write_stream_socket.h',
        'socket/client_socket_factory.cc',
        'socket/client_socket_factory.h',
        'socket/client_socket_handle.cc',
        'socket/client_socket_handle.h',
        'socket/client_socket_pool.cc',
        'socket/client_socket_pool.h',
        'socket/client_socket_pool_base.cc',
        'socket/client_socket_pool_base.h',
        'socket/client_socket_pool_histograms.cc',
        'socket/client_socket_pool_histograms.h',
        'socket/client_socket_pool_manager.cc',
        'socket/client_socket_pool_manager.h',
        'socket/client_socket_pool_manager_impl.cc',
        'socket/client_socket_pool_manager_impl.h',
        'socket/next_proto.h',
        'socket/nss_ssl_util.cc',
        'socket/nss_ssl_util.h',
        'socket/server_socket.h',
        'socket/socket_net_log_params.cc',
        'socket/socket_net_log_params.h',
        'socket/socket.h',
        'socket/socks5_client_socket.cc',
        'socket/socks5_client_socket.h',
        'socket/socks_client_socket.cc',
        'socket/socks_client_socket.h',
        'socket/socks_client_socket_pool.cc',
        'socket/socks_client_socket_pool.h',
        'socket/ssl_client_socket.cc',
        'socket/ssl_client_socket.h',
        'socket/ssl_client_socket_mac.cc',
        'socket/ssl_client_socket_mac.h',
        'socket/ssl_client_socket_nss.cc',
        'socket/ssl_client_socket_nss.h',
        'socket/ssl_client_socket_openssl.cc',
        'socket/ssl_client_socket_openssl.h',
        'socket/ssl_client_socket_pool.cc',
        'socket/ssl_client_socket_pool.h',
        'socket/ssl_client_socket_win.cc',
        'socket/ssl_client_socket_win.h',
        'socket/ssl_error_params.cc',
        'socket/ssl_error_params.h',
        'socket/ssl_server_socket.h',
        'socket/ssl_server_socket_nss.cc',
        'socket/ssl_server_socket_nss.h',
        'socket/ssl_server_socket_openssl.cc',
        'socket/ssl_socket.h',
        'socket/stream_socket.cc',
        'socket/stream_socket.h',
        'socket/tcp_client_socket.cc',
        'socket/tcp_client_socket.h',
        'socket/tcp_client_socket_libevent.cc',
        'socket/tcp_client_socket_libevent.h',
        'socket/tcp_client_socket_win.cc',
        'socket/tcp_client_socket_win.h',
        'socket/tcp_server_socket.h',
        'socket/tcp_server_socket_libevent.cc',
        'socket/tcp_server_socket_libevent.h',
        'socket/tcp_server_socket_win.cc',
        'socket/tcp_server_socket_win.h',
        'socket/transport_client_socket_pool.cc',
        'socket/transport_client_socket_pool.h',
        'socket_stream/socket_stream.cc',
        'socket_stream/socket_stream.h',
        'socket_stream/socket_stream_job.cc',
        'socket_stream/socket_stream_job.h',
        'socket_stream/socket_stream_job_manager.cc',
        'socket_stream/socket_stream_job_manager.h',
        'socket_stream/socket_stream_metrics.cc',
        'socket_stream/socket_stream_metrics.h',
        'spdy/buffered_spdy_framer.cc',
        'spdy/buffered_spdy_framer.h',
        'spdy/spdy_bitmasks.h',
        'spdy/spdy_credential_builder.cc',
        'spdy/spdy_credential_builder.h',
        'spdy/spdy_credential_state.cc',
        'spdy/spdy_credential_state.h',
        'spdy/spdy_frame_builder.cc',
        'spdy/spdy_frame_builder.h',
        'spdy/spdy_frame_reader.cc',
        'spdy/spdy_frame_reader.h',
        'spdy/spdy_framer.cc',
        'spdy/spdy_framer.h',
        'spdy/spdy_header_block.cc',
        'spdy/spdy_header_block.h',
        'spdy/spdy_http_stream.cc',
        'spdy/spdy_http_stream.h',
        'spdy/spdy_http_utils.cc',
        'spdy/spdy_http_utils.h',
        'spdy/spdy_io_buffer.cc',
        'spdy/spdy_io_buffer.h',
        'spdy/spdy_protocol.h',
        'spdy/spdy_proxy_client_socket.cc',
        'spdy/spdy_proxy_client_socket.h',
        'spdy/spdy_session.cc',
        'spdy/spdy_session.h',
        'spdy/spdy_session_pool.cc',
        'spdy/spdy_session_pool.h',
        'spdy/spdy_stream.cc',
        'spdy/spdy_stream.h',
        'spdy/spdy_websocket_stream.cc',
        'spdy/spdy_websocket_stream.h',
        'third_party/mozilla_security_manager/nsKeygenHandler.cpp',
        'third_party/mozilla_security_manager/nsKeygenHandler.h',
        'third_party/mozilla_security_manager/nsNSSCertificateDB.cpp',
        'third_party/mozilla_security_manager/nsNSSCertificateDB.h',
        'third_party/mozilla_security_manager/nsPKCS12Blob.cpp',
        'third_party/mozilla_security_manager/nsPKCS12Blob.h',
        'udp/datagram_client_socket.h',
        'udp/datagram_server_socket.h',
        'udp/datagram_socket.h',
        'udp/udp_client_socket.cc',
        'udp/udp_client_socket.h',
        'udp/udp_net_log_parameters.cc',
        'udp/udp_net_log_parameters.h',
        'udp/udp_server_socket.cc',
        'udp/udp_server_socket.h',
        'udp/udp_socket.h',
        'udp/udp_socket_libevent.cc',
        'udp/udp_socket_libevent.h',
        'udp/udp_socket_win.cc',
        'udp/udp_socket_win.h',
        'url_request/data_protocol_handler.cc',
        'url_request/data_protocol_handler.h',
        'url_request/file_protocol_handler.cc',
        'url_request/file_protocol_handler.h',
        'url_request/fraudulent_certificate_reporter.h',
        'url_request/ftp_protocol_handler.cc',
        'url_request/ftp_protocol_handler.h',
        'url_request/http_user_agent_settings.h',
        'url_request/static_http_user_agent_settings.cc',
        'url_request/static_http_user_agent_settings.h',
        'url_request/url_fetcher.cc',
        'url_request/url_fetcher.h',
        'url_request/url_fetcher_core.cc',
        'url_request/url_fetcher_core.h',
        'url_request/url_fetcher_delegate.cc',
        'url_request/url_fetcher_delegate.h',
        'url_request/url_fetcher_factory.h',
        'url_request/url_fetcher_impl.cc',
        'url_request/url_fetcher_impl.h',
        'url_request/url_request.cc',
        'url_request/url_request.h',
        'url_request/url_request_about_job.cc',
        'url_request/url_request_about_job.h',
        'url_request/url_request_context.cc',
        'url_request/url_request_context.h',
        'url_request/url_request_context_builder.cc',
        'url_request/url_request_context_builder.h',
        'url_request/url_request_context_getter.cc',
        'url_request/url_request_context_getter.h',
        'url_request/url_request_context_storage.cc',
        'url_request/url_request_context_storage.h',
        'url_request/url_request_data_job.cc',
        'url_request/url_request_data_job.h',
        'url_request/url_request_error_job.cc',
        'url_request/url_request_error_job.h',
        'url_request/url_request_file_dir_job.cc',
        'url_request/url_request_file_dir_job.h',
        'url_request/url_request_file_job.cc',
        'url_request/url_request_file_job.h',
        'url_request/url_request_filter.cc',
        'url_request/url_request_filter.h',
        'url_request/url_request_ftp_job.cc',
        'url_request/url_request_ftp_job.h',
        'url_request/url_request_http_job.cc',
        'url_request/url_request_http_job.h',
        'url_request/url_request_job.cc',
        'url_request/url_request_job.h',
        'url_request/url_request_job_factory.cc',
        'url_request/url_request_job_factory.h',
        'url_request/url_request_job_factory_impl.cc',
        'url_request/url_request_job_factory_impl.h',
        'url_request/url_request_job_manager.cc',
        'url_request/url_request_job_manager.h',
        'url_request/url_request_netlog_params.cc',
        'url_request/url_request_netlog_params.h',
        'url_request/url_request_redirect_job.cc',
        'url_request/url_request_redirect_job.h',
        'url_request/url_request_simple_job.cc',
        'url_request/url_request_simple_job.h',
        'url_request/url_request_status.h',
        'url_request/url_request_test_job.cc',
        'url_request/url_request_test_job.h',
        'url_request/url_request_throttler_entry.cc',
        'url_request/url_request_throttler_entry.h',
        'url_request/url_request_throttler_entry_interface.h',
        'url_request/url_request_throttler_header_adapter.cc',
        'url_request/url_request_throttler_header_adapter.h',
        'url_request/url_request_throttler_header_interface.h',
        'url_request/url_request_throttler_manager.cc',
        'url_request/url_request_throttler_manager.h',
        'url_request/view_cache_helper.cc',
        'url_request/view_cache_helper.h',
        'websockets/websocket_frame.cc',
        'websockets/websocket_frame.h',
        'websockets/websocket_frame_parser.cc',
        'websockets/websocket_frame_parser.h',
        'websockets/websocket_handshake_handler.cc',
        'websockets/websocket_handshake_handler.h',
        'websockets/websocket_job.cc',
        'websockets/websocket_job.h',
        'websockets/websocket_net_log_params.cc',
        'websockets/websocket_net_log_params.h',
        'websockets/websocket_stream.h',
        'websockets/websocket_throttle.cc',
        'websockets/websocket_throttle.h',
      ],
      'defines': [
        'NET_IMPLEMENTATION',
      ],
      'export_dependent_settings': [
        '../base/base.gyp:base',
      ],
      'conditions': [
        ['chromeos==1', {
          'sources!': [
             'base/network_change_notifier_linux.cc',
             'base/network_change_notifier_linux.h',
             'base/network_change_notifier_netlink_linux.cc',
             'base/network_change_notifier_netlink_linux.h',
             'proxy/proxy_config_service_linux.cc',
             'proxy/proxy_config_service_linux.h',
          ],
        }],
        ['use_kerberos==1', {
          'defines': [
            'USE_KERBEROS',
          ],
          'conditions': [
            ['OS=="openbsd"', {
              'include_dirs': [
                '/usr/include/kerberosV'
              ],
            }],
            ['linux_link_kerberos==1', {
              'link_settings': {
                'ldflags': [
                  '<!@(krb5-config --libs gssapi)',
                ],
              },
            }, { # linux_link_kerberos==0
              'defines': [
                'DLOPEN_KERBEROS',
              ],
            }],
          ],
        }, { # use_kerberos == 0
          'sources!': [
            'http/http_auth_gssapi_posix.cc',
            'http/http_auth_gssapi_posix.h',
            'http/http_auth_handler_negotiate.h',
            'http/http_auth_handler_negotiate.cc',
          ],
        }],
        ['posix_avoid_mmap==1', {
          'defines': [
            'POSIX_AVOID_MMAP',
          ],
          'direct_dependent_settings': {
            'defines': [
              'POSIX_AVOID_MMAP',
            ],
          },
          'sources!': [
            'disk_cache/mapped_file_posix.cc',
          ],
        }, { # else
          'sources!': [
            'disk_cache/mapped_file_avoid_mmap_posix.cc',
          ],
        }],
        ['disable_ftp_support==1', {
          'sources/': [
            ['exclude', '^ftp/'],
          ],
          'sources!': [
            'url_request/ftp_protocol_handler.cc',
            'url_request/ftp_protocol_handler.h',
            'url_request/url_request_ftp_job.cc',
            'url_request/url_request_ftp_job.h',
          ],
        }],
        ['enable_built_in_dns==1', {
          'defines': [
            'ENABLE_BUILT_IN_DNS',
          ]
        }, { # else
          'sources!': [
            'dns/address_sorter_posix.cc',
            'dns/address_sorter_posix.h',
            'dns/dns_client.cc',
          ],
        }],
        ['use_openssl==1', {
            'sources!': [
              'base/cert_database_nss.cc',
              'base/cert_verify_proc_nss.cc',
              'base/cert_verify_proc_nss.h',
              'base/crypto_module_nss.cc',
              'base/keygen_handler_nss.cc',
              'base/nss_cert_database.cc',
              'base/nss_cert_database.h',
              'base/nss_memio.c',
              'base/nss_memio.h',
              'base/test_root_certs_nss.cc',
              'base/x509_certificate_nss.cc',
              'base/x509_util_nss.cc',
              'base/x509_util_nss.h',
              'ocsp/nss_ocsp.cc',
              'ocsp/nss_ocsp.h',
              'socket/nss_ssl_util.cc',
              'socket/nss_ssl_util.h',
              'socket/ssl_client_socket_nss.cc',
              'socket/ssl_client_socket_nss.h',
              'socket/ssl_server_socket_nss.cc',
              'socket/ssl_server_socket_nss.h',
              'third_party/mozilla_security_manager/nsKeygenHandler.cpp',
              'third_party/mozilla_security_manager/nsKeygenHandler.h',
              'third_party/mozilla_security_manager/nsNSSCertificateDB.cpp',
              'third_party/mozilla_security_manager/nsNSSCertificateDB.h',
              'third_party/mozilla_security_manager/nsPKCS12Blob.cpp',
              'third_party/mozilla_security_manager/nsPKCS12Blob.h',
            ],
          },
          {  # else !use_openssl: remove the unneeded files
            'sources!': [
              'base/cert_database_openssl.cc',
              'base/cert_verify_proc_openssl.cc',
              'base/cert_verify_proc_openssl.h',
              'base/crypto_module_openssl.cc',
              'base/keygen_handler_openssl.cc',
              'base/openssl_memory_private_key_store.cc',
              'base/openssl_private_key_store.h',
              'base/openssl_private_key_store_android.cc',
              'base/test_root_certs_openssl.cc',
              'base/x509_certificate_openssl.cc',
              'base/x509_util_openssl.cc',
              'base/x509_util_openssl.h',
              'socket/ssl_client_socket_openssl.cc',
              'socket/ssl_client_socket_openssl.h',
              'socket/ssl_server_socket_openssl.cc',
            ],
          },
        ],
        [ 'use_glib == 1', {
            'dependencies': [
              '../build/linux/system.gyp:gconf',
              '../build/linux/system.gyp:gio',
            ],
            'conditions': [
              ['use_openssl==1', {
                'dependencies': [
                  '../third_party/openssl/openssl.gyp:openssl',
                ],
              },
              {  # else use_openssl==0, use NSS
                'dependencies': [
                  '../build/linux/system.gyp:ssl',
                ],
              }],
              ['os_bsd==1', {
                'sources!': [
                  'base/network_change_notifier_linux.cc',
                  'base/network_change_notifier_netlink_linux.cc',
                  'proxy/proxy_config_service_linux.cc',
                ],
              },{
                'dependencies': [
                  '../build/linux/system.gyp:libresolv',
                ],
              }],
              ['OS=="solaris"', {
                'link_settings': {
                  'ldflags': [
                    '-R/usr/lib/mps',
                  ],
                },
              }],
            ],
          },
          {  # else: OS is not in the above list
            'sources!': [
              'base/cert_database_nss.cc',
              'base/crypto_module_nss.cc',
              'base/keygen_handler_nss.cc',
              'base/nss_cert_database.cc',
              'base/nss_cert_database.h',
              'base/test_root_certs_nss.cc',
              'base/x509_certificate_nss.cc',
              'ocsp/nss_ocsp.cc',
              'ocsp/nss_ocsp.h',
              'third_party/mozilla_security_manager/nsKeygenHandler.cpp',
              'third_party/mozilla_security_manager/nsKeygenHandler.h',
              'third_party/mozilla_security_manager/nsNSSCertificateDB.cpp',
              'third_party/mozilla_security_manager/nsNSSCertificateDB.h',
              'third_party/mozilla_security_manager/nsPKCS12Blob.cpp',
              'third_party/mozilla_security_manager/nsPKCS12Blob.h',
            ],
          },
        ],
        [ 'toolkit_uses_gtk == 1', {
          'dependencies': [
            '../build/linux/system.gyp:gdk',
          ],
        }],
        [ 'use_nss != 1', {
            'sources!': [
              'base/cert_verify_proc_nss.cc',
              'base/cert_verify_proc_nss.h',
            ],
        }],
        [ 'enable_websockets != 1', {
            'sources/': [
              ['exclude', '^socket_stream/'],
              ['exclude', '^websockets/'],
            ],
            'sources!': [
              'spdy/spdy_websocket_stream.cc',
              'spdy/spdy_websocket_stream.h',
            ],
        }],
        [ 'OS == "win"', {
            'sources!': [
              'http/http_auth_handler_ntlm_portable.cc',
              'socket/tcp_client_socket_libevent.cc',
              'socket/tcp_client_socket_libevent.h',
              'socket/tcp_server_socket_libevent.cc',
              'socket/tcp_server_socket_libevent.h',
              'udp/udp_socket_libevent.cc',
              'udp/udp_socket_libevent.h',
            ],
            'dependencies': [
              '../third_party/nss/nss.gyp:nspr',
              '../third_party/nss/nss.gyp:nss',
              'third_party/nss/ssl.gyp:libssl',
              'tld_cleanup',
            ],
          }, { # else: OS != "win"
            'sources!': [
              'base/winsock_init.cc',
              'base/winsock_init.h',
              'base/winsock_util.cc',
              'base/winsock_util.h',
              'proxy/proxy_resolver_winhttp.cc',
              'proxy/proxy_resolver_winhttp.h',
            ],
          },
        ],
        [ 'OS == "mac"', {
            'dependencies': [
              '../third_party/nss/nss.gyp:nspr',
              '../third_party/nss/nss.gyp:nss',
              'third_party/nss/ssl.gyp:libssl',
            ],
            'link_settings': {
              'libraries': [
                '$(SDKROOT)/System/Library/Frameworks/Foundation.framework',
                '$(SDKROOT)/System/Library/Frameworks/Security.framework',
                '$(SDKROOT)/System/Library/Frameworks/SystemConfiguration.framework',
                '$(SDKROOT)/usr/lib/libresolv.dylib',
              ]
            },
          },
        ],
        [ 'OS == "ios"', {
            'dependencies': [
              '../third_party/nss/nss.gyp:nss',
              'third_party/nss/ssl.gyp:libssl',
            ],
            'link_settings': {
              'libraries': [
                '$(SDKROOT)/System/Library/Frameworks/CFNetwork.framework',
                '$(SDKROOT)/System/Library/Frameworks/MobileCoreServices.framework',
                '$(SDKROOT)/System/Library/Frameworks/Security.framework',
                '$(SDKROOT)/System/Library/Frameworks/SystemConfiguration.framework',
                '$(SDKROOT)/usr/lib/libresolv.dylib',
              ],
            },
          },
        ],
        ['OS=="android" and _toolset=="target" and android_build_type == 0', {
          'dependencies': [
             'net_java',
          ],
        }],
        [ 'OS == "android"', {
            'dependencies': [
              '../third_party/openssl/openssl.gyp:openssl',
              'net_jni_headers',
            ],
            'sources!': [
              'base/cert_database_openssl.cc',
              'base/cert_verify_proc_openssl.cc',
              'base/openssl_memory_private_key_store.cc',
              'base/test_root_certs_openssl.cc',
            ],
          }, {  # else OS != "android"
            'defines': [
              # These are the features Android doesn't support.
              'ENABLE_MEDIA_CODEC_THEORA',
            ],
          },
        ],
        [ 'OS == "linux"', {
            'dependencies': [
              '../build/linux/system.gyp:dbus',
              '../dbus/dbus.gyp:dbus',
            ],
          },
        ],
      ],
      'target_conditions': [
        # These source files are excluded by default platform rules, but they
        # are needed in specific cases on other platforms. Re-including them can
        # only be done in target_conditions as it is evaluated after the
        # platform rules.
        ['OS == "android"', {
          'sources/': [
            ['include', '^base/platform_mime_util_linux\\.cc$'],
          ],
        }],
        ['OS == "ios"', {
          'sources/': [
            ['include', '^base/network_change_notifier_mac\\.cc$'],
            ['include', '^base/network_config_watcher_mac\\.cc$'],
            ['include', '^base/platform_mime_util_mac\\.mm$'],
            ['include', '^dns/notify_watcher_mac\\.cc$'],
            ['include', '^proxy/proxy_resolver_mac\\.cc$'],
            ['include', '^proxy/proxy_server_mac\\.cc$'],
            # The iOS implementation only partially uses NSS and thus does not
            # defines |use_nss|. In particular the |USE_NSS| preprocessor
            # definition is not used. The following files are needed though:
            ['include', '^base/cert_verify_proc_nss\\.cc$'],
            ['include', '^base/cert_verify_proc_nss\\.h$'],
            ['include', '^base/test_root_certs_nss\\.cc$'],
            ['include', '^base/x509_util_nss\\.cc$'],
            ['include', '^base/x509_util_nss\\.h$'],
            ['include', '^ocsp/nss_ocsp\\.cc$'],
            ['include', '^ocsp/nss_ocsp\\.h$'],
          ],
        }],
      ],
    },
    {
      'target_name': 'net_unittests',
      'type': '<(gtest_target_type)',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:base_i18n',
        '../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
        '../build/temp_gyp/googleurl.gyp:googleurl',
        '../crypto/crypto.gyp:crypto',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        '../third_party/zlib/zlib.gyp:zlib',
        'net',
        'net_test_support',
      ],
      'sources': [
        'android/network_change_notifier_android_unittest.cc',
        'base/address_list_unittest.cc',
        'base/address_tracker_linux_unittest.cc',
        'base/backoff_entry_unittest.cc',
        'base/big_endian_unittest.cc',
        'base/cert_verify_proc_unittest.cc',
        'base/crl_set_unittest.cc',
        'base/data_url_unittest.cc',
        'base/default_server_bound_cert_store_unittest.cc',
        'base/directory_lister_unittest.cc',
        'base/dns_util_unittest.cc',
        'base/dnsrr_resolver_unittest.cc',
        'base/escape_unittest.cc',
        'base/ev_root_ca_metadata_unittest.cc',
        'base/expiring_cache_unittest.cc',
        'base/file_stream_unittest.cc',
        'base/filter_unittest.cc',
        'base/int128_unittest.cc',
        'base/gzip_filter_unittest.cc',
        'base/host_cache_unittest.cc',
        'base/host_mapping_rules_unittest.cc',
        'base/host_port_pair_unittest.cc',
        'base/host_resolver_impl_unittest.cc',
        'base/ip_endpoint_unittest.cc',
        'base/keygen_handler_unittest.cc',
        'base/mapped_host_resolver_unittest.cc',
        'base/mime_sniffer_unittest.cc',
        'base/mime_util_unittest.cc',
        'base/mock_filter_context.cc',
        'base/mock_filter_context.h',
        'base/multi_threaded_cert_verifier_unittest.cc',
        'base/net_log_unittest.h',
        'base/net_util_unittest.cc',
        'base/network_change_notifier_win_unittest.cc',
        'base/nss_cert_database_unittest.cc',
        'base/pem_tokenizer_unittest.cc',
        'base/prioritized_dispatcher_unittest.cc',
        'base/priority_queue_unittest.cc',
        'base/registry_controlled_domains/registry_controlled_domain_unittest.cc',
        'base/run_all_unittests.cc',
        'base/sdch_filter_unittest.cc',
        'base/server_bound_cert_service_unittest.cc',
        'base/single_request_host_resolver_unittest.cc',
        'base/ssl_cipher_suite_names_unittest.cc',
        'base/ssl_client_auth_cache_unittest.cc',
        'base/ssl_config_service_unittest.cc',
        'base/static_cookie_policy_unittest.cc',
        'base/tcp_listen_socket_unittest.cc',
        'base/tcp_listen_socket_unittest.h',
        'base/test_certificate_data.h',
        'base/test_completion_callback_unittest.cc',
        'base/transport_security_state_unittest.cc',
        'base/unix_domain_socket_posix_unittest.cc',
        'base/upload_bytes_element_reader_unittest.cc',
        'base/upload_data_stream_unittest.cc',
        'base/upload_file_element_reader_unittest.cc',
        'base/x509_certificate_unittest.cc',
        'base/x509_cert_types_unittest.cc',
        'base/x509_util_unittest.cc',
        'base/x509_util_nss_unittest.cc',
        'base/x509_util_openssl_unittest.cc',
        'cookies/canonical_cookie_unittest.cc',
        'cookies/cookie_monster_unittest.cc',
        'cookies/cookie_store_unittest.h',
        'cookies/cookie_util_unittest.cc',
        'cookies/parsed_cookie_unittest.cc',
        'disk_cache/addr_unittest.cc',
        'disk_cache/backend_unittest.cc',
        'disk_cache/bitmap_unittest.cc',
        'disk_cache/block_files_unittest.cc',
        'disk_cache/cache_util_unittest.cc',
        'disk_cache/entry_unittest.cc',
        'disk_cache/mapped_file_unittest.cc',
        'disk_cache/storage_block_unittest.cc',
        'disk_cache/flash/log_store_entry_unittest.cc',
        'disk_cache/flash/log_store_unittest.cc',
        'disk_cache/flash/segment_unittest.cc',
        'disk_cache/flash/storage_unittest.cc',
        'dns/address_sorter_posix_unittest.cc',
        'dns/address_sorter_unittest.cc',
        'dns/dns_config_service_posix_unittest.cc',
        'dns/dns_config_service_unittest.cc',
        'dns/dns_config_service_win_unittest.cc',
        'dns/dns_hosts_unittest.cc',
        'dns/dns_query_unittest.cc',
        'dns/dns_response_unittest.cc',
        'dns/dns_session_unittest.cc',
        'dns/dns_transaction_unittest.cc',
        'dns/serial_worker_unittest.cc',
        'ftp/ftp_auth_cache_unittest.cc',
        'ftp/ftp_ctrl_response_buffer_unittest.cc',
        'ftp/ftp_directory_listing_parser_ls_unittest.cc',
        'ftp/ftp_directory_listing_parser_netware_unittest.cc',
        'ftp/ftp_directory_listing_parser_os2_unittest.cc',
        'ftp/ftp_directory_listing_parser_unittest.cc',
        'ftp/ftp_directory_listing_parser_unittest.h',
        'ftp/ftp_directory_listing_parser_vms_unittest.cc',
        'ftp/ftp_directory_listing_parser_windows_unittest.cc',
        'ftp/ftp_network_transaction_unittest.cc',
        'ftp/ftp_util_unittest.cc',
        'http/des_unittest.cc',
        'http/http_auth_cache_unittest.cc',
        'http/http_auth_controller_unittest.cc',
        'http/http_auth_filter_unittest.cc',
        'http/http_auth_gssapi_posix_unittest.cc',
        'http/http_auth_handler_basic_unittest.cc',
        'http/http_auth_handler_digest_unittest.cc',
        'http/http_auth_handler_factory_unittest.cc',
        'http/http_auth_handler_mock.cc',
        'http/http_auth_handler_mock.h',
        'http/http_auth_handler_negotiate_unittest.cc',
        'http/http_auth_handler_unittest.cc',
        'http/http_auth_sspi_win_unittest.cc',
        'http/http_auth_unittest.cc',
        'http/http_byte_range_unittest.cc',
        'http/http_cache_unittest.cc',
        'http/http_chunked_decoder_unittest.cc',
        'http/http_content_disposition_unittest.cc',
        'http/http_network_layer_unittest.cc',
        'http/http_network_transaction_spdy3_unittest.cc',
        'http/http_network_transaction_spdy2_unittest.cc',
        'http/http_pipelined_connection_impl_unittest.cc',
        'http/http_pipelined_host_forced_unittest.cc',
        'http/http_pipelined_host_impl_unittest.cc',
        'http/http_pipelined_host_pool_unittest.cc',
        'http/http_pipelined_host_test_util.cc',
        'http/http_pipelined_host_test_util.h',
        'http/http_pipelined_network_transaction_unittest.cc',
        'http/http_proxy_client_socket_pool_spdy2_unittest.cc',
        'http/http_proxy_client_socket_pool_spdy3_unittest.cc',
        'http/http_request_headers_unittest.cc',
        'http/http_response_body_drainer_unittest.cc',
        'http/http_response_headers_unittest.cc',
        'http/http_server_properties_impl_unittest.cc',
        'http/http_stream_factory_impl_unittest.cc',
        'http/http_stream_parser_unittest.cc',
        'http/http_transaction_unittest.cc',
        'http/http_transaction_unittest.h',
        'http/http_util_unittest.cc',
        'http/http_vary_data_unittest.cc',
        'http/infinite_cache_unittest.cc',
        'http/mock_allow_url_security_manager.cc',
        'http/mock_allow_url_security_manager.h',
        'http/mock_gssapi_library_posix.cc',
        'http/mock_gssapi_library_posix.h',
        'http/mock_http_cache.cc',
        'http/mock_http_cache.h',
        'http/mock_sspi_library_win.cc',
        'http/mock_sspi_library_win.h',
        'http/url_security_manager_unittest.cc',
        'proxy/dhcp_proxy_script_adapter_fetcher_win_unittest.cc',
        'proxy/dhcp_proxy_script_fetcher_factory_unittest.cc',
        'proxy/dhcp_proxy_script_fetcher_win_unittest.cc',
        'proxy/multi_threaded_proxy_resolver_unittest.cc',
        'proxy/network_delegate_error_observer_unittest.cc',
        'proxy/proxy_bypass_rules_unittest.cc',
        'proxy/proxy_config_service_android_unittest.cc',
        'proxy/proxy_config_service_linux_unittest.cc',
        'proxy/proxy_config_service_win_unittest.cc',
        'proxy/proxy_config_unittest.cc',
        'proxy/proxy_info_unittest.cc',
        'proxy/proxy_list_unittest.cc',
        'proxy/proxy_resolver_js_bindings_unittest.cc',
        'proxy/proxy_resolver_v8_unittest.cc',
        'proxy/proxy_script_decider_unittest.cc',
        'proxy/proxy_script_fetcher_impl_unittest.cc',
        'proxy/proxy_server_unittest.cc',
        'proxy/proxy_service_unittest.cc',
        'proxy/sync_host_resolver_bridge_unittest.cc',
        'quic/congestion_control/cubic_test.cc',
        'quic/congestion_control/fix_rate_test.cc',
        'quic/congestion_control/hybrid_slow_start_test.cc',
        'quic/congestion_control/leaky_bucket_test.cc',
        'quic/congestion_control/paced_sender_test.cc',
        'quic/congestion_control/quic_receipt_metrics_collector_test.cc',
        'quic/congestion_control/quic_send_scheduler_test.cc',
        'quic/congestion_control/tcp_cubic_sender_test.cc',
        'quic/congestion_control/tcp_receiver_test.cc',
        'quic/crypto/crypto_framer_test.cc',
        'quic/crypto/null_decrypter_test.cc',
        'quic/crypto/null_encrypter_test.cc',
        'quic/crypto/quic_random_test.cc',
        'quic/test_tools/mock_clock.cc',
        'quic/test_tools/mock_clock.h',
        'quic/test_tools/quic_test_utils.cc',
        'quic/test_tools/quic_test_utils.h',
        'quic/test_tools/test_task_runner.cc',
        'quic/test_tools/test_task_runner.h',
        'quic/quic_client_session_test.cc',
        'quic/quic_clock_test.cc',
        'quic/quic_connection_helper_test.cc',
        'quic/quic_connection_test.cc',
        'quic/quic_crypto_client_stream_test.cc',
        'quic/quic_crypto_stream_test.cc',
        'quic/quic_fec_group_test.cc',
        'quic/quic_framer_test.cc',
        'quic/quic_http_stream_test.cc',
        'quic/quic_packet_creator_test.cc',
        'quic/quic_reliable_client_stream_test.cc',
        'quic/quic_session_test.cc',
        'quic/quic_stream_factory_test.cc',
        'quic/quic_stream_sequencer_test.cc',
        'quic/quic_time_test.cc',
        'socket/buffered_write_stream_socket_unittest.cc',
        'socket/client_socket_pool_base_unittest.cc',
        'socket/deterministic_socket_data_unittest.cc',
        'socket/mock_client_socket_pool_manager.cc',
        'socket/mock_client_socket_pool_manager.h',
        'socket/socks5_client_socket_unittest.cc',
        'socket/socks_client_socket_pool_unittest.cc',
        'socket/socks_client_socket_unittest.cc',
        'socket/ssl_client_socket_pool_unittest.cc',
        'socket/ssl_client_socket_unittest.cc',
        'socket/ssl_server_socket_unittest.cc',
        'socket/tcp_client_socket_unittest.cc',
        'socket/tcp_server_socket_unittest.cc',
        'socket/transport_client_socket_pool_unittest.cc',
        'socket/transport_client_socket_unittest.cc',
        'socket_stream/socket_stream_metrics_unittest.cc',
        'socket_stream/socket_stream_unittest.cc',
        'spdy/buffered_spdy_framer_spdy3_unittest.cc',
        'spdy/buffered_spdy_framer_spdy2_unittest.cc',
        'spdy/spdy_credential_builder_unittest.cc',
        'spdy/spdy_credential_state_unittest.cc',
        'spdy/spdy_frame_reader_test.cc',
        'spdy/spdy_framer_test.cc',
        'spdy/spdy_header_block_unittest.cc',
        'spdy/spdy_http_stream_spdy3_unittest.cc',
        'spdy/spdy_http_stream_spdy2_unittest.cc',
        'spdy/spdy_http_utils_unittest.cc',
        'spdy/spdy_network_transaction_spdy3_unittest.cc',
        'spdy/spdy_network_transaction_spdy2_unittest.cc',
        'spdy/spdy_protocol_test.cc',
        'spdy/spdy_proxy_client_socket_spdy3_unittest.cc',
        'spdy/spdy_proxy_client_socket_spdy2_unittest.cc',
        'spdy/spdy_session_spdy3_unittest.cc',
        'spdy/spdy_session_spdy2_unittest.cc',
        'spdy/spdy_stream_spdy3_unittest.cc',
        'spdy/spdy_stream_spdy2_unittest.cc',
        'spdy/spdy_stream_test_util.cc',
        'spdy/spdy_stream_test_util.h',
        'spdy/spdy_test_util_spdy3.cc',
        'spdy/spdy_test_util_spdy3.h',
        'spdy/spdy_test_util_spdy2.cc',
        'spdy/spdy_test_util_spdy2.h',
        'spdy/spdy_websocket_stream_spdy2_unittest.cc',
        'spdy/spdy_websocket_stream_spdy3_unittest.cc',
        'spdy/spdy_websocket_test_util_spdy2.cc',
        'spdy/spdy_websocket_test_util_spdy2.h',
        'spdy/spdy_websocket_test_util_spdy3.cc',
        'spdy/spdy_websocket_test_util_spdy3.h',
        'test/python_utils_unittest.cc',
        'tools/dump_cache/url_to_filename_encoder.cc',
        'tools/dump_cache/url_to_filename_encoder.h',
        'tools/dump_cache/url_to_filename_encoder_unittest.cc',
        'tools/dump_cache/url_utilities.h',
        'tools/dump_cache/url_utilities.cc',
        'tools/dump_cache/url_utilities_unittest.cc',
        'udp/udp_socket_unittest.cc',
        'url_request/url_fetcher_impl_unittest.cc',
        'url_request/url_request_context_builder_unittest.cc',
        'url_request/url_request_filter_unittest.cc',
        'url_request/url_request_ftp_job_unittest.cc',
        'url_request/url_request_job_factory_impl_unittest.cc',
        'url_request/url_request_job_unittest.cc',
        'url_request/url_request_throttler_simulation_unittest.cc',
        'url_request/url_request_throttler_test_support.cc',
        'url_request/url_request_throttler_test_support.h',
        'url_request/url_request_throttler_unittest.cc',
        'url_request/url_request_unittest.cc',
        'url_request/view_cache_helper_unittest.cc',
        'websockets/websocket_frame_parser_unittest.cc',
        'websockets/websocket_frame_unittest.cc',
        'websockets/websocket_handshake_handler_unittest.cc',
        'websockets/websocket_handshake_handler_spdy2_unittest.cc',
        'websockets/websocket_handshake_handler_spdy3_unittest.cc',
        'websockets/websocket_job_spdy2_unittest.cc',
        'websockets/websocket_job_spdy3_unittest.cc',
        'websockets/websocket_net_log_params_unittest.cc',
        'websockets/websocket_throttle_unittest.cc',
      ],
      'conditions': [
        ['chromeos==1', {
          'sources!': [
            'base/network_change_notifier_linux_unittest.cc',
            'proxy/proxy_config_service_linux_unittest.cc',
          ],
        }],
        [ 'OS == "android"', {
          'sources!': [
            # No res_ninit() et al on Android, so this doesn't make a lot of
            # sense.
            'dns/dns_config_service_posix_unittest.cc',
          ],
        }],
        [ 'use_glib == 1', {
            'dependencies': [
              '../build/linux/system.gyp:ssl',
            ],
          }, {  # else use_glib == 0: !posix || mac
            'sources!': [
              'base/nss_cert_database_unittest.cc',
            ],
          },
        ],
        [ 'toolkit_uses_gtk == 1', {
            'dependencies': [
              '../build/linux/system.gyp:gtk',
            ],
          },
        ],
        [ 'os_posix == 1 and OS != "mac" and OS != "android" and OS != "ios"', {
          'conditions': [
            ['linux_use_tcmalloc==1', {
              'dependencies': [
                '../base/allocator/allocator.gyp:allocator',
              ],
            }],
          ],
        }],
        [ 'use_kerberos==1', {
          'defines': [
            'USE_KERBEROS',
          ],
        }, { # use_kerberos == 0
          'sources!': [
            'http/http_auth_gssapi_posix_unittest.cc',
            'http/http_auth_handler_negotiate_unittest.cc',
            'http/mock_gssapi_library_posix.cc',
            'http/mock_gssapi_library_posix.h',
          ],
        }],
        [ 'use_openssl==1', {
            # When building for OpenSSL, we need to exclude NSS specific tests.
            # TODO(bulach): Add equivalent tests when the underlying
            #               functionality is ported to OpenSSL.
            'sources!': [
              'base/x509_util_nss_unittest.cc',
              'base/nss_cert_database_unittest.cc',
            ],
          }, {  # else !use_openssl: remove the unneeded files
            'sources!': [
              'base/x509_util_openssl_unittest.cc',
            ],
          },
        ],
        [ 'enable_websockets != 1', {
            'sources/': [
              ['exclude', '^socket_stream/'],
              ['exclude', '^websockets/'],
              ['exclude', '^spdy/spdy_websocket_stream_spdy._unittest\\.cc$'],
            ],
        }],
        [ 'disable_ftp_support==1', {
            'sources/': [
              ['exclude', '^ftp/'],
            ],
            'sources!': [
              'url_request/url_request_ftp_job_unittest.cc',
            ],
          },
        ],
        [ 'enable_built_in_dns!=1', {
            'sources!': [
              'dns/address_sorter_posix_unittest.cc',
              'dns/address_sorter_unittest.cc',
            ],
          },
        ],
        [ 'use_v8_in_net==1', {
            'dependencies': [
              'net_with_v8',
            ],
          }, {  # else: !use_v8_in_net
            'sources!': [
              'proxy/proxy_resolver_v8_unittest.cc',
            ],
          },
        ],
        [ 'OS == "win"', {
            'sources!': [
              'dns/dns_config_service_posix_unittest.cc',
              'http/http_auth_gssapi_posix_unittest.cc',
            ],
            # This is needed to trigger the dll copy step on windows.
            # TODO(mark): Specifying this here shouldn't be necessary.
            'dependencies': [
              '../third_party/icu/icu.gyp:icudata',
              '../third_party/nss/nss.gyp:nspr',
              '../third_party/nss/nss.gyp:nss',
              'third_party/nss/ssl.gyp:libssl',
            ],
          },
        ],
        [ 'OS == "mac"', {
            'dependencies': [
              '../third_party/nss/nss.gyp:nspr',
              '../third_party/nss/nss.gyp:nss',
              'third_party/nss/ssl.gyp:libssl',
            ],
          },
        ],
        [ 'OS == "ios"', {
            'dependencies': [
              '../third_party/nss/nss.gyp:nss',
            ],
            'actions': [
              {
                'action_name': 'copy_test_data',
                'variables': {
                  'test_data_files': [
                    'data/ssl/certificates/',
                    'data/url_request_unittest/',
                  ],
                  'test_data_prefix': 'net',
                },
                'includes': [ '../build/copy_test_data_ios.gypi' ],
              },
            ],
            'sources!': [
              # TODO(droger): The following tests are disabled because the
              # implementation is missing or incomplete.
              # KeygenHandler::GenKeyAndSignChallenge() is not ported to iOS.
              'base/keygen_handler_unittest.cc',
              # Need to read input data files.
              'base/gzip_filter_unittest.cc',
              'disk_cache/backend_unittest.cc',
              'disk_cache/block_files_unittest.cc',
              'socket/ssl_server_socket_unittest.cc',
              # Need TestServer.
              'proxy/proxy_script_fetcher_impl_unittest.cc',
              'socket/ssl_client_socket_unittest.cc',
              'url_request/url_fetcher_impl_unittest.cc',
              'url_request/url_request_context_builder_unittest.cc',
              # Needs GetAppOutput().
              'test/python_utils_unittest.cc',

              # The following tests are disabled because they don't apply to
              # iOS.
              # OS is not "linux" or "freebsd" or "openbsd".
              'base/unix_domain_socket_posix_unittest.cc',
            ],
            'conditions': [
              ['coverage != 0', {
                'sources!': [
                  # These sources can't be built with coverage due to a
                  # toolchain bug: http://openradar.appspot.com/radar?id=1499403
                  'base/transport_security_state_unittest.cc',

                  # These tests crash when run with coverage turned on due to an
                  # issue with llvm_gcda_increment_indirect_counter:
                  # http://crbug.com/156058
                  'cookies/cookie_monster_unittest.cc',
                  'cookies/cookie_store_unittest.h',
                  'http/http_auth_controller_unittest.cc',
                  'http/http_network_layer_unittest.cc',
                  'http/http_network_transaction_spdy2_unittest.cc',
                  'http/http_network_transaction_spdy3_unittest.cc',
                ],
              }],
            ],
        }],
        [ 'OS == "linux"', {
            'dependencies': [
              '../build/linux/system.gyp:dbus',
              '../dbus/dbus.gyp:dbus_test_support',
            ],
          },
        ],
        [ 'OS == "android"', {
            'dependencies': [
              '../third_party/openssl/openssl.gyp:openssl',
            ],
            'sources!': [
              'dns/dns_config_service_posix_unittest.cc',
            ],
          },
        ],
        ['OS == "android" and gtest_target_type == "shared_library"', {
          'dependencies': [
            '../testing/android/native_test.gyp:native_test_native_code',
          ]
        }],
        [ 'OS != "win" and OS != "mac"', {
          'sources!': [
            'base/x509_cert_types_unittest.cc',
          ],
        }],
      ],
    },
    {
      'target_name': 'net_perftests',
      'type': 'executable',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:base_i18n',
        '../base/base.gyp:test_support_perf',
        '../build/temp_gyp/googleurl.gyp:googleurl',
        '../testing/gtest.gyp:gtest',
        'net',
        'net_test_support',
      ],
      'sources': [
        'cookies/cookie_monster_perftest.cc',
        'disk_cache/disk_cache_perftest.cc',
        'proxy/proxy_resolver_perftest.cc',
      ],
      'conditions': [
        [ 'use_v8_in_net==1', {
            'dependencies': [
              'net_with_v8',
            ],
          }, {  # else: !use_v8_in_net
            'sources!': [
              'proxy/proxy_resolver_perftest.cc',
            ],
          },
        ],
        # This is needed to trigger the dll copy step on windows.
        # TODO(mark): Specifying this here shouldn't be necessary.
        [ 'OS == "win"', {
            'dependencies': [
              '../third_party/icu/icu.gyp:icudata',
            ],
          },
        ],
      ],
    },
    {
      'target_name': 'net_test_support',
      'type': 'static_library',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:test_support_base',
        '../testing/gtest.gyp:gtest',
        'net',
      ],
      'export_dependent_settings': [
        '../base/base.gyp:base',
        '../base/base.gyp:test_support_base',
        '../testing/gtest.gyp:gtest',
      ],
      'sources': [
        'base/capturing_net_log.cc',
        'base/capturing_net_log.h',
        'base/cert_test_util.cc',
        'base/cert_test_util.h',
        'base/mock_cert_verifier.cc',
        'base/mock_cert_verifier.h',
        'base/mock_file_stream.cc',
        'base/mock_file_stream.h',
        'base/mock_host_resolver.cc',
        'base/mock_host_resolver.h',
        'base/net_test_suite.cc',
        'base/net_test_suite.h',
        'base/test_completion_callback.cc',
        'base/test_completion_callback.h',
        'base/test_data_directory.cc',
        'base/test_data_directory.h',
        'cookies/cookie_monster_store_test.cc',
        'cookies/cookie_monster_store_test.h',
        'cookies/cookie_store_test_callbacks.cc',
        'cookies/cookie_store_test_callbacks.h',
        'cookies/cookie_store_test_helpers.cc',
        'cookies/cookie_store_test_helpers.h',
        'disk_cache/disk_cache_test_base.cc',
        'disk_cache/disk_cache_test_base.h',
        'disk_cache/disk_cache_test_util.cc',
        'disk_cache/disk_cache_test_util.h',
        'disk_cache/flash/flash_cache_test_base.h',
        'disk_cache/flash/flash_cache_test_base.cc',
        'dns/dns_test_util.cc',
        'dns/dns_test_util.h',
        'proxy/mock_proxy_resolver.cc',
        'proxy/mock_proxy_resolver.h',
        'proxy/mock_proxy_script_fetcher.cc',
        'proxy/mock_proxy_script_fetcher.h',
        'proxy/proxy_config_service_common_unittest.cc',
        'proxy/proxy_config_service_common_unittest.h',
        'socket/socket_test_util.cc',
        'socket/socket_test_util.h',
        'test/base_test_server.cc',
        'test/base_test_server.h',
        'test/local_sync_test_server.cc',
        'test/local_sync_test_server.h',
        'test/local_test_server_posix.cc',
        'test/local_test_server_win.cc',
        'test/local_test_server.cc',
        'test/local_test_server.h',
        'test/python_utils.cc',
        'test/python_utils.h',
        'test/remote_test_server.cc',
        'test/remote_test_server.h',
        'test/spawner_communicator.cc',
        'test/spawner_communicator.h',
        'test/test_server.h',
        'url_request/test_url_fetcher_factory.cc',
        'url_request/test_url_fetcher_factory.h',
        'url_request/url_request_test_util.cc',
        'url_request/url_request_test_util.h',
      ],
      'conditions': [
        ['inside_chromium_build==1 and OS != "ios"', {
          'dependencies': [
            # The test server uses Python modules generated by cloud print.
            # TODO(sync): Remove this hack (http://crbug.com/119403).
            '../chrome/app/policy/cloud_policy_codegen.gyp:cloud_policy_proto_compile',
            # The test server uses Python modules generated by the sync protos.
            # TODO(sync): Remove this hack (http://crbug.com/117559).
            '../sync/protocol/sync_proto.gyp:sync_proto',
            '../third_party/protobuf/protobuf.gyp:py_proto',
          ],
        }],
        ['os_posix == 1 and OS != "mac" and OS != "android" and OS != "ios"', {
          'conditions': [
            ['use_openssl==1', {
              'dependencies': [
                '../third_party/openssl/openssl.gyp:openssl',
              ],
            }, {
              'dependencies': [
                '../build/linux/system.gyp:ssl',
              ],
            }],
          ],
        }],
        ['os_posix == 1 and OS != "mac" and OS != "android" and OS != "ios"', {
          'conditions': [
            ['linux_use_tcmalloc==1', {
              'dependencies': [
                '../base/allocator/allocator.gyp:allocator',
              ],
            }],
          ],
        }],
        ['OS != "android"', {
          'sources!': [
            'test/remote_test_server.cc',
            'test/remote_test_server.h',
            'test/spawner_communicator.cc',
            'test/spawner_communicator.h',
          ],
        }],
        ['OS == "ios"', {
          'dependencies': [
            '../third_party/nss/nss.gyp:nss',
          ],
        }],
        [ 'use_v8_in_net==1', {
            'dependencies': [
              'net_with_v8',
            ],
          },
        ],
      ],
    },
    {
      'target_name': 'net_resources',
      'type': 'none',
      'variables': {
        'grit_out_dir': '<(SHARED_INTERMEDIATE_DIR)/net',
      },
      'actions': [
        {
          'action_name': 'net_resources',
          'variables': {
            'grit_grd_file': 'base/net_resources.grd',
          },
          'includes': [ '../build/grit_action.gypi' ],
        },
      ],
      'includes': [ '../build/grit_target.gypi' ],
    },
    {
      'target_name': 'http_server',
      'type': 'static_library',
      'variables': { 'enable_wexit_time_destructors': 1, },
      'dependencies': [
        '../base/base.gyp:base',
        'net',
      ],
      'sources': [
        'server/http_connection.cc',
        'server/http_connection.h',
        'server/http_server.cc',
        'server/http_server.h',
        'server/http_server_request_info.cc',
        'server/http_server_request_info.h',
        'server/web_socket.cc',
        'server/web_socket.h',
      ],
    },
    {
      'target_name': 'dump_cache',
      'type': 'executable',
      'dependencies': [
        '../base/base.gyp:base',
        'net',
        'net_test_support',
      ],
      'sources': [
        'tools/dump_cache/cache_dumper.cc',
        'tools/dump_cache/cache_dumper.h',
        'tools/dump_cache/dump_cache.cc',
        'tools/dump_cache/dump_files.cc',
        'tools/dump_cache/dump_files.h',
        'tools/dump_cache/simple_cache_dumper.cc',
        'tools/dump_cache/simple_cache_dumper.h',
        'tools/dump_cache/upgrade_win.cc',
        'tools/dump_cache/upgrade_win.h',
        'tools/dump_cache/url_to_filename_encoder.cc',
        'tools/dump_cache/url_to_filename_encoder.h',
        'tools/dump_cache/url_utilities.h',
        'tools/dump_cache/url_utilities.cc',
      ],
    },
  ],
  'conditions': [
    ['use_v8_in_net == 1', {
      'targets': [
        {
          'target_name': 'net_with_v8',
          'type': '<(component)',
          'variables': { 'enable_wexit_time_destructors': 1, },
          'dependencies': [
            '../base/base.gyp:base',
            '../build/temp_gyp/googleurl.gyp:googleurl',
            '../v8/tools/gyp/v8.gyp:v8',
            'net'
          ],
          'defines': [
            'NET_IMPLEMENTATION',
          ],
          'sources': [
            'proxy/proxy_resolver_v8.cc',
            'proxy/proxy_resolver_v8.h',
            'proxy/proxy_service_v8.cc',
            'proxy/proxy_service_v8.h',
          ],
        },
      ],
    }],
    ['OS != "ios"', {
      'targets': [
        # iOS doesn't have the concept of simple executables, these targets
        # can't be compiled on the platform.
        {
          'target_name': 'crash_cache',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            'net',
            'net_test_support',
          ],
          'sources': [
            'tools/crash_cache/crash_cache.cc',
          ],
        },
        {
          'target_name': 'crl_set_dump',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            'net',
          ],
          'sources': [
            'tools/crl_set_dump/crl_set_dump.cc',
          ],
        },
        {
          'target_name': 'dns_fuzz_stub',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            'net',
          ],
          'sources': [
            'tools/dns_fuzz_stub/dns_fuzz_stub.cc',
          ],
        },
        {
          'target_name': 'fetch_client',
          'type': 'executable',
          'variables': { 'enable_wexit_time_destructors': 1, },
          'dependencies': [
            '../base/base.gyp:base',
            '../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
            '../build/temp_gyp/googleurl.gyp:googleurl',
            '../testing/gtest.gyp:gtest',
            'net',
            'net_with_v8',
          ],
          'sources': [
            'tools/fetch/fetch_client.cc',
          ],
        },
        {
          'target_name': 'fetch_server',
          'type': 'executable',
          'variables': { 'enable_wexit_time_destructors': 1, },
          'dependencies': [
            '../base/base.gyp:base',
            '../build/temp_gyp/googleurl.gyp:googleurl',
            'net',
          ],
          'sources': [
            'tools/fetch/fetch_server.cc',
            'tools/fetch/http_listen_socket.cc',
            'tools/fetch/http_listen_socket.h',
            'tools/fetch/http_server.cc',
            'tools/fetch/http_server.h',
            'tools/fetch/http_server_request_info.cc',
            'tools/fetch/http_server_request_info.h',
            'tools/fetch/http_server_response_info.cc',
            'tools/fetch/http_server_response_info.h',
            'tools/fetch/http_session.cc',
            'tools/fetch/http_session.h',
          ],
        },
        {
          'target_name': 'gdig',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            'net',
          ],
          'sources': [
            'tools/gdig/file_net_log.cc',
            'tools/gdig/gdig.cc',
          ],
        },
        {
          'target_name': 'get_server_time',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            '../base/base.gyp:base_i18n',
            '../build/temp_gyp/googleurl.gyp:googleurl',
            'net',
          ],
          'sources': [
            'tools/get_server_time/get_server_time.cc',
          ],
        },
        {
          'target_name': 'net_watcher',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            'net',
            'net_with_v8',
          ],
          'conditions': [
            [ 'use_glib == 1', {
                'dependencies': [
                  '../build/linux/system.gyp:gconf',
                  '../build/linux/system.gyp:gio',
                ],
              },
            ],
          ],
          'sources': [
            'tools/net_watcher/net_watcher.cc',
          ],
        },
        {
          'target_name': 'run_testserver',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            '../build/temp_gyp/googleurl.gyp:googleurl',
            '../testing/gtest.gyp:gtest',
            'net',
            'net_test_support',
          ],
          'sources': [
            'tools/testserver/run_testserver.cc',
          ],
        },
        {
          'target_name': 'stress_cache',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            'net',
            'net_test_support',
          ],
          'sources': [
            'disk_cache/stress_cache.cc',
          ],
        },
        {
          'target_name': 'tld_cleanup',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            '../base/base.gyp:base_i18n',
            '../build/temp_gyp/googleurl.gyp:googleurl',
          ],
          'sources': [
            'tools/tld_cleanup/tld_cleanup.cc',
          ],
        },
      ],
    }],
    ['os_posix == 1 and OS != "mac" and OS != "ios" and OS != "android"', {
      'targets': [
        {
          'target_name': 'flip_in_mem_edsm_server',
          'type': 'executable',
          'cflags': [
            '-Wno-deprecated',
          ],
          'dependencies': [
            '../base/base.gyp:base',
            '../third_party/openssl/openssl.gyp:openssl',
            'net',
          ],
          'sources': [
            'tools/dump_cache/url_to_filename_encoder.cc',
            'tools/dump_cache/url_to_filename_encoder.h',
            'tools/dump_cache/url_utilities.h',
            'tools/dump_cache/url_utilities.cc',
            'tools/flip_server/acceptor_thread.h',
            'tools/flip_server/acceptor_thread.cc',
            'tools/flip_server/balsa_enums.h',
            'tools/flip_server/balsa_frame.cc',
            'tools/flip_server/balsa_frame.h',
            'tools/flip_server/balsa_headers.cc',
            'tools/flip_server/balsa_headers.h',
            'tools/flip_server/balsa_headers_token_utils.cc',
            'tools/flip_server/balsa_headers_token_utils.h',
            'tools/flip_server/balsa_visitor_interface.h',
            'tools/flip_server/buffer_interface.h',
            'tools/flip_server/constants.h',
            'tools/flip_server/create_listener.cc',
            'tools/flip_server/create_listener.h',
            'tools/flip_server/epoll_server.cc',
            'tools/flip_server/epoll_server.h',
            'tools/flip_server/flip_config.cc',
            'tools/flip_server/flip_config.h',
            'tools/flip_server/flip_in_mem_edsm_server.cc',
            'tools/flip_server/http_interface.cc',
            'tools/flip_server/http_interface.h',
            'tools/flip_server/http_message_constants.cc',
            'tools/flip_server/http_message_constants.h',
            'tools/flip_server/loadtime_measurement.h',
            'tools/flip_server/mem_cache.h',
            'tools/flip_server/mem_cache.cc',
            'tools/flip_server/output_ordering.cc',
            'tools/flip_server/output_ordering.h',
            'tools/flip_server/ring_buffer.cc',
            'tools/flip_server/ring_buffer.h',
            'tools/flip_server/simple_buffer.cc',
            'tools/flip_server/simple_buffer.h',
            'tools/flip_server/sm_connection.cc',
            'tools/flip_server/sm_connection.h',
            'tools/flip_server/sm_interface.h',
            'tools/flip_server/split.h',
            'tools/flip_server/split.cc',
            'tools/flip_server/spdy_ssl.cc',
            'tools/flip_server/spdy_ssl.h',
            'tools/flip_server/spdy_interface.cc',
            'tools/flip_server/spdy_interface.h',
            'tools/flip_server/spdy_util.cc',
            'tools/flip_server/spdy_util.h',
            'tools/flip_server/streamer_interface.cc',
            'tools/flip_server/streamer_interface.h',
            'tools/flip_server/string_piece_utils.h',
          ],
        },
      ]
    }],
    ['OS=="android"', {
      'targets': [
        {
          'target_name': 'net_jni_headers',
          'type': 'none',
          'sources': [
            'android/java/src/org/chromium/net/AndroidNetworkLibrary.java',
            'android/java/src/org/chromium/net/GURLUtils.java',
            'android/java/src/org/chromium/net/NetworkChangeNotifier.java',
            'android/java/src/org/chromium/net/ProxyChangeListener.java',
          ],
          'variables': {
            'jni_gen_dir': 'net',
          },
          'includes': [ '../build/jni_generator.gypi' ],
        },
        {
          'target_name': 'net_java',
          'type': 'none',
          'variables': {
            'package_name': 'net',
            'java_in_dir': '../net/android/java',
          },
          'dependencies': [
            '../base/base.gyp:base',
            'net_errors_java',
            'certificate_mime_types_java',
          ],
          'includes': [ '../build/java.gypi' ],
        },
        {
          'target_name': 'net_java_test_support',
          'type': 'none',
          'variables': {
            'package_name': 'net_java_test_support',
            'java_in_dir': '../net/test/android/javatests',
          },
          'includes': [ '../build/java.gypi' ],
        },
        {
          'target_name': 'net_javatests',
          'type': 'none',
          'variables': {
            'package_name': 'net_javatests',
            'java_in_dir': '../net/android/javatests',
          },
          'dependencies': [
            '../base/base.gyp:base',
            '../base/base.gyp:base_java_test_support',
            'net_java',
          ],
          'includes': [ '../build/java.gypi' ],
        },
        {
          'target_name': 'net_errors_java',
          'type': 'none',
          'sources': [
            'android/java/NetError.template',
          ],
          'variables': {
            'package_name': 'org.chromium.net',
            'template_deps': ['base/net_error_list.h'],
          },
          'includes': [ '../build/android/java_cpp_template.gypi' ],
        },
        {
          'target_name': 'certificate_mime_types_java',
          'type': 'none',
          'sources': [
            'android/java/CertificateMimeType.template',
          ],
          'variables': {
            'package_name': 'org.chromium.net',
            'template_deps': ['base/mime_util_certificate_type_list.h'],
          },
          'includes': [ '../build/android/java_cpp_template.gypi' ],
        },
      ],
    }],
    # Special target to wrap a gtest_target_type==shared_library
    # net_unittests into an android apk for execution.
    # See base.gyp for TODO(jrg)s about this strategy.
    ['OS == "android" and gtest_target_type == "shared_library"', {
      'targets': [
        {
          'target_name': 'net_unittests_apk',
          'type': 'none',
          'dependencies': [
            'net_java',
            'net_unittests',
          ],
          'variables': {
            'test_suite_name': 'net_unittests',
            'input_shlib_path': '<(SHARED_LIB_DIR)/<(SHARED_LIB_PREFIX)net_unittests<(SHARED_LIB_SUFFIX)',
          },
          'includes': [ '../build/apk_test.gypi' ],
        },
      ],
    }],
    ['test_isolation_mode != "noop"', {
      'targets': [
        {
          'target_name': 'net_unittests_run',
          'type': 'none',
          'dependencies': [
            'net_unittests',
          ],
          'includes': [
            'net_unittests.isolate',
          ],
          'actions': [
            {
              'action_name': 'isolate',
              'inputs': [
                'net_unittests.isolate',
                '<@(isolate_dependency_tracked)',
              ],
              'outputs': [
                '<(PRODUCT_DIR)/net_unittests.isolated',
              ],
              'action': [
                'python',
                '../tools/swarm_client/isolate.py',
                '<(test_isolation_mode)',
                '--outdir', '<(test_isolation_outdir)',
                '--variable', 'PRODUCT_DIR', '<(PRODUCT_DIR)',
                '--variable', 'OS', '<(OS)',
                '--result', '<@(_outputs)',
                '--isolate', 'net_unittests.isolate',
              ],
            },
          ],
        },
      ],
    }],
  ],
}
