/*
 * Copyright 2012 The Native Client Authors.  All rights reserved.
 * Use of this source code is governed by a BSD-style license that can
 * be found in the LICENSE file.
 */

// DO NOT EDIT: GENERATED CODE

#ifndef NACL_TRUSTED_BUT_NOT_TCB
#error This file is not meant for use in the TCB
#endif


#ifndef NATIVE_CLIENT_SRC_TRUSTED_VALIDATOR_ARM_GEN_ARM32_DECODE_NAMED_DECODER_H_
#define NATIVE_CLIENT_SRC_TRUSTED_VALIDATOR_ARM_GEN_ARM32_DECODE_NAMED_DECODER_H_

#include "native_client/src/trusted/validator_arm/decode.h"
#include "native_client/src/trusted/validator_arm/gen/arm32_decode_named_classes.h"
#include "native_client/src/trusted/validator_arm/named_class_decoder.h"

namespace nacl_arm_test {

// Defines a (named) decoder class selector for instructions
class NamedArm32DecoderState : nacl_arm_dec::DecoderState {
 public:
  explicit NamedArm32DecoderState();

  // Parses the given instruction, returning the named class
  // decoder to use.
  const NamedClassDecoder& decode_named(
     const nacl_arm_dec::Instruction) const;

  // Parses the given instruction, returning the class decoder
  // to use.
  virtual const nacl_arm_dec::ClassDecoder& decode(
     const nacl_arm_dec::Instruction) const;

  // The following fields define the set of class decoders
  // that can be returned by the API function "decode_named". They
  // are created once as instance fields, and then returned
  // by the table methods above. This speeds up the code since
  // the class decoders need to only be bulit once (and reused
  // for each call to "decode_named").
  const NamedBinary2RegisterBitRangeMsbGeLsb_Bfi_Rule_18_A1_P48 Binary2RegisterBitRangeMsbGeLsb_Bfi_Rule_18_A1_P48_instance_;
  const NamedBinary2RegisterBitRangeNotRnIsPcBitfieldExtract_Sbfx_Rule_154_A1_P308 Binary2RegisterBitRangeNotRnIsPcBitfieldExtract_Sbfx_Rule_154_A1_P308_instance_;
  const NamedBinary2RegisterBitRangeNotRnIsPcBitfieldExtract_Ubfx_Rule_236_A1_P466 Binary2RegisterBitRangeNotRnIsPcBitfieldExtract_Ubfx_Rule_236_A1_P466_instance_;
  const NamedBinary2RegisterImmedShiftedTest_CMN_register Binary2RegisterImmedShiftedTest_CMN_register_instance_;
  const NamedBinary2RegisterImmedShiftedTest_CMP_register Binary2RegisterImmedShiftedTest_CMP_register_instance_;
  const NamedBinary2RegisterImmedShiftedTest_TEQ_register Binary2RegisterImmedShiftedTest_TEQ_register_instance_;
  const NamedBinary2RegisterImmedShiftedTest_TST_register Binary2RegisterImmedShiftedTest_TST_register_instance_;
  const NamedBinary2RegisterImmediateOp_ADC_immediate Binary2RegisterImmediateOp_ADC_immediate_instance_;
  const NamedBinary2RegisterImmediateOp_AND_immediate Binary2RegisterImmediateOp_AND_immediate_instance_;
  const NamedBinary2RegisterImmediateOp_EOR_immediate Binary2RegisterImmediateOp_EOR_immediate_instance_;
  const NamedBinary2RegisterImmediateOp_RSB_immediate Binary2RegisterImmediateOp_RSB_immediate_instance_;
  const NamedBinary2RegisterImmediateOp_RSC_immediate Binary2RegisterImmediateOp_RSC_immediate_instance_;
  const NamedBinary2RegisterImmediateOp_SBC_immediate Binary2RegisterImmediateOp_SBC_immediate_instance_;
  const NamedBinary2RegisterImmediateOpAddSub_ADD_immediate Binary2RegisterImmediateOpAddSub_ADD_immediate_instance_;
  const NamedBinary2RegisterImmediateOpAddSub_SUB_immediate Binary2RegisterImmediateOpAddSub_SUB_immediate_instance_;
  const NamedBinary2RegisterImmediateOpDynCodeReplace_ORR_immediate Binary2RegisterImmediateOpDynCodeReplace_ORR_immediate_instance_;
  const NamedBinary3RegisterImmedShiftedOpRegsNotPc_Pkh_Rule_116_A1_P234 Binary3RegisterImmedShiftedOpRegsNotPc_Pkh_Rule_116_A1_P234_instance_;
  const NamedBinary3RegisterImmedShiftedOpRegsNotPc_Sxtab16_Rule_221_A1_P436 Binary3RegisterImmedShiftedOpRegsNotPc_Sxtab16_Rule_221_A1_P436_instance_;
  const NamedBinary3RegisterOp_ASR_register Binary3RegisterOp_ASR_register_instance_;
  const NamedBinary3RegisterOp_LSL_register Binary3RegisterOp_LSL_register_instance_;
  const NamedBinary3RegisterOp_LSR_register Binary3RegisterOp_LSR_register_instance_;
  const NamedBinary3RegisterOp_ROR_register Binary3RegisterOp_ROR_register_instance_;
  const NamedBinary3RegisterOpAltA_MUL_A1 Binary3RegisterOpAltA_MUL_A1_instance_;
  const NamedBinary3RegisterOpAltA_SMULBB_SMULBT_SMULTB_SMULTT Binary3RegisterOpAltA_SMULBB_SMULBT_SMULTB_SMULTT_instance_;
  const NamedBinary3RegisterOpAltA_SMULWB_SMULWT Binary3RegisterOpAltA_SMULWB_SMULWT_instance_;
  const NamedBinary3RegisterOpAltA_Usad8_Rule_253_A1_P500 Binary3RegisterOpAltA_Usad8_Rule_253_A1_P500_instance_;
  const NamedBinary3RegisterOpAltANoCondsUpdate_SDIV Binary3RegisterOpAltANoCondsUpdate_SDIV_instance_;
  const NamedBinary3RegisterOpAltANoCondsUpdate_SMMUL Binary3RegisterOpAltANoCondsUpdate_SMMUL_instance_;
  const NamedBinary3RegisterOpAltANoCondsUpdate_SMUAD Binary3RegisterOpAltANoCondsUpdate_SMUAD_instance_;
  const NamedBinary3RegisterOpAltANoCondsUpdate_SMUSD Binary3RegisterOpAltANoCondsUpdate_SMUSD_instance_;
  const NamedBinary3RegisterOpAltANoCondsUpdate_UDIV Binary3RegisterOpAltANoCondsUpdate_UDIV_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_QADD Binary3RegisterOpAltBNoCondUpdates_QADD_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_QDADD Binary3RegisterOpAltBNoCondUpdates_QDADD_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_QDSUB Binary3RegisterOpAltBNoCondUpdates_QDSUB_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_QSUB Binary3RegisterOpAltBNoCondUpdates_QSUB_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Qadd16_Rule_125_A1_P252 Binary3RegisterOpAltBNoCondUpdates_Qadd16_Rule_125_A1_P252_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Qadd8_Rule_126_A1_P254 Binary3RegisterOpAltBNoCondUpdates_Qadd8_Rule_126_A1_P254_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Qasx_Rule_127_A1_P256 Binary3RegisterOpAltBNoCondUpdates_Qasx_Rule_127_A1_P256_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Qsax_Rule_130_A1_P262 Binary3RegisterOpAltBNoCondUpdates_Qsax_Rule_130_A1_P262_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Qsub16_Rule_132_A1_P266 Binary3RegisterOpAltBNoCondUpdates_Qsub16_Rule_132_A1_P266_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Qsub8_Rule_133_A1_P268 Binary3RegisterOpAltBNoCondUpdates_Qsub8_Rule_133_A1_P268_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Sadd16_Rule_148_A1_P296 Binary3RegisterOpAltBNoCondUpdates_Sadd16_Rule_148_A1_P296_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Sadd8_Rule_149_A1_P298 Binary3RegisterOpAltBNoCondUpdates_Sadd8_Rule_149_A1_P298_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Sasx_Rule_150_A1_P300 Binary3RegisterOpAltBNoCondUpdates_Sasx_Rule_150_A1_P300_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Sel_Rule_156_A1_P312 Binary3RegisterOpAltBNoCondUpdates_Sel_Rule_156_A1_P312_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Shadd16_Rule_159_A1_P318 Binary3RegisterOpAltBNoCondUpdates_Shadd16_Rule_159_A1_P318_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Shadd8_Rule_160_A1_P320 Binary3RegisterOpAltBNoCondUpdates_Shadd8_Rule_160_A1_P320_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Shasx_Rule_161_A1_P322 Binary3RegisterOpAltBNoCondUpdates_Shasx_Rule_161_A1_P322_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Shsax_Rule_162_A1_P324 Binary3RegisterOpAltBNoCondUpdates_Shsax_Rule_162_A1_P324_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Shsub16_Rule_163_A1_P326 Binary3RegisterOpAltBNoCondUpdates_Shsub16_Rule_163_A1_P326_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Shsub8_Rule_164_A1_P328 Binary3RegisterOpAltBNoCondUpdates_Shsub8_Rule_164_A1_P328_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Ssax_Rule_185_A1_P366 Binary3RegisterOpAltBNoCondUpdates_Ssax_Rule_185_A1_P366_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Ssub16_Rule_186_A1_P368 Binary3RegisterOpAltBNoCondUpdates_Ssub16_Rule_186_A1_P368_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Ssub8_Rule_187_A1_P370 Binary3RegisterOpAltBNoCondUpdates_Ssub8_Rule_187_A1_P370_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Sxtab_Rule_220_A1_P434 Binary3RegisterOpAltBNoCondUpdates_Sxtab_Rule_220_A1_P434_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Sxtah_Rule_222_A1_P438 Binary3RegisterOpAltBNoCondUpdates_Sxtah_Rule_222_A1_P438_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uadd16_Rule_233_A1_P460 Binary3RegisterOpAltBNoCondUpdates_Uadd16_Rule_233_A1_P460_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uadd8_Rule_234_A1_P462 Binary3RegisterOpAltBNoCondUpdates_Uadd8_Rule_234_A1_P462_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uasx_Rule_235_A1_P464 Binary3RegisterOpAltBNoCondUpdates_Uasx_Rule_235_A1_P464_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uhadd16_Rule_238_A1_P470 Binary3RegisterOpAltBNoCondUpdates_Uhadd16_Rule_238_A1_P470_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uhadd8_Rule_239_A1_P472 Binary3RegisterOpAltBNoCondUpdates_Uhadd8_Rule_239_A1_P472_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uhasx_Rule_240_A1_P474 Binary3RegisterOpAltBNoCondUpdates_Uhasx_Rule_240_A1_P474_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uhsax_Rule_241_A1_P476 Binary3RegisterOpAltBNoCondUpdates_Uhsax_Rule_241_A1_P476_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uhsub16_Rule_242_A1_P478 Binary3RegisterOpAltBNoCondUpdates_Uhsub16_Rule_242_A1_P478_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uhsub8_Rule_243_A1_P480 Binary3RegisterOpAltBNoCondUpdates_Uhsub8_Rule_243_A1_P480_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uqadd16_Rule_247_A1_P488 Binary3RegisterOpAltBNoCondUpdates_Uqadd16_Rule_247_A1_P488_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uqadd8_Rule_248_A1_P490 Binary3RegisterOpAltBNoCondUpdates_Uqadd8_Rule_248_A1_P490_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uqasx_Rule_249_A1_P492 Binary3RegisterOpAltBNoCondUpdates_Uqasx_Rule_249_A1_P492_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uqsax_Rule_250_A1_P494 Binary3RegisterOpAltBNoCondUpdates_Uqsax_Rule_250_A1_P494_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uqsub16_Rule_251_A1_P496 Binary3RegisterOpAltBNoCondUpdates_Uqsub16_Rule_251_A1_P496_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uqsub8_Rule_252_A1_P498 Binary3RegisterOpAltBNoCondUpdates_Uqsub8_Rule_252_A1_P498_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Usax_Rule_257_A1_P508 Binary3RegisterOpAltBNoCondUpdates_Usax_Rule_257_A1_P508_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Usub16_Rule_258_A1_P510 Binary3RegisterOpAltBNoCondUpdates_Usub16_Rule_258_A1_P510_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Usub8_Rule_259_A1_P512 Binary3RegisterOpAltBNoCondUpdates_Usub8_Rule_259_A1_P512_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uxtab16_Rule_262_A1_P516 Binary3RegisterOpAltBNoCondUpdates_Uxtab16_Rule_262_A1_P516_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uxtab_Rule_260_A1_P514 Binary3RegisterOpAltBNoCondUpdates_Uxtab_Rule_260_A1_P514_instance_;
  const NamedBinary3RegisterOpAltBNoCondUpdates_Uxtah_Rule_262_A1_P518 Binary3RegisterOpAltBNoCondUpdates_Uxtah_Rule_262_A1_P518_instance_;
  const NamedBinary3RegisterShiftedOp_ADC_register Binary3RegisterShiftedOp_ADC_register_instance_;
  const NamedBinary3RegisterShiftedOp_ADD_register Binary3RegisterShiftedOp_ADD_register_instance_;
  const NamedBinary3RegisterShiftedOp_AND_register Binary3RegisterShiftedOp_AND_register_instance_;
  const NamedBinary3RegisterShiftedOp_BIC_register Binary3RegisterShiftedOp_BIC_register_instance_;
  const NamedBinary3RegisterShiftedOp_EOR_register Binary3RegisterShiftedOp_EOR_register_instance_;
  const NamedBinary3RegisterShiftedOp_ORR_register Binary3RegisterShiftedOp_ORR_register_instance_;
  const NamedBinary3RegisterShiftedOp_RSB_register Binary3RegisterShiftedOp_RSB_register_instance_;
  const NamedBinary3RegisterShiftedOp_RSC_register Binary3RegisterShiftedOp_RSC_register_instance_;
  const NamedBinary3RegisterShiftedOp_SBC_register Binary3RegisterShiftedOp_SBC_register_instance_;
  const NamedBinary3RegisterShiftedOp_SUB_register Binary3RegisterShiftedOp_SUB_register_instance_;
  const NamedBinary3RegisterShiftedTest_CMN_register_shifted_register Binary3RegisterShiftedTest_CMN_register_shifted_register_instance_;
  const NamedBinary3RegisterShiftedTest_CMP_register_shifted_register Binary3RegisterShiftedTest_CMP_register_shifted_register_instance_;
  const NamedBinary3RegisterShiftedTest_TEQ_register_shifted_register Binary3RegisterShiftedTest_TEQ_register_shifted_register_instance_;
  const NamedBinary3RegisterShiftedTest_TST_register_shifted_register Binary3RegisterShiftedTest_TST_register_shifted_register_instance_;
  const NamedBinary4RegisterDualOp_MLS_A1 Binary4RegisterDualOp_MLS_A1_instance_;
  const NamedBinary4RegisterDualOp_SMLABB_SMLABT_SMLATB_SMLATT Binary4RegisterDualOp_SMLABB_SMLABT_SMLATB_SMLATT_instance_;
  const NamedBinary4RegisterDualOp_SMLAWB_SMLAWT Binary4RegisterDualOp_SMLAWB_SMLAWT_instance_;
  const NamedBinary4RegisterDualOp_Usada8_Rule_254_A1_P502 Binary4RegisterDualOp_Usada8_Rule_254_A1_P502_instance_;
  const NamedBinary4RegisterDualOpLtV6RdNotRn_MLA_A1 Binary4RegisterDualOpLtV6RdNotRn_MLA_A1_instance_;
  const NamedBinary4RegisterDualOpNoCondsUpdate_SMLAD Binary4RegisterDualOpNoCondsUpdate_SMLAD_instance_;
  const NamedBinary4RegisterDualOpNoCondsUpdate_SMLSD Binary4RegisterDualOpNoCondsUpdate_SMLSD_instance_;
  const NamedBinary4RegisterDualOpNoCondsUpdate_SMMLA Binary4RegisterDualOpNoCondsUpdate_SMMLA_instance_;
  const NamedBinary4RegisterDualOpNoCondsUpdate_SMMLS Binary4RegisterDualOpNoCondsUpdate_SMMLS_instance_;
  const NamedBinary4RegisterDualResult_SMLALBB_SMLALBT_SMLALTB_SMLALTT Binary4RegisterDualResult_SMLALBB_SMLALBT_SMLALTB_SMLALTT_instance_;
  const NamedBinary4RegisterDualResult_UMAAL_A1 Binary4RegisterDualResult_UMAAL_A1_instance_;
  const NamedBinary4RegisterDualResultLtV6RdHiLoNotRn_SMLAL_A1 Binary4RegisterDualResultLtV6RdHiLoNotRn_SMLAL_A1_instance_;
  const NamedBinary4RegisterDualResultLtV6RdHiLoNotRn_UMLAL_A1 Binary4RegisterDualResultLtV6RdHiLoNotRn_UMLAL_A1_instance_;
  const NamedBinary4RegisterDualResultNoCondsUpdate_SMLALD Binary4RegisterDualResultNoCondsUpdate_SMLALD_instance_;
  const NamedBinary4RegisterDualResultNoCondsUpdate_SMLSLD Binary4RegisterDualResultNoCondsUpdate_SMLSLD_instance_;
  const NamedBinary4RegisterDualResultUsesRnRm_SMULL_A1 Binary4RegisterDualResultUsesRnRm_SMULL_A1_instance_;
  const NamedBinary4RegisterDualResultUsesRnRm_UMULL_A1 Binary4RegisterDualResultUsesRnRm_UMULL_A1_instance_;
  const NamedBinary4RegisterShiftedOp_ADC_register_shifted_register Binary4RegisterShiftedOp_ADC_register_shifted_register_instance_;
  const NamedBinary4RegisterShiftedOp_ADD_register_shifted_register Binary4RegisterShiftedOp_ADD_register_shifted_register_instance_;
  const NamedBinary4RegisterShiftedOp_AND_register_shifted_register Binary4RegisterShiftedOp_AND_register_shifted_register_instance_;
  const NamedBinary4RegisterShiftedOp_BIC_register_shifted_register Binary4RegisterShiftedOp_BIC_register_shifted_register_instance_;
  const NamedBinary4RegisterShiftedOp_EOR_register_shifted_register Binary4RegisterShiftedOp_EOR_register_shifted_register_instance_;
  const NamedBinary4RegisterShiftedOp_ORR_register_shifted_register Binary4RegisterShiftedOp_ORR_register_shifted_register_instance_;
  const NamedBinary4RegisterShiftedOp_RSB_register_shfited_register Binary4RegisterShiftedOp_RSB_register_shfited_register_instance_;
  const NamedBinary4RegisterShiftedOp_RSC_register_shifted_register Binary4RegisterShiftedOp_RSC_register_shifted_register_instance_;
  const NamedBinary4RegisterShiftedOp_SBC_register_shifted_register Binary4RegisterShiftedOp_SBC_register_shifted_register_instance_;
  const NamedBinary4RegisterShiftedOp_SUB_register_shifted_register Binary4RegisterShiftedOp_SUB_register_shifted_register_instance_;
  const NamedBinaryRegisterImmediateTest_CMN_immediate BinaryRegisterImmediateTest_CMN_immediate_instance_;
  const NamedBinaryRegisterImmediateTest_CMP_immediate BinaryRegisterImmediateTest_CMP_immediate_instance_;
  const NamedBinaryRegisterImmediateTest_TEQ_immediate BinaryRegisterImmediateTest_TEQ_immediate_instance_;
  const NamedBranchImmediate24_B_Rule_16_A1_P44 BranchImmediate24_B_Rule_16_A1_P44_instance_;
  const NamedBranchImmediate24_Bl_Blx_Rule_23_A1_P58 BranchImmediate24_Bl_Blx_Rule_23_A1_P58_instance_;
  const NamedBranchToRegister_BLX_register BranchToRegister_BLX_register_instance_;
  const NamedBranchToRegister_Bx BranchToRegister_Bx_instance_;
  const NamedBreakPointAndConstantPoolHead_BKPT BreakPointAndConstantPoolHead_BKPT_instance_;
  const NamedCondDecoder_Nop_Rule_110_A1_P222 CondDecoder_Nop_Rule_110_A1_P222_instance_;
  const NamedCondDecoder_Yield_Rule_413_A1_P812 CondDecoder_Yield_Rule_413_A1_P812_instance_;
  const NamedCondVfpOp_Vabs_Rule_269_A2_P532 CondVfpOp_Vabs_Rule_269_A2_P532_instance_;
  const NamedCondVfpOp_Vadd_Rule_271_A2_P536 CondVfpOp_Vadd_Rule_271_A2_P536_instance_;
  const NamedCondVfpOp_Vcmp_Vcmpe_Rule_A1 CondVfpOp_Vcmp_Vcmpe_Rule_A1_instance_;
  const NamedCondVfpOp_Vcmp_Vcmpe_Rule_A2 CondVfpOp_Vcmp_Vcmpe_Rule_A2_instance_;
  const NamedCondVfpOp_Vcvt_Rule_297_A1_P582 CondVfpOp_Vcvt_Rule_297_A1_P582_instance_;
  const NamedCondVfpOp_Vcvt_Rule_298_A1_P584 CondVfpOp_Vcvt_Rule_298_A1_P584_instance_;
  const NamedCondVfpOp_Vcvt_Vcvtr_Rule_295_A1_P578 CondVfpOp_Vcvt_Vcvtr_Rule_295_A1_P578_instance_;
  const NamedCondVfpOp_Vcvtb_Vcvtt_Rule_300_A1_P588 CondVfpOp_Vcvtb_Vcvtt_Rule_300_A1_P588_instance_;
  const NamedCondVfpOp_Vdiv_Rule_301_A1_P590 CondVfpOp_Vdiv_Rule_301_A1_P590_instance_;
  const NamedCondVfpOp_Vfma_vfms_Rule_A1 CondVfpOp_Vfma_vfms_Rule_A1_instance_;
  const NamedCondVfpOp_Vfnma_vfnms_Rule_A1 CondVfpOp_Vfnma_vfnms_Rule_A1_instance_;
  const NamedCondVfpOp_Vmla_vmls_Rule_423_A2_P636 CondVfpOp_Vmla_vmls_Rule_423_A2_P636_instance_;
  const NamedCondVfpOp_Vmov_Rule_326_A2_P640 CondVfpOp_Vmov_Rule_326_A2_P640_instance_;
  const NamedCondVfpOp_Vmov_Rule_327_A2_P642 CondVfpOp_Vmov_Rule_327_A2_P642_instance_;
  const NamedCondVfpOp_Vmul_Rule_338_A2_P664 CondVfpOp_Vmul_Rule_338_A2_P664_instance_;
  const NamedCondVfpOp_Vneg_Rule_342_A2_P672 CondVfpOp_Vneg_Rule_342_A2_P672_instance_;
  const NamedCondVfpOp_Vnmla_vnmls_Rule_343_A1_P674 CondVfpOp_Vnmla_vnmls_Rule_343_A1_P674_instance_;
  const NamedCondVfpOp_Vnmul_Rule_343_A2_P674 CondVfpOp_Vnmul_Rule_343_A2_P674_instance_;
  const NamedCondVfpOp_Vsqrt_Rule_388_A1_P762 CondVfpOp_Vsqrt_Rule_388_A1_P762_instance_;
  const NamedCondVfpOp_Vsub_Rule_402_A2_P790 CondVfpOp_Vsub_Rule_402_A2_P790_instance_;
  const NamedDataBarrier_Dmb_Rule_41_A1_P90 DataBarrier_Dmb_Rule_41_A1_P90_instance_;
  const NamedDataBarrier_Dsb_Rule_42_A1_P92 DataBarrier_Dsb_Rule_42_A1_P92_instance_;
  const NamedDeprecated_SWP_SWPB Deprecated_SWP_SWPB_instance_;
  const NamedDuplicateToAdvSIMDRegisters_Vdup_Rule_303_A1_P594 DuplicateToAdvSIMDRegisters_Vdup_Rule_303_A1_P594_instance_;
  const NamedForbidden_None Forbidden_None_instance_;
  const NamedForbiddenCondDecoder_BXJ ForbiddenCondDecoder_BXJ_instance_;
  const NamedForbiddenCondDecoder_Cdp_Rule_A1 ForbiddenCondDecoder_Cdp_Rule_A1_instance_;
  const NamedForbiddenCondDecoder_Dbg_Rule_40_A1_P88 ForbiddenCondDecoder_Dbg_Rule_40_A1_P88_instance_;
  const NamedForbiddenCondDecoder_ERET ForbiddenCondDecoder_ERET_instance_;
  const NamedForbiddenCondDecoder_HVC ForbiddenCondDecoder_HVC_instance_;
  const NamedForbiddenCondDecoder_LDRBT_A1 ForbiddenCondDecoder_LDRBT_A1_instance_;
  const NamedForbiddenCondDecoder_LDRBT_A2 ForbiddenCondDecoder_LDRBT_A2_instance_;
  const NamedForbiddenCondDecoder_LDRT_A1 ForbiddenCondDecoder_LDRT_A1_instance_;
  const NamedForbiddenCondDecoder_LDRT_A2 ForbiddenCondDecoder_LDRT_A2_instance_;
  const NamedForbiddenCondDecoder_Ldc_immediate_Rule_A1 ForbiddenCondDecoder_Ldc_immediate_Rule_A1_instance_;
  const NamedForbiddenCondDecoder_Ldc_literal_Rule_A1 ForbiddenCondDecoder_Ldc_literal_Rule_A1_instance_;
  const NamedForbiddenCondDecoder_Ldm_Rule_2_B6_A1_P5 ForbiddenCondDecoder_Ldm_Rule_2_B6_A1_P5_instance_;
  const NamedForbiddenCondDecoder_Ldm_Rule_3_B6_A1_P7 ForbiddenCondDecoder_Ldm_Rule_3_B6_A1_P7_instance_;
  const NamedForbiddenCondDecoder_MRS_Banked_register ForbiddenCondDecoder_MRS_Banked_register_instance_;
  const NamedForbiddenCondDecoder_MSR_Banked_register ForbiddenCondDecoder_MSR_Banked_register_instance_;
  const NamedForbiddenCondDecoder_MSR_register ForbiddenCondDecoder_MSR_register_instance_;
  const NamedForbiddenCondDecoder_Mcr_Rule_A1 ForbiddenCondDecoder_Mcr_Rule_A1_instance_;
  const NamedForbiddenCondDecoder_Mcrr_Rule_A1 ForbiddenCondDecoder_Mcrr_Rule_A1_instance_;
  const NamedForbiddenCondDecoder_Mrc_Rule_A1 ForbiddenCondDecoder_Mrc_Rule_A1_instance_;
  const NamedForbiddenCondDecoder_Mrrc_Rule_A1 ForbiddenCondDecoder_Mrrc_Rule_A1_instance_;
  const NamedForbiddenCondDecoder_Msr_Rule_B6_1_6_A1_PB6_12 ForbiddenCondDecoder_Msr_Rule_B6_1_6_A1_PB6_12_instance_;
  const NamedForbiddenCondDecoder_SMC ForbiddenCondDecoder_SMC_instance_;
  const NamedForbiddenCondDecoder_STRBT_A1 ForbiddenCondDecoder_STRBT_A1_instance_;
  const NamedForbiddenCondDecoder_STRBT_A2 ForbiddenCondDecoder_STRBT_A2_instance_;
  const NamedForbiddenCondDecoder_STRT_A1 ForbiddenCondDecoder_STRT_A1_instance_;
  const NamedForbiddenCondDecoder_STRT_A2 ForbiddenCondDecoder_STRT_A2_instance_;
  const NamedForbiddenCondDecoder_Sev_Rule_158_A1_P316 ForbiddenCondDecoder_Sev_Rule_158_A1_P316_instance_;
  const NamedForbiddenCondDecoder_Stc_Rule_A2 ForbiddenCondDecoder_Stc_Rule_A2_instance_;
  const NamedForbiddenCondDecoder_Stm_Rule_11_B6_A1_P22 ForbiddenCondDecoder_Stm_Rule_11_B6_A1_P22_instance_;
  const NamedForbiddenCondDecoder_Svc_Rule_A1 ForbiddenCondDecoder_Svc_Rule_A1_instance_;
  const NamedForbiddenCondDecoder_Wfe_Rule_411_A1_P808 ForbiddenCondDecoder_Wfe_Rule_411_A1_P808_instance_;
  const NamedForbiddenCondDecoder_Wfi_Rule_412_A1_P810 ForbiddenCondDecoder_Wfi_Rule_412_A1_P810_instance_;
  const NamedForbiddenCondDecoder_extra_load_store_instructions_unpriviledged ForbiddenCondDecoder_extra_load_store_instructions_unpriviledged_instance_;
  const NamedForbiddenUncondDecoder_Blx_Rule_23_A2_P58 ForbiddenUncondDecoder_Blx_Rule_23_A2_P58_instance_;
  const NamedForbiddenUncondDecoder_Cdp2_Rule_28_A2_P68 ForbiddenUncondDecoder_Cdp2_Rule_28_A2_P68_instance_;
  const NamedForbiddenUncondDecoder_Clrex_Rule_30_A1_P70 ForbiddenUncondDecoder_Clrex_Rule_30_A1_P70_instance_;
  const NamedForbiddenUncondDecoder_Cps_Rule_b6_1_1_A1_B6_3 ForbiddenUncondDecoder_Cps_Rule_b6_1_1_A1_B6_3_instance_;
  const NamedForbiddenUncondDecoder_Ldc2_Rule_51_A2_P106 ForbiddenUncondDecoder_Ldc2_Rule_51_A2_P106_instance_;
  const NamedForbiddenUncondDecoder_Ldc2_Rule_52_A2_P108 ForbiddenUncondDecoder_Ldc2_Rule_52_A2_P108_instance_;
  const NamedForbiddenUncondDecoder_Mcr2_Rule_92_A2_P186 ForbiddenUncondDecoder_Mcr2_Rule_92_A2_P186_instance_;
  const NamedForbiddenUncondDecoder_Mcrr2_Rule_93_A2_P188 ForbiddenUncondDecoder_Mcrr2_Rule_93_A2_P188_instance_;
  const NamedForbiddenUncondDecoder_Mrc2_Rule_100_A2_P202 ForbiddenUncondDecoder_Mrc2_Rule_100_A2_P202_instance_;
  const NamedForbiddenUncondDecoder_Mrrc2_Rule_101_A2_P204 ForbiddenUncondDecoder_Mrrc2_Rule_101_A2_P204_instance_;
  const NamedForbiddenUncondDecoder_Rfe_Rule_B6_1_10_A1_B6_16 ForbiddenUncondDecoder_Rfe_Rule_B6_1_10_A1_B6_16_instance_;
  const NamedForbiddenUncondDecoder_Setend_Rule_157_P314 ForbiddenUncondDecoder_Setend_Rule_157_P314_instance_;
  const NamedForbiddenUncondDecoder_Srs_Rule_B6_1_10_A1_B6_20 ForbiddenUncondDecoder_Srs_Rule_B6_1_10_A1_B6_20_instance_;
  const NamedForbiddenUncondDecoder_Stc2_Rule_188_A2_P372 ForbiddenUncondDecoder_Stc2_Rule_188_A2_P372_instance_;
  const NamedForbiddenUncondDecoder_Unallocated_hints ForbiddenUncondDecoder_Unallocated_hints_instance_;
  const NamedInstructionBarrier_Isb_Rule_49_A1_P102 InstructionBarrier_Isb_Rule_49_A1_P102_instance_;
  const NamedLdrImmediateOp_LDR_immediate LdrImmediateOp_LDR_immediate_instance_;
  const NamedLoad2RegisterImm12Op_LDRB_immediate Load2RegisterImm12Op_LDRB_immediate_instance_;
  const NamedLoad2RegisterImm12Op_LDRB_literal Load2RegisterImm12Op_LDRB_literal_instance_;
  const NamedLoad2RegisterImm12Op_LDR_literal Load2RegisterImm12Op_LDR_literal_instance_;
  const NamedLoad2RegisterImm8DoubleOp_LDRD_immediate Load2RegisterImm8DoubleOp_LDRD_immediate_instance_;
  const NamedLoad2RegisterImm8Op_LDRH_immediate Load2RegisterImm8Op_LDRH_immediate_instance_;
  const NamedLoad2RegisterImm8Op_LDRSB_immediate Load2RegisterImm8Op_LDRSB_immediate_instance_;
  const NamedLoad2RegisterImm8Op_LDRSH_immediate Load2RegisterImm8Op_LDRSH_immediate_instance_;
  const NamedLoad3RegisterDoubleOp_LDRD_register Load3RegisterDoubleOp_LDRD_register_instance_;
  const NamedLoad3RegisterImm5Op_LDRB_register Load3RegisterImm5Op_LDRB_register_instance_;
  const NamedLoad3RegisterImm5Op_LDR_register Load3RegisterImm5Op_LDR_register_instance_;
  const NamedLoad3RegisterOp_LDRH_register Load3RegisterOp_LDRH_register_instance_;
  const NamedLoad3RegisterOp_LDRSB_register Load3RegisterOp_LDRSB_register_instance_;
  const NamedLoad3RegisterOp_LDRSH_register Load3RegisterOp_LDRSH_register_instance_;
  const NamedLoadExclusive2RegisterDoubleOp_LDREXD LoadExclusive2RegisterDoubleOp_LDREXD_instance_;
  const NamedLoadExclusive2RegisterOp_LDREX LoadExclusive2RegisterOp_LDREX_instance_;
  const NamedLoadExclusive2RegisterOp_LDREXB LoadExclusive2RegisterOp_LDREXB_instance_;
  const NamedLoadExclusive2RegisterOp_STREXH LoadExclusive2RegisterOp_STREXH_instance_;
  const NamedLoadRegisterImm8DoubleOp_LDRD_literal LoadRegisterImm8DoubleOp_LDRD_literal_instance_;
  const NamedLoadRegisterImm8Op_LDRH_literal LoadRegisterImm8Op_LDRH_literal_instance_;
  const NamedLoadRegisterImm8Op_LDRSB_literal LoadRegisterImm8Op_LDRSB_literal_instance_;
  const NamedLoadRegisterList_Ldm_Ldmia_Ldmfd_Rule_53_A1_P110 LoadRegisterList_Ldm_Ldmia_Ldmfd_Rule_53_A1_P110_instance_;
  const NamedLoadRegisterList_Ldmda_Ldmfa_Rule_54_A1_P112 LoadRegisterList_Ldmda_Ldmfa_Rule_54_A1_P112_instance_;
  const NamedLoadRegisterList_Ldmdb_Ldmea_Rule_55_A1_P114 LoadRegisterList_Ldmdb_Ldmea_Rule_55_A1_P114_instance_;
  const NamedLoadRegisterList_Ldmib_Ldmed_Rule_56_A1_P116 LoadRegisterList_Ldmib_Ldmed_Rule_56_A1_P116_instance_;
  const NamedLoadRegisterList_Pop_Rule_A1 LoadRegisterList_Pop_Rule_A1_instance_;
  const NamedLoadVectorRegister_Vldr_Rule_320_A1_A2_P628 LoadVectorRegister_Vldr_Rule_320_A1_A2_P628_instance_;
  const NamedLoadVectorRegisterList_Vldm_Rule_318_A1_A2_P626 LoadVectorRegisterList_Vldm_Rule_318_A1_A2_P626_instance_;
  const NamedLoadVectorRegisterList_Vldm_Rule_319_A1_A2_P626 LoadVectorRegisterList_Vldm_Rule_319_A1_A2_P626_instance_;
  const NamedLoadVectorRegisterList_Vpop_Rule_354_A1_A2_P694 LoadVectorRegisterList_Vpop_Rule_354_A1_A2_P694_instance_;
  const NamedMaskedBinary2RegisterImmediateOp_BIC_immediate MaskedBinary2RegisterImmediateOp_BIC_immediate_instance_;
  const NamedMaskedBinaryRegisterImmediateTest_TST_immediate MaskedBinaryRegisterImmediateTest_TST_immediate_instance_;
  const NamedMoveDoubleVfpRegisterOp_Vmov_one_D_Rule_A1 MoveDoubleVfpRegisterOp_Vmov_one_D_Rule_A1_instance_;
  const NamedMoveDoubleVfpRegisterOp_Vmov_two_S_Rule_A1 MoveDoubleVfpRegisterOp_Vmov_two_S_Rule_A1_instance_;
  const NamedMoveImmediate12ToApsr_Msr_Rule_103_A1_P208 MoveImmediate12ToApsr_Msr_Rule_103_A1_P208_instance_;
  const NamedMoveVfpRegisterOp_Vmov_Rule_330_A1_P648 MoveVfpRegisterOp_Vmov_Rule_330_A1_P648_instance_;
  const NamedMoveVfpRegisterOpWithTypeSel_Vmov_Rule_328_A1_P644 MoveVfpRegisterOpWithTypeSel_Vmov_Rule_328_A1_P644_instance_;
  const NamedMoveVfpRegisterOpWithTypeSel_Vmov_Rule_329_A1_P646 MoveVfpRegisterOpWithTypeSel_Vmov_Rule_329_A1_P646_instance_;
  const NamedPermanentlyUndefined_Udf_Rule_A1 PermanentlyUndefined_Udf_Rule_A1_instance_;
  const NamedPreloadRegisterImm12Op_Pld_Rule_117_A1_P236 PreloadRegisterImm12Op_Pld_Rule_117_A1_P236_instance_;
  const NamedPreloadRegisterImm12Op_Pld_Rule_118_A1_P238 PreloadRegisterImm12Op_Pld_Rule_118_A1_P238_instance_;
  const NamedPreloadRegisterImm12Op_Pldw_Rule_117_A1_P236 PreloadRegisterImm12Op_Pldw_Rule_117_A1_P236_instance_;
  const NamedPreloadRegisterImm12Op_Pli_Rule_120_A1_P242 PreloadRegisterImm12Op_Pli_Rule_120_A1_P242_instance_;
  const NamedPreloadRegisterPairOp_Pld_Rule_119_A1_P240 PreloadRegisterPairOp_Pld_Rule_119_A1_P240_instance_;
  const NamedPreloadRegisterPairOp_Pldw_Rule_119_A1_P240 PreloadRegisterPairOp_Pldw_Rule_119_A1_P240_instance_;
  const NamedPreloadRegisterPairOp_Pli_Rule_121_A1_P244 PreloadRegisterPairOp_Pli_Rule_121_A1_P244_instance_;
  const NamedStore2RegisterImm12Op_STRB_immediate Store2RegisterImm12Op_STRB_immediate_instance_;
  const NamedStore2RegisterImm12Op_STR_immediate Store2RegisterImm12Op_STR_immediate_instance_;
  const NamedStore2RegisterImm8DoubleOp_STRD_immediate Store2RegisterImm8DoubleOp_STRD_immediate_instance_;
  const NamedStore2RegisterImm8Op_STRH_immediate Store2RegisterImm8Op_STRH_immediate_instance_;
  const NamedStore3RegisterDoubleOp_STRD_register Store3RegisterDoubleOp_STRD_register_instance_;
  const NamedStore3RegisterImm5Op_STRB_register Store3RegisterImm5Op_STRB_register_instance_;
  const NamedStore3RegisterImm5Op_STR_register Store3RegisterImm5Op_STR_register_instance_;
  const NamedStore3RegisterOp_STRH_register Store3RegisterOp_STRH_register_instance_;
  const NamedStoreExclusive3RegisterDoubleOp_STREXD StoreExclusive3RegisterDoubleOp_STREXD_instance_;
  const NamedStoreExclusive3RegisterOp_STREX StoreExclusive3RegisterOp_STREX_instance_;
  const NamedStoreExclusive3RegisterOp_STREXB StoreExclusive3RegisterOp_STREXB_instance_;
  const NamedStoreExclusive3RegisterOp_STREXH StoreExclusive3RegisterOp_STREXH_instance_;
  const NamedStoreRegisterList_Push_Rule_A1 StoreRegisterList_Push_Rule_A1_instance_;
  const NamedStoreRegisterList_Stm_Stmia_Stmea_Rule_189_A1_P374 StoreRegisterList_Stm_Stmia_Stmea_Rule_189_A1_P374_instance_;
  const NamedStoreRegisterList_Stmda_Stmed_Rule_190_A1_P376 StoreRegisterList_Stmda_Stmed_Rule_190_A1_P376_instance_;
  const NamedStoreRegisterList_Stmdb_Stmfd_Rule_191_A1_P378 StoreRegisterList_Stmdb_Stmfd_Rule_191_A1_P378_instance_;
  const NamedStoreRegisterList_Stmib_Stmfa_Rule_192_A1_P380 StoreRegisterList_Stmib_Stmfa_Rule_192_A1_P380_instance_;
  const NamedStoreVectorRegister_Vstr_Rule_400_A1_A2_P786 StoreVectorRegister_Vstr_Rule_400_A1_A2_P786_instance_;
  const NamedStoreVectorRegisterList_Vpush_355_A1_A2_P696 StoreVectorRegisterList_Vpush_355_A1_A2_P696_instance_;
  const NamedStoreVectorRegisterList_Vstm_Rule_399_A1_A2_P784 StoreVectorRegisterList_Vstm_Rule_399_A1_A2_P784_instance_;
  const NamedUnary1RegisterBitRangeMsbGeLsb_Bfc_17_A1_P46 Unary1RegisterBitRangeMsbGeLsb_Bfc_17_A1_P46_instance_;
  const NamedUnary1RegisterImmediateOp12DynCodeReplace_MOV_immediate_A1 Unary1RegisterImmediateOp12DynCodeReplace_MOV_immediate_A1_instance_;
  const NamedUnary1RegisterImmediateOp12DynCodeReplace_MVN_immediate Unary1RegisterImmediateOp12DynCodeReplace_MVN_immediate_instance_;
  const NamedUnary1RegisterImmediateOpDynCodeReplace_MOVT Unary1RegisterImmediateOpDynCodeReplace_MOVT_instance_;
  const NamedUnary1RegisterImmediateOpDynCodeReplace_MOVW Unary1RegisterImmediateOpDynCodeReplace_MOVW_instance_;
  const NamedUnary1RegisterImmediateOpPc_ADR_A1 Unary1RegisterImmediateOpPc_ADR_A1_instance_;
  const NamedUnary1RegisterImmediateOpPc_ADR_A2 Unary1RegisterImmediateOpPc_ADR_A2_instance_;
  const NamedUnary1RegisterSet_MRS Unary1RegisterSet_MRS_instance_;
  const NamedUnary1RegisterUse_MSR_register Unary1RegisterUse_MSR_register_instance_;
  const NamedUnary2RegisterImmedShiftedOpRegsNotPc_Sxtb16_Rule_224_A1_P442 Unary2RegisterImmedShiftedOpRegsNotPc_Sxtb16_Rule_224_A1_P442_instance_;
  const NamedUnary2RegisterImmedShiftedOpRegsNotPc_Sxtb_Rule_223_A1_P440 Unary2RegisterImmedShiftedOpRegsNotPc_Sxtb_Rule_223_A1_P440_instance_;
  const NamedUnary2RegisterOp_MOV_register Unary2RegisterOp_MOV_register_instance_;
  const NamedUnary2RegisterOp_RRX Unary2RegisterOp_RRX_instance_;
  const NamedUnary2RegisterOpNotRmIsPc_CLZ Unary2RegisterOpNotRmIsPc_CLZ_instance_;
  const NamedUnary2RegisterOpNotRmIsPcNoCondUpdates_Rbit_Rule_134_A1_P270 Unary2RegisterOpNotRmIsPcNoCondUpdates_Rbit_Rule_134_A1_P270_instance_;
  const NamedUnary2RegisterOpNotRmIsPcNoCondUpdates_Rev16_Rule_136_A1_P274 Unary2RegisterOpNotRmIsPcNoCondUpdates_Rev16_Rule_136_A1_P274_instance_;
  const NamedUnary2RegisterOpNotRmIsPcNoCondUpdates_Rev_Rule_135_A1_P272 Unary2RegisterOpNotRmIsPcNoCondUpdates_Rev_Rule_135_A1_P272_instance_;
  const NamedUnary2RegisterOpNotRmIsPcNoCondUpdates_Revsh_Rule_137_A1_P276 Unary2RegisterOpNotRmIsPcNoCondUpdates_Revsh_Rule_137_A1_P276_instance_;
  const NamedUnary2RegisterOpNotRmIsPcNoCondUpdates_Sxth_Rule_225_A1_P444 Unary2RegisterOpNotRmIsPcNoCondUpdates_Sxth_Rule_225_A1_P444_instance_;
  const NamedUnary2RegisterOpNotRmIsPcNoCondUpdates_Uxtb16_Rule_264_A1_P522 Unary2RegisterOpNotRmIsPcNoCondUpdates_Uxtb16_Rule_264_A1_P522_instance_;
  const NamedUnary2RegisterOpNotRmIsPcNoCondUpdates_Uxtb_Rule_263_A1_P520 Unary2RegisterOpNotRmIsPcNoCondUpdates_Uxtb_Rule_263_A1_P520_instance_;
  const NamedUnary2RegisterOpNotRmIsPcNoCondUpdates_Uxth_Rule_265_A1_P524 Unary2RegisterOpNotRmIsPcNoCondUpdates_Uxth_Rule_265_A1_P524_instance_;
  const NamedUnary2RegisterSatImmedShiftedOp_Ssat16_Rule_184_A1_P364 Unary2RegisterSatImmedShiftedOp_Ssat16_Rule_184_A1_P364_instance_;
  const NamedUnary2RegisterSatImmedShiftedOp_Ssat_Rule_183_A1_P362 Unary2RegisterSatImmedShiftedOp_Ssat_Rule_183_A1_P362_instance_;
  const NamedUnary2RegisterSatImmedShiftedOp_Usat16_Rule_256_A1_P506 Unary2RegisterSatImmedShiftedOp_Usat16_Rule_256_A1_P506_instance_;
  const NamedUnary2RegisterSatImmedShiftedOp_Usat_Rule_255_A1_P504 Unary2RegisterSatImmedShiftedOp_Usat_Rule_255_A1_P504_instance_;
  const NamedUnary2RegisterShiftedOp_ASR_immediate Unary2RegisterShiftedOp_ASR_immediate_instance_;
  const NamedUnary2RegisterShiftedOp_LSR_immediate Unary2RegisterShiftedOp_LSR_immediate_instance_;
  const NamedUnary2RegisterShiftedOp_MVN_register Unary2RegisterShiftedOp_MVN_register_instance_;
  const NamedUnary2RegisterShiftedOpImmNotZero_LSL_immediate Unary2RegisterShiftedOpImmNotZero_LSL_immediate_instance_;
  const NamedUnary2RegisterShiftedOpImmNotZero_ROR_immediate Unary2RegisterShiftedOpImmNotZero_ROR_immediate_instance_;
  const NamedUnary3RegisterShiftedOp_MVN_register_shifted_register Unary3RegisterShiftedOp_MVN_register_shifted_register_instance_;
  const NamedUndefined_None Undefined_None_instance_;
  const NamedUndefinedCondDecoder_Undefined_A5_6 UndefinedCondDecoder_Undefined_A5_6_instance_;
  const NamedUndefinedCondDecoder_None UndefinedCondDecoder_None_instance_;
  const NamedUnpredictableUncondDecoder_Unpredictable UnpredictableUncondDecoder_Unpredictable_instance_;
  const NamedVector1RegisterImmediate_BIT_VBIC_immediate Vector1RegisterImmediate_BIT_VBIC_immediate_instance_;
  const NamedVector1RegisterImmediate_BIT_VORR_immediate Vector1RegisterImmediate_BIT_VORR_immediate_instance_;
  const NamedVector1RegisterImmediate_MOV_VMOV_immediate_A1 Vector1RegisterImmediate_MOV_VMOV_immediate_A1_instance_;
  const NamedVector1RegisterImmediate_MVN_VMVN_immediate Vector1RegisterImmediate_MVN_VMVN_immediate_instance_;
  const NamedVector2RegisterMiscellaneous_CVT_F2I_VCVT Vector2RegisterMiscellaneous_CVT_F2I_VCVT_instance_;
  const NamedVector2RegisterMiscellaneous_CVT_H2S_CVT_between_half_precision_and_single_precision Vector2RegisterMiscellaneous_CVT_H2S_CVT_between_half_precision_and_single_precision_instance_;
  const NamedVector2RegisterMiscellaneous_F32_VABS_A1 Vector2RegisterMiscellaneous_F32_VABS_A1_instance_;
  const NamedVector2RegisterMiscellaneous_F32_VCEQ_immediate_0 Vector2RegisterMiscellaneous_F32_VCEQ_immediate_0_instance_;
  const NamedVector2RegisterMiscellaneous_F32_VCGE_immediate_0 Vector2RegisterMiscellaneous_F32_VCGE_immediate_0_instance_;
  const NamedVector2RegisterMiscellaneous_F32_VCGT_immediate_0 Vector2RegisterMiscellaneous_F32_VCGT_immediate_0_instance_;
  const NamedVector2RegisterMiscellaneous_F32_VCLE_immediate_0 Vector2RegisterMiscellaneous_F32_VCLE_immediate_0_instance_;
  const NamedVector2RegisterMiscellaneous_F32_VCLT_immediate_0 Vector2RegisterMiscellaneous_F32_VCLT_immediate_0_instance_;
  const NamedVector2RegisterMiscellaneous_F32_VNEG Vector2RegisterMiscellaneous_F32_VNEG_instance_;
  const NamedVector2RegisterMiscellaneous_F32_VRECPE Vector2RegisterMiscellaneous_F32_VRECPE_instance_;
  const NamedVector2RegisterMiscellaneous_F32_VRSQRTE Vector2RegisterMiscellaneous_F32_VRSQRTE_instance_;
  const NamedVector2RegisterMiscellaneous_I16_32_64N_VQMOVN Vector2RegisterMiscellaneous_I16_32_64N_VQMOVN_instance_;
  const NamedVector2RegisterMiscellaneous_I16_32_64N_VQMOVUN Vector2RegisterMiscellaneous_I16_32_64N_VQMOVUN_instance_;
  const NamedVector2RegisterMiscellaneous_I8_16_32L_VSHLL_A2 Vector2RegisterMiscellaneous_I8_16_32L_VSHLL_A2_instance_;
  const NamedVector2RegisterMiscellaneous_RG_VREV16 Vector2RegisterMiscellaneous_RG_VREV16_instance_;
  const NamedVector2RegisterMiscellaneous_RG_VREV32 Vector2RegisterMiscellaneous_RG_VREV32_instance_;
  const NamedVector2RegisterMiscellaneous_RG_VREV64 Vector2RegisterMiscellaneous_RG_VREV64_instance_;
  const NamedVector2RegisterMiscellaneous_V16_32_64N_VMOVN Vector2RegisterMiscellaneous_V16_32_64N_VMOVN_instance_;
  const NamedVector2RegisterMiscellaneous_V8_VCNT Vector2RegisterMiscellaneous_V8_VCNT_instance_;
  const NamedVector2RegisterMiscellaneous_V8_VMVN_register Vector2RegisterMiscellaneous_V8_VMVN_register_instance_;
  const NamedVector2RegisterMiscellaneous_V8S_VSWP Vector2RegisterMiscellaneous_V8S_VSWP_instance_;
  const NamedVector2RegisterMiscellaneous_V8_16_32_VABS_A1 Vector2RegisterMiscellaneous_V8_16_32_VABS_A1_instance_;
  const NamedVector2RegisterMiscellaneous_V8_16_32_VCEQ_immediate_0 Vector2RegisterMiscellaneous_V8_16_32_VCEQ_immediate_0_instance_;
  const NamedVector2RegisterMiscellaneous_V8_16_32_VCGE_immediate_0 Vector2RegisterMiscellaneous_V8_16_32_VCGE_immediate_0_instance_;
  const NamedVector2RegisterMiscellaneous_V8_16_32_VCGT_immediate_0 Vector2RegisterMiscellaneous_V8_16_32_VCGT_immediate_0_instance_;
  const NamedVector2RegisterMiscellaneous_V8_16_32_VCLE_immediate_0 Vector2RegisterMiscellaneous_V8_16_32_VCLE_immediate_0_instance_;
  const NamedVector2RegisterMiscellaneous_V8_16_32_VCLS Vector2RegisterMiscellaneous_V8_16_32_VCLS_instance_;
  const NamedVector2RegisterMiscellaneous_V8_16_32_VCLT_immediate_0 Vector2RegisterMiscellaneous_V8_16_32_VCLT_immediate_0_instance_;
  const NamedVector2RegisterMiscellaneous_V8_16_32_VCLZ Vector2RegisterMiscellaneous_V8_16_32_VCLZ_instance_;
  const NamedVector2RegisterMiscellaneous_V8_16_32_VNEG Vector2RegisterMiscellaneous_V8_16_32_VNEG_instance_;
  const NamedVector2RegisterMiscellaneous_V8_16_32_VPADAL Vector2RegisterMiscellaneous_V8_16_32_VPADAL_instance_;
  const NamedVector2RegisterMiscellaneous_V8_16_32_VPADDL Vector2RegisterMiscellaneous_V8_16_32_VPADDL_instance_;
  const NamedVector2RegisterMiscellaneous_V8_16_32_VQABS Vector2RegisterMiscellaneous_V8_16_32_VQABS_instance_;
  const NamedVector2RegisterMiscellaneous_V8_16_32_VQNEG Vector2RegisterMiscellaneous_V8_16_32_VQNEG_instance_;
  const NamedVector2RegisterMiscellaneous_V8_16_32I_VUZP Vector2RegisterMiscellaneous_V8_16_32I_VUZP_instance_;
  const NamedVector2RegisterMiscellaneous_V8_16_32I_VZIP Vector2RegisterMiscellaneous_V8_16_32I_VZIP_instance_;
  const NamedVector2RegisterMiscellaneous_V8_16_32T_VTRN Vector2RegisterMiscellaneous_V8_16_32T_VTRN_instance_;
  const NamedVectorBinary2RegisterScalar_F32_VMLA_by_scalar_A1 VectorBinary2RegisterScalar_F32_VMLA_by_scalar_A1_instance_;
  const NamedVectorBinary2RegisterScalar_F32_VMLS_by_scalar_A1 VectorBinary2RegisterScalar_F32_VMLS_by_scalar_A1_instance_;
  const NamedVectorBinary2RegisterScalar_F32_VMUL_by_scalar_A1 VectorBinary2RegisterScalar_F32_VMUL_by_scalar_A1_instance_;
  const NamedVectorBinary2RegisterScalar_I16_32_VMLA_by_scalar_A1 VectorBinary2RegisterScalar_I16_32_VMLA_by_scalar_A1_instance_;
  const NamedVectorBinary2RegisterScalar_I16_32_VMLS_by_scalar_A1 VectorBinary2RegisterScalar_I16_32_VMLS_by_scalar_A1_instance_;
  const NamedVectorBinary2RegisterScalar_I16_32_VMUL_by_scalar_A1 VectorBinary2RegisterScalar_I16_32_VMUL_by_scalar_A1_instance_;
  const NamedVectorBinary2RegisterScalar_I16_32_VQDMULH_A2 VectorBinary2RegisterScalar_I16_32_VQDMULH_A2_instance_;
  const NamedVectorBinary2RegisterScalar_I16_32_VQRDMULH VectorBinary2RegisterScalar_I16_32_VQRDMULH_instance_;
  const NamedVectorBinary2RegisterScalar_I16_32L_VMLAL_by_scalar_A2 VectorBinary2RegisterScalar_I16_32L_VMLAL_by_scalar_A2_instance_;
  const NamedVectorBinary2RegisterScalar_I16_32L_VMLSL_by_scalar_A2 VectorBinary2RegisterScalar_I16_32L_VMLSL_by_scalar_A2_instance_;
  const NamedVectorBinary2RegisterScalar_I16_32L_VMULL_by_scalar_A2 VectorBinary2RegisterScalar_I16_32L_VMULL_by_scalar_A2_instance_;
  const NamedVectorBinary2RegisterScalar_I16_32L_VQDMLAL_A1 VectorBinary2RegisterScalar_I16_32L_VQDMLAL_A1_instance_;
  const NamedVectorBinary2RegisterScalar_I16_32L_VQDMLSL_A1 VectorBinary2RegisterScalar_I16_32L_VQDMLSL_A1_instance_;
  const NamedVectorBinary2RegisterScalar_I16_32L_VQDMULL_A2 VectorBinary2RegisterScalar_I16_32L_VQDMULL_A2_instance_;
  const NamedVectorBinary2RegisterShiftAmount_CVT_VCVT_between_floating_point_and_fixed_point VectorBinary2RegisterShiftAmount_CVT_VCVT_between_floating_point_and_fixed_point_instance_;
  const NamedVectorBinary2RegisterShiftAmount_E8_16_32L_VSHLL_A1_or_VMOVL VectorBinary2RegisterShiftAmount_E8_16_32L_VSHLL_A1_or_VMOVL_instance_;
  const NamedVectorBinary2RegisterShiftAmount_I_VRSHR VectorBinary2RegisterShiftAmount_I_VRSHR_instance_;
  const NamedVectorBinary2RegisterShiftAmount_I_VRSRA VectorBinary2RegisterShiftAmount_I_VRSRA_instance_;
  const NamedVectorBinary2RegisterShiftAmount_I_VSHL_immediate VectorBinary2RegisterShiftAmount_I_VSHL_immediate_instance_;
  const NamedVectorBinary2RegisterShiftAmount_I_VSHR VectorBinary2RegisterShiftAmount_I_VSHR_instance_;
  const NamedVectorBinary2RegisterShiftAmount_I_VSLI VectorBinary2RegisterShiftAmount_I_VSLI_instance_;
  const NamedVectorBinary2RegisterShiftAmount_I_VSRA VectorBinary2RegisterShiftAmount_I_VSRA_instance_;
  const NamedVectorBinary2RegisterShiftAmount_I_VSRI VectorBinary2RegisterShiftAmount_I_VSRI_instance_;
  const NamedVectorBinary2RegisterShiftAmount_ILS_VQSHL_VQSHLU_immediate VectorBinary2RegisterShiftAmount_ILS_VQSHL_VQSHLU_immediate_instance_;
  const NamedVectorBinary2RegisterShiftAmount_N16_32_64R_VRSHRN VectorBinary2RegisterShiftAmount_N16_32_64R_VRSHRN_instance_;
  const NamedVectorBinary2RegisterShiftAmount_N16_32_64R_VSHRN VectorBinary2RegisterShiftAmount_N16_32_64R_VSHRN_instance_;
  const NamedVectorBinary2RegisterShiftAmount_N16_32_64RS_VQRSHRN VectorBinary2RegisterShiftAmount_N16_32_64RS_VQRSHRN_instance_;
  const NamedVectorBinary2RegisterShiftAmount_N16_32_64RS_VQRSHRUN VectorBinary2RegisterShiftAmount_N16_32_64RS_VQRSHRUN_instance_;
  const NamedVectorBinary2RegisterShiftAmount_N16_32_64RS_VQSHRN VectorBinary2RegisterShiftAmount_N16_32_64RS_VQSHRN_instance_;
  const NamedVectorBinary2RegisterShiftAmount_N16_32_64RS_VQSHRUN VectorBinary2RegisterShiftAmount_N16_32_64RS_VQSHRUN_instance_;
  const NamedVectorBinary3RegisterDifferentLength_I16_32L_VQDMLAL_VQDMLSL_A1 VectorBinary3RegisterDifferentLength_I16_32L_VQDMLAL_VQDMLSL_A1_instance_;
  const NamedVectorBinary3RegisterDifferentLength_I16_32L_VQDMULL_A1 VectorBinary3RegisterDifferentLength_I16_32L_VQDMULL_A1_instance_;
  const NamedVectorBinary3RegisterDifferentLength_I16_32_64_VADDHN VectorBinary3RegisterDifferentLength_I16_32_64_VADDHN_instance_;
  const NamedVectorBinary3RegisterDifferentLength_I16_32_64_VRADDHN VectorBinary3RegisterDifferentLength_I16_32_64_VRADDHN_instance_;
  const NamedVectorBinary3RegisterDifferentLength_I16_32_64_VRSUBHN VectorBinary3RegisterDifferentLength_I16_32_64_VRSUBHN_instance_;
  const NamedVectorBinary3RegisterDifferentLength_I16_32_64_VSUBHN VectorBinary3RegisterDifferentLength_I16_32_64_VSUBHN_instance_;
  const NamedVectorBinary3RegisterDifferentLength_I8_16_32_VADDL_VADDW VectorBinary3RegisterDifferentLength_I8_16_32_VADDL_VADDW_instance_;
  const NamedVectorBinary3RegisterDifferentLength_I8_16_32_VSUBL_VSUBW VectorBinary3RegisterDifferentLength_I8_16_32_VSUBL_VSUBW_instance_;
  const NamedVectorBinary3RegisterDifferentLength_I8_16_32L_VABAL_A2 VectorBinary3RegisterDifferentLength_I8_16_32L_VABAL_A2_instance_;
  const NamedVectorBinary3RegisterDifferentLength_I8_16_32L_VABDL_integer_A2 VectorBinary3RegisterDifferentLength_I8_16_32L_VABDL_integer_A2_instance_;
  const NamedVectorBinary3RegisterDifferentLength_I8_16_32L_VMLAL_VMLSL_integer_A2 VectorBinary3RegisterDifferentLength_I8_16_32L_VMLAL_VMLSL_integer_A2_instance_;
  const NamedVectorBinary3RegisterDifferentLength_I8_16_32L_VMULL_integer_A2 VectorBinary3RegisterDifferentLength_I8_16_32L_VMULL_integer_A2_instance_;
  const NamedVectorBinary3RegisterDifferentLength_P8_VMULL_polynomial_A2 VectorBinary3RegisterDifferentLength_P8_VMULL_polynomial_A2_instance_;
  const NamedVectorBinary3RegisterImmOp_Vext_Rule_305_A1_P598 VectorBinary3RegisterImmOp_Vext_Rule_305_A1_P598_instance_;
  const NamedVectorBinary3RegisterLookupOp_Vtbl_Vtbx_Rule_406_A1_P798 VectorBinary3RegisterLookupOp_Vtbl_Vtbx_Rule_406_A1_P798_instance_;
  const NamedVectorBinary3RegisterSameLength32P_VPADD_floating_point VectorBinary3RegisterSameLength32P_VPADD_floating_point_instance_;
  const NamedVectorBinary3RegisterSameLength32P_VPMAX VectorBinary3RegisterSameLength32P_VPMAX_instance_;
  const NamedVectorBinary3RegisterSameLength32P_VPMIN VectorBinary3RegisterSameLength32P_VPMIN_instance_;
  const NamedVectorBinary3RegisterSameLength32_DQ_VABD_floating_point VectorBinary3RegisterSameLength32_DQ_VABD_floating_point_instance_;
  const NamedVectorBinary3RegisterSameLength32_DQ_VACGE VectorBinary3RegisterSameLength32_DQ_VACGE_instance_;
  const NamedVectorBinary3RegisterSameLength32_DQ_VACGT VectorBinary3RegisterSameLength32_DQ_VACGT_instance_;
  const NamedVectorBinary3RegisterSameLength32_DQ_VADD_floating_point_A1 VectorBinary3RegisterSameLength32_DQ_VADD_floating_point_A1_instance_;
  const NamedVectorBinary3RegisterSameLength32_DQ_VCEQ_register_A2 VectorBinary3RegisterSameLength32_DQ_VCEQ_register_A2_instance_;
  const NamedVectorBinary3RegisterSameLength32_DQ_VCGE_register_A2 VectorBinary3RegisterSameLength32_DQ_VCGE_register_A2_instance_;
  const NamedVectorBinary3RegisterSameLength32_DQ_VCGT_register_A2 VectorBinary3RegisterSameLength32_DQ_VCGT_register_A2_instance_;
  const NamedVectorBinary3RegisterSameLength32_DQ_VFMA_A1 VectorBinary3RegisterSameLength32_DQ_VFMA_A1_instance_;
  const NamedVectorBinary3RegisterSameLength32_DQ_VFMS_A1 VectorBinary3RegisterSameLength32_DQ_VFMS_A1_instance_;
  const NamedVectorBinary3RegisterSameLength32_DQ_VMAX_floating_point VectorBinary3RegisterSameLength32_DQ_VMAX_floating_point_instance_;
  const NamedVectorBinary3RegisterSameLength32_DQ_VMIN_floating_point VectorBinary3RegisterSameLength32_DQ_VMIN_floating_point_instance_;
  const NamedVectorBinary3RegisterSameLength32_DQ_VMLA_floating_point_A1 VectorBinary3RegisterSameLength32_DQ_VMLA_floating_point_A1_instance_;
  const NamedVectorBinary3RegisterSameLength32_DQ_VMLS_floating_point_A1 VectorBinary3RegisterSameLength32_DQ_VMLS_floating_point_A1_instance_;
  const NamedVectorBinary3RegisterSameLength32_DQ_VMUL_floating_point_A1 VectorBinary3RegisterSameLength32_DQ_VMUL_floating_point_A1_instance_;
  const NamedVectorBinary3RegisterSameLength32_DQ_VRECPS VectorBinary3RegisterSameLength32_DQ_VRECPS_instance_;
  const NamedVectorBinary3RegisterSameLength32_DQ_VRSQRTS VectorBinary3RegisterSameLength32_DQ_VRSQRTS_instance_;
  const NamedVectorBinary3RegisterSameLength32_DQ_VSUB_floating_point_A1 VectorBinary3RegisterSameLength32_DQ_VSUB_floating_point_A1_instance_;
  const NamedVectorBinary3RegisterSameLengthDI_VPADD_integer VectorBinary3RegisterSameLengthDI_VPADD_integer_instance_;
  const NamedVectorBinary3RegisterSameLengthDI_VPMAX VectorBinary3RegisterSameLengthDI_VPMAX_instance_;
  const NamedVectorBinary3RegisterSameLengthDI_VPMIN VectorBinary3RegisterSameLengthDI_VPMIN_instance_;
  const NamedVectorBinary3RegisterSameLengthDQ_VADD_integer VectorBinary3RegisterSameLengthDQ_VADD_integer_instance_;
  const NamedVectorBinary3RegisterSameLengthDQ_VAND_register VectorBinary3RegisterSameLengthDQ_VAND_register_instance_;
  const NamedVectorBinary3RegisterSameLengthDQ_VBIC_register VectorBinary3RegisterSameLengthDQ_VBIC_register_instance_;
  const NamedVectorBinary3RegisterSameLengthDQ_VBIF VectorBinary3RegisterSameLengthDQ_VBIF_instance_;
  const NamedVectorBinary3RegisterSameLengthDQ_VBIT VectorBinary3RegisterSameLengthDQ_VBIT_instance_;
  const NamedVectorBinary3RegisterSameLengthDQ_VBSL VectorBinary3RegisterSameLengthDQ_VBSL_instance_;
  const NamedVectorBinary3RegisterSameLengthDQ_VEOR VectorBinary3RegisterSameLengthDQ_VEOR_instance_;
  const NamedVectorBinary3RegisterSameLengthDQ_VORN_register VectorBinary3RegisterSameLengthDQ_VORN_register_instance_;
  const NamedVectorBinary3RegisterSameLengthDQ_VORR_register_or_VMOV_register_A1 VectorBinary3RegisterSameLengthDQ_VORR_register_or_VMOV_register_A1_instance_;
  const NamedVectorBinary3RegisterSameLengthDQ_VQADD VectorBinary3RegisterSameLengthDQ_VQADD_instance_;
  const NamedVectorBinary3RegisterSameLengthDQ_VQRSHL VectorBinary3RegisterSameLengthDQ_VQRSHL_instance_;
  const NamedVectorBinary3RegisterSameLengthDQ_VQSHL_register VectorBinary3RegisterSameLengthDQ_VQSHL_register_instance_;
  const NamedVectorBinary3RegisterSameLengthDQ_VQSUB VectorBinary3RegisterSameLengthDQ_VQSUB_instance_;
  const NamedVectorBinary3RegisterSameLengthDQ_VRSHL VectorBinary3RegisterSameLengthDQ_VRSHL_instance_;
  const NamedVectorBinary3RegisterSameLengthDQ_VSHL_register VectorBinary3RegisterSameLengthDQ_VSHL_register_instance_;
  const NamedVectorBinary3RegisterSameLengthDQ_VSUB_integer VectorBinary3RegisterSameLengthDQ_VSUB_integer_instance_;
  const NamedVectorBinary3RegisterSameLengthDQI16_32_VQDMULH_A1 VectorBinary3RegisterSameLengthDQI16_32_VQDMULH_A1_instance_;
  const NamedVectorBinary3RegisterSameLengthDQI16_32_VQRDMULH_A1 VectorBinary3RegisterSameLengthDQI16_32_VQRDMULH_A1_instance_;
  const NamedVectorBinary3RegisterSameLengthDQI8P_VMUL_polynomial_A1 VectorBinary3RegisterSameLengthDQI8P_VMUL_polynomial_A1_instance_;
  const NamedVectorBinary3RegisterSameLengthDQI8_16_32_VABA VectorBinary3RegisterSameLengthDQI8_16_32_VABA_instance_;
  const NamedVectorBinary3RegisterSameLengthDQI8_16_32_VABD VectorBinary3RegisterSameLengthDQI8_16_32_VABD_instance_;
  const NamedVectorBinary3RegisterSameLengthDQI8_16_32_VCEQ_register_A1 VectorBinary3RegisterSameLengthDQI8_16_32_VCEQ_register_A1_instance_;
  const NamedVectorBinary3RegisterSameLengthDQI8_16_32_VCGE_register_A1 VectorBinary3RegisterSameLengthDQI8_16_32_VCGE_register_A1_instance_;
  const NamedVectorBinary3RegisterSameLengthDQI8_16_32_VCGT_register_A1 VectorBinary3RegisterSameLengthDQI8_16_32_VCGT_register_A1_instance_;
  const NamedVectorBinary3RegisterSameLengthDQI8_16_32_VHADD VectorBinary3RegisterSameLengthDQI8_16_32_VHADD_instance_;
  const NamedVectorBinary3RegisterSameLengthDQI8_16_32_VHSUB VectorBinary3RegisterSameLengthDQI8_16_32_VHSUB_instance_;
  const NamedVectorBinary3RegisterSameLengthDQI8_16_32_VMAX VectorBinary3RegisterSameLengthDQI8_16_32_VMAX_instance_;
  const NamedVectorBinary3RegisterSameLengthDQI8_16_32_VMIN VectorBinary3RegisterSameLengthDQI8_16_32_VMIN_instance_;
  const NamedVectorBinary3RegisterSameLengthDQI8_16_32_VMLA_integer_A1 VectorBinary3RegisterSameLengthDQI8_16_32_VMLA_integer_A1_instance_;
  const NamedVectorBinary3RegisterSameLengthDQI8_16_32_VMLS_integer_A1 VectorBinary3RegisterSameLengthDQI8_16_32_VMLS_integer_A1_instance_;
  const NamedVectorBinary3RegisterSameLengthDQI8_16_32_VMUL_integer_A1 VectorBinary3RegisterSameLengthDQI8_16_32_VMUL_integer_A1_instance_;
  const NamedVectorBinary3RegisterSameLengthDQI8_16_32_VRHADD VectorBinary3RegisterSameLengthDQI8_16_32_VRHADD_instance_;
  const NamedVectorBinary3RegisterSameLengthDQI8_16_32_VTST VectorBinary3RegisterSameLengthDQI8_16_32_VTST_instance_;
  const NamedVectorLoadSingle1AllLanes_VLD1_single_element_to_all_lanes VectorLoadSingle1AllLanes_VLD1_single_element_to_all_lanes_instance_;
  const NamedVectorLoadSingle2AllLanes_VLD2_single_2_element_structure_to_all_lanes VectorLoadSingle2AllLanes_VLD2_single_2_element_structure_to_all_lanes_instance_;
  const NamedVectorLoadSingle3AllLanes_VLD3_single_3_element_structure_to_all_lanes VectorLoadSingle3AllLanes_VLD3_single_3_element_structure_to_all_lanes_instance_;
  const NamedVectorLoadSingle4AllLanes_VLD4_single_4_element_structure_to_all_lanes VectorLoadSingle4AllLanes_VLD4_single_4_element_structure_to_all_lanes_instance_;
  const NamedVectorLoadStoreMultiple1_VLD1_multiple_single_elements VectorLoadStoreMultiple1_VLD1_multiple_single_elements_instance_;
  const NamedVectorLoadStoreMultiple1_VST1_multiple_single_elements VectorLoadStoreMultiple1_VST1_multiple_single_elements_instance_;
  const NamedVectorLoadStoreMultiple2_VLD2_multiple_2_element_structures VectorLoadStoreMultiple2_VLD2_multiple_2_element_structures_instance_;
  const NamedVectorLoadStoreMultiple2_VST2_multiple_2_element_structures VectorLoadStoreMultiple2_VST2_multiple_2_element_structures_instance_;
  const NamedVectorLoadStoreMultiple3_VLD3_multiple_3_element_structures VectorLoadStoreMultiple3_VLD3_multiple_3_element_structures_instance_;
  const NamedVectorLoadStoreMultiple3_VST3_multiple_3_element_structures VectorLoadStoreMultiple3_VST3_multiple_3_element_structures_instance_;
  const NamedVectorLoadStoreMultiple4_VLD4_multiple_4_element_structures VectorLoadStoreMultiple4_VLD4_multiple_4_element_structures_instance_;
  const NamedVectorLoadStoreMultiple4_VST4_multiple_4_element_structures VectorLoadStoreMultiple4_VST4_multiple_4_element_structures_instance_;
  const NamedVectorLoadStoreSingle1_VLD1_single_element_to_one_lane VectorLoadStoreSingle1_VLD1_single_element_to_one_lane_instance_;
  const NamedVectorLoadStoreSingle1_VST1_single_element_from_one_lane VectorLoadStoreSingle1_VST1_single_element_from_one_lane_instance_;
  const NamedVectorLoadStoreSingle2_VLD2_single_2_element_structure_to_one_lane VectorLoadStoreSingle2_VLD2_single_2_element_structure_to_one_lane_instance_;
  const NamedVectorLoadStoreSingle2_VST2_single_2_element_structure_from_one_lane VectorLoadStoreSingle2_VST2_single_2_element_structure_from_one_lane_instance_;
  const NamedVectorLoadStoreSingle3_VLD3_single_3_element_structure_to_one_lane VectorLoadStoreSingle3_VLD3_single_3_element_structure_to_one_lane_instance_;
  const NamedVectorLoadStoreSingle3_VST3_single_3_element_structure_from_one_lane VectorLoadStoreSingle3_VST3_single_3_element_structure_from_one_lane_instance_;
  const NamedVectorLoadStoreSingle4_VLD4_single_4_element_structure_to_one_lane VectorLoadStoreSingle4_VLD4_single_4_element_structure_to_one_lane_instance_;
  const NamedVectorLoadStoreSingle4_VST4_single_4_element_structure_form_one_lane VectorLoadStoreSingle4_VST4_single_4_element_structure_form_one_lane_instance_;
  const NamedVectorUnary2RegisterDup_Vdup_Rule_302_A1_P592 VectorUnary2RegisterDup_Vdup_Rule_302_A1_P592_instance_;
  const NamedVfpMrsOp_Vmrs_Rule_335_A1_P658 VfpMrsOp_Vmrs_Rule_335_A1_P658_instance_;
  const NamedVfpUsesRegOp_Vmsr_Rule_336_A1_P660 VfpUsesRegOp_Vmsr_Rule_336_A1_P660_instance_;
  const NamedBranch_B_Rule_16_A1_P44 Branch_B_Rule_16_A1_P44_instance_;
  const NamedBranch_Bl_Blx_Rule_23_A1_P58 Branch_Bl_Blx_Rule_23_A1_P58_instance_;
  const NamedDefs12To15CondsDontCareMsbGeLsb_Bfi_Rule_18_A1_P48 Defs12To15CondsDontCareMsbGeLsb_Bfi_Rule_18_A1_P48_instance_;
  const NamedDefs12To15CondsDontCareRdRnNotPc_Rbit_Rule_134_A1_P270 Defs12To15CondsDontCareRdRnNotPc_Rbit_Rule_134_A1_P270_instance_;
  const NamedDefs12To15CondsDontCareRdRnNotPc_Rev16_Rule_136_A1_P274 Defs12To15CondsDontCareRdRnNotPc_Rev16_Rule_136_A1_P274_instance_;
  const NamedDefs12To15CondsDontCareRdRnNotPc_Rev_Rule_135_A1_P272 Defs12To15CondsDontCareRdRnNotPc_Rev_Rule_135_A1_P272_instance_;
  const NamedDefs12To15CondsDontCareRdRnNotPc_Revsh_Rule_137_A1_P276 Defs12To15CondsDontCareRdRnNotPc_Revsh_Rule_137_A1_P276_instance_;
  const NamedDefs12To15CondsDontCareRdRnNotPc_Ssat16_Rule_184_A1_P364 Defs12To15CondsDontCareRdRnNotPc_Ssat16_Rule_184_A1_P364_instance_;
  const NamedDefs12To15CondsDontCareRdRnNotPc_Ssat_Rule_183_A1_P362 Defs12To15CondsDontCareRdRnNotPc_Ssat_Rule_183_A1_P362_instance_;
  const NamedDefs12To15CondsDontCareRdRnNotPc_Sxtb16_Rule_224_A1_P442 Defs12To15CondsDontCareRdRnNotPc_Sxtb16_Rule_224_A1_P442_instance_;
  const NamedDefs12To15CondsDontCareRdRnNotPc_Sxtb_Rule_223_A1_P440 Defs12To15CondsDontCareRdRnNotPc_Sxtb_Rule_223_A1_P440_instance_;
  const NamedDefs12To15CondsDontCareRdRnNotPc_Sxth_Rule_225_A1_P444 Defs12To15CondsDontCareRdRnNotPc_Sxth_Rule_225_A1_P444_instance_;
  const NamedDefs12To15CondsDontCareRdRnNotPc_Usat16_Rule_256_A1_P506 Defs12To15CondsDontCareRdRnNotPc_Usat16_Rule_256_A1_P506_instance_;
  const NamedDefs12To15CondsDontCareRdRnNotPc_Usat_Rule_255_A1_P504 Defs12To15CondsDontCareRdRnNotPc_Usat_Rule_255_A1_P504_instance_;
  const NamedDefs12To15CondsDontCareRdRnNotPc_Uxtb16_Rule_264_A1_P522 Defs12To15CondsDontCareRdRnNotPc_Uxtb16_Rule_264_A1_P522_instance_;
  const NamedDefs12To15CondsDontCareRdRnNotPc_Uxtb_Rule_263_A1_P520 Defs12To15CondsDontCareRdRnNotPc_Uxtb_Rule_263_A1_P520_instance_;
  const NamedDefs12To15CondsDontCareRdRnNotPc_Uxth_Rule_265_A1_P524 Defs12To15CondsDontCareRdRnNotPc_Uxth_Rule_265_A1_P524_instance_;
  const NamedDefs12To15CondsDontCareRdRnNotPcBitfieldExtract_Sbfx_Rule_154_A1_P308 Defs12To15CondsDontCareRdRnNotPcBitfieldExtract_Sbfx_Rule_154_A1_P308_instance_;
  const NamedDefs12To15CondsDontCareRdRnNotPcBitfieldExtract_Ubfx_Rule_236_A1_P466 Defs12To15CondsDontCareRdRnNotPcBitfieldExtract_Ubfx_Rule_236_A1_P466_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Pkh_Rule_116_A1_P234 Defs12To15CondsDontCareRnRdRmNotPc_Pkh_Rule_116_A1_P234_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Qadd16_Rule_125_A1_P252 Defs12To15CondsDontCareRnRdRmNotPc_Qadd16_Rule_125_A1_P252_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Qadd8_Rule_126_A1_P254 Defs12To15CondsDontCareRnRdRmNotPc_Qadd8_Rule_126_A1_P254_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Qasx_Rule_127_A1_P256 Defs12To15CondsDontCareRnRdRmNotPc_Qasx_Rule_127_A1_P256_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Qsax_Rule_130_A1_P262 Defs12To15CondsDontCareRnRdRmNotPc_Qsax_Rule_130_A1_P262_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Qsub16_Rule_132_A1_P266 Defs12To15CondsDontCareRnRdRmNotPc_Qsub16_Rule_132_A1_P266_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Qsub8_Rule_133_A1_P268 Defs12To15CondsDontCareRnRdRmNotPc_Qsub8_Rule_133_A1_P268_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Sadd16_Rule_148_A1_P296 Defs12To15CondsDontCareRnRdRmNotPc_Sadd16_Rule_148_A1_P296_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Sadd8_Rule_149_A1_P298 Defs12To15CondsDontCareRnRdRmNotPc_Sadd8_Rule_149_A1_P298_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Sasx_Rule_150_A1_P300 Defs12To15CondsDontCareRnRdRmNotPc_Sasx_Rule_150_A1_P300_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Sel_Rule_156_A1_P312 Defs12To15CondsDontCareRnRdRmNotPc_Sel_Rule_156_A1_P312_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Shadd16_Rule_159_A1_P318 Defs12To15CondsDontCareRnRdRmNotPc_Shadd16_Rule_159_A1_P318_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Shadd8_Rule_160_A1_P320 Defs12To15CondsDontCareRnRdRmNotPc_Shadd8_Rule_160_A1_P320_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Shasx_Rule_161_A1_P322 Defs12To15CondsDontCareRnRdRmNotPc_Shasx_Rule_161_A1_P322_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Shsax_Rule_162_A1_P324 Defs12To15CondsDontCareRnRdRmNotPc_Shsax_Rule_162_A1_P324_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Shsub16_Rule_163_A1_P326 Defs12To15CondsDontCareRnRdRmNotPc_Shsub16_Rule_163_A1_P326_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Shsub8_Rule_164_A1_P328 Defs12To15CondsDontCareRnRdRmNotPc_Shsub8_Rule_164_A1_P328_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Ssax_Rule_185_A1_P366 Defs12To15CondsDontCareRnRdRmNotPc_Ssax_Rule_185_A1_P366_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Ssub16_Rule_186_A1_P368 Defs12To15CondsDontCareRnRdRmNotPc_Ssub16_Rule_186_A1_P368_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Ssub8_Rule_187_A1_P370 Defs12To15CondsDontCareRnRdRmNotPc_Ssub8_Rule_187_A1_P370_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Sxtab16_Rule_221_A1_P436 Defs12To15CondsDontCareRnRdRmNotPc_Sxtab16_Rule_221_A1_P436_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Sxtab_Rule_220_A1_P434 Defs12To15CondsDontCareRnRdRmNotPc_Sxtab_Rule_220_A1_P434_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Sxtah_Rule_222_A1_P438 Defs12To15CondsDontCareRnRdRmNotPc_Sxtah_Rule_222_A1_P438_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uadd16_Rule_233_A1_P460 Defs12To15CondsDontCareRnRdRmNotPc_Uadd16_Rule_233_A1_P460_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uadd8_Rule_234_A1_P462 Defs12To15CondsDontCareRnRdRmNotPc_Uadd8_Rule_234_A1_P462_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uasx_Rule_235_A1_P464 Defs12To15CondsDontCareRnRdRmNotPc_Uasx_Rule_235_A1_P464_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uhadd16_Rule_238_A1_P470 Defs12To15CondsDontCareRnRdRmNotPc_Uhadd16_Rule_238_A1_P470_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uhadd8_Rule_239_A1_P472 Defs12To15CondsDontCareRnRdRmNotPc_Uhadd8_Rule_239_A1_P472_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uhasx_Rule_240_A1_P474 Defs12To15CondsDontCareRnRdRmNotPc_Uhasx_Rule_240_A1_P474_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uhsax_Rule_241_A1_P476 Defs12To15CondsDontCareRnRdRmNotPc_Uhsax_Rule_241_A1_P476_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uhsub16_Rule_242_A1_P478 Defs12To15CondsDontCareRnRdRmNotPc_Uhsub16_Rule_242_A1_P478_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uhsub8_Rule_243_A1_P480 Defs12To15CondsDontCareRnRdRmNotPc_Uhsub8_Rule_243_A1_P480_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uqadd16_Rule_247_A1_P488 Defs12To15CondsDontCareRnRdRmNotPc_Uqadd16_Rule_247_A1_P488_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uqadd8_Rule_248_A1_P490 Defs12To15CondsDontCareRnRdRmNotPc_Uqadd8_Rule_248_A1_P490_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uqasx_Rule_249_A1_P492 Defs12To15CondsDontCareRnRdRmNotPc_Uqasx_Rule_249_A1_P492_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uqsax_Rule_250_A1_P494 Defs12To15CondsDontCareRnRdRmNotPc_Uqsax_Rule_250_A1_P494_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uqsub16_Rule_251_A1_P496 Defs12To15CondsDontCareRnRdRmNotPc_Uqsub16_Rule_251_A1_P496_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uqsub8_Rule_252_A1_P498 Defs12To15CondsDontCareRnRdRmNotPc_Uqsub8_Rule_252_A1_P498_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Usax_Rule_257_A1_P508 Defs12To15CondsDontCareRnRdRmNotPc_Usax_Rule_257_A1_P508_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Usub16_Rule_258_A1_P510 Defs12To15CondsDontCareRnRdRmNotPc_Usub16_Rule_258_A1_P510_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Usub8_Rule_259_A1_P512 Defs12To15CondsDontCareRnRdRmNotPc_Usub8_Rule_259_A1_P512_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uxtab16_Rule_262_A1_P516 Defs12To15CondsDontCareRnRdRmNotPc_Uxtab16_Rule_262_A1_P516_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uxtab_Rule_260_A1_P514 Defs12To15CondsDontCareRnRdRmNotPc_Uxtab_Rule_260_A1_P514_instance_;
  const NamedDefs12To15CondsDontCareRnRdRmNotPc_Uxtah_Rule_262_A1_P518 Defs12To15CondsDontCareRnRdRmNotPc_Uxtah_Rule_262_A1_P518_instance_;
  const NamedDefs16To19CondsDontCareRdRaRmRnNotPc_Usada8_Rule_254_A1_P502 Defs16To19CondsDontCareRdRaRmRnNotPc_Usada8_Rule_254_A1_P502_instance_;
  const NamedDefs16To19CondsDontCareRdRmRnNotPc_Usad8_Rule_253_A1_P500 Defs16To19CondsDontCareRdRmRnNotPc_Usad8_Rule_253_A1_P500_instance_;
  const NamedDontCareInst_Msr_Rule_103_A1_P208 DontCareInst_Msr_Rule_103_A1_P208_instance_;
  const NamedDontCareInst_Nop_Rule_110_A1_P222 DontCareInst_Nop_Rule_110_A1_P222_instance_;
  const NamedDontCareInst_Yield_Rule_413_A1_P812 DontCareInst_Yield_Rule_413_A1_P812_instance_;
  const NamedDontCareInstRdNotPc_Vmsr_Rule_336_A1_P660 DontCareInstRdNotPc_Vmsr_Rule_336_A1_P660_instance_;
  const NamedForbidden_BXJ Forbidden_BXJ_instance_;
  const NamedForbidden_Blx_Rule_23_A2_P58 Forbidden_Blx_Rule_23_A2_P58_instance_;
  const NamedForbidden_Cdp2_Rule_28_A2_P68 Forbidden_Cdp2_Rule_28_A2_P68_instance_;
  const NamedForbidden_Cdp_Rule_A1 Forbidden_Cdp_Rule_A1_instance_;
  const NamedForbidden_Clrex_Rule_30_A1_P70 Forbidden_Clrex_Rule_30_A1_P70_instance_;
  const NamedForbidden_Cps_Rule_b6_1_1_A1_B6_3 Forbidden_Cps_Rule_b6_1_1_A1_B6_3_instance_;
  const NamedForbidden_Dbg_Rule_40_A1_P88 Forbidden_Dbg_Rule_40_A1_P88_instance_;
  const NamedForbidden_ERET Forbidden_ERET_instance_;
  const NamedForbidden_HVC Forbidden_HVC_instance_;
  const NamedForbidden_Ldc2_Rule_51_A2_P106 Forbidden_Ldc2_Rule_51_A2_P106_instance_;
  const NamedForbidden_Ldc2_Rule_52_A2_P108 Forbidden_Ldc2_Rule_52_A2_P108_instance_;
  const NamedForbidden_Ldc_immediate_Rule_A1 Forbidden_Ldc_immediate_Rule_A1_instance_;
  const NamedForbidden_Ldc_literal_Rule_A1 Forbidden_Ldc_literal_Rule_A1_instance_;
  const NamedForbidden_Ldm_Rule_2_B6_A1_P5 Forbidden_Ldm_Rule_2_B6_A1_P5_instance_;
  const NamedForbidden_Ldm_Rule_3_B6_A1_P7 Forbidden_Ldm_Rule_3_B6_A1_P7_instance_;
  const NamedForbidden_MRS_Banked_register Forbidden_MRS_Banked_register_instance_;
  const NamedForbidden_MSR_Banked_register Forbidden_MSR_Banked_register_instance_;
  const NamedForbidden_MSR_register Forbidden_MSR_register_instance_;
  const NamedForbidden_Mcr2_Rule_92_A2_P186 Forbidden_Mcr2_Rule_92_A2_P186_instance_;
  const NamedForbidden_Mcr_Rule_A1 Forbidden_Mcr_Rule_A1_instance_;
  const NamedForbidden_Mcrr2_Rule_93_A2_P188 Forbidden_Mcrr2_Rule_93_A2_P188_instance_;
  const NamedForbidden_Mcrr_Rule_A1 Forbidden_Mcrr_Rule_A1_instance_;
  const NamedForbidden_Mrc2_Rule_100_A2_P202 Forbidden_Mrc2_Rule_100_A2_P202_instance_;
  const NamedForbidden_Mrc_Rule_A1 Forbidden_Mrc_Rule_A1_instance_;
  const NamedForbidden_Mrrc2_Rule_101_A2_P204 Forbidden_Mrrc2_Rule_101_A2_P204_instance_;
  const NamedForbidden_Mrrc_Rule_A1 Forbidden_Mrrc_Rule_A1_instance_;
  const NamedForbidden_Msr_Rule_B6_1_6_A1_PB6_12 Forbidden_Msr_Rule_B6_1_6_A1_PB6_12_instance_;
  const NamedForbidden_Rfe_Rule_B6_1_10_A1_B6_16 Forbidden_Rfe_Rule_B6_1_10_A1_B6_16_instance_;
  const NamedForbidden_SMC Forbidden_SMC_instance_;
  const NamedForbidden_Setend_Rule_157_P314 Forbidden_Setend_Rule_157_P314_instance_;
  const NamedForbidden_Sev_Rule_158_A1_P316 Forbidden_Sev_Rule_158_A1_P316_instance_;
  const NamedForbidden_Srs_Rule_B6_1_10_A1_B6_20 Forbidden_Srs_Rule_B6_1_10_A1_B6_20_instance_;
  const NamedForbidden_Stc2_Rule_188_A2_P372 Forbidden_Stc2_Rule_188_A2_P372_instance_;
  const NamedForbidden_Stc_Rule_A2 Forbidden_Stc_Rule_A2_instance_;
  const NamedForbidden_Stm_Rule_11_B6_A1_P22 Forbidden_Stm_Rule_11_B6_A1_P22_instance_;
  const NamedForbidden_Svc_Rule_A1 Forbidden_Svc_Rule_A1_instance_;
  const NamedForbidden_Unallocated_hints Forbidden_Unallocated_hints_instance_;
  const NamedForbidden_Wfe_Rule_411_A1_P808 Forbidden_Wfe_Rule_411_A1_P808_instance_;
  const NamedForbidden_Wfi_Rule_412_A1_P810 Forbidden_Wfi_Rule_412_A1_P810_instance_;
  const NamedLoadMultiple_Ldm_Ldmia_Ldmfd_Rule_53_A1_P110 LoadMultiple_Ldm_Ldmia_Ldmfd_Rule_53_A1_P110_instance_;
  const NamedLoadMultiple_Ldmda_Ldmfa_Rule_54_A1_P112 LoadMultiple_Ldmda_Ldmfa_Rule_54_A1_P112_instance_;
  const NamedLoadMultiple_Ldmdb_Ldmea_Rule_55_A1_P114 LoadMultiple_Ldmdb_Ldmea_Rule_55_A1_P114_instance_;
  const NamedLoadMultiple_Ldmib_Ldmed_Rule_56_A1_P116 LoadMultiple_Ldmib_Ldmed_Rule_56_A1_P116_instance_;
  const NamedLoadMultiple_Pop_Rule_A1 LoadMultiple_Pop_Rule_A1_instance_;
  const NamedUndefined_Undefined_A5_6 Undefined_Undefined_A5_6_instance_;
  const NamedUnpredictable_Unpredictable Unpredictable_Unpredictable_instance_;
  const NamedVfpOp_Vabs_Rule_269_A2_P532 VfpOp_Vabs_Rule_269_A2_P532_instance_;
  const NamedVfpOp_Vadd_Rule_271_A2_P536 VfpOp_Vadd_Rule_271_A2_P536_instance_;
  const NamedVfpOp_Vcmp_Vcmpe_Rule_A1 VfpOp_Vcmp_Vcmpe_Rule_A1_instance_;
  const NamedVfpOp_Vcmp_Vcmpe_Rule_A2 VfpOp_Vcmp_Vcmpe_Rule_A2_instance_;
  const NamedVfpOp_Vcvt_Rule_297_A1_P582 VfpOp_Vcvt_Rule_297_A1_P582_instance_;
  const NamedVfpOp_Vcvt_Rule_298_A1_P584 VfpOp_Vcvt_Rule_298_A1_P584_instance_;
  const NamedVfpOp_Vcvt_Vcvtr_Rule_295_A1_P578 VfpOp_Vcvt_Vcvtr_Rule_295_A1_P578_instance_;
  const NamedVfpOp_Vcvtb_Vcvtt_Rule_300_A1_P588 VfpOp_Vcvtb_Vcvtt_Rule_300_A1_P588_instance_;
  const NamedVfpOp_Vdiv_Rule_301_A1_P590 VfpOp_Vdiv_Rule_301_A1_P590_instance_;
  const NamedVfpOp_Vfma_vfms_Rule_A1 VfpOp_Vfma_vfms_Rule_A1_instance_;
  const NamedVfpOp_Vfnma_vfnms_Rule_A1 VfpOp_Vfnma_vfnms_Rule_A1_instance_;
  const NamedVfpOp_Vmla_vmls_Rule_423_A2_P636 VfpOp_Vmla_vmls_Rule_423_A2_P636_instance_;
  const NamedVfpOp_Vmov_Rule_326_A2_P640 VfpOp_Vmov_Rule_326_A2_P640_instance_;
  const NamedVfpOp_Vmov_Rule_327_A2_P642 VfpOp_Vmov_Rule_327_A2_P642_instance_;
  const NamedVfpOp_Vmul_Rule_338_A2_P664 VfpOp_Vmul_Rule_338_A2_P664_instance_;
  const NamedVfpOp_Vneg_Rule_342_A2_P672 VfpOp_Vneg_Rule_342_A2_P672_instance_;
  const NamedVfpOp_Vnmla_vnmls_Rule_343_A1_P674 VfpOp_Vnmla_vnmls_Rule_343_A1_P674_instance_;
  const NamedVfpOp_Vnmul_Rule_343_A2_P674 VfpOp_Vnmul_Rule_343_A2_P674_instance_;
  const NamedVfpOp_Vsqrt_Rule_388_A1_P762 VfpOp_Vsqrt_Rule_388_A1_P762_instance_;
  const NamedVfpOp_Vsub_Rule_402_A2_P790 VfpOp_Vsub_Rule_402_A2_P790_instance_;
 private:

  // The following list of methods correspond to each decoder table,
  // and implements the pattern matching of the corresponding bit
  // patterns. After matching the corresponding bit patterns, they
  // either call other methods in this list (corresponding to another
  // decoder table), or they return the instance field that implements
  // the class decoder that should be used to decode the particular
  // instruction.
  inline const NamedClassDecoder& decode_ARMv7(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_advanced_simd_data_processing_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_advanced_simd_element_or_structure_load_store_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_branch_branch_with_link_and_block_data_transfer(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_coprocessor_instructions_and_supervisor_call(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_data_processing_and_miscellaneous_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_data_processing_immediate(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_data_processing_register(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_data_processing_register_shifted_register(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_extension_register_load_store_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_extra_load_store_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_floating_point_data_processing_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_halfword_multiply_and_multiply_accumulate(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_load_store_word_and_unsigned_byte(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_media_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_memory_hints_advanced_simd_instructions_and_miscellaneous_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_miscellaneous_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_msr_immediate_and_hints(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_multiply_and_multiply_accumulate(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_other_floating_point_data_processing_instructions(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_packing_unpacking_saturation_and_reversal(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_parallel_addition_and_subtraction_signed(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_parallel_addition_and_subtraction_unsigned(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_saturating_addition_and_subtraction(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_signed_multiply_signed_and_unsigned_divide(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_simd_dp_1imm(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_simd_dp_2misc(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_simd_dp_2scalar(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_simd_dp_2shift(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_simd_dp_3diff(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_simd_dp_3same(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_synchronization_primitives(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_transfer_between_arm_core_and_extension_register_8_16_and_32_bit(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_transfer_between_arm_core_and_extension_registers_64_bit(
      const nacl_arm_dec::Instruction inst) const;
  inline const NamedClassDecoder& decode_unconditional_instructions(
      const nacl_arm_dec::Instruction inst) const;
  // Defines default action if parse tables don't define what action
  // to take.
  const NotImplementedNamed not_implemented_;
};

} // namespace nacl_arm_test
#endif  // NATIVE_CLIENT_SRC_TRUSTED_VALIDATOR_ARM_GEN_ARM32_DECODE_NAMED_DECODER_H_
