// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

onload = function() {
  var getURL = chrome.extension.getURL;
  chrome.tabs.create({"url": "about:blank"}, function(tab) {
    var tabId = tab.id;

    chrome.test.runTests([
      // Navigates to a.html which includes b.html as an iframe. b.html
      // redirects to c.html.
      function iframe() {
        expect([
          { label: "a-onBeforeNavigate",
            event: "onBeforeNavigate",
            details: { frameId: 0,
                       parentFrameId: -1,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/a.html') }},
          { label: "a-onCommitted",
            event: "onCommitted",
            details: { frameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       transitionQualifiers: [],
                       transitionType: "link",
                       url: getURL('iframe/a.html') }},
          { label: "a-onDOMContentLoaded",
            event: "onDOMContentLoaded",
            details: { frameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/a.html') }},
          { label: "a-onCompleted",
            event: "onCompleted",
            details: { frameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/a.html') }},
          { label: "b-onBeforeNavigate",
            event: "onBeforeNavigate",
            details: { frameId: 1,
                       parentFrameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/b.html') }},
          { label: "b-onCommitted",
            event: "onCommitted",
            details: { frameId: 1,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       transitionQualifiers: [],
                       transitionType: "auto_subframe",
                       url: getURL('iframe/b.html') }},
          { label: "b-onDOMContentLoaded",
            event: "onDOMContentLoaded",
            details: { frameId: 1,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/b.html') }},
          { label: "b-onCompleted",
            event: "onCompleted",
            details: { frameId: 1,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/b.html') }},
          { label: "c-onBeforeNavigate",
            event: "onBeforeNavigate",
            details: { frameId: 1,
                       parentFrameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/c.html') }},
          { label: "c-onCommitted",
            event: "onCommitted",
            details: { frameId: 1,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       transitionQualifiers: [],
                       transitionType: "auto_subframe",
                       url: getURL('iframe/c.html') }},
          { label: "c-onDOMContentLoaded",
            event: "onDOMContentLoaded",
            details: { frameId: 1,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/c.html') }},
          { label: "c-onCompleted",
            event: "onCompleted",
            details: { frameId: 1,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/c.html') }}],
          [ navigationOrder("a-"),
            navigationOrder("b-"),
            navigationOrder("c-"),
            isIFrameOf("b-", "a-"),
            isLoadedBy("c-", "b-")]);
        chrome.tabs.update(tabId, { url: getURL('iframe/a.html') });
      },

      // Navigates to d.html which includes e.html and f.html as iframes. To be
      // able to predict which iframe has which id, the iframe for f.html is
      // created by javascript. f.html then navigates to g.html.
      function iframeMultiple() {
        expect([
          { label: "d-onBeforeNavigate",
            event: "onBeforeNavigate",
            details: { frameId: 0,
                       parentFrameId: -1,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/d.html') }},
          { label: "d-onCommitted",
            event: "onCommitted",
            details: { frameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       transitionQualifiers: [],
                       transitionType: "link",
                       url: getURL('iframe/d.html') }},
          { label: "d-onDOMContentLoaded",
            event: "onDOMContentLoaded",
            details: { frameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/d.html') }},
          { label: "d-onCompleted",
            event: "onCompleted",
            details: { frameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/d.html') }},
          { label: "e-onBeforeNavigate",
            event: "onBeforeNavigate",
            details: { frameId: 1,
                       parentFrameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/e.html') }},
          { label: "e-onCommitted",
            event: "onCommitted",
            details: { frameId: 1,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       transitionQualifiers: [],
                       transitionType: "auto_subframe",
                       url: getURL('iframe/e.html') }},
          { label: "e-onDOMContentLoaded",
            event: "onDOMContentLoaded",
            details: { frameId: 1,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/e.html') }},
          { label: "e-onCompleted",
            event: "onCompleted",
            details: { frameId: 1,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/e.html') }},
          { label: "f-onBeforeNavigate",
            event: "onBeforeNavigate",
            details: { frameId: 2,
                       parentFrameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/f.html') }},
          { label: "f-onCommitted",
            event: "onCommitted",
            details: { frameId: 2,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       transitionQualifiers: [],
                       transitionType: "auto_subframe",
                       url: getURL('iframe/f.html') }},
          { label: "f-onDOMContentLoaded",
            event: "onDOMContentLoaded",
            details: { frameId: 2,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/f.html') }},
          { label: "f-onCompleted",
            event: "onCompleted",
            details: { frameId: 2,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/f.html') }},
          { label: "g-onBeforeNavigate",
            event: "onBeforeNavigate",
            details: { frameId: 2,
                       parentFrameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/g.html') }},
          { label: "g-onCommitted",
            event: "onCommitted",
            details: { frameId: 2,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       transitionQualifiers: [],
                       transitionType: "auto_subframe",
                       url: getURL('iframe/g.html') }},
          { label: "g-onDOMContentLoaded",
            event: "onDOMContentLoaded",
            details: { frameId: 2,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/g.html') }},
          { label: "g-onCompleted",
            event: "onCompleted",
            details: { frameId: 2,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/g.html') }}],
          [ navigationOrder("d-"),
            navigationOrder("e-"),
            navigationOrder("f-"),
            navigationOrder("g-"),
            isIFrameOf("e-", "d-"),
            ["d-onDOMContentLoaded", "f-onBeforeNavigate", "f-onCompleted",
             "d-onCompleted"],
            isLoadedBy("g-", "f-")]);
        chrome.tabs.update(tabId, { url: getURL('iframe/d.html') });
      },

      // Navigates to h.html which includes i.html that triggers a navigation
      // on the main frame.
      function iframeNavigate() {
        expect([
          { label: "h-onBeforeNavigate",
            event: "onBeforeNavigate",
            details: { frameId: 0,
                       parentFrameId: -1,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/h.html') }},
          { label: "h-onCommitted",
            event: "onCommitted",
            details: { frameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       transitionQualifiers: [],
                       transitionType: "link",
                       url: getURL('iframe/h.html') }},
          { label: "h-onDOMContentLoaded",
            event: "onDOMContentLoaded",
            details: { frameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/h.html') }},
          { label: "h-onCompleted",
            event: "onCompleted",
            details: { frameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/h.html') }},
          { label: "i-onBeforeNavigate",
            event: "onBeforeNavigate",
            details: { frameId: 1,
                       parentFrameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/i.html') }},
          { label: "i-onCommitted",
            event: "onCommitted",
            details: { frameId: 1,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       transitionQualifiers: [],
                       transitionType: "auto_subframe",
                       url: getURL('iframe/i.html') }},
          { label: "i-onDOMContentLoaded",
            event: "onDOMContentLoaded",
            details: { frameId: 1,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/i.html') }},
          { label: "i-onCompleted",
            event: "onCompleted",
            details: { frameId: 1,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/i.html') }},
          { label: "c-onBeforeNavigate",
            event: "onBeforeNavigate",
            details: { frameId: 0,
                       parentFrameId: -1,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/c.html') }},
          { label: "c-onCommitted",
            event: "onCommitted",
            details: { frameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       transitionQualifiers: ['maybe_client_redirect'],
                       transitionType: "link",
                       url: getURL('iframe/c.html') }},
          { label: "c-onDOMContentLoaded",
            event: "onDOMContentLoaded",
            details: { frameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/c.html') }},
          { label: "c-onCompleted",
            event: "onCompleted",
            details: { frameId: 0,
                       processId: 0,
                       tabId: 0,
                       timeStamp: 0,
                       url: getURL('iframe/c.html') }}],
          [ navigationOrder("h-"),
            navigationOrder("i-"),
            navigationOrder("c-"),
            isIFrameOf("i-", "h-"),
            isLoadedBy("c-", "i-") ]);
        chrome.tabs.update(tabId, { url: getURL('iframe/h.html') });
      },
    ]);
  });
};
