// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

var kExpectedDeviceNames = ["d1"];

function testDiscovery() {
  chrome.test.assertEq(kExpectedDeviceNames.length,
      discoveredDevices.length);
  for (var i = 0; i < kExpectedDeviceNames.length; ++i) {
    chrome.test.assertEq(kExpectedDeviceNames[i],
        discoveredDevices[i].name);
  }

  chrome.test.succeed();
}

function startTests() {
  chrome.test.runTests([testDiscovery]);
}

function sendReady(callback) {
  chrome.test.sendMessage('ready', callback);
}

function stopDiscoveryAndContinue() {
  chrome.bluetooth.stopDiscovery();
  sendReady(startTests);
}

var discoveredDevices = [];
function recordDevice(device) {
  discoveredDevices.push(device);
}

chrome.bluetooth.startDiscovery(
    { deviceCallback:recordDevice },
    function() { sendReady(stopDiscoveryAndContinue); });
