# Copyright 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.
{
  'targets': [
    {
      # This target contains mocks and test utilities that don't belong in
      # production libraries but are used by more than one test executable.
      'target_name': 'test_support_common',
      'type': 'static_library',
      'dependencies': [
        # NOTE: New dependencies should generally be added in the OS!="ios"
        # dependencies block below, rather than here.
        'app/policy/cloud_policy_codegen.gyp:policy_test_support',
        'browser',
        '../sync/protocol/sync_proto.gyp:sync_proto',
        'chrome_resources.gyp:chrome_resources',
        'chrome_resources.gyp:chrome_strings',
        'chrome_resources.gyp:theme_resources',
        'common',
        '../base/base.gyp:test_support_base',
        '../content/content.gyp:content_app',
        '../content/content.gyp:test_support_content',
        '../media/media.gyp:media_test_support',
        '../net/net.gyp:net',
        '../net/net.gyp:net_test_support',
        '../skia/skia.gyp:skia',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
      ],
      'export_dependent_settings': [
        'app/policy/cloud_policy_codegen.gyp:policy_test_support',
        '../base/base.gyp:test_support_base',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        '../extensions/common/url_pattern_unittest.cc',
        '../extensions/common/url_pattern_set_unittest.cc',
        'app/breakpad_mac_stubs.mm',
        'app/chrome_main_delegate.cc',
        'app/chrome_main_delegate.h',
        'browser/android/mock_google_location_settings_helper.cc',
        'browser/android/mock_google_location_settings_helper.h',
        'browser/android/tab_android_test_stubs.cc',
        'browser/autofill/autofill_common_test.cc',
        'browser/autofill/autofill_common_test.h',
        'browser/autofill/data_driven_test.cc',
        'browser/autofill/data_driven_test.h',
        'browser/autofill/test_autofill_external_delegate.cc',
        'browser/autofill/test_autofill_external_delegate.h',
        'browser/automation/mock_tab_event_observer.cc',
        'browser/automation/mock_tab_event_observer.h',
        'browser/browsing_data/mock_browsing_data_appcache_helper.cc',
        'browser/browsing_data/mock_browsing_data_appcache_helper.h',
        'browser/browsing_data/mock_browsing_data_cookie_helper.cc',
        'browser/browsing_data/mock_browsing_data_cookie_helper.h',
        'browser/browsing_data/mock_browsing_data_database_helper.cc',
        'browser/browsing_data/mock_browsing_data_database_helper.h',
        'browser/browsing_data/mock_browsing_data_file_system_helper.cc',
        'browser/browsing_data/mock_browsing_data_file_system_helper.h',
        'browser/browsing_data/mock_browsing_data_flash_lso_helper.cc',
        'browser/browsing_data/mock_browsing_data_flash_lso_helper.h',
        'browser/browsing_data/mock_browsing_data_indexed_db_helper.cc',
        'browser/browsing_data/mock_browsing_data_indexed_db_helper.h',
        'browser/browsing_data/mock_browsing_data_local_storage_helper.cc',
        'browser/browsing_data/mock_browsing_data_local_storage_helper.h',
        'browser/browsing_data/mock_browsing_data_quota_helper.cc',
        'browser/browsing_data/mock_browsing_data_quota_helper.h',
        'browser/browsing_data/mock_browsing_data_server_bound_cert_helper.cc',
        'browser/browsing_data/mock_browsing_data_server_bound_cert_helper.h',
        'browser/chromeos/contacts/contact_test_util.cc',
        'browser/chromeos/contacts/contact_test_util.h',
        'browser/chromeos/cros/mock_cert_library.cc',
        'browser/chromeos/cros/mock_cert_library.h',
        'browser/chromeos/cros/mock_cryptohome_library.cc',
        'browser/chromeos/cros/mock_cryptohome_library.h',
        'browser/chromeos/cros/mock_network_library.cc',
        'browser/chromeos/cros/mock_network_library.h',
        'browser/chromeos/input_method/mock_candidate_window_controller.cc',
        'browser/chromeos/input_method/mock_candidate_window_controller.h',
        'browser/chromeos/input_method/mock_input_method_delegate.cc',
        'browser/chromeos/input_method/mock_input_method_delegate.h',
        'browser/chromeos/input_method/mock_input_method_manager.cc',
        'browser/chromeos/input_method/mock_input_method_manager.h',
        'browser/chromeos/input_method/mock_xkeyboard.cc',
        'browser/chromeos/input_method/mock_xkeyboard.h',
        'browser/chromeos/login/mock_login_status_consumer.cc',
        'browser/chromeos/login/mock_login_status_consumer.h',
        'browser/chromeos/login/mock_login_utils.cc',
        'browser/chromeos/login/mock_login_utils.h',
        'browser/chromeos/login/mock_url_fetchers.cc',
        'browser/chromeos/login/mock_url_fetchers.h',
        'browser/chromeos/login/mock_user_image_manager.cc',
        'browser/chromeos/login/mock_user_image_manager.h',
        'browser/chromeos/login/mock_user_manager.cc',
        'browser/chromeos/login/mock_user_manager.h',
        'browser/chromeos/settings/device_settings_test_helper.cc',
        'browser/chromeos/settings/device_settings_test_helper.h',
        'browser/chromeos/settings/mock_owner_key_util.cc',
        'browser/chromeos/settings/mock_owner_key_util.h',
        'browser/chromeos/system/mock_statistics_provider.cc',
        'browser/chromeos/system/mock_statistics_provider.h',
        # The only thing used from browser is Browser::Type.
        'browser/download/download_test_file_chooser_observer.cc',
        'browser/download/download_test_file_chooser_observer.h',
        'browser/download/test_download_shelf.cc',
        'browser/download/test_download_shelf.h',
        'browser/extensions/mock_extension_special_storage_policy.cc',
        'browser/extensions/mock_extension_special_storage_policy.h',
        'browser/extensions/test_blacklist.cc',
        'browser/extensions/test_blacklist.h',
        'browser/extensions/test_extension_prefs.cc',
        'browser/extensions/test_extension_prefs.h',
        'browser/extensions/test_extension_service.cc',
        'browser/extensions/test_extension_service.h',
        'browser/extensions/test_extension_system.cc',
        'browser/extensions/test_extension_system.h',
        'browser/extensions/test_management_policy.cc',
        'browser/extensions/test_management_policy.h',
        'browser/google_apis/test_server/http_connection.cc',
        'browser/google_apis/test_server/http_connection.h',
        'browser/google_apis/test_server/http_request.cc',
        'browser/google_apis/test_server/http_request.h',
        'browser/google_apis/test_server/http_response.cc',
        'browser/google_apis/test_server/http_response.h',
        'browser/google_apis/test_server/http_server.cc',
        'browser/google_apis/test_server/http_server.h',
        'browser/google_apis/test_util.cc',
        'browser/google_apis/test_util.h',
        'browser/media_gallery/media_galleries_test_util.cc',
        'browser/media_gallery/media_galleries_test_util.h',
        'browser/net/url_request_mock_link_doctor_job.cc',
        'browser/net/url_request_mock_link_doctor_job.h',
        'browser/net/url_request_mock_util.cc',
        'browser/net/url_request_mock_util.h',
        'browser/notifications/notification_test_util.cc',
        'browser/notifications/notification_test_util.h',
        'browser/password_manager/mock_password_store.cc',
        'browser/password_manager/mock_password_store.h',
        'browser/password_manager/password_form_data.cc',
        'browser/password_manager/password_form_data.h',
        'browser/policy/mock_cloud_policy_data_store.cc',
        'browser/policy/mock_cloud_policy_data_store.h',
        'browser/policy/mock_configuration_policy_provider.cc',
        'browser/policy/mock_configuration_policy_provider.h',
        'browser/policy/policy_builder.cc',
        'browser/policy/policy_builder.h',
        'browser/prefs/mock_pref_change_callback.cc',
        'browser/prefs/mock_pref_change_callback.h',
        'browser/prefs/pref_service_mock_builder.cc',
        'browser/prefs/pref_service_mock_builder.h',
        'browser/search_engines/template_url_service_test_util.cc',
        'browser/search_engines/template_url_service_test_util.h',
        'browser/sessions/session_service_test_helper.cc',
        'browser/sessions/session_service_test_helper.h',
        'browser/sessions/session_types_test_helper.cc',
        'browser/sessions/session_types_test_helper.h',
        'browser/ssl/ssl_client_auth_requestor_mock.cc',
        'browser/ssl/ssl_client_auth_requestor_mock.h',
        'browser/ui/browser.h',
        'browser/ui/cocoa/find_bar/find_bar_host_unittest_util_cocoa.mm',
        'browser/ui/cocoa/run_loop_testing.h',
        'browser/ui/cocoa/run_loop_testing.mm',
        'browser/ui/find_bar/find_bar_host_unittest_util.h',
        'browser/ui/fullscreen/fullscreen_controller_state_test.cc',
        'browser/ui/fullscreen/fullscreen_controller_state_test.h',
        'browser/ui/fullscreen/fullscreen_controller_test.cc',
        'browser/ui/fullscreen/fullscreen_controller_test.h',
        'browser/ui/gtk/find_bar_host_unittest_util_gtk.cc',
        'browser/ui/views/find_bar_host_unittest_util_views.cc',
        'common/extensions/extension_builder.cc',
        'common/extensions/extension_builder.h',
        'common/extensions/extension_test_util.cc',
        'common/extensions/extension_test_util.h',
        'common/extensions/value_builder.cc',
        'common/extensions/value_builder.h',
        'renderer/chrome_mock_render_thread.cc',
        'renderer/chrome_mock_render_thread.h',
        'renderer/mock_printer.cc',
        'renderer/mock_printer.h',
        'renderer/safe_browsing/mock_feature_extractor_clock.cc',
        'renderer/safe_browsing/mock_feature_extractor_clock.h',
        'renderer/safe_browsing/test_utils.cc',
        'renderer/safe_browsing/test_utils.h',
        'test/automation/automation_handle_tracker.cc',
        'test/automation/automation_handle_tracker.h',
        'test/automation/automation_json_requests.cc',
        'test/automation/automation_json_requests.h',
        'test/automation/automation_proxy.cc',
        'test/automation/automation_proxy.h',
        'test/automation/browser_proxy.cc',
        'test/automation/browser_proxy.h',
        'test/automation/tab_proxy.cc',
        'test/automation/tab_proxy.h',
        'test/automation/value_conversion_traits.cc',
        'test/automation/value_conversion_traits.h',
        'test/automation/value_conversion_util.h',
        'test/automation/window_proxy.cc',
        'test/automation/window_proxy.h',
        'test/base/bookmark_load_observer.cc',
        'test/base/bookmark_load_observer.h',
        'test/base/chrome_render_view_host_test_harness.cc',
        'test/base/chrome_render_view_host_test_harness.h',
        'test/base/chrome_test_suite.cc',
        'test/base/chrome_test_suite.h',
        'test/base/history_index_restore_observer.cc',
        'test/base/history_index_restore_observer.h',
        'test/base/in_process_browser_test.cc',
        'test/base/in_process_browser_test.h',
        'test/base/javascript_test_observer.cc',
        'test/base/javascript_test_observer.h',
        'test/base/model_test_utils.cc',
        'test/base/model_test_utils.h',
        'test/base/module_system_test.cc',
        'test/base/module_system_test.h',
        'test/base/profile_mock.cc',
        'test/base/profile_mock.h',
        'test/base/test_browser_window.cc',
        'test/base/test_browser_window.h',
        'test/base/test_launcher_utils.cc',
        'test/base/test_launcher_utils.h',
        'test/base/test_location_bar.cc',
        'test/base/test_location_bar.h',
        'test/base/test_tab_strip_model_observer.cc',
        'test/base/test_tab_strip_model_observer.h',
        'test/base/testing_browser_process.cc',
        'test/base/testing_browser_process.h',
        'test/base/testing_pref_service.cc',
        'test/base/testing_pref_service.h',
        'test/base/testing_profile.cc',
        'test/base/testing_profile.h',
        'test/base/testing_profile_manager.cc',
        'test/base/testing_profile_manager.h',
        'test/base/thread_observer_helper.h',
        'test/base/tracing.cc',
        'test/base/tracing.h',
        'test/base/ui_test_utils.cc',
        'test/base/ui_test_utils.h',
        'test/base/uma_histogram_helper.cc',
        'test/base/uma_histogram_helper.h',
        'test/logging/win/file_logger.cc',
        'test/logging/win/file_logger.h',
        'test/logging/win/log_file_printer.cc',
        'test/logging/win/log_file_printer.h',
        'test/logging/win/log_file_reader.cc',
        'test/logging/win/log_file_reader.h',
        'test/logging/win/mof_data_parser.cc',
        'test/logging/win/mof_data_parser.h',
        'test/logging/win/test_log_collector.cc',
        'test/logging/win/test_log_collector.h',
        'test/ppapi/ppapi_test.cc',
        'test/ppapi/ppapi_test.h',

        # TODO(joi): Move to 'base_prefs' target in base/base.gyp once
        # Prefs move is complete and dependencies have been broken.
        '../base/prefs/testing_pref_store.cc',
        '../base/prefs/testing_pref_store.h',
        '../base/prefs/pref_store_observer_mock.cc',
        '../base/prefs/pref_store_observer_mock.h',

        '../ui/gfx/image/image_unittest_util.h',
        '../ui/gfx/image/image_unittest_util.cc',
        '../webkit/quota/mock_quota_manager.cc',
        '../webkit/quota/mock_quota_manager.h',
      ],
      'conditions': [
        ['OS!="ios"', {
          'dependencies': [
            'common/extensions/api/api.gyp:api',
            'plugin',
            'renderer',
            'utility',
            '../content/content.gyp:content_gpu',
            '../content/content.gyp:content_plugin',
            '../content/content.gyp:content_ppapi_plugin',
            '../content/content.gyp:content_renderer',
            '../content/content.gyp:content_utility',
            '../content/content.gyp:content_worker',
            '../ipc/ipc.gyp:test_support_ipc',
            '../ppapi/ppapi_internal.gyp:ppapi_shared',
            '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
            '../ui/compositor/compositor.gyp:compositor_test_support',
          ],
          'export_dependent_settings': [
            'renderer',
          ],
        }, {  # OS=="ios"
          'sources/': [
            # Exclude everything but iOS-specific files.
            ['exclude', '\\.(cc|mm)$'],
            ['include', '_ios\\.(cc|mm)$'],
            ['include', '(^|/)ios/'],
            # TODO(ios): Add files here as they are updated to compile on iOS.
            ['include', '^test/base/chrome_test_suite\\.cc$'],
            ['include', '^test/base/testing_browser_process'],
          ],
        }],
        ['chromeos==0', {
          'sources/': [
            ['exclude', '^browser/chromeos'],
          ],
        }, {  # chromeos==1
          'dependencies': [
            '../build/linux/system.gyp:dbus',
            '../chromeos/chromeos.gyp:chromeos_test_support',
          ],
        }],
        ['toolkit_uses_gtk == 1', {
          'dependencies': [
            '../build/linux/system.gyp:gtk',
          ],
        }],
        ['toolkit_uses_gtk == 1 or chromeos==1 or (OS=="linux" and use_aura==1)', {
          'dependencies': [
            '../build/linux/system.gyp:ssl',
          ],
        }],
        ['OS!="android" and OS!="ios"', {
          'dependencies': [
            'service',
          ],
        }],
        ['OS=="win"', {
          'include_dirs': [
            '<(DEPTH)/third_party/wtl/include',
          ],
        }],
      ],
    },
    {
      'target_name': 'test_support_unit',
      'type': 'static_library',
      'dependencies': [
        'chrome_resources.gyp:chrome_resources',
        'chrome_resources.gyp:chrome_strings',
        'browser',
        'common',
        'test_support_common',
        '../base/base.gyp:base',
        '../skia/skia.gyp:skia',
        '../sync/sync.gyp:sync',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        'browser/sync/profile_sync_service_mock.cc',
        'browser/sync/profile_sync_service_mock.h',
        'test/base/run_all_unittests.cc',
      ],
      'conditions': [
        ['toolkit_uses_gtk == 1', {
          'dependencies': [
            # Needed for the following #include chain:
            #   test/base/run_all_unittests.cc
            #   test/base/chrome_test_suite.h
            #   gtk/gtk.h
            '../build/linux/system.gyp:gtk',
          ],
        }],
      ],
    },
    {
      'target_name': 'unit_tests',
      'type': '<(gtest_target_type)',
      'dependencies': [
        # NOTE: New dependencies should generally be added in the OS!="ios"
        # dependencies block below, rather than here.
        # Unit tests should only depend on:
        # 1) everything that the chrome binaries depend on:
        '<@(chromium_dependencies)',
        # 2) test-specific support libraries:
        '../base/base.gyp:test_support_base',
        '../media/media.gyp:media_test_support',
        '../net/net.gyp:net',
        '../net/net.gyp:net_test_support',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        'test_support_common',
        '../sync/sync.gyp:test_support_sync_api',
        '../sync/sync.gyp:test_support_sync_core',
        '../sync/sync.gyp:test_support_sync_internal_api',
        '../sync/sync.gyp:test_support_sync_notifier',
        'test_support_unit',
        # 3) anything tests directly depend on
        '../google_apis/google_apis.gyp:google_apis',
        '../skia/skia.gyp:skia',
        '../third_party/bzip2/bzip2.gyp:bzip2',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../third_party/libxml/libxml.gyp:libxml',
        '../ui/ui.gyp:ui_resources',
        '../ui/ui.gyp:ui_test_support',
        'chrome_resources.gyp:chrome_resources',
        'chrome_resources.gyp:chrome_strings',
      ],
      'include_dirs': [
        '..',
      ],
      'defines': [
        'CLD_WINDOWS',
      ],
      'direct_dependent_settings': {
        'defines': [
          'CLD_WINDOWS',
        ],
      },
      'msvs_settings': {
        'VCLinkerTool': {
          'conditions': [
            ['incremental_chrome_dll==1', {
              'UseLibraryDependencyInputs': "true",
            }],
          ],
        },
      },
      'sources': [
        'app/breakpad_mac_stubs.mm',
        'app/chrome_dll.rc',
        '<(SHARED_INTERMEDIATE_DIR)/chrome/chrome_unscaled_resources.rc',
        # All unittests in browser, common, renderer and service.
        'browser/about_flags_unittest.cc',
        'browser/app_controller_mac_unittest.mm',
        'browser/autocomplete/autocomplete_input_unittest.cc',
        'browser/autocomplete/autocomplete_match_unittest.cc',
        'browser/autocomplete/autocomplete_provider_unittest.cc',
        'browser/autocomplete/autocomplete_result_unittest.cc',
        'browser/autocomplete/bookmark_provider_unittest.cc',
        'browser/autocomplete/builtin_provider_unittest.cc',
        'browser/autocomplete/contact_provider_chromeos_unittest.cc',
        'browser/autocomplete/extension_app_provider_unittest.cc',
        'browser/autocomplete/history_contents_provider_unittest.cc',
        'browser/autocomplete/history_quick_provider_unittest.cc',
        'browser/autocomplete/history_url_provider_unittest.cc',
        'browser/autocomplete/keyword_provider_unittest.cc',
        'browser/autocomplete/search_provider_unittest.cc',
        'browser/autocomplete/shortcuts_provider_unittest.cc',
        'browser/autofill/address_field_unittest.cc',
        'browser/autofill/address_unittest.cc',
        'browser/autofill/autocomplete_history_manager_unittest.cc',
        'browser/autofill/autofill_country_unittest.cc',
        'browser/autofill/autofill_download_unittest.cc',
        'browser/autofill/autofill_download_url_unittest.cc',
        'browser/autofill/autofill_external_delegate_unittest.cc',
        'browser/autofill/autofill_field_unittest.cc',
        'browser/autofill/autofill_ie_toolbar_import_win_unittest.cc',
        'browser/autofill/autofill_manager_unittest.cc',
        'browser/autofill/autofill_merge_unittest.cc',
        'browser/autofill/autofill_metrics_unittest.cc',
        'browser/autofill/autofill_profile_unittest.cc',
        'browser/autofill/autofill_regexes_unittest.cc',
        'browser/autofill/autofill_type_unittest.cc',
        'browser/autofill/autofill_xml_parser_unittest.cc',
        'browser/autofill/contact_info_unittest.cc',
        'browser/autofill/credit_card_field_unittest.cc',
        'browser/autofill/credit_card_unittest.cc',
        'browser/autofill/form_field_unittest.cc',
        'browser/autofill/form_structure_unittest.cc',
        'browser/autofill/name_field_unittest.cc',
        'browser/autofill/password_autofill_manager_unittest.cc',
        'browser/autofill/password_generator_unittest.cc',
        'browser/autofill/personal_data_manager_unittest.cc',
        'browser/autofill/phone_field_unittest.cc',
        'browser/autofill/phone_number_unittest.cc',
        'browser/autofill/phone_number_i18n_unittest.cc',
        'browser/automation/automation_provider_unittest.cc',
        'browser/automation/automation_tab_helper_unittest.cc',
        'browser/background/background_application_list_model_unittest.cc',
        'browser/background/background_contents_service_unittest.cc',
        'browser/background/background_mode_manager_unittest.cc',
        'browser/bookmarks/bookmark_codec_unittest.cc',
        'browser/bookmarks/bookmark_expanded_state_tracker_unittest.cc',
        'browser/bookmarks/bookmark_html_writer_unittest.cc',
        'browser/bookmarks/bookmark_index_unittest.cc',
        'browser/bookmarks/bookmark_model_test_utils.cc',
        'browser/bookmarks/bookmark_model_test_utils.h',
        'browser/bookmarks/bookmark_model_unittest.cc',
        'browser/bookmarks/bookmark_node_data_unittest.cc',
        'browser/bookmarks/bookmark_utils_unittest.cc',
        'browser/bookmarks/recently_used_folders_combo_model_unittest.cc',
        'browser/browser_about_handler_unittest.cc',
        'browser/browser_commands_unittest.cc',
        'browser/browsing_data/browsing_data_appcache_helper_unittest.cc',
        'browser/browsing_data/browsing_data_cookie_helper_unittest.cc',
        'browser/browsing_data/browsing_data_database_helper_unittest.cc',
        'browser/browsing_data/browsing_data_file_system_helper_unittest.cc',
        'browser/browsing_data/browsing_data_helper_unittest.cc',
        'browser/browsing_data/browsing_data_indexed_db_helper_unittest.cc',
        'browser/browsing_data/browsing_data_local_storage_helper_unittest.cc',
        'browser/browsing_data/browsing_data_quota_helper_unittest.cc',
        'browser/browsing_data/browsing_data_remover_unittest.cc',
        'browser/browsing_data/browsing_data_server_bound_cert_helper_unittest.cc',
        'browser/browsing_data/cookies_tree_model_unittest.cc',
        'browser/captive_portal/captive_portal_detector_unittest.cc',
        'browser/captive_portal/captive_portal_service_unittest.cc',
        'browser/captive_portal/captive_portal_tab_helper_unittest.cc',
        'browser/captive_portal/captive_portal_tab_reloader_unittest.cc',
        'browser/captive_portal/testing_utils.cc',
        'browser/captive_portal/testing_utils.h',
        'browser/chrome_browser_application_mac_unittest.mm',
        'browser/chrome_browser_main_unittest.cc',
        'browser/chrome_page_zoom_unittest.cc',
        'browser/chromeos/contacts/contact_database_unittest.cc',
        'browser/chromeos/contacts/contact_manager_stub.cc',
        'browser/chromeos/contacts/contact_manager_stub.h',
        'browser/chromeos/contacts/contact_manager_unittest.cc',
        'browser/chromeos/contacts/contact_map_unittest.cc',
        'browser/chromeos/contacts/fake_contact_database.cc',
        'browser/chromeos/contacts/fake_contact_database.h',
        'browser/chromeos/contacts/fake_contact_store.cc',
        'browser/chromeos/contacts/fake_contact_store.h',
        'browser/chromeos/contacts/gdata_contacts_service_stub.cc',
        'browser/chromeos/contacts/gdata_contacts_service_stub.h',
        'browser/chromeos/contacts/gdata_contacts_service_unittest.cc',
        'browser/chromeos/contacts/google_contact_store_unittest.cc',
        'browser/chromeos/cros/cros_network_functions_unittest.cc',
        'browser/chromeos/cros/network_constants.h',
        'browser/chromeos/cros/network_library.cc',
        'browser/chromeos/cros/network_library.h',
        'browser/chromeos/cros/network_library_unittest.cc',
        'browser/chromeos/cros/network_ui_data_unittest.cc',
        'browser/chromeos/cros/onc_network_parser_unittest.cc',
        'browser/chromeos/customization_document_unittest.cc',
        'browser/chromeos/dbus/cros_dbus_service_unittest.cc',
        'browser/chromeos/dbus/printer_service_provider_unittest.cc',
        'browser/chromeos/dbus/proxy_resolution_service_provider_unittest.cc',
        'browser/chromeos/dbus/service_provider_test_helper.cc',
        'browser/chromeos/dbus/service_provider_test_helper.h',
        'browser/chromeos/drive/drive_cache_metadata_unittest.cc',
        'browser/chromeos/drive/drive_cache_unittest.cc',
        'browser/chromeos/drive/drive_file_system_unittest.cc',
        'browser/chromeos/drive/drive_file_system_util_unittest.cc',
        'browser/chromeos/drive/drive_prefetcher_unittest.cc',
        'browser/chromeos/drive/drive_resource_metadata_unittest.cc',
        'browser/chromeos/drive/drive_scheduler_unittest.cc',
        'browser/chromeos/drive/drive_sync_client_unittest.cc',
        'browser/chromeos/drive/drive_system_service_unittest.cc',
        'browser/chromeos/drive/drive_test_util.cc',
        'browser/chromeos/drive/drive_test_util.h',
        'browser/chromeos/drive/drive_webapps_registry_unittest.cc',
        'browser/chromeos/drive/event_logger_unittest.cc',
        'browser/chromeos/drive/fake_free_disk_space_getter.cc',
        'browser/chromeos/drive/fake_free_disk_space_getter.h',
        'browser/chromeos/drive/file_change_unittest.cc',
        'browser/chromeos/drive/file_write_helper_unittest.cc',
        'browser/chromeos/drive/mock_directory_change_observer.cc',
        'browser/chromeos/drive/mock_directory_change_observer.h',
        'browser/chromeos/drive/mock_drive_cache_observer.cc',
        'browser/chromeos/drive/mock_drive_cache_observer.h',
        'browser/chromeos/drive/mock_drive_file_system.cc',
        'browser/chromeos/drive/mock_drive_file_system.h',
        'browser/chromeos/drive/resource_entry_conversion_unittest.cc',
        'browser/chromeos/drive/stale_cache_files_remover_unittest.cc',
        'browser/chromeos/extensions/default_app_order_unittest.cc',
        'browser/chromeos/extensions/file_browser_notifications_unittest.cc',
        'browser/chromeos/extensions/wallpaper_private_api_unittest.cc',
        'browser/chromeos/external_metrics_unittest.cc',
        'browser/chromeos/imageburner/burn_manager_unittest.cc',
        'browser/chromeos/input_method/browser_state_monitor_unittest.cc',
        'browser/chromeos/input_method/candidate_window_controller_impl_unittest.cc',
        'browser/chromeos/input_method/candidate_window_view_unittest.cc',
        'browser/chromeos/input_method/ibus_controller_base_unittest.cc',
        'browser/chromeos/input_method/ibus_controller_impl_unittest.cc',
        'browser/chromeos/input_method/ibus_controller_unittest.cc',
        'browser/chromeos/input_method/input_method_configuration_unittest.cc',
        'browser/chromeos/input_method/input_method_descriptor_unittest.cc',
        'browser/chromeos/input_method/input_method_manager_impl_unittest.cc',
        'browser/chromeos/input_method/input_method_persistence_unittest.cc',
        'browser/chromeos/input_method/input_method_property_unittest.cc',
        'browser/chromeos/input_method/input_method_util_unittest.cc',
        'browser/chromeos/input_method/input_method_whitelist_unittest.cc',
        'browser/chromeos/input_method/xkeyboard_unittest.cc',
        'browser/chromeos/kiosk_mode/kiosk_mode_idle_logout_unittest.cc',
        'browser/chromeos/kiosk_mode/kiosk_mode_settings_unittest.cc',
        'browser/chromeos/language_preferences_unittest.cc',
        'browser/chromeos/login/merge_session_load_page_unittest.cc',
        'browser/chromeos/login/mock_auth_attempt_state_resolver.cc',
        'browser/chromeos/login/mock_auth_attempt_state_resolver.h',
        'browser/chromeos/login/online_attempt_unittest.cc',
        'browser/chromeos/login/parallel_authenticator_unittest.cc',
        'browser/chromeos/login/user_manager_unittest.cc',
        'browser/chromeos/memory/oom_priority_manager_unittest.cc',
        'browser/chromeos/mobile/mobile_activator_unittest.cc',
        'browser/chromeos/mobile_config_unittest.cc',
        'browser/chromeos/net/network_portal_detector_unittest.cc',
        'browser/chromeos/offline/offline_load_page_unittest.cc',
        'browser/chromeos/power/session_length_limiter_unittest.cc',
        'browser/chromeos/preferences_unittest.cc',
        'browser/chromeos/process_proxy/process_output_watcher_unittest.cc',
        'browser/chromeos/proxy_config_service_impl_unittest.cc',
        'browser/chromeos/settings/cros_settings_unittest.cc',
        'browser/chromeos/settings/device_settings_provider_unittest.cc',
        'browser/chromeos/settings/device_settings_service_unittest.cc',
        'browser/chromeos/settings/owner_key_util_unittest.cc',
        'browser/chromeos/settings/session_manager_operation_unittest.cc',
        'browser/chromeos/settings/stub_cros_settings_provider_unittest.cc',
        'browser/chromeos/status/network_menu_icon.cc',
        'browser/chromeos/status/network_menu_icon_unittest.cc',
        'browser/chromeos/system/name_value_pairs_parser_unittest.cc',
        'browser/chromeos/system_logs/lsb_release_log_source_unittest.cc',
        'browser/chromeos/version_loader_unittest.cc',
        'browser/chromeos/web_socket_proxy_helper_unittest.cc',
        'browser/command_updater_unittest.cc',
        'browser/component_updater/component_updater_interceptor.cc',
        'browser/component_updater/component_updater_interceptor.h',
        'browser/component_updater/test/component_installers_unittest.cc',
        'browser/component_updater/test/component_updater_service_unittest.cc',
        'browser/content_settings/content_settings_default_provider_unittest.cc',
        'browser/content_settings/content_settings_mock_observer.cc',
        'browser/content_settings/content_settings_mock_observer.h',
        'browser/content_settings/content_settings_mock_provider.cc',
        'browser/content_settings/content_settings_mock_provider.h',
        'browser/content_settings/content_settings_origin_identifier_value_map_unittest.cc',
        'browser/content_settings/content_settings_policy_provider_unittest.cc',
        'browser/content_settings/content_settings_pref_provider_unittest.cc',
        'browser/content_settings/content_settings_provider_unittest.cc',
        'browser/content_settings/content_settings_rule_unittest.cc',
        'browser/content_settings/content_settings_utils_unittest.cc',
        'browser/content_settings/cookie_settings_unittest.cc',
        'browser/content_settings/host_content_settings_map_unittest.cc',
        'browser/content_settings/mock_settings_observer.cc',
        'browser/content_settings/mock_settings_observer.h',
        'browser/content_settings/tab_specific_content_settings_unittest.cc',
        'browser/custom_handlers/protocol_handler_registry_unittest.cc',
        'browser/diagnostics/diagnostics_model_unittest.cc',
        'browser/download/chrome_download_manager_delegate_unittest.cc',
        'browser/download/download_item_model_unittest.cc',
        'browser/download/all_download_item_notifier_unittest.cc',
        'browser/download/download_history_unittest.cc',
        'browser/download/download_request_infobar_delegate_unittest.cc',
        'browser/download/download_request_limiter_unittest.cc',
        'browser/download/download_path_reservation_tracker_unittest.cc',
        'browser/download/download_shelf_unittest.cc',
        'browser/download/download_status_updater_unittest.cc',
        'browser/enumerate_modules_model_unittest_win.cc',
        'browser/extensions/active_tab_unittest.cc',
        'browser/extensions/admin_policy_unittest.cc',
        'browser/extensions/api/alarms/alarms_api_unittest.cc',
        'browser/extensions/api/api_resource_manager_unittest.cc',
        'browser/extensions/api/bluetooth/bluetooth_event_router_unittest.cc',
        'browser/extensions/api/bookmarks/bookmark_api_helpers_unittest.cc',
        'browser/extensions/api/content_settings/content_settings_store_unittest.cc',
        'browser/extensions/api/content_settings/content_settings_unittest.cc',
        'browser/extensions/api/cookies/cookies_unittest.cc',
        'browser/extensions/api/declarative/initializing_rules_registry_unittest.cc',
        'browser/extensions/api/declarative/rules_registry_service_unittest.cc',
        'browser/extensions/api/declarative/rules_registry_with_cache_unittest.cc',
        'browser/extensions/api/declarative_webrequest/webrequest_action_unittest.cc',
        'browser/extensions/api/declarative_webrequest/webrequest_condition_attribute_unittest.cc',
        'browser/extensions/api/declarative_webrequest/webrequest_condition_unittest.cc',
        'browser/extensions/api/declarative_webrequest/webrequest_rule_unittest.cc',
        'browser/extensions/api/declarative_webrequest/webrequest_rules_registry_unittest.cc',
        'browser/extensions/api/dial/dial_device_data_unittest.cc',
        'browser/extensions/api/dial/dial_registry_unittest.cc',
        'browser/extensions/api/dial/dial_service_unittest.cc',
        'browser/extensions/api/discovery/discovery_api_unittest.cc',
        'browser/extensions/api/extension_action/extension_browser_actions_api_unittest.cc',
        'browser/extensions/api/file_system/file_system_api_unittest.cc',
        'browser/extensions/api/identity/web_auth_flow_unittest.cc',
        'browser/extensions/api/idle/idle_api_unittest.cc',
        'browser/extensions/api/messaging/native_message_process_host_unittest_posix.cc',
        'browser/extensions/api/omnibox/omnibox_unittest.cc',
        'browser/extensions/api/permissions/permissions_api_helpers_unittest.cc',
        'browser/extensions/api/proxy/proxy_api_helpers_unittest.cc',
        'browser/extensions/api/push_messaging/obfuscated_gaia_id_fetcher_unittest.cc',
        'browser/extensions/api/push_messaging/push_messaging_invalidation_handler_unittest.cc',
        'browser/extensions/api/serial/serial_port_enumerator_unittest.cc',
        'browser/extensions/api/socket/socket_api_unittest.cc',
        'browser/extensions/api/socket/tcp_socket_unittest.cc',
        'browser/extensions/api/socket/udp_socket_unittest.cc',
        'browser/extensions/api/system_info_storage/storage_info_provider_linux_unittest.cc',
        'browser/extensions/api/system_info_storage/storage_info_provider_unittest.cc',
        'browser/extensions/api/web_navigation/frame_navigation_state_unittest.cc',
        'browser/extensions/api/web_request/form_data_parser_unittest.cc',
        'browser/extensions/api/web_request/upload_data_presenter_unittest.cc',
        'browser/extensions/api/web_request/web_request_api_unittest.cc',
        'browser/extensions/api/web_request/web_request_permissions_unittest.cc',
        'browser/extensions/api/web_request/web_request_time_tracker_unittest.cc',
        'browser/extensions/app_notification_manager_sync_unittest.cc',
        'browser/extensions/app_notification_manager_unittest.cc',
        'browser/extensions/app_notification_storage_unittest.cc',
        'browser/extensions/app_notification_test_util.cc',
        'browser/extensions/app_notify_channel_setup_unittest.cc',
        'browser/extensions/app_sync_data_unittest.cc',
        'browser/extensions/blacklist_unittest.cc',
        'browser/extensions/component_loader_unittest.cc',
        'browser/extensions/convert_user_script_unittest.cc',
        'browser/extensions/convert_web_app_unittest.cc',
        'browser/extensions/default_apps_unittest.cc',
        'browser/extensions/event_listener_map_unittest.cc',
        'browser/extensions/event_router_forwarder_unittest.cc',
        'browser/extensions/extension_action_icon_factory_unittest.cc',
        'browser/extensions/extension_action_unittest.cc',
        'browser/extensions/extension_context_menu_model_unittest.cc',
        'browser/extensions/extension_creator_filter_unittest.cc',
        'browser/extensions/extension_function_test_utils.cc',
        'browser/extensions/extension_function_test_utils.h',
        'browser/extensions/extension_icon_image_unittest.cc',
        'browser/extensions/extension_icon_manager_unittest.cc',
        'browser/extensions/extension_info_map_unittest.cc',
        'browser/extensions/extension_pref_value_map_unittest.cc',
        'browser/extensions/extension_prefs_unittest.cc',
        'browser/extensions/extension_prefs_unittest.h',
        'browser/extensions/extension_process_manager_unittest.cc',
        'browser/extensions/extension_protocols_unittest.cc',
        'browser/extensions/extension_service_unittest.cc',
        'browser/extensions/extension_service_unittest.h',
        'browser/extensions/extension_sorting_unittest.cc',
        'browser/extensions/extension_special_storage_policy_unittest.cc',
        'browser/extensions/extension_sync_data_unittest.cc',
        'browser/extensions/extension_ui_unittest.cc',
        'browser/extensions/extension_warning_badge_service_unittest.cc',
        'browser/extensions/extension_warning_service_unittest.cc',
        'browser/extensions/extensions_quota_service_unittest.cc',
        'browser/extensions/external_policy_loader_unittest.cc',
        'browser/extensions/menu_manager_unittest.cc',
        'browser/extensions/page_action_controller_unittest.cc',
        'browser/extensions/permissions_updater_unittest.cc',
        'browser/extensions/file_reader_unittest.cc',
        'browser/extensions/image_loader_unittest.cc',
        'browser/extensions/image_loading_tracker_unittest.cc',
        'browser/extensions/key_identifier_conversion_views_unittest.cc',
        'browser/extensions/management_policy_unittest.cc',
        'browser/extensions/process_map_unittest.cc',
        'browser/extensions/sandboxed_unpacker_unittest.cc',
        'browser/extensions/script_badge_controller_unittest.cc',
        'browser/extensions/script_bubble_controller_unittest.cc',
        'browser/extensions/settings/policy_value_store_unittest.cc',
        'browser/extensions/settings/settings_frontend_unittest.cc',
        'browser/extensions/settings/settings_quota_unittest.cc',
        'browser/extensions/settings/settings_sync_unittest.cc',
        'browser/extensions/settings/settings_test_util.cc',
        'browser/extensions/settings/settings_test_util.h',
        'browser/extensions/shell_window_geometry_cache_unittest.cc',
        'browser/extensions/standard_management_policy_provider_unittest.cc',
        'browser/extensions/updater/extension_updater_unittest.cc',
        'browser/extensions/user_script_listener_unittest.cc',
        'browser/extensions/user_script_master_unittest.cc',
        'browser/extensions/webstore_standalone_installer_unittest.cc',
        'browser/external_protocol/external_protocol_handler_unittest.cc',
        'browser/favicon/favicon_handler_unittest.cc',
        'browser/file_select_helper_unittest.cc',
        'browser/first_run/first_run_unittest.cc',
        'browser/geolocation/chrome_geolocation_permission_context_unittest.cc',
        'browser/geolocation/geolocation_infobar_queue_controller_unittest.cc',
        'browser/geolocation/geolocation_settings_state_unittest.cc',
        'browser/geolocation/wifi_data_provider_unittest_chromeos.cc',
        'browser/global_keyboard_shortcuts_mac_unittest.mm',
        'browser/google/google_search_counter_unittest.cc',
        'browser/google/google_update_settings_unittest.cc',
        'browser/google/google_url_tracker_unittest.cc',
        'browser/google/google_util_unittest.cc',
        'browser/google_apis/base_operations_unittest.cc',
        'browser/google_apis/drive_api_parser_unittest.cc',
        'browser/google_apis/drive_uploader_unittest.cc',
        'browser/google_apis/dummy_drive_service.cc',
        'browser/google_apis/dummy_drive_service.h',
        'browser/google_apis/gdata_wapi_parser_unittest.cc',
        'browser/google_apis/gdata_wapi_operations_unittest.cc',
        'browser/google_apis/gdata_wapi_url_generator_unittest.cc',
        'browser/google_apis/fake_drive_service.cc',
        'browser/google_apis/fake_drive_service.h',
        'browser/google_apis/mock_drive_service.cc',
        'browser/google_apis/mock_drive_service.h',
        'browser/google_apis/operation_registry_unittest.cc',
        'browser/google_apis/test_server/http_request_unittest.cc',
        'browser/google_apis/test_server/http_response_unittest.cc',
        'browser/google_apis/test_server/http_server_unittest.cc',
        'browser/google_apis/time_util_unittest.cc',
        'browser/history/android/android_cache_database_unittest.cc',
        'browser/history/android/android_history_provider_service_unittest.cc',
        'browser/history/android/android_history_types_unittest.cc',
        'browser/history/android/android_provider_backend_unittest.cc',
        'browser/history/android/android_urls_database_unittest.cc',
        'browser/history/android/bookmark_model_sql_handler_unittest.cc',
        'browser/history/android/sqlite_cursor_unittest.cc',
        'browser/history/android/urls_sql_handler_unittest.cc',
        'browser/history/android/visit_sql_handler_unittest.cc',
        'browser/history/expire_history_backend_unittest.cc',
        'browser/history/history_backend_unittest.cc',
        'browser/history/history_database_unittest.cc',
        'browser/history/history_querying_unittest.cc',
        'browser/history/history_types_unittest.cc',
        'browser/history/history_unittest.cc',
        'browser/history/history_unittest_base.cc',
        'browser/history/history_unittest_base.h',
        'browser/history/in_memory_url_index_types_unittest.cc',
        'browser/history/in_memory_url_index_unittest.cc',
        'browser/history/query_parser_unittest.cc',
        'browser/history/scored_history_match_unittest.cc',
        'browser/history/select_favicon_frames_unittest.cc',
        'browser/history/shortcuts_backend_unittest.cc',
        'browser/history/shortcuts_database_unittest.cc',
        'browser/history/snippet_unittest.cc',
        'browser/history/text_database_manager_unittest.cc',
        'browser/history/text_database_unittest.cc',
        'browser/history/thumbnail_database_unittest.cc',
        'browser/history/top_sites_database_unittest.cc',
        'browser/history/top_sites_unittest.cc',
        'browser/history/url_database_unittest.cc',
        'browser/history/visit_database_unittest.cc',
        'browser/history/visit_filter_unittest.cc',
        'browser/history/visit_tracker_unittest.cc',
        'browser/importer/firefox_importer_unittest.cc',
        'browser/importer/firefox_importer_unittest_messages_internal.h',
        'browser/importer/firefox_importer_unittest_utils.h',
        'browser/importer/firefox_importer_unittest_utils_mac.cc',
        'browser/importer/firefox_importer_utils_unittest.cc',
        'browser/importer/firefox_profile_lock_unittest.cc',
        'browser/importer/firefox_proxy_settings_unittest.cc',
        'browser/importer/ie_importer_unittest_win.cc',
        'browser/importer/importer_unittest_utils.cc',
        'browser/importer/importer_unittest_utils.h',
        'browser/importer/safari_importer_unittest.mm',
        'browser/importer/toolbar_importer_unittest.cc',
        'browser/intents/cws_intents_registry_unittest.cc',
        'browser/intents/default_web_intent_service_unittest.cc',
        'browser/intents/native_services_unittest.cc',
        'browser/intents/register_intent_handler_infobar_delegate_unittest.cc',
        'browser/intents/web_intents_registry_unittest.cc',
        'browser/intents/web_intents_reporting_unittest.cc',
        'browser/intents/web_intents_util_unittest.cc',
        'browser/internal_auth_unittest.cc',
        'browser/language_usage_metrics_unittest.cc',
        'browser/mac/keystone_glue_unittest.mm',
        'browser/managed_mode/managed_mode_unittest.cc',
        'browser/managed_mode/managed_mode_url_filter_unittest.cc',
        'browser/media/media_internals_unittest.cc',
        'browser/media_gallery/media_file_system_registry_unittest.cc',
        'browser/media_gallery/media_galleries_dialog_controller_mock.cc',
        'browser/media_gallery/media_galleries_dialog_controller_mock.h',
        'browser/media_gallery/media_galleries_preferences_unittest.cc',
        'browser/media_gallery/media_gallery_database_unittest.cc',
        'browser/metrics/metrics_log_unittest.cc',
        'browser/metrics/metrics_log_serializer_unittest.cc',
        'browser/metrics/metrics_service_unittest.cc',
        'browser/metrics/thread_watcher_unittest.cc',
        'browser/metrics/variations/variations_service_unittest.cc',
        'browser/metrics/variations/resource_request_allowed_notifier_test_util.cc',
        'browser/metrics/variations/resource_request_allowed_notifier_test_util.h',
        'browser/metrics/variations/resource_request_allowed_notifier_unittest.cc',
        'browser/nacl_host/nacl_validation_cache_unittest.cc',
        'browser/nacl_host/pnacl_file_host_unittest.cc',
        'browser/net/chrome_fraudulent_certificate_reporter_unittest.cc',
        'browser/net/chrome_net_log_unittest.cc',
        'browser/net/chrome_network_delegate_unittest.cc',
        'browser/net/clear_on_exit_policy_unittest.cc',
        'browser/net/connection_tester_unittest.cc',
        'browser/net/dns_probe_job_unittest.cc',
        'browser/net/dns_probe_service_unittest.cc',
        'browser/net/gaia/gaia_oauth_fetcher_unittest.cc',
        'browser/net/http_pipelining_compatibility_client_unittest.cc',
        'browser/net/http_server_properties_manager_unittest.cc',
        'browser/net/load_timing_observer_unittest.cc',
        'browser/net/net_error_tab_helper_unittest.cc',
        'browser/net/network_stats_unittest.cc',
        'browser/net/predictor_unittest.cc',
        'browser/net/pref_proxy_config_tracker_impl_unittest.cc',
        'browser/net/quoted_printable_unittest.cc',
        'browser/net/spdyproxy/http_auth_handler_spdyproxy_unittest.cc',
        'browser/net/sqlite_persistent_cookie_store_unittest.cc',
        'browser/net/sqlite_server_bound_cert_store_unittest.cc',
        'browser/net/ssl_config_service_manager_pref_unittest.cc',
        'browser/net/transport_security_persister_unittest.cc',
        'browser/net/url_fixer_upper_unittest.cc',
        'browser/net/url_info_unittest.cc',
        'browser/notifications/desktop_notification_service_unittest.cc',
        'browser/page_cycler/page_cycler_unittest.cc',
        'browser/parsers/metadata_parser_filebase_unittest.cc',
        'browser/password_manager/encryptor_password_mac_unittest.cc',
        'browser/password_manager/encryptor_unittest.cc',
        'browser/password_manager/login_database_unittest.cc',
        'browser/password_manager/native_backend_gnome_x_unittest.cc',
        'browser/password_manager/native_backend_kwallet_x_unittest.cc',
        'browser/password_manager/password_form_manager_unittest.cc',
        'browser/password_manager/password_manager_unittest.cc',
        'browser/password_manager/password_store_unittest.cc',
        'browser/password_manager/password_store_default_unittest.cc',
        'browser/password_manager/password_store_mac_unittest.cc',
        'browser/password_manager/password_store_win_unittest.cc',
        'browser/password_manager/password_store_x_unittest.cc',
        'browser/performance_monitor/database_unittest.cc',
        'browser/plugins/plugin_finder_unittest.cc',
        'browser/plugins/plugin_metadata_unittest.cc',
        'browser/plugins/plugin_prefs_unittest.cc',
        'browser/policy/async_policy_provider_unittest.cc',
        'browser/policy/auto_enrollment_client_unittest.cc',
        'browser/policy/browser_policy_connector_unittest.cc',
        'browser/policy/cloud_policy_client_unittest.cc',
        'browser/policy/cloud_policy_controller_unittest.cc',
        'browser/policy/cloud_policy_core_unittest.cc',
        'browser/policy/cloud_policy_manager_unittest.cc',
        'browser/policy/cloud_policy_provider_unittest.cc',
        'browser/policy/cloud_policy_refresh_scheduler_unittest.cc',
        'browser/policy/cloud_policy_service_unittest.cc',
        'browser/policy/cloud_policy_subsystem_unittest.cc',
        'browser/policy/cloud_policy_validator_unittest.cc',
        'browser/policy/config_dir_policy_loader_unittest.cc',
        'browser/policy/configuration_policy_handler_chromeos_unittest.cc',
        'browser/policy/configuration_policy_handler_unittest.cc',
        'browser/policy/configuration_policy_pref_store_unittest.cc',
        'browser/policy/configuration_policy_provider_test.cc',
        'browser/policy/configuration_policy_provider_test.h',
        'browser/policy/cros_user_policy_cache_unittest.cc',
        'browser/policy/device_cloud_policy_manager_chromeos_unittest.cc',
        'browser/policy/device_cloud_policy_store_chromeos_unittest.cc',
        'browser/policy/device_management_service_unittest.cc',
        'browser/policy/device_policy_cache_unittest.cc',
        'browser/policy/device_token_fetcher_unittest.cc',
        'browser/policy/device_local_account_policy_service_unittest.cc',
        'browser/policy/enterprise_install_attributes_unittest.cc',
        'browser/policy/logging_work_scheduler.cc',
        'browser/policy/logging_work_scheduler.h',
        'browser/policy/logging_work_scheduler_unittest.cc',
        'browser/policy/managed_mode_policy_provider_unittest.cc',
        'browser/policy/mock_cloud_policy_client.cc',
        'browser/policy/mock_cloud_policy_client.h',
        'browser/policy/mock_cloud_policy_store.cc',
        'browser/policy/mock_cloud_policy_store.h',
        'browser/policy/mock_device_management_service.cc',
        'browser/policy/mock_device_management_service.h',
        'browser/policy/mock_policy_service.cc',
        'browser/policy/mock_policy_service.h',
        'browser/policy/mock_user_cloud_policy_store.cc',
        'browser/policy/mock_user_cloud_policy_store.h',
        'browser/policy/network_configuration_updater_unittest.cc',
        'browser/policy/policy_bundle_unittest.cc',
        'browser/policy/policy_loader_mac_unittest.cc',
        'browser/policy/policy_loader_win_unittest.cc',
        'browser/policy/policy_map_unittest.cc',
        'browser/policy/policy_path_parser_unittest.cc',
        'browser/policy/policy_service_impl_unittest.cc',
        'browser/policy/policy_statistics_collector_unittest.cc',
        'browser/policy/proxy_policy_provider_unittest.cc',
        'browser/policy/test_task_runner.cc',
        'browser/policy/test_task_runner.h',
        'browser/policy/testing_cloud_policy_subsystem.cc',
        'browser/policy/testing_cloud_policy_subsystem.h',
        'browser/policy/testing_policy_url_fetcher_factory.cc',
        'browser/policy/testing_policy_url_fetcher_factory.h',
        'browser/policy/url_blacklist_manager_unittest.cc',
        'browser/policy/user_cloud_policy_manager_chromeos_unittest.cc',
        'browser/policy/user_cloud_policy_manager_unittest.cc',
        'browser/policy/user_cloud_policy_store_chromeos_unittest.cc',
        'browser/policy/user_cloud_policy_store_unittest.cc',
        'browser/policy/user_info_fetcher_unittest.cc',
        'browser/policy/user_policy_cache_unittest.cc',
        'browser/policy/user_policy_signin_service_unittest.cc',
        'browser/predictors/autocomplete_action_predictor_table_unittest.cc',
        'browser/predictors/autocomplete_action_predictor_unittest.cc',
        'browser/predictors/resource_prefetch_predictor_unittest.cc',
        'browser/predictors/resource_prefetch_predictor_tables_unittest.cc',
        'browser/predictors/resource_prefetcher_unittest.cc',
        'browser/preferences_mock_mac.cc',
        'browser/preferences_mock_mac.h',
        'browser/prefs/command_line_pref_store_unittest.cc',
        'browser/prefs/incognito_mode_prefs_unittest.cc',
        'browser/prefs/pref_model_associator_unittest.cc',
        'browser/prefs/pref_notifier_impl_unittest.cc',
        'browser/prefs/pref_service_unittest.cc',
        'browser/prefs/pref_value_store_unittest.cc',
        'browser/prefs/proxy_config_dictionary_unittest.cc',
        'browser/prefs/proxy_policy_unittest.cc',
        'browser/prefs/proxy_prefs_unittest.cc',
        'browser/prefs/scoped_user_pref_update_unittest.cc',
        'browser/prefs/session_startup_pref_unittest.cc',
        'browser/prerender/prerender_history_unittest.cc',
        'browser/prerender/prerender_manager_unittest.cc',
        'browser/prerender/prerender_tracker_unittest.cc',
        'browser/prerender/prerender_unittest.cc',
        'browser/prerender/prerender_util_unittest.cc',
        'browser/printing/cloud_print/cloud_print_proxy_service_unittest.cc',
        'browser/printing/cloud_print/cloud_print_setup_source_unittest.cc',
        'browser/printing/print_dialog_cloud_unittest.cc',
        'browser/printing/print_job_unittest.cc',
        'browser/printing/print_preview_tab_controller_unittest.cc',
        'browser/printing/print_preview_test.cc',
        'browser/printing/print_preview_test.h',
        'browser/process_info_snapshot_mac_unittest.cc',
        'browser/process_singleton_linux_unittest.cc',
        'browser/process_singleton_mac_unittest.cc',
        'browser/profiles/avatar_menu_model_unittest.cc',
        'browser/profiles/gaia_info_update_service_unittest.cc',
        'browser/profiles/off_the_record_profile_impl_unittest.cc',
        'browser/profiles/profile_dependency_manager_unittest.cc',
        'browser/profiles/profile_downloader_unittest.cc',
        'browser/profiles/profile_info_cache_unittest.cc',
        'browser/profiles/profile_info_cache_unittest.h',
        'browser/profiles/profile_info_util_unittest.cc',
        'browser/profiles/profile_manager_unittest.cc',
        'browser/profiles/profile_shortcut_manager_unittest_win.cc',
        'browser/renderer_host/plugin_info_message_filter_unittest.cc',
        'browser/renderer_host/web_cache_manager_unittest.cc',
        'browser/resources/print_preview/data/measurement_system.js',
        'browser/resources/print_preview/data/measurement_system_unittest.gtestjs',
        'browser/resources/print_preview/print_preview_utils.js',
        'browser/resources/print_preview/print_preview_utils_unittest.gtestjs',
        'browser/resources/shared/js/cr.js',
        'browser/resources_util_unittest.cc',
        'browser/rlz/rlz_unittest.cc',
        'browser/safe_browsing/browser_feature_extractor_unittest.cc',
        'browser/safe_browsing/chunk_range_unittest.cc',
        'browser/safe_browsing/client_side_detection_host_unittest.cc',
        'browser/safe_browsing/client_side_detection_service_unittest.cc',
        'browser/safe_browsing/download_protection_service_unittest.cc',
        'browser/safe_browsing/malware_details_unittest.cc',
        'browser/safe_browsing/ping_manager_unittest.cc',
        'browser/safe_browsing/prefix_set_unittest.cc',
        'browser/safe_browsing/protocol_manager_unittest.cc',
        'browser/safe_browsing/protocol_parser_unittest.cc',
        'browser/safe_browsing/safe_browsing_blocking_page_unittest.cc',
        'browser/safe_browsing/safe_browsing_database_unittest.cc',
        'browser/safe_browsing/safe_browsing_store_file_unittest.cc',
        'browser/safe_browsing/safe_browsing_store_unittest.cc',
        'browser/safe_browsing/safe_browsing_store_unittest_helper.cc',
        'browser/safe_browsing/safe_browsing_util_unittest.cc',
        'browser/safe_browsing/signature_util_win_unittest.cc',
        'browser/search_engines/search_host_to_urls_map_unittest.cc',
        'browser/search_engines/search_provider_install_data_unittest.cc',
        'browser/search_engines/template_url_fetcher_unittest.cc',
        'browser/search_engines/template_url_service_util_unittest.cc',
        'browser/search_engines/template_url_service_sync_unittest.cc',
        'browser/search_engines/template_url_service_unittest.cc',
        'browser/search_engines/template_url_parser_unittest.cc',
        'browser/search_engines/template_url_prepopulate_data_unittest.cc',
        'browser/search_engines/template_url_scraper_unittest.cc',
        'browser/search_engines/template_url_unittest.cc',
        'browser/sessions/session_backend_unittest.cc',
        'browser/sessions/session_service_unittest.cc',
        'browser/sessions/session_types_unittest.cc',
        'browser/shell_integration_unittest.cc',
        'browser/signin/oauth2_token_service_request_unittest.cc',
        'browser/signin/oauth2_token_service_unittest.cc',
        'browser/signin/signin_manager_fake.cc',
        'browser/signin/signin_manager_fake.h',
        'browser/signin/signin_manager_unittest.cc',
        'browser/signin/signin_names_io_thread_unittest.cc',
        'browser/signin/signin_tracker_unittest.cc',
        'browser/signin/token_service_unittest.cc',
        'browser/signin/token_service_unittest.h',
        'browser/signin/ubertoken_fetcher_unittest.cc',
        'browser/speech/extension_api/tts_extension_api_controller_unittest.cc',
        'browser/speech/speech_recognition_bubble_controller_unittest.cc',
        'browser/spellchecker/spellcheck_custom_dictionary_unittest.cc',
        'browser/spellchecker/spellcheck_host_metrics_unittest.cc',
        'browser/spellchecker/spellcheck_platform_mac_unittest.cc',
        'browser/spellchecker/spellcheck_service_unittest.cc',
        'browser/spellchecker/spelling_service_client_unittest.cc',
        'browser/status_icons/status_icon_unittest.cc',
        'browser/status_icons/status_tray_unittest.cc',
        'browser/sync/about_sync_util_unittest.cc',
        'browser/sync/abstract_profile_sync_service_test.cc',
        'browser/sync/abstract_profile_sync_service_test.h',
        'browser/sync/backend_migrator_unittest.cc',
        'browser/sync/glue/app_notification_data_type_controller_unittest.cc',
        'browser/sync/glue/autofill_data_type_controller_unittest.cc',
        'browser/sync/glue/bookmark_data_type_controller_unittest.cc',
        'browser/sync/glue/bridged_invalidator_unittest.cc',
        'browser/sync/glue/browser_thread_model_worker_unittest.cc',
        'browser/sync/glue/change_processor_mock.cc',
        'browser/sync/glue/change_processor_mock.h',
        'browser/sync/glue/chrome_encryptor_unittest.cc',
        'browser/sync/glue/chrome_extensions_activity_monitor_unittest.cc',
        'browser/sync/glue/chrome_sync_notification_bridge_unittest.cc',
        'browser/sync/glue/data_type_controller_mock.cc',
        'browser/sync/glue/data_type_controller_mock.h',
        'browser/sync/glue/data_type_error_handler_mock.cc',
        'browser/sync/glue/data_type_error_handler_mock.h',
        'browser/sync/glue/data_type_manager_impl_unittest.cc',
        'browser/sync/glue/data_type_manager_mock.cc',
        'browser/sync/glue/data_type_manager_mock.h',
        'browser/sync/glue/fake_data_type_controller.cc',
        'browser/sync/glue/fake_data_type_controller.h',
        'browser/sync/glue/fake_generic_change_processor.cc',
        'browser/sync/glue/fake_generic_change_processor.h',
        'browser/sync/glue/frontend_data_type_controller_mock.cc',
        'browser/sync/glue/frontend_data_type_controller_mock.h',
        'browser/sync/glue/frontend_data_type_controller_unittest.cc',
        'browser/sync/glue/model_association_manager_unittest.cc',
        'browser/sync/glue/model_associator_mock.cc',
        'browser/sync/glue/model_associator_mock.h',
        'browser/sync/glue/non_frontend_data_type_controller_mock.cc',
        'browser/sync/glue/non_frontend_data_type_controller_mock.h',
        'browser/sync/glue/non_frontend_data_type_controller_unittest.cc',
        'browser/sync/glue/non_ui_data_type_controller_mock.cc',
        'browser/sync/glue/non_ui_data_type_controller_mock.h',
        'browser/sync/glue/non_ui_data_type_controller_unittest.cc',
        'browser/sync/glue/search_engine_data_type_controller_unittest.cc',
        'browser/sync/glue/session_model_associator_unittest.cc',
        'browser/sync/glue/shared_change_processor_mock.cc',
        'browser/sync/glue/shared_change_processor_mock.h',
        'browser/sync/glue/shared_change_processor_unittest.cc',
        'browser/sync/glue/sync_backend_host_unittest.cc',
        'browser/sync/glue/sync_backend_registrar_unittest.cc',
        'browser/sync/glue/synced_device_tracker_unittest.cc',
        'browser/sync/glue/synced_session_tracker_unittest.cc',
        'browser/sync/glue/typed_url_model_associator_unittest.cc',
        'browser/sync/glue/ui_data_type_controller_unittest.cc',
        'browser/sync/glue/ui_model_worker_unittest.cc',
        'browser/sync/invalidations/invalidator_storage_unittest.cc',
        'browser/sync/profile_sync_components_factory_impl_unittest.cc',
        'browser/sync/profile_sync_components_factory_mock.cc',
        'browser/sync/profile_sync_components_factory_mock.h',
        'browser/sync/profile_sync_service_autofill_unittest.cc',
        'browser/sync/profile_sync_service_bookmark_unittest.cc',
        'browser/sync/profile_sync_service_password_unittest.cc',
        'browser/sync/profile_sync_service_preference_unittest.cc',
        'browser/sync/profile_sync_service_session_unittest.cc',
        'browser/sync/profile_sync_service_startup_unittest.cc',
        'browser/sync/profile_sync_service_typed_url_unittest.cc',
        'browser/sync/profile_sync_service_unittest.cc',
        'browser/sync/profile_sync_test_util.cc',
        'browser/sync/profile_sync_test_util.h',
        'browser/sync/sync_global_error_unittest.cc',
        'browser/sync/sync_prefs_unittest.cc',
        'browser/sync/sync_ui_util_mac_unittest.mm',
        'browser/sync/sync_ui_util_unittest.cc',
        'browser/sync/test/test_http_bridge_factory.cc',
        'browser/sync/test/test_http_bridge_factory.h',
        'browser/sync/test_profile_sync_service.cc',
        'browser/sync/test_profile_sync_service.h',
        'browser/sync_file_system/drive_file_sync_client_unittest.cc',
        'browser/sync_file_system/drive_file_sync_service_unittest.cc',
        'browser/sync_file_system/drive_metadata_store_unittest.cc',
        'browser/sync_file_system/local_file_sync_service_unittest.cc',
        'browser/sync_file_system/mock_local_change_processor.cc',
        'browser/sync_file_system/mock_local_change_processor.h',
        'browser/sync_file_system/mock_remote_change_processor.cc',
        'browser/sync_file_system/mock_remote_change_processor.h',
        'browser/sync_file_system/mock_remote_file_sync_service.cc',
        'browser/sync_file_system/mock_remote_file_sync_service.h',
        'browser/sync_file_system/sync_file_system_service_unittest.cc',
        'browser/sync_file_system/sync_file_system_test_util.cc',
        'browser/sync_file_system/sync_file_system_test_util.h',
        'browser/system_monitor/media_device_notifications_utils_unittest.cc',
        'browser/system_monitor/media_storage_util_unittest.cc',
        'browser/system_monitor/media_transfer_protocol_device_observer_linux_unittest.cc',
        'browser/system_monitor/removable_device_notifications_chromeos_unittest.cc',
        'browser/system_monitor/removable_device_notifications_linux_unittest.cc',
        'browser/system_monitor/removable_device_notifications_mac_unittest.mm',
        'browser/system_monitor/removable_device_notifications_window_win_unittest.cc',
        'browser/tab_contents/render_view_context_menu_unittest.cc',
        'browser/task_manager/task_manager_unittest.cc',
        'browser/task_profiler/task_profiler_data_serializer_unittest.cc',
        'browser/themes/browser_theme_pack_unittest.cc',
        'browser/themes/theme_service_unittest.cc',
        'browser/themes/theme_syncable_service_unittest.cc',
        'browser/thumbnails/thumbnail_service_unittest.cc',
        'browser/thumbnails/thumbnail_tab_helper_unittest.cc',
        'browser/ui/android/tab_model/tab_model_unittest.cc',
        'browser/ui/ash/event_rewriter_unittest.cc',
        'browser/ui/ash/ime_controller_chromeos_unittest.cc',
        'browser/ui/ash/launcher/browser_launcher_item_controller_unittest.cc',
        'browser/ui/ash/launcher/chrome_launcher_controller_per_app_unittest.cc',
        'browser/ui/ash/launcher/chrome_launcher_controller_per_browser_unittest.cc',
        'browser/ui/ash/window_positioner_unittest.cc',
        'browser/ui/auto_login_prompter_unittest.cc',
        'browser/ui/autofill/autofill_popup_controller_unittest.cc',
        'browser/ui/bookmarks/bookmark_context_menu_controller_unittest.cc',
        'browser/ui/bookmarks/bookmark_prompt_controller_unittest.cc',
        'browser/ui/bookmarks/bookmark_ui_utils_unittest.cc',
        'browser/ui/browser_command_controller_unittest.cc',
        'browser/ui/chrome_select_file_policy_unittest.cc',
        # It is safe to list */cocoa/* files in the "common" file list
        # without an explicit exclusion since gyp is smart enough to
        # exclude them from non-Mac builds.
        'browser/ui/cocoa/about_ipc_controller_unittest.mm',
        'browser/ui/cocoa/accelerators_cocoa_unittest.mm',
        'browser/ui/cocoa/animatable_image_unittest.mm',
        'browser/ui/cocoa/animatable_view_unittest.mm',
        'browser/ui/cocoa/applescript/bookmark_applescript_utils_unittest.h',
        'browser/ui/cocoa/applescript/bookmark_applescript_utils_unittest.mm',
        'browser/ui/cocoa/applescript/bookmark_folder_applescript_unittest.mm',
        'browser/ui/cocoa/applescript/bookmark_item_applescript_unittest.mm',
        'browser/ui/cocoa/background_gradient_view_unittest.mm',
        'browser/ui/cocoa/background_tile_view_unittest.mm',
        'browser/ui/cocoa/base_bubble_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_all_tabs_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_bridge_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_button_cell_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_hover_state_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_view_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_folder_window_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_toolbar_view_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_unittest_helper.h',
        'browser/ui/cocoa/bookmarks/bookmark_bar_unittest_helper.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bar_view_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_bubble_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_button_cell_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_button_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_editor_base_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_editor_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_folder_target_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_menu_bridge_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_menu_cocoa_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_menu_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_model_observer_for_cocoa_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_name_folder_controller_unittest.mm',
        'browser/ui/cocoa/bookmarks/bookmark_tree_browser_cell_unittest.mm',
        'browser/ui/cocoa/browser/avatar_button_controller_unittest.mm',
        'browser/ui/cocoa/browser/avatar_menu_bubble_controller_unittest.mm',
        'browser/ui/cocoa/browser/edit_search_engine_cocoa_controller_unittest.mm',
	'browser/ui/cocoa/browser/password_generation_bubble_controller_unittest.mm',
        'browser/ui/cocoa/browser_window_cocoa_unittest.mm',
        'browser/ui/cocoa/browser_window_controller_unittest.mm',
        'browser/ui/cocoa/bubble_view_unittest.mm',
        'browser/ui/cocoa/chrome_browser_window_unittest.mm',
        'browser/ui/cocoa/chrome_event_processing_window_unittest.mm',
        'browser/ui/cocoa/chrome_to_mobile_bubble_controller_unittest.mm',
        'browser/ui/cocoa/clickhold_button_cell_unittest.mm',
        'browser/ui/cocoa/cocoa_profile_test.h',
        'browser/ui/cocoa/cocoa_profile_test.mm',
        'browser/ui/cocoa/cocoa_test_helper.h',
        'browser/ui/cocoa/cocoa_test_helper.mm',
        'browser/ui/cocoa/command_observer_bridge_unittest.mm',
        'browser/ui/cocoa/confirm_bubble_controller_unittest.mm',
        'browser/ui/cocoa/confirm_quit_panel_controller_unittest.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_alert_unittest.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_animation_unittest.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_button_unittest.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_custom_window_unittest.mm',
        'browser/ui/cocoa/constrained_window/constrained_window_sheet_controller_unittest.mm',
        'browser/ui/cocoa/content_settings/cookie_details_unittest.mm',
        'browser/ui/cocoa/content_settings/cookie_details_view_controller_unittest.mm',
        'browser/ui/cocoa/custom_frame_view_unittest.mm',
        'browser/ui/cocoa/download/download_item_button_unittest.mm',
        'browser/ui/cocoa/download/download_shelf_mac_unittest.mm',
        'browser/ui/cocoa/download/download_shelf_view_unittest.mm',
        'browser/ui/cocoa/download/download_util_mac_unittest.mm',
        'browser/ui/cocoa/draggable_button_unittest.mm',
        'browser/ui/cocoa/event_utils_unittest.mm',
        'browser/ui/cocoa/extensions/browser_actions_container_view_unittest.mm',
        'browser/ui/cocoa/extensions/extension_install_prompt_test_utils.h',
        'browser/ui/cocoa/extensions/extension_install_prompt_test_utils.mm',
        'browser/ui/cocoa/extensions/extension_install_view_controller_unittest.mm',
        'browser/ui/cocoa/extensions/extension_installed_bubble_controller_unittest.mm',
        'browser/ui/cocoa/extensions/media_galleries_dialog_cocoa_unittest.mm',
        'browser/ui/cocoa/fast_resize_view_unittest.mm',
        'browser/ui/cocoa/find_bar/find_bar_bridge_unittest.mm',
        'browser/ui/cocoa/find_bar/find_bar_cocoa_controller_unittest.mm',
        'browser/ui/cocoa/find_bar/find_bar_text_field_cell_unittest.mm',
        'browser/ui/cocoa/find_bar/find_bar_text_field_unittest.mm',
        'browser/ui/cocoa/find_bar/find_bar_view_unittest.mm',
        'browser/ui/cocoa/find_pasteboard_unittest.mm',
        'browser/ui/cocoa/first_run_bubble_controller_unittest.mm',
        'browser/ui/cocoa/floating_bar_backing_view_unittest.mm',
        'browser/ui/cocoa/framed_browser_window_unittest.mm',
        'browser/ui/cocoa/fullscreen_window_unittest.mm',
        'browser/ui/cocoa/fullscreen_exit_bubble_controller_unittest.mm',
        'browser/ui/cocoa/gradient_button_cell_unittest.mm',
        'browser/ui/cocoa/history_menu_bridge_unittest.mm',
        'browser/ui/cocoa/history_menu_cocoa_controller_unittest.mm',
        'browser/ui/cocoa/history_overlay_controller_unittest.mm',
        'browser/ui/cocoa/hover_close_button_unittest.mm',
        'browser/ui/cocoa/hover_image_button_unittest.mm',
        'browser/ui/cocoa/hung_renderer_controller_unittest.mm',
        'browser/ui/cocoa/hyperlink_button_cell_unittest.mm',
        'browser/ui/cocoa/hyperlink_text_view_unittest.mm',
        'browser/ui/cocoa/image_button_cell_unittest.mm',
        'browser/ui/cocoa/info_bubble_view_unittest.mm',
        'browser/ui/cocoa/info_bubble_window_unittest.mm',
        'browser/ui/cocoa/infobars/infobar_container_controller_unittest.mm',
        'browser/ui/cocoa/infobars/infobar_controller_unittest.mm',
        'browser/ui/cocoa/infobars/infobar_gradient_view_unittest.mm',
        'browser/ui/cocoa/infobars/translate_infobar_unittest.mm',
        'browser/ui/cocoa/location_bar/autocomplete_text_field_cell_unittest.mm',
        'browser/ui/cocoa/location_bar/autocomplete_text_field_editor_unittest.mm',
        'browser/ui/cocoa/location_bar/autocomplete_text_field_unittest.mm',
        'browser/ui/cocoa/location_bar/autocomplete_text_field_unittest_helper.mm',
        'browser/ui/cocoa/location_bar/ev_bubble_decoration_unittest.mm',
        'browser/ui/cocoa/location_bar/image_decoration_unittest.mm',
        'browser/ui/cocoa/location_bar/keyword_hint_decoration_unittest.mm',
        'browser/ui/cocoa/location_bar/selected_keyword_decoration_unittest.mm',
        'browser/ui/cocoa/location_bar/web_intents_button_decoration_unittest.mm',
        'browser/ui/cocoa/menu_button_unittest.mm',
        'browser/ui/cocoa/menu_controller_unittest.mm',
        'browser/ui/cocoa/notifications/balloon_controller_unittest.mm',
        'browser/ui/cocoa/nsimage_cache_unittest.mm',
        'browser/ui/cocoa/nsmenuitem_additions_unittest.mm',
        'browser/ui/cocoa/omnibox/omnibox_popup_view_mac_unittest.mm',
        'browser/ui/cocoa/omnibox/omnibox_view_mac_unittest.mm',
        'browser/ui/cocoa/one_click_signin_bubble_controller_unittest.mm',
        'browser/ui/cocoa/page_info_bubble_controller_unittest.mm',
        'browser/ui/cocoa/panels/panel_cocoa_unittest.mm',
        'browser/ui/cocoa/profile_menu_controller_unittest.mm',
        'browser/ui/cocoa/ratings_view_unittest.mm',
        'browser/ui/cocoa/run_loop_testing_unittest.mm',
        'browser/ui/cocoa/status_bubble_mac_unittest.mm',
        'browser/ui/cocoa/status_icons/status_icon_mac_unittest.mm',
        'browser/ui/cocoa/styled_text_field_cell_unittest.mm',
        'browser/ui/cocoa/styled_text_field_test_helper.h',
        'browser/ui/cocoa/styled_text_field_test_helper.mm',
        'browser/ui/cocoa/styled_text_field_unittest.mm',
        'browser/ui/cocoa/tab_contents/sad_tab_controller_unittest.mm',
        'browser/ui/cocoa/tab_contents/sad_tab_view_unittest.mm',
        'browser/ui/cocoa/tab_view_picker_table_unittest.mm',
        'browser/ui/cocoa/table_row_nsimage_cache_unittest.mm',
        'browser/ui/cocoa/tabpose_window_unittest.mm',
        'browser/ui/cocoa/tabs/tab_controller_unittest.mm',
        'browser/ui/cocoa/tabs/tab_projecting_image_view_unittest.mm',
        'browser/ui/cocoa/tabs/tab_strip_controller_unittest.mm',
        'browser/ui/cocoa/tabs/tab_strip_view_unittest.mm',
        'browser/ui/cocoa/tabs/tab_view_unittest.mm',
        'browser/ui/cocoa/tabs/throbber_view_unittest.mm',
        'browser/ui/cocoa/tabs/throbbing_image_view_unittest.mm',
        'browser/ui/cocoa/task_manager_mac_unittest.mm',
        'browser/ui/cocoa/toolbar/reload_button_unittest.mm',
        'browser/ui/cocoa/toolbar/toolbar_button_unittest.mm',
        'browser/ui/cocoa/toolbar/toolbar_controller_unittest.mm',
        'browser/ui/cocoa/toolbar/toolbar_view_unittest.mm',
        'browser/ui/cocoa/tracking_area_unittest.mm',
        'browser/ui/cocoa/vertical_gradient_view_unittest.mm',
        'browser/ui/cocoa/view_resizer_pong.h',
        'browser/ui/cocoa/view_resizer_pong.mm',
        'browser/ui/cocoa/website_settings_bubble_controller_unittest.mm',
        'browser/ui/cocoa/web_dialog_window_controller_unittest.mm',
        'browser/ui/cocoa/window_size_autosaver_unittest.mm',
        'browser/ui/cocoa/wrench_menu/menu_tracked_root_view_unittest.mm',
        'browser/ui/cocoa/wrench_menu/wrench_menu_button_cell_unittest.mm',
        'browser/ui/cocoa/wrench_menu/wrench_menu_controller_unittest.mm',
        'browser/ui/constrained_window_tab_helper_unittest.cc',
        'browser/ui/content_settings/content_setting_bubble_model_unittest.cc',
        'browser/ui/content_settings/content_setting_image_model_unittest.cc',
        'browser/ui/find_bar/find_backend_unittest.cc',
        'browser/ui/fullscreen/fullscreen_controller_state_unittest.cc',
        'browser/ui/global_error/global_error_service_unittest.cc',
        'browser/ui/gtk/accelerators_gtk_unittest.cc',
        'browser/ui/gtk/bookmarks/bookmark_bar_gtk_unittest.cc',
        'browser/ui/gtk/bookmarks/bookmark_editor_gtk_unittest.cc',
        'browser/ui/gtk/bookmarks/bookmark_utils_gtk_unittest.cc',
        'browser/ui/gtk/event_utils_unittest.cc',
        'browser/ui/gtk/extensions/media_galleries_dialog_gtk_unittest.cc',
        'browser/ui/gtk/gtk_chrome_shrinkable_hbox_unittest.cc',
        'browser/ui/gtk/gtk_theme_service_unittest.cc',
        'browser/ui/gtk/omnibox/omnibox_popup_view_gtk_unittest.cc',
        'browser/ui/gtk/reload_button_gtk_unittest.cc',
        'browser/ui/gtk/status_icons/status_tray_gtk_unittest.cc',
        'browser/ui/gtk/tabs/tab_renderer_gtk_unittest.cc',
        'browser/ui/intents/web_intent_inline_disposition_delegate_unittest.cc',
        'browser/ui/intents/web_intent_picker_model_unittest.cc',
        'browser/ui/intents/web_intent_picker_unittest.cc',
        'browser/ui/login/login_prompt_unittest.cc',
        'browser/ui/omnibox/omnibox_edit_unittest.cc',
        'browser/ui/omnibox/omnibox_view_unittest.cc',
        'browser/ui/panels/display_settings_provider_win_unittest.cc',
        'browser/ui/panels/panel_mouse_watcher_unittest.cc',
        'browser/ui/search_engines/keyword_editor_controller_unittest.cc',
        'browser/ui/search/search_delegate_unittest.cc',
        'browser/ui/search/search_unittest.cc',
        'browser/ui/sync/one_click_signin_helper_unittest.cc',
        'browser/ui/tab_contents/tab_contents_iterator_unittest.cc',
        'browser/ui/tabs/dock_info_unittest.cc',
        'browser/ui/tabs/pinned_tab_codec_unittest.cc',
        'browser/ui/tabs/pinned_tab_service_unittest.cc',
        'browser/ui/tabs/pinned_tab_test_utils.cc',
        'browser/ui/tabs/tab_menu_model_unittest.cc',
        'browser/ui/tabs/tab_strip_model_unittest.cc',
        'browser/ui/tabs/tab_strip_selection_model_unittest.cc',
        'browser/ui/tabs/test_tab_strip_model_delegate.cc',
        'browser/ui/tabs/test_tab_strip_model_delegate.h',
        'browser/ui/tests/ui_gfx_image_unittest.cc',
        'browser/ui/tests/ui_gfx_image_unittest.mm',
        'browser/ui/toolbar/action_box_menu_model_unittest.cc',
        'browser/ui/toolbar/back_forward_menu_model_unittest.cc',
        'browser/ui/toolbar/encoding_menu_controller_unittest.cc',
        'browser/ui/toolbar/recent_tabs_builder_test_helper.cc',
        'browser/ui/toolbar/recent_tabs_builder_test_helper.h',
        'browser/ui/toolbar/recent_tabs_sub_menu_model_unittest.cc',
        'browser/ui/toolbar/toolbar_model_unittest.cc',
        'browser/ui/toolbar/test_toolbar_model.cc',
        'browser/ui/toolbar/test_toolbar_model.h',
        'browser/ui/toolbar/wrench_menu_model_unittest.cc',
        'browser/ui/views/accelerator_table_unittest.cc',
        'browser/ui/views/accessibility/accessibility_event_router_views_unittest.cc',
        'browser/ui/views/bookmarks/bookmark_context_menu_test.cc',
        'browser/ui/views/bookmarks/bookmark_editor_view_unittest.cc',
        'browser/ui/views/crypto_module_password_dialog_view_unittest.cc',
        'browser/ui/views/extensions/browser_action_drag_data_unittest.cc',
        'browser/ui/views/first_run_bubble_unittest.cc',
        'browser/ui/views/reload_button_unittest.cc',
        'browser/ui/views/select_file_dialog_extension_unittest.cc',
        'browser/ui/views/status_icons/status_tray_win_unittest.cc',
        'browser/ui/views/tabs/fake_base_tab_strip_controller.cc',
        'browser/ui/views/tabs/fake_base_tab_strip_controller.h',
        'browser/ui/views/tabs/stacked_tab_strip_layout_unittest.cc',
        'browser/ui/views/tabs/tab_unittest.cc',
        'browser/ui/views/tabs/tab_strip_unittest.cc',
        'browser/ui/website_settings/website_settings_unittest.cc',
        'browser/ui/webui/chrome_web_ui_data_source_unittest.cc',
        'browser/ui/webui/fileicon_source_unittest.cc',
        'browser/ui/webui/ntp/android/partner_bookmarks_shim_unittest.cc',
        'browser/ui/webui/ntp/suggestions_combiner_unittest.cc',
        'browser/ui/webui/options/language_options_handler_unittest.cc',
        'browser/ui/webui/options/pepper_flash_content_settings_utils_unittest.cc',
        'browser/ui/webui/performance_monitor/performance_monitor_ui_util_unittest.cc',
        'browser/ui/webui/policy_ui_unittest.cc',
        'browser/ui/webui/print_preview/print_preview_handler_unittest.cc',
        'browser/ui/webui/print_preview/print_preview_ui_unittest.cc',
        'browser/ui/webui/signin/login_ui_service_unittest.cc',
        'browser/ui/webui/sync_internals_ui_unittest.cc',
        'browser/ui/webui/sync_setup_handler_unittest.cc',
        'browser/ui/webui/theme_source_unittest.cc',
        'browser/ui/webui/web_dialog_web_contents_delegate_unittest.cc',
        'browser/ui/webui/web_ui_unittest.cc',
        'browser/ui/webui/web_ui_util_unittest.cc',
        'browser/ui/window_sizer/window_sizer_ash_unittest.cc',
        'browser/ui/window_sizer/window_sizer_common_unittest.cc',
        'browser/ui/window_sizer/window_sizer_unittest.cc',
        'browser/ui/zoom/zoom_controller_unittest.cc',
        'browser/chrome_to_mobile_service_unittest.cc',
        'browser/user_style_sheet_watcher_unittest.cc',
        'browser/value_store/leveldb_value_store_unittest.cc',
        'browser/value_store/testing_value_store_unittest.cc',
        'browser/value_store/value_store_change_unittest.cc',
        'browser/value_store/value_store_frontend_unittest.cc',
        'browser/value_store/value_store_unittest.cc',
        'browser/value_store/value_store_unittest.h',
        'browser/visitedlink/visitedlink_unittest.cc',
        'browser/web_applications/web_app_mac_unittest.mm',
        'browser/web_applications/web_app_unittest.cc',
        'browser/web_resource/promo_resource_service_mobile_ntp_unittest.cc',
        'browser/web_resource/promo_resource_service_unittest.cc',
        'browser/webdata/autofill_entry_unittest.cc',
        'browser/webdata/autofill_profile_syncable_service_unittest.cc',
        'browser/webdata/autofill_table_unittest.cc',
        'browser/webdata/keyword_table_unittest.cc',
        'browser/webdata/token_service_table_unittest.cc',
        'browser/webdata/web_apps_table_unittest.cc',
        'browser/webdata/web_data_service_test_util.h',
        'browser/webdata/web_data_service_unittest.cc',
        'browser/webdata/web_database_migration_unittest.cc',
        'browser/webdata/web_intents_table_unittest.cc',
        'common/bzip2_unittest.cc',
        'common/cancelable_task_tracker_unittest.cc',
        'common/child_process_logging_mac_unittest.mm',
        'common/chrome_paths_unittest.cc',
        'common/cloud_print/cloud_print_helpers_unittest.cc',
        'common/chrome_content_client_unittest.cc',
        'common/content_settings_helper_unittest.cc',
        'common/content_settings_pattern_parser_unittest.cc',
        'common/content_settings_pattern_unittest.cc',
        'common/extensions/command_unittest.cc',
        'common/extensions/csp_validator_unittest.cc',
        'common/extensions/event_filter_unittest.cc',
        'common/extensions/extension_constants_unittest.cc',
        'common/extensions/extension_file_util_unittest.cc',
        'common/extensions/extension_icon_set_unittest.cc',
        'common/extensions/extension_l10n_util_unittest.cc',
        'common/extensions/extension_localization_peer_unittest.cc',
        'common/extensions/extension_resource_unittest.cc',
        'common/extensions/extension_set_unittest.cc',
        'common/extensions/extension_unittest.cc',
        'common/extensions/feature_switch_unittest.cc',
        'common/extensions/features/base_feature_provider_unittest.cc',
        'common/extensions/features/complex_feature_unittest.cc',
        'common/extensions/features/simple_feature_unittest.cc',
        'common/extensions/manifest_tests/extension_manifest_test.cc',
        'common/extensions/manifest_tests/extension_manifests_auth_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_background_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_browseraction_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_chromepermission_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_command_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_contentscript_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_contentsecuritypolicy_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_default_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_devtools_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_excludematches_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_experimental_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_filebrowser_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_homepage_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_icon_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_initvalue_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_isolatedapp_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_launch_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_manifest_version_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_offline_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_old_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_options_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_override_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_pageaction_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_platformapp_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_portsinpermissions_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_requirements_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_sandboxed_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_scriptbadge_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_storage_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_tts_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_ui_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_update_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_validapp_unittest.cc',
        'common/extensions/manifest_tests/extension_manifests_web_unittest.cc',
        'common/extensions/matcher/regex_set_matcher_unittest.cc',
        'common/extensions/matcher/string_pattern_unittest.cc',
        'common/extensions/matcher/substring_set_matcher_unittest.cc',
        'common/extensions/matcher/url_matcher_unittest.cc',
        'common/extensions/matcher/url_matcher_factory_unittest.cc',
        'common/extensions/manifest_unittest.cc',
        'common/extensions/message_bundle_unittest.cc',
        'common/extensions/permissions/api_permission_set_unittest.cc',
        'common/extensions/permissions/permission_set_unittest.cc',
        'common/extensions/permissions/socket_permission_unittest.cc',
        'common/extensions/unpacker_unittest.cc',
        'common/extensions/update_manifest_unittest.cc',
        'common/extensions/user_script_unittest.cc',
        'common/extensions/value_counter_unittest.cc',
        'common/extensions/api/extension_api_unittest.cc',
        'common/json_schema_validator_unittest.cc',
        'common/json_schema_validator_unittest_base.cc',
        'common/json_schema_validator_unittest_base.h',
        'common/json_value_serializer_unittest.cc',
        'common/mac/cfbundle_blocker_unittest.mm',
        'common/mac/mock_launchd.cc',
        'common/mac/mock_launchd.h',
        'common/mac/nscoder_util_unittest.mm',
        'common/mac/objc_method_swizzle_unittest.mm',
        'common/mac/objc_zombie_unittest.mm',
        'common/metrics/entropy_provider_unittest.cc',
        'common/metrics/metrics_log_base_unittest.cc',
        'common/metrics/metrics_log_manager_unittest.cc',
        'common/metrics/metrics_util_unittest.cc',
        'common/metrics/variations/variations_util_unittest.cc',
        'common/multi_process_lock_unittest.cc',
        'common/net/url_util_unittest.cc',
        'common/net/x509_certificate_model_unittest.cc',
        'common/pref_names_util_unittest.cc',
        'common/service_process_util_unittest.cc',
        'common/switch_utils_unittest.cc',
        'common/thumbnail_score_unittest.cc',
        'common/time_format_unittest.cc',
        'common/web_apps_unittest.cc',
        'common/worker_thread_ticker_unittest.cc',
        'common/zip_reader_unittest.cc',
        'common/zip_unittest.cc',
        'nacl/nacl_ipc_adapter_unittest.cc',
        'nacl/nacl_validation_query_unittest.cc',
        'renderer/chrome_content_renderer_client_unittest.cc',
        'renderer/content_settings_observer_unittest.cc',
        'renderer/extensions/chrome_v8_context_set_unittest.cc',
        'renderer/extensions/event_unittest.cc',
        'renderer/extensions/json_schema_unittest.cc',
        'renderer/extensions/module_system_unittest.cc',
        'renderer/net/predictor_queue_unittest.cc',
        'renderer/net/renderer_predictor_unittest.cc',
        'renderer/plugins/plugin_uma_unittest.cc',
        'renderer/prerender/prerender_dispatcher_unittest.cc',
        'renderer/safe_browsing/features_unittest.cc',
        'renderer/safe_browsing/murmurhash3_util_unittest.cc',
        'renderer/safe_browsing/phishing_term_feature_extractor_unittest.cc',
        'renderer/safe_browsing/phishing_url_feature_extractor_unittest.cc',
        'renderer/safe_browsing/scorer_unittest.cc',
        'renderer/spellchecker/spellcheck_provider_hunspell_unittest.cc',
        'renderer/spellchecker/spellcheck_provider_mac_unittest.cc',
        'renderer/spellchecker/spellcheck_provider_test.cc',
        'renderer/spellchecker/spellcheck_provider_test.h',
        'renderer/spellchecker/spellcheck_unittest.cc',
        'renderer/spellchecker/spellcheck_worditerator_unittest.cc',
        'service/cloud_print/cloud_print_helpers_unittest.cc',
        'service/cloud_print/cloud_print_token_store_unittest.cc',
        'service/cloud_print/cloud_print_url_fetcher_unittest.cc',
        'service/cloud_print/connector_settings_unittest.cc',
        'service/service_process_prefs_unittest.cc',
        'service/service_process_unittest.cc',
        'test/base/browser_with_test_window_test.cc',
        'test/base/browser_with_test_window_test.h',
        'test/base/chrome_render_view_test.cc',
        'test/base/chrome_render_view_test.h',
        'test/base/menu_model_test.cc',
        'test/base/menu_model_test.h',
        'test/base/v8_unit_test.cc',
        'test/base/v8_unit_test.h',
        'test/data/resource.rc',
        'test/data/unit/framework_unittest.gtestjs',
        'test/logging/win/mof_data_parser_unittest.cc',
        'tools/convert_dict/convert_dict_unittest.cc',

        # TODO(joi): Move to 'base_prefs' target in base/base.gyp once
        # Prefs move is complete and dependencies have been broken.
        '../base/prefs/public/pref_change_registrar_unittest.cc',
        '../base/prefs/public/pref_member_unittest.cc',
        '../base/prefs/overlay_user_pref_store_unittest.cc',
        '../base/prefs/pref_value_map_unittest.cc',
        '../base/prefs/json_pref_store_unittest.cc',

        # TODO(joi): Move the google_apis tests to a separate
        # google_apis_unittests executable.
        '../google_apis/google_api_keys_unittest.cc',
        '../google_apis/gaia/mock_url_fetcher_factory.h',
        '../google_apis/gaia/gaia_auth_fetcher_unittest.cc',
        '../google_apis/gaia/gaia_auth_util_unittest.cc',
        '../google_apis/gaia/gaia_authenticator_unittest.cc',
        '../google_apis/gaia/gaia_oauth_client_unittest.cc',
        '../google_apis/gaia/google_service_auth_error_unittest.cc',
        '../google_apis/gaia/oauth_request_signer_unittest.cc',
        '../google_apis/gaia/oauth2_access_token_fetcher_unittest.cc',
        '../google_apis/gaia/oauth2_api_call_flow_unittest.cc',
        '../google_apis/gaia/oauth2_mint_token_fetcher_unittest.cc',
        '../google_apis/gaia/oauth2_mint_token_flow_unittest.cc',
        '../google_apis/gaia/oauth2_revocation_fetcher_unittest.cc',
        '../skia/ext/bitmap_platform_device_mac_unittest.cc',
        '../skia/ext/convolver_unittest.cc',
        '../skia/ext/image_operations_unittest.cc',
        '../skia/ext/platform_canvas_unittest.cc',
        '../skia/ext/refptr_unittest.cc',
        '../skia/ext/skia_utils_ios_unittest.mm',
        '../skia/ext/skia_utils_mac_unittest.mm',
        '../skia/ext/vector_canvas_unittest.cc',
        '../testing/gtest_mac_unittest.mm',
        '../third_party/cld/encodings/compact_lang_det/compact_lang_det_unittest_small.cc',
        '../tools/json_schema_compiler/test/additional_properties_unittest.cc',
        '../tools/json_schema_compiler/test/any_unittest.cc',
        '../tools/json_schema_compiler/test/arrays_unittest.cc',
        '../tools/json_schema_compiler/test/callbacks_unittest.cc',
        '../tools/json_schema_compiler/test/choices_unittest.cc',
        '../tools/json_schema_compiler/test/crossref_unittest.cc',
        '../tools/json_schema_compiler/test/enums_unittest.cc',
        '../tools/json_schema_compiler/test/functions_as_parameters_unittest.cc',
        '../tools/json_schema_compiler/test/functions_on_types_unittest.cc',
        '../tools/json_schema_compiler/test/idl_schemas_unittest.cc',
        '../tools/json_schema_compiler/test/objects_unittest.cc',
        '../tools/json_schema_compiler/test/simple_api_unittest.cc',
        '../ui/views/test/desktop_test_views_delegate.cc',
        '../ui/views/test/desktop_test_views_delegate.h',
        '../ui/views/test/test_views_delegate.cc',
        '../ui/views/test/test_views_delegate.h',
        '../ui/views/test/views_test_base.cc',
        '../ui/views/test/views_test_base.h',
        '../webkit/blob/mock_blob_url_request_context.cc',
        '../webkit/blob/mock_blob_url_request_context.h',
        '../webkit/fileapi/syncable/canned_syncable_file_system.cc',
        '../webkit/fileapi/syncable/canned_syncable_file_system.cc',
        '../webkit/fileapi/syncable/mock_sync_status_observer.cc',
        '../webkit/fileapi/syncable/mock_sync_status_observer.h',
        '../webkit/glue/web_intent_reply_data_unittest.cc',
        '../webkit/glue/web_intent_service_data_unittest.cc',
        '../webkit/quota/mock_storage_client.cc',
        '../webkit/quota/mock_storage_client.h',
      ],
      'conditions': [
        ['OS!="ios"', {
          'dependencies': [
            'common/extensions/api/api.gyp:api',
            '../device/device.gyp:device_bluetooth_mocks',
            '../gpu/gpu.gyp:gpu_unittest_utils',
            '../ppapi/ppapi_internal.gyp:ppapi_unittest_shared',
            '../third_party/cld/cld.gyp:cld',
            '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
            '../third_party/libjingle/libjingle.gyp:libjingle',
            '../tools/json_schema_compiler/test/json_schema_compiler_tests.gyp:json_schema_compiler_tests',
            '../ui/gl/gl.gyp:gl',
            '../v8/tools/gyp/v8.gyp:v8',
            '../webkit/webkit.gyp:test_shell_test_support',
          ],
          # TODO(scr): Use this in browser_tests too.
          'includes': [
            'js_unittest_rules.gypi',
          ],
        }, {  # OS=="ios"
          'dependencies': [
            '../third_party/ocmock/ocmock.gyp:ocmock',
          ],
          'sources/': [
            # Exclude everything but iOS-specific files.
            ['exclude', '\\.(cc|mm)$'],
            ['include', '_ios\\.(cc|mm)$'],
            ['include', '(^|/)ios/'],
            # TODO(ios): Add files here as they are updated to compile on iOS.
            ['include', '^common/bzip2_unittest\\.cc$'],
            ['include', '^common/zip_'],
          ],
          'conditions': [
            ['coverage != 0', {
              'sources/': [
                # These tests crash when run with coverage turned on due to an
                # issue with llvm_gcda_increment_indirect_counter:
                # http://crbug.com/156058
                ['exclude', '^browser/autocomplete/builtin_provider_unittest\\.cc$'],
                ['exclude', '^browser/autocomplete/shortcuts_provider_unittest\\.cc$'],
              ],
            }],
          ],
          # Bundle all the necessary resources into the test bundle.
          'includes': ['chrome_ios_bundle_resources.gypi'],
          'actions': [
            {
              'action_name': 'copy_test_data',
              'variables': {
                'test_data_files': [
                  'test/data/zip',
                ],
                'test_data_prefix': 'chrome',
              },
              'includes': [ '../build/copy_test_data_ios.gypi' ],
            },
          ],
          'xcode_settings': {'OTHER_LDFLAGS': ['-ObjC']},
        }],
        ['enable_background==0', {
          'sources/': [
            ['exclude', '^browser/background/'],
          ],
        }],
        ['enable_one_click_signin==0', {
          'sources!': [
            'browser/ui/cocoa/one_click_signin_bubble_controller_unittest.mm',
            'browser/ui/sync/one_click_signin_helper_unittest.cc',
          ]
        }],
        ['disable_nacl==1', {
          'sources!':[
            'browser/nacl_host/nacl_validation_cache_unittest.cc',
            'browser/nacl_host/pnacl_file_host_unittest.cc',
            'nacl/nacl_ipc_adapter_unittest.cc',
            'nacl/nacl_validation_query_unittest.cc',
          ],
        }],
        ['target_arch!="arm" and OS!="ios"', {
          'dependencies': [
            # build time dependency.
            '../v8/tools/gyp/v8.gyp:v8_shell#host',
          ],
        }],
        ['enable_extensions==0', {
          'sources/': [
            ['exclude', '^browser/extensions/api/'],
            ['exclude', '^browser/sync/glue/chrome_extensions_activity_monitor_unittest.cc'],
            ['exclude', '^common/extensions/api/'],
          ],
          'sources!':[
            'browser/extensions/extension_context_menu_model_unittest.cc',
            'browser/extensions/extension_ui_unittest.cc',
            'browser/extensions/permissions_updater_unittest.cc',
          ],
        }],
        ['use_ash==1', {
          'sources': [
            'browser/ui/app_list/apps_model_builder_unittest.cc',
          ],
          'dependencies': [
            '../ash/ash.gyp:ash_resources',
            '../ash/ash.gyp:ash_test_support',
            '../ash/ash_strings.gyp:ash_strings',
          ],
          # We eventually want to compile both in Win Aura builds, see
          # http://crbug.com/155545.
          'conditions': [
            ['OS=="win"', {
              'sources!': [
                'browser/ui/window_sizer/window_sizer_ash_unittest.cc',
              ],
            }, { # else: OS!=win
              'sources!': [
                'browser/ui/window_sizer/window_sizer_unittest.cc',
              ],
            }],
          ],
        }],
        ['use_aura==1', {
          'dependencies': [
            '../ui/aura/aura.gyp:aura_test_support',
          ],
          'sources/': [
            ['exclude', '^browser/automation/automation_provider_unittest.cc'],
            ['exclude', '^browser/ui/views/extensions/browser_action_drag_data_unittest.cc'],
            ['exclude', '^browser/ui/views/bookmarks/bookmark_editor_view_unittest.cc'],
            ['exclude', '^browser/ui/panels/display_settings_provider_win_unittest.cc'],
            ['exclude', '^browser/bookmarks/bookmark_node_data_unittest.cc'],
          ],
        }],
        ['enable_task_manager==0', {
          'sources/': [
            ['exclude', '^browser/task_manager/'],
            ['exclude', '^browser/ui/webui/task_manager/'],
          ],
        }],
        ['file_manager_extension==0', {
          'sources!': [
            'browser/ui/views/select_file_dialog_extension_unittest.cc',
          ],
        }],
        ['configuration_policy==0', {
          'sources!': [
            'browser/extensions/settings/policy_value_store_unittest.cc',
            'browser/managed_mode/managed_mode_url_filter_unittest.cc',
            'browser/prefs/proxy_policy_unittest.cc',
            'browser/ui/webui/policy_ui_unittest.cc',
          ],
          'sources/': [
            ['exclude', '^browser/policy/'],
          ],
        }],
        ['input_speech==0', {
          'sources/': [
            ['exclude', '^browser/speech/'],
          ],
        }],
        ['notifications==0', {
          'sources/': [
            ['exclude', '^browser/notifications/'],
          ],
        }],
        ['safe_browsing==1', {
          'defines': [
            'FULL_SAFE_BROWSING',
          ],
        }],
        # TODO(sgurun): enable tests.
        ['safe_browsing==2', {
          'sources/': [
            ['exclude', '^browser/safe_browsing/'],
            ['exclude', '^renderer/safe_browsing/'],
          ],
        }],
        ['safe_browsing==0', {
          'sources/': [
            ['exclude', '^browser/safe_browsing/'],
            ['exclude', '^renderer/safe_browsing/'],
          ],
        }],
        ['enable_automation!=1', {
          'sources/': [
            ['exclude', '^browser/automation/'],
          ],
        }],
        ['enable_printing!=1', {
          'sources/': [
            ['exclude', '^browser/printing/'],
            ['exclude', '^browser/ui/webui/print_preview/'],
          ],
        }],
        ['enable_captive_portal_detection!=1', {
          'sources/': [
            ['exclude', '^browser/captive_portal/'],
          ],
        }],
        ['enable_session_service!=1', {
          'sources!': [
            'browser/sessions/session_service_unittest.cc',
          ],
        }],
        ['chromeos==1', {
          'sources/': [
            ['exclude', '^browser/password_manager/native_backend_gnome_x_unittest.cc'],
            ['exclude', '^browser/password_manager/native_backend_kwallet_x_unittest.cc'],
            ['exclude', '^browser/policy/mock_user_cloud_policy_store.cc' ],
            ['exclude', '^browser/policy/mock_user_cloud_policy_store.h' ],
            ['exclude', '^browser/policy/user_cloud_policy_manager_unittest.cc'],
            ['exclude', '^browser/policy/user_cloud_policy_store_unittest.cc'],
            ['exclude', '^browser/policy/user_policy_signin_service_unittest.cc'],
            ['exclude', '^browser/safe_browsing/download_protection_service_unittest.cc' ],
            ['exclude', '^browser/system_monitor/removable_device_notifications_linux_unittest.cc'],
          ],
          'sources': [
            'browser/ui/webui/feedback_ui_unittest.cc',
          ],
        }, { # else: chromeos == 0
          'sources/': [
            ['exclude', '^browser/chromeos/'],
            ['exclude', '^browser/ui/webui/chromeos/imageburner/'],
            ['exclude', '^browser/ui/webui/chromeos/login'],
            ['exclude', '^browser/ui/webui/options/chromeos/'],
            ['exclude', '^browser/ui/webui/options/chromeos/'],
          ],
          'sources!': [
            'browser/net/gaia/gaia_oauth_fetcher_unittest.cc',
            'browser/policy/auto_enrollment_client_unittest.cc' ,
            'browser/policy/cros_user_policy_cache_unittest.cc',
            'browser/policy/device_policy_cache_unittest.cc',
            'browser/policy/device_local_account_policy_service_unittest.cc',
            'browser/policy/device_status_collector_unittest.cc',
            'browser/policy/enterprise_install_attributes_unittest.cc',
            'browser/policy/network_configuration_updater_unittest.cc',
            'browser/policy/proxy_policy_provider_unittest.cc',
          ],
        }],
        ['toolkit_uses_gtk == 1', {
          'conditions': [
            ['selinux==0', {
              'dependencies': [
                '../sandbox/sandbox.gyp:*',
              ],
            }],
            ['toolkit_views==1', {
              'sources!': [
                'browser/ui/gtk/accelerators_gtk_unittest.cc',
                'browser/ui/gtk/bookmarks/bookmark_bar_gtk_unittest.cc',
                'browser/ui/gtk/bookmarks/bookmark_editor_gtk_unittest.cc',
                'browser/ui/gtk/gtk_chrome_shrinkable_hbox_unittest.cc',
                'browser/ui/gtk/gtk_theme_service_unittest.cc',
                'browser/ui/gtk/omnibox/omnibox_popup_view_gtk_unittest.cc',
                'browser/ui/gtk/reload_button_gtk_unittest.cc',
                'browser/ui/gtk/status_icons/status_tray_gtk_unittest.cc',
              ],
            }],
            ['chromeos==0', {
              'conditions': [
                ['use_gnome_keyring==1', {
                  # We use a few library functions directly, so link directly.
                  'dependencies': [
                    '../build/linux/system.gyp:gnome_keyring_direct',
                  ],
                }],
              ],
            }],
          ],
          'dependencies': [
            '../build/linux/system.gyp:dbus',
            '../build/linux/system.gyp:gtk',
            '../dbus/dbus.gyp:dbus_test_support',
            '../tools/xdisplaycheck/xdisplaycheck.gyp:xdisplaycheck',
          ],
          'sources!': [
            'browser/printing/print_job_unittest.cc',
          ],
        }, { # else: toolkit_uses_gtk != 1
          'sources!': [
            'browser/ui/gtk/tabs/tab_renderer_gtk_unittest.cc',
            '../ui/views/focus/accelerator_handler_gtk_unittest.cc',
          ],
        }],
        ['toolkit_uses_gtk == 1 or chromeos==1 or (OS=="linux" and use_aura==1)', {
          'dependencies': [
            '../build/linux/system.gyp:ssl',
          ],
        }],
        ['use_gnome_keyring == 0', {
          # Disable the GNOME Keyring tests if we are not using it.
          'sources!': [
            'browser/password_manager/native_backend_gnome_x_unittest.cc',
          ],
        }],
        ['OS=="linux" and use_aura==1', {
          'dependencies': [
            '../build/linux/system.gyp:dbus',
            '../dbus/dbus.gyp:dbus_test_support',
            '../ui/aura/aura.gyp:aura_test_support',
          ],
        }],
        ['OS=="linux" and branding=="Chrome" and target_arch=="ia32"', {
          'configurations': {
            'Release': {
              'ldflags': [
                '-Wl,--strip-debug',
              ],
            },
          },
        }],
        ['os_posix == 1 and OS != "mac" and OS != "ios" and OS != "android"', {
          'conditions': [
            ['linux_use_tcmalloc==1', {
              'dependencies': [
                '../base/allocator/allocator.gyp:allocator',
              ],
            }],
          ],
        }],
        ['OS=="mac"', {
           # The test fetches resources which means Mac need the app bundle to
           # exist on disk so it can pull from it.
          'dependencies': [
            'chrome',
            '../third_party/ocmock/ocmock.gyp:ocmock',
          ],
          'include_dirs': [
            '../third_party/GTM',
            '../third_party/GTM/AppKit',
          ],
          'sources!': [
            'browser/ui/tabs/dock_info_unittest.cc',
            'browser/ui/tests/ui_gfx_image_unittest.cc',
            'browser/ui/gtk/reload_button_gtk_unittest.cc',
            'browser/password_manager/password_store_default_unittest.cc',
            'tools/convert_dict/convert_dict_unittest.cc',
            'renderer/spellchecker/spellcheck_provider_hunspell_unittest.cc',
          ],
          # TODO(mark): We really want this for all non-static library targets,
          # but when we tried to pull it up to the common.gypi level, it broke
          # other things like the ui, startup, and page_cycler tests. *shrug*
          'xcode_settings': {'OTHER_LDFLAGS': ['-Wl,-ObjC']},
        }],
        ['OS!="mac" and OS!="ios"', {
          'dependencies': [
            'chrome_resources.gyp:packed_extra_resources',
            'chrome_resources.gyp:packed_resources',
            'convert_dict_lib',
            '../third_party/hunspell/hunspell.gyp:hunspell',
          ],
        }],
        ['OS!="win" and OS!="mac"', {
          'sources!': [
            '../skia/ext/platform_canvas_unittest.cc',
          ],
        }],
        ['enable_rlz==0', {
          'sources!': [
            'browser/rlz/rlz_unittest.cc',
          ],
        }],
        ['OS=="win" and component!="shared_library"', {
          # Unit_tests pdb files can get too big when incremental linking is
          # on, disabling for this target.
          'configurations': {
            'Debug': {
              'msvs_settings': {
                'VCLinkerTool': {
                  'LinkIncremental': '<(msvs_debug_link_nonincremental)',
                },
              },
            },
          },
        }],
        ['OS=="win"', {
          'dependencies': [
            'chrome_version_resources',
            'installer_util_strings',
            '../third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
            '../third_party/isimpledom/isimpledom.gyp:isimpledom',
          ],
          'conditions': [
            ['win_use_allocator_shim==1', {
              'dependencies': [
                '<(allocator_target)',
              ],
            }],
          ],
          'include_dirs': [
            '<(DEPTH)/third_party/wtl/include',
          ],
          'sources': [
            # TODO:  It would be nice to have these pulled in
            # automatically from direct_dependent_settings in
            # their various targets (net.gyp:net_resources, etc.),
            # but that causes errors in other targets when
            # resulting .res files get referenced multiple times.
            '<(SHARED_INTERMEDIATE_DIR)/chrome/browser_resources.rc',
            '<(SHARED_INTERMEDIATE_DIR)/chrome/common_resources.rc',
            '<(SHARED_INTERMEDIATE_DIR)/chrome/extensions_api_resources.rc',
            '<(SHARED_INTERMEDIATE_DIR)/chrome_version/other_version.rc',
            '<(SHARED_INTERMEDIATE_DIR)/content/content_resources.rc',
            '<(SHARED_INTERMEDIATE_DIR)/installer_util_strings/installer_util_strings.rc',
            '<(SHARED_INTERMEDIATE_DIR)/net/net_resources.rc',
            '<(SHARED_INTERMEDIATE_DIR)/webkit/webkit_chromium_resources.rc',
            '<(SHARED_INTERMEDIATE_DIR)/webkit/webkit_unscaled_resources.rc',
          ],
          'link_settings': {
            'libraries': [
              '-lcomsupp.lib',
              '-loleacc.lib',
              '-lrpcrt4.lib',
              '-lurlmon.lib',
              '-lwinmm.lib',
            ],
          },
        }, { # else: OS != "win"
          'sources!': [
            'app/chrome_dll.rc',
            'browser/bookmarks/bookmark_node_data_unittest.cc',
            'browser/search_engines/template_url_scraper_unittest.cc',
            'browser/ui/views/bookmarks/bookmark_editor_view_unittest.cc',
            'browser/ui/views/extensions/browser_action_drag_data_unittest.cc',
            'test/data/resource.rc',
            '../skia/ext/vector_canvas_unittest.cc',
          ],
        }],
        ['OS!="android" and OS!="ios"', {
          'sources!': [
            'browser/web_resource/promo_resource_service_mobile_ntp_unittest.cc',
          ],
        }],
        ['OS=="android"', {
          'sources!': [
            # Bookmark export/import are handled via the BookmarkColumns
            # ContentProvider.
            'browser/bookmarks/bookmark_html_writer_unittest.cc',

            'browser/shell_integration_unittest.cc',

            # No service process (which also requires multiprocess lock).
            'common/multi_process_lock_unittest.cc',

            # Sync setup uses native ui.
            'browser/ui/webui/sync_setup_handler_unittest.cc',

            'browser/browser_commands_unittest.cc',
            'browser/managed_mode/managed_mode_unittest.cc',
            'browser/managed_mode/managed_mode_url_filter_unittest.cc',
            'browser/net/gaia/gaia_oauth_fetcher_unittest.cc',
            'browser/page_cycler/page_cycler_unittest.cc',
            'browser/profiles/off_the_record_profile_impl_unittest.cc',
            'browser/sync/profile_sync_service_session_unittest.cc',
            'browser/sync/sync_global_error_unittest.cc',
            'browser/tab_contents/render_view_context_menu_unittest.cc',
            'browser/ui/bookmarks/bookmark_context_menu_controller_unittest.cc',
            'browser/ui/bookmarks/bookmark_prompt_controller_unittest.cc',
            'browser/ui/browser_command_controller_unittest.cc',
            'browser/ui/fullscreen/fullscreen_controller_state_unittest.cc',
            'browser/ui/fullscreen/fullscreen_controller_unittest.cc',
            'browser/ui/search/search_delegate_unittest.cc',
            'browser/ui/search/search_unittest.cc',
            'browser/ui/tab_contents/tab_contents_iterator_unittest.cc',
            'browser/ui/toolbar/recent_tabs_sub_menu_model_unittest.cc',
            'browser/ui/toolbar/toolbar_model_unittest.cc',
            'browser/ui/toolbar/wrench_menu_model_unittest.cc',
            'browser/ui/webui/ntp/suggestions_combiner_unittest.cc',
            'browser/ui/webui/web_dialog_web_contents_delegate_unittest.cc',
            'browser/ui/window_sizer/window_sizer_common_unittest.cc',
            'browser/ui/window_sizer/window_sizer_unittest.cc',
            'test/base/browser_with_test_window_test.cc',
            'test/base/browser_with_test_window_test.h',
            'test/base/test_browser_window.h',

            'browser/sessions/persistent_tab_restore_service_browsertest.cc',
            'browser/sessions/session_backend_unittest.cc',

            # Test files cannot be opened on Android.
            'browser/google_apis/gdata_wapi_operations_unittest.cc',
            'browser/google_apis/gdata_wapi_parser_unittest.cc',

            # The autofill popup is implemented in mostly native code on
            # Android.
            'browser/ui/autofill/autofill_popup_controller_unittest.cc',
          ],
          'sources/': [
            ['exclude', '^browser/captive_portal/'],
            ['exclude', '^browser/chrome_to_mobile'],
            ['exclude', '^browser/first_run/'],
            ['exclude', '^browser/importer/'],
            ['exclude', '^browser/lifetime/'],
            ['exclude', '^browser/speech/'],
            ['exclude', '^browser/sync/glue/app_'],
            ['exclude', '^browser/sync/glue/extension_'],
            ['exclude', '^browser/themes/'],
            ['exclude', '^browser/ui/omnibox/'],
            ['exclude', '^browser/ui/panels'],
            ['exclude', '^browser/ui/tabs/'],
            ['exclude', '^browser/ui/toolbar/'],
            ['exclude', '^browser/ui/webui/downloads_'],
            ['exclude', '^browser/ui/webui/feedback_'],
            ['exclude', '^browser/ui/webui/flags_'],
            ['exclude', '^browser/ui/webui/help/'],
            ['exclude', '^browser/ui/webui/options/'],
            ['exclude', '^browser/ui/webui/options/'],
            ['exclude', '^browser/ui/webui/signin/'],
            ['exclude', '^browser/ui/webui/suggestions_internals'],
            ['exclude', '^browser/ui/webui/sync_promo'],
            # No service process on Android.
            ['exclude', '^browser/service/'],
            ['exclude', '^common/service_'],
            ['exclude', '^service/'],
          ],
          'conditions': [
            ['gtest_target_type == "shared_library"', {
              'dependencies': [
                '../testing/android/native_test.gyp:native_test_native_code',
              ],
            }],
          ],
        }],  # OS == android
        ['enable_web_intents==0', {
          'sources/': [
            ['exclude', '^browser/intents/'],
            ['exclude', '^browser/ui/intents/'],
          ],
          'sources!': [
            'browser/webdata/web_data_service_unittest.cc',
            'browser/webdata/web_intents_table_unittest.cc',
          ],
        }],
        ['enable_themes==0', {
          'sources!': [
            'browser/ui/webui/theme_source_unittest.cc',
          ],
          'sources/': [
            ['exclude', '^browser/themes/'],
          ],
        }],
        ['enable_language_detection==0', {
          'sources!': [
            'browser/language_usage_metrics_unittest.cc',
          ],
        }],
        ['toolkit_views==1', {
          'dependencies': [
            '../ui/views/views.gyp:views',
          ],
          'sources!': [
            'browser/ui/gtk/tabs/tab_renderer_gtk_unittest.cc',
          ],
        }, { # else: toolkit_views == 0
          'sources/': [
            ['exclude', '^browser/ui/views/'],
            ['exclude', '^../ui/views/'],
            ['exclude', '^browser/extensions/key_identifier_conversion_views_unittest.cc'],
          ],
        }],
        ['use_nss==0 and use_openssl==0', {
          'sources!': [
            'common/net/x509_certificate_model_unittest.cc',
          ],
        }],
        ['use_openssl==1', {
          'sources/': [
            # OpenSSL build does not support firefox importer. See
            # http://crbug.com/64926
            ['exclude', '^browser/importer/'],
          ],
        }],
        # TODO(joi): Remove from this file once separate
        # google_apis_unittests target is established.
        ['use_official_google_api_keys==1', {
          'defines': ['USE_OFFICIAL_GOOGLE_API_KEYS=1'],
        }],
      ],
      'target_conditions': [
        ['OS == "ios"', {
          'sources/': [
            ['include', '^common/mac/nscoder_util_unittest\\.mm$'],
          ],
        }],
      ],
    },
    {
      'target_name': 'chrome_app_unittests',
      'type': 'executable',
      'dependencies': [
        # unit tests should only depend on
        # 1) everything that the chrome binaries depend on:
        '<@(chromium_dependencies)',
        # 2) test-specific support libraries:
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        'test_support_common',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        'app/breakpad_field_trial_win.cc',
        'app/breakpad_win.cc',
        'app/breakpad_unittest_win.cc',
        'app/crash_analysis_win.cc',
        'app/hard_error_handler_win.cc',
        'app/run_all_unittests.cc'
      ],
      'conditions': [
        ['OS=="mac"', {
          # TODO(mark): We really want this for all non-static library targets,
          # but when we tried to pull it up to the common.gypi level, it broke
          # other things like the ui, startup, and page_cycler tests. *shrug*
          'xcode_settings': {'OTHER_LDFLAGS': ['-Wl,-ObjC']},
        }],
        ['OS=="win"', {
          'dependencies': [
            # breakpad is currently only tested on Windows.
            '../breakpad/breakpad.gyp:*',
          ],
          'conditions': [
            ['win_use_allocator_shim==1', {
              'dependencies': [
                '<(allocator_target)',
              ],
            }],
          ],
        }],
      ],
    },
  ],
  'conditions': [
    # Special target to wrap a gtest_target_type==shared_library
    # unit_tests into an android apk for execution.
    ['OS == "android" and gtest_target_type == "shared_library"', {
      'targets': [
        {
          'target_name': 'unit_tests_apk',
          'type': 'none',
          'dependencies': [
            'chrome_java',
            'unit_tests',
          ],
          'variables': {
            'test_suite_name': 'unit_tests',
            'input_shlib_path': '<(SHARED_LIB_DIR)/<(SHARED_LIB_PREFIX)unit_tests<(SHARED_LIB_SUFFIX)',
          },
          'includes': [ '../build/apk_test.gypi' ],
        },
      ],
    }],
    ['test_isolation_mode != "noop"', {
      'targets': [
        {
          'target_name': 'unit_tests_run',
          'type': 'none',
          'dependencies': [
            'unit_tests',
          ],
          'includes': [
            '../build/isolate.gypi',
            'unit_tests.isolate',
          ],
          'sources': [
            'unit_tests.isolate',
          ],
        },
      ],
    }],
  ],  # 'conditions'
}
