// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/views/frame/system_menu_model.h"

#include <windows.h>

#include <algorithm>

SystemMenuModel::SystemMenuModel(ui::SimpleMenuModel::Delegate* delegate)
    : ui::SimpleMenuModel(delegate) {
}

SystemMenuModel::~SystemMenuModel() {
}

int SystemMenuModel::GetFirstItemIndex(gfx::NativeMenu native_menu) const {
  // We allow insertions before last item (Close).
  return std::max(0, GetMenuItemCount(native_menu) - 1);
}

int SystemMenuModel::FlipIndex(int index) const {
  return GetItemCount() - index - 1;
}
