// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/printing/cloud_print/cloud_print_setup_message_handler.h"

#include "base/bind.h"
#include "base/bind_helpers.h"
#include "base/json/json_reader.h"
#include "base/json/json_writer.h"
#include "base/memory/scoped_ptr.h"
#include "chrome/browser/printing/cloud_print/cloud_print_setup_flow.h"
#include "content/public/browser/web_ui.h"

void CloudPrintSetupMessageHandler::RegisterMessages() {
  // Pass the WebUI object to the setup flow.
  flow_->Attach(web_ui());

  web_ui()->RegisterMessageCallback("SubmitAuth",
      base::Bind(&CloudPrintSetupMessageHandler::HandleSubmitAuth,
                 base::Unretained(this)));
  web_ui()->RegisterMessageCallback("PrintTestPage",
      base::Bind(&CloudPrintSetupMessageHandler::HandlePrintTestPage,
                 base::Unretained(this)));
  web_ui()->RegisterMessageCallback("LearnMore",
      base::Bind(&CloudPrintSetupMessageHandler::HandleLearnMore,
                 base::Unretained(this)));
}

void CloudPrintSetupMessageHandler::HandleSubmitAuth(const ListValue* args) {
  std::string json;
  bool ret = args->GetString(0, &json);
  std::string username, password, captcha, access_code;
  if (!ret || json.empty()) {
    NOTREACHED() << "Empty json string";
    return;
  }

  scoped_ptr<Value> parsed_value(base::JSONReader::Read(json));
  if (!parsed_value.get() || !parsed_value->IsType(Value::TYPE_DICTIONARY)) {
    NOTREACHED() << "Unable to parse auth data";
    return;
  }

  DictionaryValue* result = static_cast<DictionaryValue*>(parsed_value.get());
  if (!result->GetString("user", &username) ||
      !result->GetString("pass", &password) ||
      !result->GetString("captcha", &captcha) ||
      !result->GetString("access_code", &access_code)) {
    NOTREACHED() << "Unable to parse auth data";
    return;
  }

  // Pass the information to the flow.
  if (flow_)
    flow_->OnUserSubmittedAuth(username, password, captcha, access_code);
}

void CloudPrintSetupMessageHandler::HandlePrintTestPage(const ListValue* args) {
  if (flow_)
    flow_->OnUserClickedPrintTestPage();
}

void CloudPrintSetupMessageHandler::HandleLearnMore(const ListValue* args) {
  if (flow_)
    flow_->OnUserClickedLearnMore();
}
