// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/chromeos/cros/network_ip_config.h"

#include "base/logging.h"

namespace chromeos {

namespace {
#define ENUM_CASE(x) case x: return std::string(#x)
std::string IPConfigTypeAsString(IPConfigType type) {
  switch (type) {
    ENUM_CASE(IPCONFIG_TYPE_UNKNOWN);
    ENUM_CASE(IPCONFIG_TYPE_IPV4);
    ENUM_CASE(IPCONFIG_TYPE_IPV6);
    ENUM_CASE(IPCONFIG_TYPE_DHCP);
    ENUM_CASE(IPCONFIG_TYPE_BOOTP);
    ENUM_CASE(IPCONFIG_TYPE_ZEROCONF);
    ENUM_CASE(IPCONFIG_TYPE_DHCP6);
    ENUM_CASE(IPCONFIG_TYPE_PPP);
  }
  NOTREACHED() << "Unhandled enum value " << type;
  return std::string();
}
#undef ENUM_CASE
}  // namespace

NetworkIPConfig::NetworkIPConfig(
    const std::string& device_path, IPConfigType type,
    const std::string& address, const std::string& netmask,
    const std::string& gateway, const std::string& name_servers)
    : device_path(device_path),
      type(type),
      address(address),
      netmask(netmask),
      gateway(gateway),
      name_servers(name_servers) {
}

NetworkIPConfig::~NetworkIPConfig() {}

std::string NetworkIPConfig::ToString() const {
  return std::string("path: ") + device_path
      + " type: " + IPConfigTypeAsString(type)
      + " address: " + address
      + " netmask: " + netmask
      + " gateway: " + gateway
      + " name_servers: " + name_servers;
}

}  // namespace chromeos
