from ufaspy.tests.introspection import BaseIntrospectionTestCase


class TestNetwork(BaseIntrospectionTestCase):

    def setUp(self):
        super(TestNetwork, self).setUp()
        self.dbus_interface = 'com.canonical.android.network.NetworkService'
        self.s_Connectivity = 'Connectivity'
        self.s_NetworkStateChanged = 'NetworkStateChanged'
        self.s_RSSIChanged = 'RSSIChanged'
        self.s_ScanResultsAvailable = 'ScanResultsAvailable'
        self.m_AddNetwork = 'AddNetwork'
        self.m_Disconnect = 'Disconnect'
        self.m_EnableNetwork = 'EnableNetwork'
        self.m_GetConnectedName = 'GetConnectedName'
        self.m_GetConnectionInformation = 'GetConnectionInformation'
        self.m_GetNetworkState = 'GetNetworkState'
        self.m_GetScanResults = 'GetScanResults'
        self.m_SaveNetworks = 'SaveNetworks'
        self.m_StartScan = 'StartScan'

    def tearDown(self):
        super(TestNetwork, self).tearDown()

    def find_item(self, dbus_if, method_or_signal_name, s_or_m_type):
        item_found = False
        xml = self.proxy_net.Introspect()
        item_found = self.parse_xml(xml, dbus_if, method_or_signal_name,
                                    s_or_m_type)
        return item_found

    def test_network_s_Connectivity(self):
        item = self.s_Connectivity
        item_found = self.find_item(self.dbus_interface, item, 'signal')
        self.assertTrue(item_found)

    def test_network_s_NetworkStateChanged(self):
        item = self.s_NetworkStateChanged
        item_found = self.find_item(self.dbus_interface, item, 'signal')
        self.assertTrue(item_found)

    def test_network_s_RSSIChanged(self):
        item = self.s_RSSIChanged
        item_found = self.find_item(self.dbus_interface, item, 'signal')
        self.assertTrue(item_found)

    def test_network_s_ScanResultsAvailable(self):
        item = self.s_ScanResultsAvailable
        item_found = self.find_item(self.dbus_interface, item, 'signal')
        self.assertTrue(item_found)

    def test_network_m_AddNetwork(self):
        item = self.m_AddNetwork
        item_found = self.find_item(self.dbus_interface, item, 'method')
        self.assertTrue(item_found)

    def test_network_m_Disconnect(self):
        item = self.m_Disconnect
        item_found = self.find_item(self.dbus_interface, item, 'method')
        self.assertTrue(item_found)

    def test_network_m_EnableNetwork(self):
        item = self.m_EnableNetwork
        item_found = self.find_item(self.dbus_interface, item, 'method')
        self.assertTrue(item_found)

    def test_network_m_GetConnectedName(self):
        item = self.m_GetConnectedName
        item_found = self.find_item(self.dbus_interface, item, 'method')
        self.assertTrue(item_found)

    def test_network_m_GetConnectionInformation(self):
        item = self.m_GetConnectionInformation
        item_found = self.find_item(self.dbus_interface, item, 'method')
        self.assertTrue(item_found)

    def test_network_m_GetNetworkState(self):
        item = self.m_GetNetworkState
        item_found = self.find_item(self.dbus_interface, item, 'method')
        self.assertTrue(item_found)

    def test_network_m_GetScanResults(self):
        item = self.m_GetScanResults
        item_found = self.find_item(self.dbus_interface, item, 'method')
        self.assertTrue(item_found)

    def test_network_m_SaveNetworks(self):
        item = self.m_SaveNetworks
        item_found = self.find_item(self.dbus_interface, item, 'method')
        self.assertTrue(item_found)

    def test_network_m_StartScan(self):
        item = self.m_StartScan
        item_found = self.find_item(self.dbus_interface, item, 'method')
        self.assertTrue(item_found)
