from ufaspy.tests.introspection import BaseIntrospectionTestCase


class TestCallLog(BaseIntrospectionTestCase):
    def setUp(self):
        super(TestCallLog, self).setUp()
        self.dbus_interface = "com.canonical.android.telephony.CallLog"
        self.s_CallListChanged = "CallListChanged"
        self.m_deleteCallAtTime = "deleteCallAtTime"
        self.m_deleteCallsWithNumber = "deleteCallsWithNumber"
        self.m_listCallsBegin = "listCallsBegin"
        self.m_listCallsEnd = "listCallsEnd"
        self.m_listCallsNextPage = "listCallsNextPage"
        self.m_markCallAsRead = "markCallAsRead"

    def tearDown(self):
        super(TestCallLog, self).tearDown()

    def find_item(self, dbus_if, method_or_signal_name, s_or_m_type):
        item_found = False
        xml = self.proxy_callLog.Introspect()
        item_found = self.parse_xml(xml, dbus_if, method_or_signal_name,
                                    s_or_m_type)
        return item_found

    def test_calllog_s_CallListChanged(self):
        item = self.s_CallListChanged
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_calllog_m_deleteCallAtTime(self):
        item = self.m_deleteCallAtTime
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_calllog_m_deleteCallsWithNumber(self):
        item = self.m_deleteCallsWithNumber
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_calllog_m_listCallsBegin(self):
        item = self.m_listCallsBegin
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_calllog_m_listCallsEnd(self):
        item = self.m_listCallsEnd
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_calllog_m_listCallsNextPage(self):
        item = self.m_listCallsNextPage
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_calllog_m_markCallAsRead(self):
        item = self.m_markCallAsRead
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)
