# -*- coding: utf-8 -*-

__license__   = 'GPL v3'
__copyright__ = '2009, Gerhard Aigner <gerhard.aigner at gmail.com>'

''' http://www.derstandard.at - Austrian Newspaper '''
import re
from calibre.web.feeds.news import BasicNewsRecipe

class TelepolisArtikel(BasicNewsRecipe):
	title          = u'Telepolis (Artikel)'
	__author__ = 'Gerhard Aigner'
	publisher = 'Heise Zeitschriften Verlag GmbH & Co KG'
	category = 'news'
	description = 'Telepolis Artikel'
	oldest_article = 7
	max_articles_per_feed = 100
	recursion = 0
	no_stylesheets = True

	use_embedded_content = False
	remove_empty_feeds = True

	remove_tags_before = dict(name='h1')
	remove_tags = [dict(name='img')]

	feeds          = [(u'Artikel', u'http://www.heise.de/tp/rss/news-a.rdf')]

	preprocess_regexps = [(re.compile(r'<a[^>]*>', re.DOTALL|re.IGNORECASE), lambda match: ''),
		(re.compile(r'</a>', re.DOTALL|re.IGNORECASE), lambda match: ''),]

	html2lrf_options = [
		'--comment'  , description
		, '--category' , category
		, '--publisher', publisher]

	html2epub_options  = 'publisher="' + publisher + '"\ncomments="' + description + '"\ntags="' + category + '"'

	def print_version(self, url):
		p = re.compile(r'\d{5}', re.DOTALL|re.IGNORECASE)
		m = p.search(url)
		return "http://www.heise.de/bin/tp/issue/r4/dl-artikel2.cgi?artikelnr="+ m.group() +"&mode=print"

